![Project](https://github.com/elfeenah/Sprocket-Central-Pty-Ltd-/assets/111433655/44fdd47a-5793-48a1-b2b9-36f34a738ce4)

# Sprocket Central Pty Ltd - Analysis Dashboard

## About the Project
The client is happy with the analysis plan and would like us to proceed. After building the model, we need to present our results back to the client. Visualizations such as interactive dashboards often help us highlight key findings and convey our ideas in a more succinct manner. A list of customers or algorithm won't cut it with the client, we need to support our results with the use of visualizations.

## Task
Please develop a dashboard that we can present to the client at our next meeting. Display your data summary and results of the analysis in a dashboard. Maximum of 3 dashboard views/tabs, creativity in layout and presentation is welcome.

## Business Context
It is important to keep in mind the business context when presenting your findings:

- What are the trends in the underlying data?
- Which customer segment has the highest customer value?
- What do you propose should be Sprocket Central Pty Ltd's marketing and growth strategy?
- What additional external datasets may be useful to obtain greater insights into customer preferences and propensity to purchase the products?

## Target Audience
Specifically, your presentation should specify who Sprocket Central Pty Ltd's marketing team should be targeting out of the new 1000 customer list as well as the broader market segment to reach out to.

## Insights and Recommendations
Based on the analysis, here are the key insights and recommendations:

- From a customer analysis, it was discovered that the most profitable age group was 45–54, with 35–44 and 25–34 following closely behind. The company should prioritize targeting female customers as they made up the majority of their customer base.
- Both car owners and non-owners were equally represented, indicating that the company’s target market is not solely car owners.
- The months of August, July, May, and October were the most profitable, providing the company with an opportunity to attract more customers during these periods.
- Solex, Wearea2B, and Trek bicycles were the top-selling brands, while OHM and Norco Bicycles were the least successful. By focusing on improving the less successful brands, Sprocket Ltd. could potentially increase overall sales.
- The mass customer segment was the most profitable, followed by high net worth and affluent customers.

## Marketing and Strategies
### Brands
- Sprocket Central Pty Ltd can increase sales by highlighting the success of popular brands, such as Solex, Wearea2B, and Trek bicycles.
- The company could invest in product development for OHM and Norco Bicycles to introduce new features and improve quality, making them more attractive to customers.
- Sprocket Central Pty Ltd can increase sales of less popular brands by creating product bundles that include popular and less successful brands.

### Period
- Sprocket Central Pty Ltd can create seasonal promotions in August, July, May & October to attract new customers tailored to each month’s characteristics.
- The company can create targeted ads on social media/Google Ads to attract new customers and highlight the benefits of owning a bike in the coming months.
- Sprocket Central Pty Ltd could offer discounts or incentives to customers who refer new customers, helping to drive new business during peak months.

### Wealth Segment
- Sprocket Central Pty Ltd could create targeted marketing campaigns to attract mass and high net worth customers by highlighting their premium product features.
- The company can personalize marketing and content to attract new customers from each segment, offer specialized deals, and personalize the customer experience to make them feel valued.
- Sprocket Central Pty Ltd can expand their product line with bikes and accessories tailored to mass, high net worth, and affluent customers.

### Gender
The company can create tailored campaigns to appeal to both male and female customers, highlighting the health and fitness benefits as well as the convenience and time-saving aspects of biking. They can also offer products or services tailored to each gender, such as different bike models with different sizes, colors, and styles.

## Conclusion
The analysis provides valuable insights into customer behavior, segmentation, and marketing strategies for Sprocket Central Pty Ltd. By leveraging these insights, the company can make informed decisions to optimize marketing efforts, drive growth, and enhance customer satisfaction.

## Feel Free to Contribute
This is an open-source project, and contributions are welcome. If you have any suggestions, improvements, or additional insights, feel free to submit a pull request.

## Author
This project was made by **Nafisa Lawal Idris**. You can contact me at nafisaidris413@gmail.com

## License
This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for more details.
