import type { ICredentialType, INodeProperties } from 'n8n-workflow';

export class HelpScoutOAuth2Api implements ICredentialType {
	name = 'helpScoutOAuth2Api';

	extends = ['oAuth2Api'];

	displayName = 'HelpScout OAuth2 API';

	documentationUrl = 'helpScout';

	properties: INodeProperties[] = [
		{
			displayName: 'Grant Type',
			name: 'grantType',
			type: 'hidden',
			default: 'authorizationCode',
		},
		{
			displayName: 'Authorization URL',
			name: 'authUrl',
			type: 'hidden',
			default: 'https://secure.helpscout.net/authentication/authorizeClientApplication',
			required: true,
		},
		{
			displayName: 'Access Token URL',
			name: 'accessTokenUrl',
			type: 'hidden',
			default: 'https://api.helpscout.net/v2/oauth2/token',
			required: true,
		},
		{
			displayName: 'Scope',
			name: 'scope',
			type: 'hidden',
			default: '',
		},
		{
			displayName: 'Auth URI Query Parameters',
			name: 'authQueryParameters',
			type: 'hidden',
			default: '',
		},
		{
			displayName: 'Authentication',
			name: 'authentication',
			type: 'hidden',
			default: 'body',
		},
	];
}
