import { plainToInstance, instanceToPlain } from 'class-transformer';
import { validate } from 'class-validator';
import { ApplicationError, jsonParse } from 'n8n-workflow';

import { isObjectLiteral } from '@/utils';

export class BaseFilter {
	protected static async toFilter(rawFilter: string, Filter: typeof BaseFilter) {
		const dto = jsonParse(rawFilter, { errorMessage: 'Failed to parse filter JSON' });

		if (!isObjectLiteral(dto)) throw new ApplicationError('Filter must be an object literal');

		const instance = plainToInstance(Filter, dto, {
			excludeExtraneousValues: true, // remove fields not in class
		});

		await instance.validate();

		return instanceToPlain(instance, {
			exposeUnsetFields: false, // remove in-class undefined fields
		});
	}

	private async validate() {
		const result = await validate(this);

		if (result.length > 0) throw new ApplicationError('Parsed filter does not fit the schema');
	}
}
