# Why Dialoqbase?

You don't need to use Dialoqbase to create a chatbot. You can use any other best chatbot platform. However, if you want to create a chatbot with the following features, you may give Dialoqbase a try.

## Open Source

All the code is available on GitHub under the MIT license and free for commercial use.

## Chat & Embedding Models

Supports most popular chat and embedding models. You can choose the one that suits your needs.

### Chat Models

Here is a list of chat models that are currently supported by dialoqbase:

#### OpenAI

* gpt-3.5-turbo
* gpt-3.5-turbo-16K
* gpt-4
* gpt-4-0613
* gpt-3.5-turbo-instruct
* gpt-3.5-turbo-1106
* gpt-4-1106-preview

#### Anthropic

* claude-1
* claude-instant-1
* claude-2


### Google PaLM 2

* chat-bison-001


### Llama via Fireworks.ai

* llama v2 7b

* llama v2 13b

* llama v2 70b

* mistral 7b instruct 4k


Note: In order to use Llama models you need to provide [fireworks.ai](https://fireworks.ai/) API key. You can get a free API key from [here](https://fireworks.ai/).

## Bringing Your Own Model

You can also bring your own model. Dialoqbase supports all the models that are supported by compitable with OpenAI API.

### Embedding Models

Here is a list of embedding models that are currently supported by dialoqbase:

* OpenAI 
* Cohere
* Tensorflow (cpu)
* Hugging Face Embedding
* Sentence Transformers (all-MiniLM-L6-v2)
* Google text-gecko-001
* jina-embeddings-v2-base-en

## Multi-Platform

With dialoqbase, you can create chatbots for multiple platforms. 

### Web

Using dialoqbase, you can easily embed your chatbot on your website. You can also customize the chatbot to match your website's design.

### Telegram 

Integrating telegram with dialoqbase is very easy. You just need to create a telegram bot and provide the token to dialoqbase and dialoqbase will take care of the rest.


### Discord 

Integrating discord with dialoqbase is very easy. You just need to create a discord bot and provide the token to dialoqbase and dialoqbase will take care of the rest.

## WhatsApp (experimental)

Integrating WhatsApp with dialoqbase is very easy. You just need to create a WhatsApp bot and provide the token to dialoqbase and dialoqbase will take care of the rest.

## Data Loaders

Here is a list of data loaders that are currently supported by dialoqbase:

* Webpage
* Crawling
* PDF
* Docx
* text
* CSV
* Github repository
* mp3, mp4
* Youtube
* Sitemap

## Vector Search with PostgreSQL

You don't need to spend money on other vector search services. Dialoqbase uses PostgreSQL for vector search operations, which is fast and reliable