function UrlParser(){"use strict";this.plugins={}}function cloneObject(a){"use strict";if(null===a||"object"!=typeof a)return a;var b=a.constructor();for(var c in a)a.hasOwnProperty(c)&&(b[c]=cloneObject(a[c]));return b}function getQueryParams(a){"use strict";if("string"!=typeof a)return{};a=a.split("+").join(" ");var b,c={},d=a.match(/(?:[\?](?:[^=]+)=(?:[^&#]*)(?:[&](?:[^=]+)=(?:[^&#]*))*(?:[#].*)?)|(?:[#].*)/);if(null===d)return{};b=d[0].substr(1).split(/[&#=]/);for(var e=0;e<b.length;e+=2)c[decodeURIComponent(b[e])]=decodeURIComponent(b[e+1]||"");return c}function combineParams(a){"use strict";if("object"!=typeof a)return"";a.params=a.params||{};var b="",c=0,d=Object.keys(a.params);if(0===d.length)return"";for(d.sort(),a.hasParams||(b+="?"+d[0]+"="+a.params[d[0]],c+=1);c<d.length;c+=1)b+="&"+d[c]+"="+a.params[d[c]];return b}function getTime(a){"use strict";var b,c=0,d={s:1,m:60,h:3600,d:86400,w:604800};if(!a.match(/^(\d+[smhdw]?)+$/))return 0;a=a.replace(/([smhdw])/g," $1 ").trim(),b=a.split(" ");for(var e=0;e<b.length;e+=2)c+=parseInt(b[e],10)*d[b[e+1]||"s"];return c}function CanalPlus(){"use strict";this.provider="canalplus",this.defaultFormat="embed",this.formats={embed:this.createEmbedUrl},this.mediaTypes={VIDEO:"video"}}function Coub(){"use strict";this.provider="coub",this.defaultFormat="long",this.formats={"long":this.createLongUrl,embed:this.createEmbedUrl},this.mediaTypes={VIDEO:"video"}}function Dailymotion(){"use strict";this.provider="dailymotion",this.alternatives=["dai"],this.defaultFormat="long",this.formats={"short":this.createShortUrl,"long":this.createLongUrl,embed:this.createEmbedUrl},this.mediaTypes={VIDEO:"video"}}function Twitch(){"use strict";this.provider="twitch",this.defaultFormat="long",this.formats={"long":this.createLongUrl,embed:this.createEmbedUrl},this.mediaTypes={VIDEO:"video",STREAM:"stream",EMBEDVIDEO:"embed-video"}}function Vimeo(){"use strict";this.provider="vimeo",this.alternatives=["vimeopro"],this.defaultFormat="long",this.formats={"long":this.createLongUrl,embed:this.createEmbedUrl},this.mediaTypes={VIDEO:"video"}}function YouTube(){"use strict";this.provider="youtube",this.alternatives=["youtu","ytimg"],this.defaultFormat="long",this.formats={"short":this.createShortUrl,"long":this.createLongUrl,embed:this.createEmbedUrl,shortImage:this.createShortImageUrl,longImage:this.createLongImageUrl},this.imageQualities={0:"0",1:"1",2:"2",3:"3",DEFAULT:"default",HQDEFAULT:"hqdefault",SDDEFAULT:"sddefault",MQDEFAULT:"mqdefault",MAXRESDEFAULT:"maxresdefault"},this.defaultImageQuality=this.imageQualities.HQDEFAULT,this.mediaTypes={VIDEO:"video",PLAYLIST:"playlist",SHARE:"share"}}function Youku(){"use strict";this.provider="youku",this.defaultFormat="embed",this.formats={embed:this.createEmbedUrl,"long":this.createLongUrl,flash:this.createFlashUrl,"static":this.createStaticUrl},this.mediaTypes={VIDEO:"video"}}UrlParser.prototype.parseProvider=function(a){"use strict";var b=a.match(/(?:(?:https?:)?\/\/)?(?:[^\.]+\.)?(\w+)\./i);return b?b[1]:void 0},UrlParser.prototype.removeEmptyParameters=function(a){"use strict";return a.params&&0===Object.keys(a.params).length&&delete a.params,a},UrlParser.prototype.parse=function(a){"use strict";var b,c=this,d=c.parseProvider(a),e=c.plugins[d];return d&&e&&e.parse?(b=e.parse.apply(e,[a,getQueryParams(a)]),b&&(b=c.removeEmptyParameters(b),b.provider=e.provider),b):void 0},UrlParser.prototype.bind=function(a){"use strict";if(this.plugins[a.provider]=a,a.alternatives)for(var b=0;b<a.alternatives.length;b+=1)this.plugins[a.alternatives[b]]=a},UrlParser.prototype.create=function(a){"use strict";var b=a.videoInfo,c=a.params,d=this.plugins[b.provider];return c="internal"===c?b.params:c||{},d&&(a.format=a.format||d.defaultFormat,d.formats.hasOwnProperty(a.format))?d.formats[a.format].apply(d,[b,cloneObject(c)]):void 0};var urlParser=new UrlParser;"undefined"!=typeof module&&"undefined"!=typeof module.exports&&(module.exports=urlParser),CanalPlus.prototype.parseParameters=function(a){"use strict";return delete a.vid,a},CanalPlus.prototype.parse=function(a,b){"use strict";var c=this,d={mediaType:this.mediaTypes.VIDEO,id:b.vid};return d.params=c.parseParameters(b),d.id?d:void 0},CanalPlus.prototype.createEmbedUrl=function(a,b){"use strict";var c="http://player.canalplus.fr/embed/";return b.vid=a.id,c+=combineParams({params:b})},urlParser.bind(new CanalPlus),Coub.prototype.parseUrl=function(a){"use strict";var b=a.match(/(?:embed|view)\/([a-zA-Z\d]+)/i);return b?b[1]:void 0},Coub.prototype.parse=function(a,b){"use strict";var c={mediaType:this.mediaTypes.VIDEO,params:b,id:this.parseUrl(a)};return c.id?c:void 0},Coub.prototype.createUrl=function(a,b,c){"use strict";var d=a+b.id;return d+=combineParams({params:c})},Coub.prototype.createLongUrl=function(a,b){"use strict";return this.createUrl("https://coub.com/view/",a,b)},Coub.prototype.createEmbedUrl=function(a,b){"use strict";return this.createUrl("//coub.com/embed/",a,b)},urlParser.bind(new Coub),Dailymotion.prototype.parseParameters=function(a){"use strict";return this.parseTime(a)},Dailymotion.prototype.parseTime=function(a){"use strict";return a.start&&(a.start=getTime(a.start)),a},Dailymotion.prototype.parseUrl=function(a){"use strict";var b=a.match(/(?:\/video|ly)\/([A-Za-z0-9]+)/i);return b?b[1]:void 0},Dailymotion.prototype.parse=function(a,b){"use strict";var c=this,d={mediaType:this.mediaTypes.VIDEO,params:c.parseParameters(b),id:c.parseUrl(a)};return d.id?d:void 0},Dailymotion.prototype.createUrl=function(a,b,c){"use strict";return a+b.id+combineParams({params:c})},Dailymotion.prototype.createShortUrl=function(a){"use strict";return this.createUrl("https://dai.ly/",a,{})},Dailymotion.prototype.createLongUrl=function(a,b){"use strict";return this.createUrl("https://dailymotion.com/video/",a,b)},Dailymotion.prototype.createEmbedUrl=function(a,b){"use strict";return this.createUrl("//www.dailymotion.com/embed/video/",a,b)},urlParser.bind(new Dailymotion),Twitch.prototype.seperateId=function(a){"use strict";return{pre:a[0],id:a.substr(1)}},Twitch.prototype.parseChannel=function(a,b){"use strict";var c=b.channel||b.utm_content||a.channel;return delete b.utm_content,delete b.channel,c},Twitch.prototype.parseUrl=function(a,b,c){"use strict";var d;return d=a.match(/twitch\.tv\/(\w+)(?:\/(.)\/(\d+))?/i),b.channel=d?d[1]:void 0,d&&d[2]&&d[3]?b.id=d[2]+d[3]:c.video&&(b.id=c.video,delete c.video),b},Twitch.prototype.parseMediaType=function(a){"use strict";var b;return a.channel?b=a.id?this.mediaTypes.VIDEO:this.mediaTypes.STREAM:a.id&&(b=this.mediaTypes.EMBEDVIDEO,delete a.channel),b},Twitch.prototype.parseParameters=function(a){"use strict";return a.t&&(a.start=getTime(a.t),delete a.t),a},Twitch.prototype.parse=function(a,b){"use strict";var c=this,d={};return d=c.parseUrl(a,d,b),d.channel=c.parseChannel(d,b),d.mediaType=c.parseMediaType(d),d.params=c.parseParameters(b),d.channel||d.id?d:void 0},Twitch.prototype.createLongUrl=function(a,b){"use strict";var c="";if(a.mediaType===this.mediaTypes.STREAM)c="https://twitch.tv/"+a.channel;else if(a.mediaType===this.mediaTypes.VIDEO){var d=this.seperateId(a.id);c="https://twitch.tv/"+a.channel+"/"+d.pre+"/"+d.id,b.start&&(b.t=b.start+"s",delete b.start)}return c+=combineParams({params:b})},Twitch.prototype.createEmbedUrl=function(a,b){"use strict";var c="https://player.twitch.tv/";return a.mediaType===this.mediaTypes.STREAM?b.channel=a.channel:(a.mediaType===this.mediaTypes.VIDEO||a.mediaType===this.mediaTypes.EMBEDVIDEO)&&(b.video=a.id,b.start&&(b.t=b.start+"s",delete b.start)),c+=combineParams({params:b})},urlParser.bind(new Twitch),Vimeo.prototype.parseUrl=function(a){"use strict";var b=a.match(/(?:\/(?:channels\/[\w]+|(?:(?:album\/\d+|groups\/[\w]+)\/)?videos?))?\/(\d+)/i);return b?b[1]:void 0},Vimeo.prototype.parseParameters=function(a){"use strict";return this.parseTime(a)},Vimeo.prototype.parseTime=function(a){"use strict";return a.t&&(a.start=getTime(a.t),delete a.t),a},Vimeo.prototype.parse=function(a,b){"use strict";var c={mediaType:this.mediaTypes.VIDEO,params:this.parseParameters(b),id:this.parseUrl(a)};return c.id?c:void 0},Vimeo.prototype.createUrl=function(a,b,c){"use strict";var d=a+b.id,e=c.start;return delete c.start,d+=combineParams({params:c}),e&&(d+="#t="+e),d},Vimeo.prototype.createLongUrl=function(a,b){"use strict";return this.createUrl("https://vimeo.com/",a,b)},Vimeo.prototype.createEmbedUrl=function(a,b){"use strict";return this.createUrl("//player.vimeo.com/video/",a,b)},urlParser.bind(new Vimeo),YouTube.prototype.parseUrl=function(a){"use strict";var b=a.match(/(?:(?:v|vi|be|videos|embed)\/(?!videoseries)|(?:v|ci)=)([\w\-]{11})/i);return b?b[1]:void 0},YouTube.prototype.parseTime=function(a){"use strict";return a.start=getTime(a.start||a.t),delete a.t,a},YouTube.prototype.parseParameters=function(a,b){"use strict";return(a.start||a.t)&&(a.start=getTime(a.start||a.t),delete a.t),a.v===b.id&&delete a.v,a.list===b.id&&delete a.list,a},YouTube.prototype.parseMediaType=function(a){"use strict";if(a.params.list&&(a.list=a.params.list,delete a.params.list),a.id&&!a.params.ci)a.mediaType=this.mediaTypes.VIDEO;else if(a.list)delete a.id,a.mediaType=this.mediaTypes.PLAYLIST;else{if(!a.params.ci)return void 0;delete a.params.ci,a.mediaType=this.mediaTypes.SHARE}return a},YouTube.prototype.parse=function(a,b){"use strict";var c=this,d={params:b,id:c.parseUrl(a)};return d.params=c.parseParameters(b,d),d=c.parseMediaType(d)},YouTube.prototype.createShortUrl=function(a,b){"use strict";var c="https://youtu.be/"+a.id;return b.start&&(c+="#t="+b.start),c},YouTube.prototype.createLongUrl=function(a,b){"use strict";var c="",d=b.start;return delete b.start,a.mediaType===this.mediaTypes.PLAYLIST?(b.feature="share",c+="https://youtube.com/playlist"):a.mediaType===this.mediaTypes.VIDEO?(b.v=a.id,c+="https://youtube.com/watch"):a.mediaType===this.mediaTypes.SHARE&&(b.ci=a.id,c+="https://www.youtube.com/shared"),a.list&&(b.list=a.list),c+=combineParams({params:b}),a.mediaType!==this.mediaTypes.PLAYLIST&&d&&(c+="#t="+d),c},YouTube.prototype.createEmbedUrl=function(a,b){"use strict";var c="//youtube.com/embed";return a.mediaType===this.mediaTypes.PLAYLIST?b.listType="playlist":(c+="/"+a.id,"1"===b.loop&&(b.playlist=a.id)),a.list&&(b.list=a.list),c+=combineParams({params:b})},YouTube.prototype.createImageUrl=function(a,b,c){"use strict";var d=a+b.id+"/",e=c.imageQuality||this.defaultImageQuality;return d+e+".jpg"},YouTube.prototype.createShortImageUrl=function(a,b){"use strict";return this.createImageUrl("https://i.ytimg.com/vi/",a,b)},YouTube.prototype.createLongImageUrl=function(a,b){"use strict";return this.createImageUrl("https://img.youtube.com/vi/",a,b)},urlParser.bind(new YouTube),Youku.prototype.parseUrl=function(a){"use strict";var b=a.match(/(?:(?:embed|sid)\/|v_show\/id_|VideoIDS=)([a-zA-Z0-9]+)/);return b?b[1]:void 0},Youku.prototype.parseParameters=function(a){"use strict";return a.VideoIDS&&delete a.VideoIDS,a},Youku.prototype.parse=function(a,b){"use strict";var c=this,d={mediaType:this.mediaTypes.VIDEO,id:c.parseUrl(a),params:c.parseParameters(b)};return d.id?d:void 0},Youku.prototype.createUrl=function(a,b,c){"use strict";var d=a+b.id;return d+=combineParams({params:c})},Youku.prototype.createEmbedUrl=function(a,b){"use strict";return this.createUrl("http://player.youku.com/embed/",a,b)},Youku.prototype.createLongUrl=function(a,b){"use strict";return this.createUrl("http://v.youku.com/v_show/id_",a,b)},Youku.prototype.createStaticUrl=function(a,b){"use strict";return this.createUrl("http://static.youku.com/v1.0.0638/v/swf/loader.swf?VideoIDS=",a,b)},Youku.prototype.createFlashUrl=function(a,b){"use strict";var c="http://player.youku.com/player.php/sid/"+a.id+"/v.swf";return c+=combineParams({params:b})},urlParser.bind(new Youku);