<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>博客评论添加--${site.name}</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="format-detection" content="telephone=no">
    <meta name="description" content="${site.description}"/>
    <meta name="keywords" content="${site.keywords}"/>
    <meta name="author" content="${site.author}"/>
    <link rel="icon" href="${site.logo}">
    <link rel="stylesheet" href="${base}/static/layui/css/layui.css" media="all" />
    <style type="text/css">
        .layui-form-item .layui-inline{ width:33.333%; float:left; margin-right:0; }
        @media(max-width:1240px){
            .layui-form-item .layui-inline{ width:100%; float:none; }
        }
        .layui-form-item .role-box {
            position: relative;
        }
        .layui-form-item .role-box .jq-role-inline {
            height: 100%;
            overflow: auto;
        }

    </style>
</head>
<body class="childrenBody">
<form class="layui-form" style="width:80%;">
    <div class="layui-form-item">
        <label class="layui-form-label">评论内容</label>
        <div class="layui-input-block">

            <textarea name="content" lay-verify="required" placeholder="请输入评论内容" class="layui-textarea"></textarea>
        </div>
    </div>
    <div class="layui-form-item">
        <label class="layui-form-label">ip</label>
        <div class="layui-input-block">

            <input  type="text"  class="layui-input" name="ip"  placeholder="请输入ip">
        </div>
    </div>
    <div class="layui-form-item">
        <label class="layui-form-label">操作系统</label>
        <div class="layui-input-block">

            <input  type="text"  class="layui-input" name="system"  placeholder="请输入操作系统">
        </div>
    </div>
    <div class="layui-form-item">
        <label class="layui-form-label">浏览器</label>
        <div class="layui-input-block">

            <input  type="text"  class="layui-input" name="browser"  placeholder="请输入浏览器">
        </div>
    </div>
    <div class="layui-form-item">
        <label class="layui-form-label">管理员是否回复</label>
        <div class="layui-input-block">

            <input type="checkbox" name="adminReply"  lay-skin="switch" value="1" lay-text="是|否" >

        </div>
    </div>
    <div class="layui-form-item">
        <label class="layui-form-label">管理员回复内容</label>
        <div class="layui-input-block">

            <textarea name="replyContent"  placeholder="请输入管理员回复内容" class="layui-textarea"></textarea>
        </div>
    </div>
    <div class="layui-form-item">
        <div class="layui-input-block">
            <button class="layui-btn" lay-submit="" lay-filter="addBlogComment">立即提交</button>
            <button type="reset" class="layui-btn layui-btn-primary">重置</button>
        </div>
    </div>
</form>
<script type="text/javascript" src="${base}/static/layui/layui.js"></script>
<script>
    layui.use(['form','jquery','layer'],function(){
        var form      = layui.form,
                $     = layui.jquery,
                layer = layui.layer;


        form.on("submit(addBlogComment)",function(data){
                     if(undefined === data.field.adminReply || '0' === data.field.adminReply || null === data.field.adminReply){
                    data.field.adminReply = false;
                }else{
                    data.field.adminReply = true;
                }


            var loadIndex = layer.load(2, {
                shade: [0.3, '#333']
            });
            $.post("${base}/admin/blogComment/add",data.field,function(res){
                layer.close(loadIndex);
                if(res.success){
                    parent.layer.msg("博客评论添加成功！",{time:1000},function(){
                        parent.layer.close(parent.addIndex);
                        //刷新父页面
                        parent.location.reload();
                    });
                }else{
                    layer.msg(res.message);
                }
            });
            return false;
        });

    });
</script>
</body>
</html>