# Generated by Django 4.2.11 on 2024-06-14 18:59

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('mwmbl', '0007_flagcuration_status_alter_flagcuration_reason'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='flagcuration',
            options={'permissions': [('change_flag_status', 'Can change the flag status (approve or reject)')]},
        ),
        migrations.AlterField(
            model_name='flagcuration',
            name='curation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flag_curation_set', to='mwmbl.curation'),
        ),
        migrations.CreateModel(
            name='DomainSubmission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('submitted_on', models.DateTimeField()),
                ('status', models.CharField(choices=[('PENDING', 'The domain submission is awaiting review'), ('APPROVED', 'The domain submission has been approved'), ('REJECTED', 'The domain submission has been rejected')], default='PENDING', max_length=20)),
                ('status_changed_on', models.DateTimeField(blank=True, null=True)),
                ('rejection_reason', models.CharField(blank=True, choices=[('SPAM', 'The domain submission was rejected because it was spam'), ('OFFENSIVE', 'The domain submission was rejected because it was offensive'), ('LANGUAGE', 'The domain is in an unsupported language'), ('OTHER', 'The domain submission was rejected for another reason')], max_length=20)),
                ('rejection_detail', models.CharField(blank=True, max_length=300)),
                ('status_changed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='domain_submissions_changed', to=settings.AUTH_USER_MODEL)),
                ('submitted_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='domain_submissions', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
