# Generated by Django 4.2.6 on 2023-12-03 06:14
from itertools import groupby
from urllib.parse import urlparse, parse_qs

from django.db import migrations


def create_curations_from_user_curation(apps, schema_editor):
    Curation = apps.get_model('mwmbl', 'Curation')
    UserCuration = apps.get_model('mwmbl', 'UserCuration')

    # Order curations by timestamp
    curations = UserCuration.objects.all().order_by('timestamp')

    # Group by user and url
    for (user, url), curations in groupby(curations, lambda c: (c.user, c.url)):
        curations = list(curations)

        # Get the original results from the first curation
        original_results = curations[0].results

        # Get the new results from the last curation
        new_results = curations[-1].results

        # Get the number of changes from the number of curations
        num_changes = len(curations)

        # Get the timestamp from the first curation
        timestamp = curations[0].timestamp

        # Get the query from the url
        parsed_url_query = parse_qs(urlparse(url).query)
        query = parsed_url_query.get("q", [""])[0]

        # Create the new curation
        curation = Curation(
            timestamp=timestamp,
            query=query,
            original_results=original_results,
            new_results=new_results,
            num_changes=num_changes,
            user=user,
        )
        curation.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mwmbl', '0002_curation'),
    ]

    operations = [
        migrations.RunPython(create_curations_from_user_curation),
    ]
