---
title: Recording for Practice
date: 2021-02-02
---

Last week I finally recorded myself as part of my practice toolset. I've been
putting it off for some time now, despite several prompts from various sources,
saying it is a powerful learning tool. Already, I've experienced some immediate
benefits so I thought I'd share.

First though, I should define what I mean by "Recording for practice". In this
case the reason for recording is in order to later review and so improve playing.
Compare this to recording for others to listen to or just for fun.

You might record a complete performance or a small segment or skill such as a
scale or arpeggio. Recording audio only may provide all you need but video lets
you visually assess things such as technique and posture.

Usable audio and video are easy to achieve these days. Even using something as basic
as a smartphone with a tripod. However a slightly more sophisticated setup such
as a microphone with recording hardware or digital interface plus software
can improve quality.

For my first adventure I plugged my bass into a digital interface (McMillen K-Mix)
and used trusty Audacity software. The point for me was to NOT get sucked into
yak shaving the audio hardware, software and sound recording engineering. Not
easy for a me I can tell you. I just wanted to press record and play.

The hardest part was just getting going. I needed to overcome discomfort of committing
and subsequent critique. However I found, it soon got easier. Once I had practiced
Ode to Joy so I could play it reasonably well I was ready to start. A few trial
runs and I had the sound levels about right. Then after a few more takes I had a
recording ready for review.

It's interesting how my perspective changed when listening to a recording of my
own playing. I found I could be critical without so many emotions getting in the way.
The recording objectively reproduces a moment, warts and all, yet provides a tool
for improving future moments.

It's impressive how much valuable info you can get when listening back.
During practice, you may miss much as your concentration is usually focussed on specific
things to be improved.

However, you do need to be easy on yourself and remember even really experienced
musicians will notice things they feel could be improved. Use recording as a tool
to discover things that went well and others that would benefit from some intentional
practice.

In my case, I spotted marked variation in volume of notes, late notes and others
clipped short. I can now work on these, perhaps with further recordings to help
drill down on specific issues before the next recorded performance.

Some practical thoughts:

- Don't get distracted by the tech. It's just there to make it easy to get the job done
- Get into a relaxed performance mindset, perhaps with breathing or centering exercises
- Don't stop and start again on every mistake. You want to develop performing skills
- Avoid discarding takes as mistakes might point to something to work on
- Consider keeping recordings to show improvements and perhaps provide inspiration

So far I've see these benefits

- Helps reduce performance anxiety as recording feels like a performance
- Focuses practice sessions leading up to recording and after reviewing
- Highlights specific issues to work on that could otherwise be missed
- Makes creative recording and performing seem a little more obtainable
- Provides a real sense of achievement

So, all in all, recording is a great tool to add to practice sessions.
Plus it's rather fun too.
