---
title: Use Cases
index: 4
description: MQTT is the top choice of major companies worldwide for data exchange with constrained devices and server applications.
---

<div class="content-floating">
<h1>Use Cases</h1>
MQTT is used in a large variety of use cases and industries. 
<br/><br/>
   <section id="use-cases">
      <article class="use-case">
         <img src="{{ '/assets/img/automotive.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="automotive">Automotive</h2>
            <ul>
               <li>HiveMQ: <a href="https://www.hivemq.com/case-studies/bmw-mobility-services/" target="_blank">BMW Car-Sharing application</a> relies on HiveMQ for reliable connectivity</li>
               <li>EMQ helps <a href="https://www.emqx.com/en/customers/saic-volkswagen" target="_blank">SAIC Volkswagen building IoV platform</a></li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/logistics.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="logistics">Logistics</h2>
            <ul>
               <li><a href="https://www.hivemq.com/case-studies/large-transportation/" target="_blank">Transportation & Logistics company</a> cuts costs and improves asset tracking</li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/manufacturing.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="manufacturing">Manufacturing</h2>
            <ul>
               <li>Transforming Manufacturing Efficiency: <a href="https://www.bevywise.com/mqtt-usecases/manufacturing-solutions.html" target="_blank">The Power of MQTT in Industrial Solutions</a></li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/smart-home.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="smarthome">Smart Home</h2>
            <ul>
               <li>IBM Telemetry use case: <a href="https://www.ibm.com/docs/en/ibm-mq/latest?topic=cases-telemetry-use-case-home-energy-monitoring-control" target="_blank">Home energy monitoring and control</a></li>
               <li>IBM Telemetry use case: <a href="https://www.ibm.com/docs/en/ibm-mq/latest?topic=cases-telemetry-use-case-home-patient-monitoring" target="_blank">Home patient monitoring</a></li>
               <li>The eFon Technology's <a href="https://www.bevywise.com/blog/iot-home-security-system-mqtt-broker/" target="_blank">Smart Home security system</a> trusts Bevywise MQTT solution</li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/oil-and-gas.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="oil-gas">Energy</h2>
            <ul>
               <li>EMQ helps IoT innovation in the <a href="https://www.emqx.com/en/customers/emq-helps-innovation-in-the-oil-iot" target="_blank">petrochemical industry</a></li>
               <li><a href="https://cirrus-link.com/wp-content/uploads/2022/05/Case-Study-Energy-Company-Maximizing-MQTT-for-Control-and-Efficient-Image-Data-Transfer-Final.pdf" target="_blank">Energy company</a> maximizing MQTT for control</li>
               <li>MQTT implementation on Celikler Holding's <a href="https://www.bevywise.com/blog/iot-success-stories-mqtt-broker-celikler-holding/" target="_blank">power plant monitoring</a></li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/consumer-products.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
            <h2 id="consumer-products">Consumer Products</h2>
            <ul>
               <li>CASO Design creates <a href="https://www.hivemq.com/case-studies/caso/" target="_blank">smart kitchen appliances</a></li>
            </ul>
         </div>
      </article>
   <!-- Use Case Category -->
      <article class="use-case">
         <img src="{{ '/assets/img/transportation.jpg' | relative_url }}" class="use-case-img">
         <div class="use-case-description">
         <h2 id="transportation">Transportation</h2>
         <ul>
            <li>Deploying IoT on Germany's <a href="https://iot.eclipse.org/community/resources/case-studies/pdf/Eclipse%20IoT%20Success%20Story%20-%20DB.pdf" target="_blank">DB Railway System</a></li>
            <li><a href="https://www.hivemq.com/case-studies/air-france-klm/" target="_blank">Air France-KLM Group</a> improves efficiency and passenger experience</li>
         </ul>
      </div>
      </article>
   </section>
</div>

{% include community-contributions.html %}
