---
title: MQTT Specification
index: 2
description: Links to documentation on the MQTT specification and APIs. High quality MQTT logo download.
---

<section class="content-floating">
<h1>MQTT Specifications</h1>

<a href="https://www.oasis-open.org/committees/tc_home.php?wg_abbrev=mqtt"><img src="{{ 'assets/img/oasis-logo.png' | relative_url }}" alt="Oasis Logo" title="Oasis"></a><br/><br/>
MQTT is an OASIS standard. The specification is managed by the OASIS MQTT Technical Committee.

<section id="mqtt-specs">
   <article>
      <div class="spec-hl"> 
         <img src="{{ 'assets/img/mqtt-logo.svg' | relative_url }}" class="specs-logo"><h3>MQTT 5 Specification</h3>
      </div>
      is an OASIS Standard. The specification is available as either<br/>
      &gt; <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/mqtt-v5.0.html">single-page HTML</a> or<br/> 
      &gt; <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/mqtt-v5.0.pdf">PDF</a>.
   </article>
   <article>
      <div class="spec-hl"> 
         <img src="{{ 'assets/img/mqtt-logo.svg' | relative_url }}" class="specs-logo"><h3>MQTT 3.1.1 Specification</h3>
      </div>
      is an older ISO and OASIS Standard. The specification is available as either<br/>
      &gt; <a href="http://docs.oasis-open.org/mqtt/mqtt/v3.1.1/os/mqtt-v3.1.1-os.html">single-page HTML</a> or<br/> 
      &gt; <a href="http://docs.oasis-open.org/mqtt/mqtt/v3.1.1/os/mqtt-v3.1.1-os.pdf">PDF</a>.<br/>
   </article>
   <article>
      <div class="spec-hl"> 
         <img src="{{ 'assets/img/mqtt-logo.svg' | relative_url }}" class="specs-logo"><h3>MQTT 3.1 Specification</h3>
      </div>
      For historical reference, the specification of MQTT v3.1 is available<br/> 
      &gt; <a href="https://public.dhe.ibm.com/software/dw/webservices/ws-mqtt/mqtt-v3r1.html">here</a>.
   </article>
   <article>
      <div class="spec-hl"> 
         <img src="{{ 'assets/img/mqtt-logo.svg' | relative_url }}" class="specs-logo"><h3>MQTT-SN v1.2</h3>
      </div>
      formerly known as MQTT-S, is available<br/>
      &gt; <a href="https://www.oasis-open.org/committees/document.php?document_id=66091&wg_abbrev=mqtt">here</a>
      <br/><br/>
      MQTT for Sensor Networks is aimed at embedded devices on non-TCP/IP networks, such as Zigbee. MQTT-SN is a publish/subscribe messaging protocol for wireless sensor networks (WSN), with the aim of extending the MQTT protocol beyond the reach of TCP/IP infrastructure for Sensor and Actuator solutions.
      Read more about it on <a href="https://www.hivemq.com/blog/mqtt-sn-smart-choice-for-iiot/" target="_blank">HiveMQ’s blog</a>. 
   </article>
</section>
</section>

<section class="technical-committee">
   <div class="floating-right">
   <h2>TC Member Organizations</h2>
   <div id="tc-members">
         <a href="https://www.cisco.com/" target="_blank"><img src=" {{ 'assets/img/tc-cisco.png' | relative_url }}" class="tc-logo" alt="Cisco logo" title="Cisco"></a>
         <a href="https://www.emqx.com/en" target="_blank"><img src=" {{ 'assets/img/tc-emq.png' | relative_url }}" class="tc-logo" alt="EMQ logo" title="EMQ"></a>
         <a href="https://www.hivemq.com" target="_blank" ><img src=" {{ 'assets/img/tc-hivemq.png' | relative_url }}" class="tc-logo" alt="HiveMQ logo" title="HiveMQ"></a>
         <a href="https://www.ibm.com" target="_blank"><img src=" {{ 'assets/img/tc-ibm.png' | relative_url }}" class="tc-logo" alt="IBM logo" title="IBM"></a>
         <a href="https://www.microsoft.com" target="_blank"><img src=" {{ 'assets/img/tc-microsoft.png' | relative_url }}" class="tc-logo" alt="Microsoft logo" title="Microsoft"></a>
         <a href="https://www.ninefx.com" target="_blank"><img src=" {{ 'assets/img/tc-ninefx.png' | relative_url }}" class="tc-logo" alt="Ninefx Logo logo" title="Ninefx"></a>
         <a href="https://www.softwareag.com/" target="_blank"><img src=" {{ 'assets/img/tc-software-ag.png' | relative_url }}" class="tc-logo" alt="Software-AG logo" title="Software-AG"></a>
         <a href="https://www.solace.com/" target="_blank"><img src=" {{ 'assets/img/tc-solace.png' | relative_url }}" class="tc-logo" alt="Solace logo" title="Solace"></a>
         <a href="https://thingstream.io/" target="_blank"><img src=" {{ 'assets/img/tc-thingstream.png' | relative_url }}" class="tc-logo" alt="Thingstream logo" title="Thingstream"></a>
   </div>
         <a href="https://www.oasis-open.org/committees/tc_home.php?wg_abbrev=mqtt"><button class="major-cta major-cta-orange" style="margin: 25px 0;">Join the Technical Committee</button></a>
   </div>
</section>

<section  class="floating-right" style="margin-top: 50px;">
   <h2 id="logos">MQTT Logos</h2>
   Feel free to download the MQTT logo assets in .png, .svg, .eps and .jpg format.
   <article id="mqtt-logos">
      <div class="logo-container">
         <img src="{{ 'assets/img/mqtt-logo.jpg' | relative_url }}" class="mqtt-logo" alt="MQTT Logo" title="MQTT Logo">
         <br />
         &gt; <a href="{{ 'assets/downloads/mqtt-logo.png' | relative_url }}">Save image </a> as transparent PNG
      </div>
      <div class="logo-container">
         <img src="{{ 'assets/img/mqtt-logo-hor-neg.jpg' | relative_url }}" class="mqtt-logo" alt="MQTT Logo" title="MQTT Logo">
         <br />
         &gt; <a href="{{ 'assets/downloads/mqtt-hor-neg.png' | relative_url }}">Save image </a> as transparent PNG
      </div>
      <div class="logo-container">   
         <img src=" {{ 'assets/img/mqtt-logo-ver.jpg' | relative_url }}" class="mqtt-logo" alt="MQTT Logo" title="MQTT Logo">
         <br />&gt; <a href="{{ 'assets/downloads/mqtt-ver.png' | relative_url }}">Save image </a> as transparent PNG
      </div>
      <div class="logo-container">   
         <img src=" {{ 'assets/img/mqtt-logo-ver-neg.jpg' | relative_url }}" class="mqtt-logo" alt="MQTT Logo" title="MQTT Logo">
         <br />&gt; <a href="{{ 'assets/downloads/mqtt-ver-neg.png' | relative_url }}">Save image </a> as transparent PNG
      </div>
   </article>
   <article>
      <a href="{{ 'assets/downloads/mqtt-logo-assets.zip' | relative_url }}" alt="Download MQTT Logo as .eps .svg .png" title="Download MQTT Logo as .eps .svg .png"><button class="major-cta major-cta-orange" style="margin: 25px 0;">Download all MQTT logo assets</button></a>
   </article>
</section>

