# TreeMap API
=============

`TreeMap` is an implementation of Set with values sorted by keys. Keys will be arranged from the lowest to the highest.

**`CollectionType\Map\TreeMap` is a final class:**

* extends: `CollectionType\Map\MapAbstract`
* implements: `CollectionType\Map\Sorted\SortedMapInterface`

### Schema
----------

![CollectionType library structure](/docs/images/TreeMap.png?raw=true)

### Inherited all public methods from:
--------------------------------------

* [CollectionType\Map\MapAbstract](/docs/api/5.2.1.0.MapAbstractAPI.md)

* [CollectionType\Common\KeyTypeTrait](/docs/api/5.3.1.KeyTypeTraitAPI.md)

* [CollectionType\Common\ValueTypeTrait](/docs/api/5.3.2.ValueTypeTraitAPI.md)

## Public methods
-----------------

* `put($key, $value) : bool ` - adds and sorts new element to Map with index passed in `$key`. If Map has element with the same key, 
then value of this element will be overridden. Returns `true` if element will be added, otherwise returns `false`; 

* `putAll(CollectionType\Map\MapInterface $map) : bool` - adds and sorts new elements to Map passed in `$map`. 
If passed Map has element(s) with the same key as base Map, then value(s) of this element(s) will be overridden. 
Returns `true` if elements from `$map` will be added, otherwise returns `false`;

* `sort() : bool` - sorts elements in Map;

### Navigate
------------

* next to [HashMap API](/docs/api/5.2.1.2.HashMapAPI.md)
* back to [MapAbstract API](/docs/api/5.2.1.0.MapAbstractAPI.md)
* go to [index](/docs/README.md)