# MapAbstract API
=================

Map is an object that maps keys to values. A Map cannot contain duplicate keys. Each value is signed to key. Key can hold only one value.

1. [MapAbstract API](/docs/api/5.2.1.0.MapAbstractAPI.md)
    1. [TreeMap API](/docs/api/5.2.1.1.TreeMapAPI.md)
    2. [HashMap API](/docs/api/5.2.1.2.HashMapAPI.md)

**`CollectionType\Map\MapAbstract` is an abstract class:**

* extends: `CollectionType\Iterator\IteratorAbstract`
* implements: `CollectionType\Map\MapInterface`

### Schema
----------

![CollectionType library structure](/docs/images/map_abstract_structure.png?raw=true)

### Inherited all public methods from:
--------------------------------------

* [CollectionType\Common\KeyTypeTrait](/docs/api/5.3.1.KeyTypeTraitAPI.md)

* [CollectionType\Common\ValueTypeTrait](/docs/api/5.3.2.ValueTypeTraitAPI.md)

## Public methods
-----------------

* `__construct(CollectionType\TypeValidator\TypeValidatorInterface $keyType, CollectionType\TypeValidator\TypeValidatorInterface $valueType)` - `$keyType` is index, 
`$valueType` is value assigned to the index;

* `count() : int` - returns number of elements in Map;

* `clear() : void` - clears Map. All elements in Map will be removed;

* `isEmpty() : bool` - returns true if Map hasn't got any elements, otherwise returns false;

* `equalType(CollectionType\TypeValidator\TypeValidatorInterface $keyType, CollectionType\TypeValidator\TypeValidatorInterface $valueType)` - checks if passed 
`$keyType` type and `$valueType` are equal to Map set type;

* `equals(CollectionType\Map\MapInterface $map)` - checks if passed `$map` has the same list of elements as base Map. 
Returns true if given `$map` contains exactly the same elements with exactly the same cardinality;

* `get($key) : CollectionType\TypeValidator\TypeValidatorInterface` - returns value for passed `$key`;
 
* `getKeyOfValue($value) : CollectionType\TypeValidator\TypeValidatorInterface` - returns key value for passed `$value`;

* `keys() : array` - returns all keys in Map;

* `values() : array` - returns all values in Map;

* `put($key, $value) : bool ` - adds new element to Map with index passed in `$key`. If Map has element with the same key, then value of this element will be overridden. 
Returns `true` if element will be added, otherwise returns `false`; 

* `putAll(CollectionType\Map\MapInterface $map) : bool` - adds new elements to Map passed in `$map`. If passed Map has element(s) with the same key as base Map, 
then value(s) of this element(s) will be overridden. Returns `true` if elements from `$map` will be added, otherwise returns `false`;

* `remove($key) : bool` - removes element from the Map which index is passed in `$key`. Returns `true` if element was removed, 
otherwise if element was not found it returns `false`;

* `removeKeyAll(CollectionType\Map\MapInterface $map) : bool` - removes all pairs key-value passed in `$map` from the base Map. 
Elements will be searched only by keys. Values in passed Map are irrelevant. If base Map has all keys passed in `$map` then returns `true`, otherwise returns `false`;

* `removeAll(CollectionType\Map\MapInterface $map) : bool` - removes all elements passed in `$map` from the base Map. 
Elements will be searched by pairs key-value. If base Map has all pairs key-value passed in `$map` then returns `true`, otherwise returns `false`;
 
* `removeValue($value) : bool` - removes element `$value` from the Map. Returns `true` if element was removed, otherwise returns `false`;

* `removeValueAll(CollectionType\Map\MapInterface $map) : bool` - removes all elements passed in `$map` from the base Map. 
Elements will be searched by values. If base Map has all elements passed in `$map` then returns `true`, otherwise returns `false`;
 
* `containsKey($key) : bool` - returns `true` if Map contains key, otherwise returns `false`;

* `containsKeyAll(CollectionType\Map\MapInterface $map)` - returns `true` if Map has all keys passed in `$map`, otherwise returns `false`;

* `containsValue($value) : bool` - returns `true` if Map contains value, otherwise returns `false`;

* `containsValueAll(CollectionType\Map\MapInterface $map) : bool` - returns `true` if Map has all values passed in `$map`, otherwise returns `false`;

* `containsAll(CollectionType\Map\MapInterface $map) : bool` - returns `true` if Map has all pairs key-value passed in `$map`, otherwise returns `false`;

### Navigate
------------

* next to [TreeMap API](/docs/api/5.2.1.1.TreeMapAPI.md)
* back to [Map API](/docs/api/5.2.0.0.MapAPI.md)
* go to [index](/docs/README.md)