# TreeSet API
=============

`TreeSet` is an implementation of Set with sorted values. Elements will be arranged from the lowest to the highest.

**`CollectionType\Collection\CollectionSet\TreeSet` is a final class:**

* extends: `CollectionType\Collection\CollectionSet\SetAbstract`
* implements: `CollectionType\Collection\CollectionSet\Sorted\SortedSetInterface`

### Schema
----------

![CollectionType library structure](/docs/images/tree_set_structure.png?raw=true)

### Inherited all public methods from:
--------------------------------------

* [CollectionType\Iterator\IteratorAbstract](/docs/api/5.1.1.0.0.0.IteratorAbstractAPI.md)

* [CollectionType\Collection\CollectionAbstract](/docs/api/5.1.1.1.0.0.CollectionAbstractAPI.md)

* [CollectionType\Collection\CollectionSet\SetAbstract](/docs/api/5.1.1.1.2.0.SetAbstractAPI.md)

* [CollectionType\Common\ValueTypeTrait](/docs/api/5.3.2.ValueTypeTraitAPI.md)

## Public methods
-----------------

* `add($value) : bool` - adds element passed in `$value` parameter. If Collection has the same element as passed, then returns `false` (element will not be added);

* `addAll(SetInterface $set) : bool` - adds all elements passed in `$set` parameter. If passed Collection has duplicates, 
then duplicates will not be added (will be omitted);

* `sort() : bool` - sorts elements in Collection;

### Navigate
------------

* next to [Map API](/docs/api/5.2.0.0.MapAPI.md)
* back to [HashSet API](/docs/api/5.1.1.1.2.2.HashSetAPI.md)
* go to [index](/docs/README.md)