# LinkedList API
================

The `LinkedList` can hold duplicate elements. Allows insert value of a specified index.

**`CollectionType\Collection\CollectionList\LinkedSet` is a final class:**

* extends: `CollectionType\Collection\CollectionList\ListAbstract`
* implements: `CollectionType\Collection\CollectionList\Sequential\SequentialSetInterface`

### Schema
----------

![CollectionType library structure](/docs/images/LinkedList.png?raw=true)

### Inherited all public methods from:
--------------------------------------

* [CollectionType\Iterator\IteratorAbstract](/docs/api/5.1.1.0.0.0.IteratorAbstractAPI.md)

* [CollectionType\Collection\CollectionAbstract](/docs/api/5.1.1.1.0.0.CollectionAbstractAPI.md)

* [CollectionType\Collection\CollectionList\LinkedList API](/docs/api/5.1.1.1.1.2.LinkedListAPI.md)

* [CollectionType\Common\ValueTypeTrait](/docs/api/5.3.2.ValueTypeTraitAPI.md)

* [CollectionType\Common\Sequential\SequentialTrait](/docs/api/5.3.3.SequentialTraitAPI.md)

## Public methods
-----------------

* `set($index, $value) : bool` - sets element to Collection into index passed in `$index`. `$index` parameter must be positive integer;
 
* `setAll($index, use CollectionType\Collection\CollectionInterface $collection) : bool` - sets Collection which starts from index passed in `$index`. 
`$index` parameter must be positive integer;

### Navigate
------------

* next to [SetAbstract API](/docs/api/5.1.1.1.2.0.SetAbstractAPI.md)
* back to [ArrayList API](/docs/api/5.1.1.1.1.1.ArrayListAPI.md)
* go to [index](/docs/README.md)