# CollectionAbstract API
========================

1. [CollectionAbstract API](/docs/api/5.1.1.1.0.0.CollectionAbstractAPI.md)
    1. [ListAbstract API](/docs/api/5.1.1.1.1.0.ListAbstractAPI.md)
        1. [ArrayList API](/docs/api/5.1.1.1.1.1.ArrayListAPI.md)
        2. [LinkedList API](/docs/api/5.1.1.1.1.2.LinkedListAPI.md)
    2. [SetAbstract API](/docs/api/5.1.1.1.2.0.SetAbstractAPI.md)
        1. [LinkedSet API](/docs/api/5.1.1.1.2.1.LinkedSetAPI.md)
        2. [HashSet API](/docs/api/5.1.1.1.2.2.HashSetAPI.md)
        3. [TreeSet API](/docs/api/5.1.1.1.2.3.TreeSetAPI.md)

**`CollectionAbstract` is an abstract class:**

* extends: `IteratorAbstract`
* implements: `CollectionInterface`

### Schema
----------

![CollectionType library structure](/docs/images/collection_abstract_structure.png?raw=true)

### Inherited all public methods from:
--------------------------------------

* [CollectionType\Iterator\IteratorAbstract](/docs/api/5.1.1.0.0.0.IteratorAbstractAPI.md)

* [CollectionType\Common\ValueTypeTrait](/docs/api/5.3.2.ValueTypeTraitAPI.md)

## Public methods
-----------------

* `__construct(CollectionType\TypeValidator\TypeValidatorInterface $valueType)` - sets validator for held values;

* `clear() : void` - clears Collection. All elements in Collection will be removed;

* `equalType(CollectionType\TypeValidator\TypeValidatorInterface $type) : bool` - checks if passed type is equal to Collection set type;

* `equals(CollectionType\Collection\CollectionInterface $collection)` - checks if passed `$collection` has the same list of elements as base. 
Returns true if given `$collection` contains exactly the same elements with exactly the same cardinality;

* `getAll() : array` - gets all elements of Collection;

* `toArray() : array` - returns all elements in array;

* `remove($value) : bool` - removes element from Collection passed by parameter;

* `removeAll(CollectionType\Collection\CollectionInterface $collection) : bool` - removes all elements passed by `$collection` parameter;

* `removeAny(CollectionType\Collection\CollectionInterface $collection) : bool` - removes any element passed in `$collection` parameter;

* `contains($value) : bool` - returns true if Collection has passed value, otherwise returns `false`;

* `containsAll(CollectionType\Collection\CollectionInterface $collection) : bool` - returns `true` if Collection has all elements passed by `$collection` parameter, 
otherwise returns `false`;

* `getDifference(CollectionType\Collection\CollectionInterface $collection) : CollectionType\Collection\CollectionInterface` - returns only unique elements passed by `$collection` parameter;

### Navigate
------------

* next to [ListAbstract API](/docs/api/5.1.1.1.1.0.ListAbstractAPI.md)
* back to [IteratorAbstract API](/docs/api/5.1.1.0.0.0.IteratorAbstractAPI.md)
* go to [index](/docs/README.md)