# IteratorAbstract API
======================

The `IteratorAbstract` class provides basic methods to cycle through a Collection and to add element.

1. [IteratorAbstract API](/docs/api/5.1.1.0.0.0.IteratorAbstractAPI.md)
    1. [CollectionAbstract API](/docs/api/5.1.1.1.0.0.CollectionAbstractAPI.md)
        1. [ListAbstract API](/docs/api/5.1.1.1.1.0.ListAbstractAPI.md)
            ;1. [ArrayList API](/docs/api/5.1.1.1.1.1.ArrayListAPI.md)
            2. [LinkedList API](/docs/api/5.1.1.1.1.2.LinkedListAPI.md)
        2. [SetAbstract API](/docs/api/5.1.1.1.2.0.SetAbstractAPI.md)
            1. [LinkedSet API](/docs/api/5.1.1.1.2.1.LinkedSetAPI.md)
            2. [HashSet API](/docs/api/5.1.1.1.2.2.HashSetAPI.md)
            3. [TreeSet API](/docs/api/5.1.1.1.2.3.TreeSetAPI.md)

**`CollectionType\Iterator\IteratorAbstract` is an abstract class**:

* implements: `CollectionType\Iterator\IteratorInterface`

### Schema
----------

![CollectionType library structure](/docs/images/iterator_abstract_structure.png?raw=true)

## Public methods

* `getIterator() : ArrayIterator` - returns `ArrayIterator` with values from collection to be iterated on.

* `count() : int` - returns number of elements in collection.

* `clear() : void` - clears collection. All elements in collection will be removed.

* `isEmpty() : bool` - returns true if collection hasn't got any elements, otherwise returns false;

* `current() : mixed` - returns value of the collection element that's currently being pointed to by the internal pointer, or false if collection hasn't got any elements.

* `next() : mixed` - if collection has elements returns value in the next place that's pointed to by the internal array pointer, or false if collection hasn't got any elements.

* `key() : mixed` - if collection has elements returns key of the collection element that's currently being pointed to by the internal pointer, or false if collection hasn't got any elements.

* `first() : mixed` - if collection has elements returns first value of the collection, or false if collection hasn't got any elements.

* `last() : mixed` - if collection has elements returns last value of the collection, or false if collection hasn't got any elements.

* `rewind() : void` - if collection has elements returns set pointer to the first element of the collection and returns them, or false if collection hasn't got any elements.

### Navigate
------------

* next to [CollectionAbstract API](/docs/api/5.1.1.1.0.0.CollectionAbstractAPI.md)
* back to [Collection API](/docs/api/5.1.0.0.0.0.CollectionAPI.md)
* go to [index](/docs/README.md)