# Usage
=======

This document will describe how to use CollectionType.

Every instance of CollectionType must define what type of elements will be held. First of all, you must define type and pass it to CollectionType instance.
PHP does not have generic type, hence it needs to define an object which will check elements of type. That type object is called TypeValidator.

For example, definition of object TypeValidator looks like this:

```php
use CollectionType\TypeValidator\ObjectTypeValidator;

$objectType = new ObjectTypeValidator();
```
You can use other predefined TypeValidators or define and use your own TypeValidator. TypeValidators are described in [Types](/docs/4.TypeValidators.md) section.

After this, you can create collection, for example `HashSet`:

```php
use CollectionType\Collection\CollectionSet\HashSet;

$set = new HashSet(new ObjectTypeValidator());
```

Now, you can add, list, remove elements and do other things with defined Collection. All public function will be described in [API](/docs/5.API.md) section.
Every added element to Collection must be the same type (must be valid by passed TypeValidator) as defined and passed in `HasSet` constructor.

For example:

```php
use CollectionType\Collection\CollectionSet\HashSet;
use CollectionType\TypeValidator\ObjectTypeValidator;

$objectType = new ObjectTypeValidator();
$set = new HashSet($objectType);

$obj1 = new \stdClass();
$set->add($obj1);

$obj2 = new \stdClass();
$set->add($obj2);
```

You cannot add other element type as defined ObjectType. This causes error:
```php
$set->add('invalid element');
```

```sh
CollectionType\Exception\InvalidTypeException: The value is incorrect type. string given!
```

Getting all elements held in collection:

```php
$set->getAll();
```

Comparing types of collections:

```php
use CollectionType\Collection\CollectionSet\HashSet;
use CollectionType\TypeValidator\IntegerTypeValidator;
use CollectionType\TypeValidator\ObjectTypeValidator;

$setIntegerType = new HashSet(new IntegerTypeValidator());

$setObjectType = new HashSet(new ObjectTypeValidator());

// it returns false
$setIntegerType->equalType($setObjectType->getValueType());
```

Adding `HashSet` to `HashSet` when both have the same type:

```php
use CollectionType\Collection\CollectionSet\HashSet;
use CollectionType\TypeValidator\ObjectType;

$set1 = new HashSet(new ObjectTypeValidator());
$set1->add(new \stdClass());

$set2 = new HashSet(new ObjectTypeValidator());
$set2->add(new \stdClass());

$set1->addAll($set2);
```

Using `HashMap`:

```php
use CollectionType\Map\HashMap;
use CollectionType\TypeValidator\StringTypeValidator;
use CollectionType\TypeValidator\ObjectTypeValidator;

$map = new HashMap(new StringTypeValidator(), new ObjectTypeValidator());
$map->put('key1', new \stdClass());

$key = $map->getKeyOfValue(new \stdClass());
```

### Navigate
------------

* next to [Types](/docs/4.TypeValidators.md)
* back to [Library structure](/docs/2.LibraryStructure.md)
* go to [index](/docs/README.md)