# Introduction
==============

Welcome to the documentation of CollectionType.

In this part, the following questions will be answered:

* What is CollectionType library?
* How does it work?
* When you need CollectionType library?
* When you shouldn't use CollectionType library?

## What is CollectionType library?
----------------------------------

A CollectionType is an object that groups multiple elements into a single unit. CollectionType is used to store, retrieve and manipulate data. 
Furthermore, CollectionType provides checking types of data added to the Collection or Map.
The name of library is CollectionType but the library provides implementation of both Collection and Map.

* Collection: you can collate to numerous array. You can add, hold, retrieve and remove elements without bothering about keys.
* Map: you can collate to array of pair key<->value, which key can be scalar type or object.
 
It is important that if you define your Collection or Map, all added elements will have the same type. Collection and Map will check the type of added element. 

The CollectionType library is an architecture for representing and manipulating data. The CollectionType library provides:

* Interfaces which are abstract data types that represent collections.
* Implementations which are the implementations of the collection interfaces.

The CollectionType library's structure is inspired by Java Collection framework provided by `java.util.*` library. The CollectionType library is not 1:1 implementation of Java Collection framework. It has its own architecture and implementation.

## How does it work?
--------------------

Usage of the CollectionType library is very simple. For example:

```php
use CollectionType\Collection\CollectionSet\HashSet;
use CollectionType\TypeValidator\IntegerTypeValidator;

$collectionType = new HashSet(new IntegerTypeValidator());

// Adding correct type of values
$collectionType->add(100);
$collectionType->add(101);

// This will throw an error. Incorrect type of adding value. It must be integer, string given.
$collectionType->add('incorrect type');
```

## When you need CollectionType library?
--------------------------------------

You can use the CollectionType library when you want to have absolute certainty that elements (or/and keys in Map) of collection have the same type.

## When you shouldn't use CollectionType library?
-----------------------------------------------

The CollectionType library **is not suitable for high performance architecture**. The CollectionType library has its own surcharge of extra execute time for validate type of each element in collection.  

### Navigate
------------

* next to [Library structure](/docs/2.LibraryStructure.md)
* go to [index](/docs/README.md)