<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($pEs5l, \Closure $KqSwj = null) { goto Y6bkv; c35vV: $this->repository = Repository::instance($pEs5l); goto PYuk3; n6AVr: $this->builder($KqSwj); goto MoWda; VqE33: $this->setupRepositoryFilter(); goto n6AVr; Y6bkv: $this->id = IdUtil::generate('Grid'); goto c35vV; PYuk3: $this->setupFields(); goto YHi4X; YHi4X: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto VqE33; MoWda: } public static function make($BWo2e = null, \Closure $KqSwj = null) { if (is_object($BWo2e) || class_exists($BWo2e) && is_subclass_of($BWo2e, Model::class)) { return new Form($BWo2e, $KqSwj); } return new Form(DynamicModel::make($BWo2e), $KqSwj); } public function asTree($AWXu8 = 'id', $LdK4t = 'pid', $xleCl = 'sort', $HPS0I = 'title') { goto nsXWd; o6U7u: $this->repository->setTreePidColumn($LdK4t); goto SRobB; TYJvf: return $this; goto zSC58; RWHvZ: $this->canSort(true); goto TYJvf; fPv6k: $this->repository->setTreeTitleColumn($HPS0I); goto ApPMD; ApPMD: $this->engine = FormEngine::TREE; goto RWHvZ; SRobB: $this->repository->setSortColumn($xleCl); goto fPv6k; nsXWd: $this->repository->setKeyName($AWXu8); goto o6U7u; zSC58: } public function asTreeMass($veSD3 = 0, $AWXu8 = 'id', $LdK4t = 'pid', $xleCl = 'sort', $HPS0I = 'title') { goto xUwj2; d4CR0: $this->canSort(true); goto laG_S; arr9b: $this->repository->setTreeTitleColumn($HPS0I); goto sSgPt; cV3aL: $this->repository->setTreePidColumn($LdK4t); goto EYumk; laG_S: return $this; goto QeeZm; sSgPt: $this->engine = FormEngine::TREE_MASS; goto d4CR0; EYumk: $this->repository->setSortColumn($xleCl); goto arr9b; xUwj2: $this->repository->setKeyName($AWXu8); goto cV3aL; QeeZm: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $acdQI = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $acdQI->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $acdQI = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $acdQI->value(0); } $this->prependField($acdQI); } else { if ($this->engine == FormEngine::TREE_MASS) { goto TCo12; TCo12: $acdQI = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto zZiaj; GbNRU: $acdQI->hookRendering(function (AbstractField $acdQI, $Xvngd, $K_IJ6) { if (empty($Xvngd)) { $So5Sv = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $So5Sv = $Xvngd->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $So5Sv); $sSGsz = $this->repository->getTreeAncestorItems(); $A1nut = array(); $A1nut[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($sSGsz as $wvW07) { $A1nut[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($wvW07->{$this->repository->getTreeTitleColumn()}); } $A1nut[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($So5Sv) . '" />'; return AutoRenderedFieldValue::make(join('', $A1nut)); }); goto pRKUl; zZiaj: $acdQI->addable(true)->editable(true)->listable(false); goto GbNRU; pRKUl: $this->prependField($acdQI); goto dHEZh; dHEZh: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($BpSP0, $kFc4w) { goto V6qrx; g2jfU: return $NH83J; goto s6kHx; emYzY: foreach ($BpSP0 as $acdQI) { if (!($IwADg = $acdQI->getValidator($kFc4w))) { continue; } if ($IwADg instanceof Validator) { try { if (!$IwADg->passes()) { $XxUnB[] = $IwADg; } } catch (\Exception $WVwSN) { BizException::throws('Form.fieldValidateMessages.Error - ' . json_encode($IwADg->getRules(), JSON_UNESCAPED_UNICODE)); } } } goto UlCjo; yxAX8: if (empty($NH83J)) { return false; } goto g2jfU; V6qrx: $XxUnB = array(); goto emYzY; UlCjo: $NH83J = array(); goto ojvcc; ojvcc: foreach ($XxUnB as $IwADg) { foreach ($IwADg->messages()->getMessages() as $VDtGk => $nh_e7) { $NH83J[$VDtGk] = $nh_e7; } } goto yxAX8; s6kHx: } private function convertBizExceptionToResponse($PvPxO) { goto XrVkd; TunJP: $uNYdf = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto UasOR; bxImq: return Response::jsonError($aCIJ8); goto yol2v; UasOR: foreach ($uNYdf as $JJRD4) { if (Str::startsWith($aCIJ8, $JJRD4[0])) { goto ylyUc; GKOUC: if ($acdQI) { return Response::jsonError(L($JJRD4[1], $acdQI->label())); } goto l6JBE; SKzKu: $acdQI = $this->getFieldByColumn($w3jTU); goto GKOUC; ylyUc: list($vn2QN, $w3jTU) = explode(':', $aCIJ8); goto SKzKu; l6JBE: } } goto bxImq; XrVkd: $aCIJ8 = $PvPxO->getMessage(); goto TunJP; yol2v: } private function validateFields($BpSP0, $CnWtd) { goto BB6dM; S8XQS: return Response::generateSuccess(); goto eEUTD; oAEOp: if ($XlSwY = $this->fieldValidateMessages($BpSP0, $CnWtd)) { $Iy7vy = array_merge($Iy7vy, $XlSwY); } goto QwT4h; BB6dM: $Iy7vy = array(); goto oAEOp; QwT4h: foreach ($Iy7vy as $VDtGk => $NH83J) { foreach ($NH83J as $NLEz7) { return Response::generateError($NLEz7); } } goto S8XQS; eEUTD: } private function removeReservedFields() { goto uoW1o; S2r7x: $this->fields = $this->fields()->reject($UXLeE); goto e03xT; uoW1o: $lfbcL = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto ODqcq; ODqcq: $UXLeE = function (AbstractField $acdQI) use(&$lfbcL) { return in_array($acdQI->column(), $lfbcL, true) && $acdQI instanceof \ModStart\Field\Display; }; goto S2r7x; e03xT: } public function hookCall($SO11l) { if ($SO11l instanceof Closure) { $f3Nqc = call_user_func($SO11l, $this); if (null !== $f3Nqc) { return $f3Nqc; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($SO11l, array $CnWtd = null) { goto ZqPon; sVnrO: $this->build(); goto LA0ww; ZqPon: $this->mode(FormMode::FORM); goto sVnrO; AZp_Z: try { goto I8Lzv; WKO9L: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto nhJ0F; n7WUO: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto QdNrm; Po5My: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto hoi1b; OUjPV: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto oEwNC; TokFC: foreach ($this->addableFields() as $acdQI) { goto hIzuu; YmT8o: if ($acdQI->hookValueSerialize()) { $Gttsd = call_user_func($acdQI->hookValueSerialize(), $Gttsd, $acdQI); } goto bXfaQ; hIzuu: if ($acdQI->isLayoutField()) { continue; } goto xQB4f; nDwBv: $Gttsd = $acdQI->serializeValue($Gttsd, $acdQI); goto YmT8o; Zltlq: $Gttsd = $acdQI->prepareInput($Gttsd, $this->dataSubmitted); goto nDwBv; bXfaQ: $this->dataForming[$acdQI->column()] = $Gttsd; goto jJw91; xQB4f: $Gttsd = isset($this->dataSubmitted[$acdQI->column()]) ? $this->dataSubmitted[$acdQI->column()] : null; goto Zltlq; jJw91: } goto WKO9L; uFKwe: $this->removeReservedFields(); goto TokFC; oEwNC: if (null !== $f3Nqc) { return Response::jsonFromGenerate($f3Nqc); } goto n7WUO; I8Lzv: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto Po5My; hoi1b: $this->dataForming = array(); goto uFKwe; QdNrm: return Response::jsonSuccess(L('Save Success')); goto yE1nV; fa33i: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto OUjPV; DVZfL: if (null !== $f3Nqc) { if (Response::isError($f3Nqc)) { return Response::jsonFromGenerate($f3Nqc); } } goto fa33i; nhJ0F: $f3Nqc = call_user_func($SO11l, $this); goto DVZfL; yE1nV: } catch (BizException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } catch (ResultException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } goto ww587; LA0ww: $this->dataSubmitted = $CnWtd ? $CnWtd : Input::all(); goto AZp_Z; ww587: } public function add() { goto pEdYG; smDKm: if ($this->canCopy()) { $mKDlE = CRUDUtil::copyId(); if ($mKDlE) { goto xEUiC; UtqSi: $this->item($this->repository()->editing($this)); goto gGrnf; gGrnf: $this->itemId(0); goto aEHUU; aEHUU: $II22R = true; goto eiZJZ; xEUiC: $this->itemId($mKDlE); goto UtqSi; eiZJZ: } } goto Y__hJ; Y__hJ: $this->build(); goto F4CaY; s_M53: $II22R = false; goto smDKm; sONec: return $this; goto emHGy; pEdYG: $this->mode(FormMode::ADD); goto s_M53; F4CaY: if ($II22R) { $this->fillFields(); } goto sONec; emHGy: } public function addRequest(array $CnWtd = null) { goto iC8Zk; nJH1Q: $this->build(); goto c0JKB; iC8Zk: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto cd5Ga; pq3pn: try { goto YGqPh; AaoKR: foreach ($this->addableFields() as $acdQI) { if ($acdQI->hookValueSaved()) { call_user_func($acdQI->hookValueSaved(), $T6TGt, $acdQI); } } goto WjmHq; Bh9KT: $this->dataAdding = array(); goto Lminl; Lminl: $this->removeReservedFields(); goto goS4N; N49p7: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto Bh9KT; WjmHq: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto TOXBd; goS4N: foreach ($this->addableFields() as $acdQI) { goto Mx6E0; vsf4H: $Gttsd = $acdQI->prepareInput($Gttsd, $this->dataSubmitted); goto nlSgU; G_SJL: $Gttsd = isset($this->dataSubmitted[$acdQI->column()]) ? $this->dataSubmitted[$acdQI->column()] : null; goto vsf4H; Mx6E0: if ($acdQI->isLayoutField() || $acdQI->isCustomField()) { continue; } goto G_SJL; W2jM2: if ($acdQI->hookValueSerialize()) { $Gttsd = call_user_func($acdQI->hookValueSerialize(), $Gttsd, $acdQI); } goto HfO9D; nlSgU: $Gttsd = $acdQI->serializeValue($Gttsd, $acdQI); goto W2jM2; HfO9D: $this->dataAdding[$acdQI->column()] = $Gttsd; goto JkK3M; JkK3M: } goto zNMN6; TOXBd: return Response::jsonSuccess(L('Add Success')); goto w_29x; YGqPh: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto N49p7; zNMN6: $T6TGt = $this->repository->add($this); goto AaoKR; w_29x: } catch (BizException $WVwSN) { return $this->convertBizExceptionToResponse($WVwSN); } catch (ResultException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } goto sZPHC; c0JKB: $this->dataSubmitted = $CnWtd ? $CnWtd : Input::all(); goto pq3pn; cd5Ga: $this->mode(FormMode::ADD); goto nJH1Q; sZPHC: } public function edit($T6TGt) { try { goto oUMfz; wRfmn: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto S1IT7; j8MTn: $this->item($this->repository()->editing($this)); goto wRfmn; s6odB: $this->fillFields(); goto T3A4v; T3A4v: return $this; goto Ylf42; ouXMO: $this->itemId($T6TGt); goto j8MTn; S1IT7: $this->build(); goto s6odB; oUMfz: $this->mode(FormMode::EDIT); goto ouXMO; Ylf42: } catch (BizException $WVwSN) { return Response::sendError($WVwSN->getMessage()); } } public function editRequest($T6TGt, array $CnWtd = null) { goto FXJRh; FXJRh: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto xf4iO; qFVsO: try { goto OmqcC; OmqcC: $this->edit($T6TGt); goto z81un; XYr0T: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto stJrw; jfhib: if ('itemCellEdit' == $fOKL5) { foreach ($this->editableFields() as $acdQI) { if ($acdQI->column() == $VDtGk && $acdQI->hookValueSaved()) { call_user_func($acdQI->hookValueSaved(), $this->itemId(), $acdQI); } } } else { foreach ($this->editableFields() as $acdQI) { if ($acdQI->hookValueSaved()) { call_user_func($acdQI->hookValueSaved(), $this->itemId(), $acdQI); } } } goto EDBGJ; stJrw: $this->dataEditing = array(); goto v6A7s; z81un: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto XYr0T; NOyXC: $fOKL5 = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto pvENv; pvENv: if ('itemCellEdit' == $fOKL5) { goto Re5o9; hG_gl: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto tVmno; faaYq: if ($VDtGk) { foreach ($this->editableFields() as $acdQI) { if ($acdQI->isLayoutField() || $acdQI->isCustomField()) { continue; } if ($acdQI->column() == $VDtGk) { $this->dataEditing[$acdQI->column()] = $Gttsd; break; } } } goto hG_gl; Re5o9: $VDtGk = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto KdDb1; KdDb1: $Gttsd = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto faaYq; tVmno: } else { foreach ($this->editableFields() as $acdQI) { goto ZOFgJ; G0JxW: $Gttsd = $acdQI->prepareInput($Gttsd, $this->dataSubmitted); goto cDPO0; ZOFgJ: if ($acdQI->isLayoutField() || $acdQI->isCustomField()) { continue; } goto eRuhS; ANdRY: if ($acdQI->hookValueSerialize()) { $Gttsd = call_user_func($acdQI->hookValueSerialize(), $Gttsd, $acdQI); } goto FsDLG; FsDLG: $this->dataEditing[$acdQI->column()] = $Gttsd; goto D3wa2; cDPO0: $Gttsd = $acdQI->serializeValue($Gttsd, $acdQI); goto ANdRY; eRuhS: $Gttsd = isset($this->dataSubmitted[$acdQI->column()]) ? $this->dataSubmitted[$acdQI->column()] : null; goto G0JxW; D3wa2: } } goto ll0Fg; v6A7s: $this->removeReservedFields(); goto NOyXC; EDBGJ: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto x3nh4; x3nh4: return Response::jsonSuccess(L('Edit Success')); goto Hbkc6; ll0Fg: $this->repository()->edit($this); goto jfhib; Hbkc6: } catch (BizException $WVwSN) { return $this->convertBizExceptionToResponse($WVwSN); } catch (ResultException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } goto M7jZU; xf4iO: $this->dataSubmitted = $CnWtd ? $CnWtd : Input::all(); goto qFVsO; M7jZU: } public function deleteRequest($DQL3P) { goto TapkI; KI9L2: $this->mode(FormMode::DELETE); goto t74xd; wWJKe: try { goto a3uvo; q1MOc: $trLLJ = $this->repository->delete($this, $CnWtd); goto BhpbE; KrnRj: $this->item($CnWtd); goto ah1ou; a3uvo: $CnWtd = $this->repository->deleting($this); goto KrnRj; ah1ou: $this->itemId(collect($CnWtd)->map(function ($Etabp) { return $Etabp->{$this->repository()->getKeyName()}; })->toArray()); goto q1MOc; BhpbE: return Response::jsonSuccess(L('Delete Success')); goto xwTSM; xwTSM: } catch (BizException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } catch (ResultException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } goto Yh1v0; TapkI: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto KI9L2; t5n8n: $this->build(); goto wWJKe; t74xd: $this->itemId($DQL3P); goto t5n8n; Yh1v0: } public function sortRequest($DQL3P) { goto zO9nS; QqKcG: try { goto PhXfv; PhXfv: $trLLJ = $this->repository->sortEdit($this); goto Hkj6v; Nzkrw: return Response::jsonSuccess(L('Operate Success')); goto UrZqP; Hkj6v: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto Nzkrw; UrZqP: } catch (BizException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } catch (ResultException $WVwSN) { return Response::jsonError($WVwSN->getMessage()); } goto vS9Ap; o9Emz: $this->itemId($DQL3P); goto OFfwg; lXYS2: $this->repository->setArgument('direction', $kFc4w->getType('direction', SortDirection::class)); goto duBCG; OFfwg: $kFc4w = InputPackage::buildFromInput(); goto lXYS2; x7ENA: $this->mode(FormMode::SORT); goto o9Emz; zO9nS: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto x7ENA; duBCG: $this->build(); goto QqKcG; vS9Ap: } public function render() { goto hU03l; yte0C: switch ($this->mode) { case FormMode::FORM: $CnWtd['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto mIacK; ohbnn: break; goto rYs00; Pw4WK: $CnWtd['fields'] = $this->addableFields(true); goto ohbnn; mIacK: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto Pw4WK; rYs00: case FormMode::EDIT: goto T126d; AYxRw: break; goto ezlGk; T126d: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto V5jS6; V5jS6: $CnWtd['fields'] = $this->editableFields(true); goto AYxRw; ezlGk: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto Nh7X_; hU03l: $CnWtd = array(); goto yte0C; Nh7X_: $CnWtd = array_merge($this->fluentAttributeVariables(), $CnWtd); goto xtI2s; xtI2s: return view($this->view, $CnWtd)->render(); goto HljUa; HljUa: } public function __call($fSCUf, $g59Hh) { goto TFrVf; BQJYi: if ($this->isFluentAttribute($fSCUf)) { switch ($fSCUf) { case 'item': if (isset($g59Hh[0]) && is_array($g59Hh[0])) { $g59Hh[0] = RepositoryUtil::itemFromArray($g59Hh[0]); } break; } return $this->fluentAttribute($fSCUf, $g59Hh); } goto CNunJ; CNunJ: return FieldManager::call($this, $fSCUf, $g59Hh); goto gUgWC; TFrVf: switch ($fSCUf) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': return $this; } goto BQJYi; gUgWC: } public function __toString() { try { return $this->render(); } catch (\Exception $WVwSN) { return $WVwSN->getMessage(); } } }