@extends($_viewFrame)

@section('pageTitleMain'){{'搜索“'.$keyword.'”'}}@endsection
@section('pageKeywords'){{'搜索“'.$keyword.'”'}}@endsection
@section('pageDescription'){{'搜索“'.$keyword.'”'}}@endsection

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::style('[data-markjs]{color:red !important;background:transparent;}') !!}
{!! \ModStart\ModStart::script("$('.item-d .title,.item-d .summary').mark(".json_encode($keyword).",{});") !!}

@section('bodyContent')

    @include('module::CmsHelp.View.pc.cmsHelp.inc.searchBlock')

    <div class="ub-container margin-top">
        <div class="ub-search-result">
            搜索 <span class="keyword">{{$keyword}}</span> ，共找到 <span class="count">{{$total}}</span> 条记录
        </div>
    </div>

    <div class="ub-container margin-top">
        <div class="ub-list">
            <div class="head">
                <div class="title">
                    搜索结果
                </div>
            </div>
            <div class="body">
                @if(empty($records))
                    <div class="ub-empty">
                        <div class="icon"><i class="iconfont icon-empty-box"></i></div>
                        <div class="text">暂无记录</div>
                    </div>
                @endif
                <div class="row">
                    @foreach($records as $record)
                        <div class="col-md-12 col-12">
                            <div class="item-d">
                                <a class="title" href="{{$__msRoot}}help/{{$record['id']}}">{{$record['title']}}</a>
                                <div class="summary">
                                    {{\ModStart\Core\Util\HtmlUtil::text($record['content'],200)}}
                                </div>
                                <div class="action">
                                    <div class="left">
                                        分类：
                                        <a href="{{$__msRoot}}help/category/{{$record['categoryId']}}">{{$record['_category']['name']}}</a>
                                    </div>
                                    <div class="right"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-page">
            {!! $pageHtml !!}
        </div>
    </div>
@endsection





