@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' | '.modstart_config('siteSlogan')}}@endsection
@section('pageDescription'){{modstart_config('siteDescription')}}@endsection
@section('pageKeywords'){{modstart_config('siteKeywords')}}@endsection

@section('bodyContent')

    @if(modstart_module_enabled('Banner'))
        {!! \Module\Banner\View\BannerView::basic('novel',null,'5-1') !!}
    @endif

    <div class="ub-container">

        <div class="ub-panel margin-top">
            <div class="head">
                <div class="title">
                    <i class="iconfont icon-gift"></i>
                    好书推荐
                </div>
            </div>
            <div class="body">
                <div class="row">
                    @foreach(\Module\Novel\Model\NovelBook::recommends(8) as $book)
                        <div class="col-md-3 col-12">
                            <div class="tw-flex">
                                <div class="tw-w-20 tw-flex-shrink-0 margin-right">
                                    <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                                </div>
                                <div class="tw-flex-grow tw-min-w-0">
                                    <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                    <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                        {{$book['summary']}}
                                    </div>
                                    <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                        作者：
                                        <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                            {{$book['_author']['username']}}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="ub-panel margin-top">
            <div class="head">
                <div class="title">
                    <i class="iconfont icon-time"></i>
                    最近更新
                </div>
            </div>
            <div class="body">
                <div class="row">
                    @foreach(\Module\Novel\Model\NovelBook::latestUpdated(8) as $book)
                        <div class="col-md-3 col-12">
                            <div class="tw-flex">
                                <div class="tw-w-20 tw-flex-shrink-0 margin-right">
                                    <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                                </div>
                                <div class="tw-flex-grow tw-min-w-0">
                                    <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                    <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                        {{$book['summary']}}
                                    </div>
                                    <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                        作者：
                                        <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                            {{$book['_author']['username']}}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        @foreach(\Module\Novel\Model\NovelCategory::categoryTree() as $cat0)
            <div class="ub-panel margin-top">
                <div class="head">
                    <div class="more">
                        @if(!empty($cat0['_child']))
                            @foreach($cat0['_child'] as $cat1)
                                <a href="{{modstart_web_url('novel/book_list',['categoryId'=>$cat1['id']])}}" class="btn btn-sm btn-round">{{$cat1['title']}}</a>
                            @endforeach
                        @endif
                    </div>
                    <div class="title">
                        <a href="{{modstart_web_url('novel/book_list',['categoryId'=>$cat0['id']])}}"
                            class="ub-text-default">
                            <i class="iconfont icon-category"></i>
                            {{$cat0['title']}}
                        </a>
                    </div>
                </div>
                <div class="body">
                    <div class="row">
                        @foreach(\Module\Novel\Model\NovelBook::latestByCategoryId($cat0['id'],8) as $book)
                            <div class="col-md-3 col-12">
                                <div class="tw-flex">
                                    <div class="tw-w-20 tw-flex-shrink-0 margin-right">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                                    </div>
                                    <div class="tw-flex-grow tw-min-w-0">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                        <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                            {{$book['summary']}}
                                        </div>
                                        <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                            作者：
                                            <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                                {{$book['_author']['username']}}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endforeach

    </div>

    @if(modstart_module_enabled('Partner'))
        <div class="ub-container margin-top">
            {!! \Module\Partner\View\PartnerView::simple('novel') !!}
        </div>
    @endif

@endsection
