@extends($_viewFrame)

@section('pageTitleMain'){{$title}}@endsection
@section('pageKeywords'){{$title}}@endsection
@section('pageDescription'){{$title}}@endsection

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::style('[data-markjs]{color:red !important;background:transparent;}') !!}
{!! \ModStart\ModStart::script("$('.pb-keywords').mark(".json_encode($keywords).".split('').join(' '),{separateWordSearch:true});") !!}

@section('bodyContent')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('novel')}}">连载文学</a>
            <a class="active" href="{{modstart_web_url('novel/book_search')}}">书籍搜索</a>
        </div>

        <div class="row">

            <div class="col-md-12">
                <div class="tw-bg-white tw-rounded tw-p-4">
                    <div class="ub-search-block-a">
                        <input class="input" type="text" placeholder="输入关键词搜索" id="keywords"
                               value="{{ empty($keywords) ? '' : $keywords }}"
                               onkeypress="if(event.keyCode===13){window.location.href='{{modstart_web_url('novel/book_search')}}?keywords='+window.api.util.urlencode($(this).val());}">
                        <a class="search-btn" href="javascript:;"
                           onclick="window.location.href='{{modstart_web_url('novel/book_search')}}?keywords='+window.api.util.urlencode($(this).prev().val());">
                            <span class="iconfont icon-search"></span>
                            搜索
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            搜索 <span class="keyword ub-text-danger">{{$keywords}}</span> ，共找到 <span
                                class="count ub-text-danger">{{$total}}</span> 条记录
                        </div>
                    </div>
                    <div class="body">
                        @foreach($records as $book)
                            <div class="tw-border-b tw-border-0 tw-border-dashed tw-border-gray-200 tw-mb-4">
                                <div class="tw-flex tw-items-center">
                                    <div class="tw-w-28 tw-flex-shrink-0 margin-right">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                                    </div>
                                    <div class="tw-flex-grow tw-min-w-0">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="pb-keywords tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                        <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                            {{$book['summary']}}
                                        </div>
                                        <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                            作者：
                                            <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                                {{$book['_author']['username']}}
                                            </a>
                                        </div>
                                    </div>
                                    <div>
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="btn btn-primary btn-round">
                                            进入阅读
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
