@extends($_viewFrame)

@section('pageTitleMain'){{$title}}@endsection
@section('pageKeywords'){{$title}}@endsection
@section('pageDescription'){{$title}}@endsection

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::style('[data-markjs]{color:red !important;background:transparent;}') !!}
{!! \ModStart\ModStart::script("$('.pb-keywords').mark(".json_encode($keywords).".split('').join(' '),{separateWordSearch:true});") !!}

@section('bodyContent')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('novel')}}">连载文学</a>
            <a class="active" href="{{modstart_web_url('novel/book_search')}}">书籍列表</a>
        </div>

        <div class="row">

            <div class="col-md-12">
                <div class="ub-nav-group">
                    <div class="group">
                        <div class="label">
                            <div class="text">频道</div>
                        </div>
                        <div class="items">
                            <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>null])}}"
                               @if(!$rootCategory) class="active" @endif>全部</a>
                            @foreach(\Module\Novel\Model\NovelCategory::categoryTree() as $cat0)
                                <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>$cat0['id']])}}"
                                   @if($rootCategory&&$rootCategory['id']==$cat0['id']) class="active" @endif>{{$cat0['title']}}</a>
                            @endforeach
                        </div>
                    </div>
                    @if($rootCategory)
                        @foreach(\Module\Novel\Model\NovelCategory::categoryTree() as $cat0)
                            @if($rootCategory['id']==$cat0['id'] && !empty($cat0['_child']))
                                <div class="group">
                                    <div class="label">
                                        <div class="text">分类</div>
                                    </div>
                                    <div class="items">
                                        <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>null])}}"
                                           @if($category['id']==$rootCategory['id']) class="active" @endif>全部</a>
                                        @foreach($cat0['_child'] as $cat1)
                                            <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>$cat1['id']])}}"
                                               @if($category&&$category['id']==$cat1['id']) class="active" @endif>{{$cat1['title']}}</a>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endif
                </div>
            </div>

            <div class="col-md-12">
                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            {{$title}}
                        </div>
                    </div>
                    <div class="body">
                        @foreach($records as $book)
                            <div class="tw-border-b tw-border-0 tw-border-dashed tw-border-gray-200 tw-mb-4">
                                <div class="tw-flex tw-items-center">
                                    <div class="tw-w-28 tw-flex-shrink-0 margin-right">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                                    </div>
                                    <div class="tw-flex-grow tw-min-w-0">
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="pb-keywords tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                        <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                            {{$book['summary']}}
                                        </div>
                                        <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                            作者：
                                            <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                                {{$book['_author']['username']}}
                                            </a>
                                        </div>
                                    </div>
                                    <div>
                                        <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="btn btn-primary btn-round">
                                            进入阅读
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
