@extends($_viewFrame)

@section('pageTitleMain'){{$chapter['title']}}@endsection
@section('pageKeywords'){{$chapter['title']}}@endsection
@section('pageDescription'){{$chapter['title']}}@endsection

@section('headAppend')
    @parent
    <style>
        :root{
            @if(!empty($novelChapterSetting['pageWidth']))
                --custom-novel-width: {{$novelChapterSetting['pageWidth']}}px;
            @endif
            @if(!empty($novelChapterSetting['fontSize']))
                --custom-novel-text-size-base: {{$novelChapterSetting['fontSize']}}px;
            @endif
        }
    </style>
    <link rel="stylesheet" href="@asset('vendor/Novel/style/chapter.css')"/>
@endsection

@section('bodyAppend')
    @parent
    <script>
        window.__bookChapter = {
            bookUrl: "{{modstart_web_url('novel/book/'.$book['hash'])}}",
            memberBookUrl: "{{modstart_web_url('novel/member/book_store')}}",
            reportUrl: "{{modstart_module_enabled('ContentReport')?\Module\ContentReport\Util\ContentReportUtil::submitPageUrl('NovelC',$chapter['id'],$book['title'].'-'.$chapter['title']):''}}",
        };
    </script>
    <script src="@asset('asset/vendor/vue.js')"></script>
    <script src="@asset('asset/vendor/element-ui/index.js')"></script>
    <script src="@asset('vendor/Novel/entry/chapterToolbox.js')"></script>
@endsection

@if(!empty($novelChapterSetting['theme']))
@section('bodyProperties') class="novel-theme-{{$novelChapterSetting['theme']}}" @endsection
@endif

@section('bodyContent')

    <div class="pb-book-chapter">
        <div class="nav" id="bookNav">
            当前位置：
            <a href="{{modstart_web_url('novel')}}">连载文学</a>
            <i class="iconfont icon-angle-right"></i>
            <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}">{{$book['title']}}</a>
            <i class="iconfont icon-angle-right"></i>
            <a href="{{modstart_web_url('novel/book_chapter/'.$chapter['hash'])}}">{{$chapter['title']}}</a>
        </div>
        <div class="content @if(!empty($novelChapterSetting['fontName'])) font-name-{{$novelChapterSetting['fontName']}} @endif">
            <div class="chapter-title">
                <h1>{{$chapter['title']}}</h1>
            </div>
            <div class="chapter-attr">
                作者：<a href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">{{$book['_author']['username']}}</a>
                更新时间：{{$book['updateTime']}}
            </div>
            <div class="book-content">
                @if($accessCheck->check && empty($accessCheck->data))
                    <div class="tw-py-10 tw-text-center">
                        <div>
                            当前章节为付费章节，您无权查看
                        </div>
                        <div class="tw-pt-10">
                            @if($accessCheck->vipSupport)
                                <a href="{{modstart_web_url('member_vip')}}" class="btn btn-primary btn-round">
                                    开通VIP
                                </a>
                            @endif
                            @if($accessCheck->creditSupport)
                                <a href="javascript:;" data-ajax-request-loading
                                   data-ajax-request="{{modstart_api_url('novel/book_chapter/credit_buy',['hash'=>$chapter['hash']])}}"
                                   class="btn btn-primary btn-round">
                                    使用 {{$accessCheck->creditCost}}{{\ModStart\Module\ModuleManager::getModuleConfig('Member', 'creditName', '积分')}} 购买
                                </a>
                            @endif
                        </div>
                        @if($accessCheck->vipSupport)
                            <div class="tw-text-gray-400 tw-mt-4">
                                VIP需开通
                                @foreach($accessCheck->vipList as $v)
                                    {{$v['title']}}
                                @endforeach
                            </div>
                        @endif
                    </div>
                @else
                    {!! $chapter['content'] !!}
                @endif
            </div>
            <div class="book-nav">
                <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}">目录</a>
                @if($prevChapter)
                    <a href="{{modstart_web_url('novel/book_chapter/'.$prevChapter['hash'])}}">上一章</a>
                @endif
                @if($nextChapter)
                    <a href="{{modstart_web_url('novel/book_chapter/'.$nextChapter['hash'])}}">下一章</a>
                @endif
            </div>
            <div id="toolbarApp"></div>
        </div>
    </div>

@endsection
