@extends($_viewFrame)

@section('pageTitleMain'){{$author['username']}}@endsection
@section('pageKeywords'){{$author['username']}}@endsection
@section('pageDescription'){{$author['username']}}@endsection


@section('bodyContent')

    <div class="ub-container">

        <div class="tw-bg-white tw-p-4 tw-rounded margin-top">
            <div class="tw-flex">
                <div class="tw-w-20 tw-mr-10">
                    <div class="ub-cover-1-1 tw-rounded-full tw-shadow-lg" style="background-image:url({{$author['avatar']}})"></div>
                </div>
                <div>
                    <h1 class="tw-text-xl">{{$author['username']}}</h1>
                    <div class="tw-text-gray-400">
                        简介：{{$author['signature']?:'暂无简介'}}
                    </div>
                </div>
            </div>
        </div>

        <div class="ub-panel margin-top">
            <div class="head">
                <div class="title">
                    所有作品
                </div>
            </div>
            <div class="body">
                @foreach($authorBooks as $book)
                    <div class="tw-border-b tw-border-0 tw-border-dashed tw-border-gray-200 tw-mb-4 tw-pb-4">
                        <div class="tw-flex tw-items-center">
                            <div class="tw-w-28 tw-flex-shrink-0 margin-right">
                                <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="ub-cover-3-4 tw-shadow tw-rounded" style="background-image:url({{$book['cover']}});"></a>
                            </div>
                            <div class="tw-flex-grow tw-min-w-0">
                                <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="pb-keywords tw-block tw-font-bold tw-text-gray-700 ub-text-truncate">{{$book['title']}}</a>
                                <div class="tw-text-gray-400 tw-text-sm margin-top tw-h-12 tw-overflow-hidden tw-overflow-ellipsis tw-leading-4">
                                    {{$book['summary']}}
                                </div>
                                <div class="tw-text-gray-400 margin-top ub-text-sm tw-h-10">
                                    作者：
                                    <a class="tw-text-gray-400" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">
                                        {{$book['_author']['username']}}
                                    </a>
                                </div>
                            </div>
                            <div>
                                <a href="{{modstart_web_url('novel/book/'.$book['hash'])}}" class="btn btn-primary btn-round">
                                    进入阅读
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

    </div>

@endsection
