@extends($_viewFrame)

@section('pageTitleMain'){{$book['title']}}@endsection
@section('pageKeywords'){{$book['title']}}@endsection
@section('pageDescription'){{$book['summary']}}@endsection

@section('bodyContent')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('novel')}}">连载文学</a>
            <a href="{{modstart_web_url('novel/book_list')}}">书籍列表</a>
            <a class="active" href="{{modstart_web_url('novel/book/'.$book['hash'])}}">{{$book['title']}}</a>
        </div>

        <div class="tw-bg-white tw-rounded tw-p-4">
            <div class="tw-flex">
                <div class="tw-w-36 tw-flex-shrink-0 tw-mr-8">
                    <div class="ub-cover-3-4 tw-shadow tw-rounded"  style="background-image:url({{$book['cover']}});"></div>
                </div>
                <div class="tw-flex-grow">
                    <div class="tw-font-bold tw-text-xl">
                        {{$book['title']}}
                    </div>
                    <div class="tw-text-gray-400 tw-mt-2">
                        作者：{{$book['_author']['username']}}
                    </div>
                    <div class="tw-mt-2 tw-text-gray-400">
                        @if(!empty($book['_category']))
                            <a href="{{modstart_web_url('novel/book_list',['categoryId'=>$book['categoryId']])}}" class="tw-text-gray-400">
                                {{$book['_category']['title']}}
                            </a>
                        @endif
                        <i class="iconfont icon-dot-sm tw-ml-2"></i>
                        更新：{{$book['updateTime']}}
                        <i class="iconfont icon-dot-sm tw-ml-2"></i>
                        点击：{{$book['viewCount']?:0}}
                        <i class="iconfont icon-dot-sm tw-ml-2"></i>
                        收藏：{{$book['favCount']?$book['favCount']:0}}
                    </div>
                    <div class="tw-text-gray-400 tw-mt-4">
                        {{$book['summary']}}
                    </div>
                    <div class="tw-mt-4">
                        <a href="{{modstart_web_url('novel/book_enter/'.$book['hash'])}}"
                           class="btn btn-round btn-primary btn-lg">
                            <i class="iconfont icon-eye"></i>
                            开始阅读
                        </a>
                        {!! \ModStart\ModStart::js('vendor/Vendor/asset/toggle.js') !!}
                        {!! \ModStart\ModStart::css('vendor/Vendor/asset/toggle.css') !!}
                        <div class="tw-inline-block"
                             data-toggle-group="{{modstart_api_url('novel/member_book_store/submit')}}"
                             data-status="{{ $memberBookStore? 'is_toggle' : 'not_toggle' }}"
                             data-id="{{$book['hash']}}">
                            <a href="javascript:;" class="btn btn-round btn-lg" data-action="toggle">
                                <i class="iconfont icon-book"></i>
                                放入书架
                            </a>
                            <a href="javascript:;" class="btn btn-round btn-lg btn-primary" data-action="untoggle">
                                <i class="iconfont icon-book"></i>
                                已放入书架
                            </a>
                        </div>
                        @if(0)
                        <a href="#" class="tw-ml-4">
                            <i class="iconfont icon-phone"></i>
                            手机阅读
                        </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            作品介绍
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-html lg">
                            {!! $book['content']?:'<p>暂无简介</p>' !!}
                        </div>
                    </div>
                </div>
                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            所有章节
                        </div>
                    </div>
                    <div class="body">
                        <div class="row">
                            @foreach($chapters as $c)
                                <div class="col-md-4">
                                    <a href="{{modstart_web_url('novel/book_chapter/'.$c['hash'])}}" class="tw-text-gray-400 tw-block tw-leading-8">
                                        {{$c['title']}}
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @if(modstart_module_enabled('MemberComment'))
                    <div class="margin-top" style="">
                        @include('module::MemberComment.View.pc.public.comment',['biz'=>'novel_b','bizId'=>$book['id']])
                    </div>
                @endif
            </div>
            <div class="col-md-3">
                <div class="tw-bg-white tw-rounded tw-p-4 margin-top">
                    <div class="tw-w-16 tw-m-auto">
                        <a href="#" class="ub-cover-1-1 tw-rounded-full"
                           style="background-image:url({{$book['_author']['avatar']}})"></a>
                    </div>
                    <div class="tw-text-center tw-mt-2">
                        <a class="ub-text-default" href="{{modstart_web_url('novel/book_author/'.$book['authorId'])}}">{{$book['_author']['username']}}</a>
                    </div>
                    @if(!empty($authorBooks))
                    <div class="tw-mt-4">
                        <div class="ub-text-muted">
                            其他作品
                        </div>
                        <div class="tw-mt-2">
                            <div class="row">
                                @foreach($authorBooks as $authorBook)
                                    <div class="col-4">
                                        <div class="tw-my-2">
                                            <div>
                                                <a href="{{modstart_web_url('novel/book/'.$authorBook['hash'])}}"
                                                   class="ub-cover-3-4 tw-rounded" style="background-image:url({{$authorBook['cover']}})"></a>
                                            </div>
                                            <div class="tw-text-center">
                                                <a href="{{modstart_web_url('novel/book/'.$authorBook['hash'])}}" class="ub-text-default">{{$authorBook['title']}}</a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            热门推荐
                        </div>
                    </div>
                    <div class="body">
                        @foreach(\Module\Novel\Model\NovelBook::recommends(10) as $i=>$book)
                            <div class="tw-flex tw-my-2 tw-items-center">
                                @if($i<3)
                                    <div class="tw-w-6 tw-h-6 ub-bg-primary tw-text-white tw-text-center tw-rounded-full tw-leading-6">{{$i+1}}</div>
                                @else
                                    <div class="tw-w-6 tw-h-6 tw-bg-gray-300 tw-text-white tw-text-center tw-rounded-full tw-leading-6">{{$i+1}}</div>
                                @endif
                                <div class="tw-ml-2">
                                    <a class="ub-text-default" href="{{modstart_web_url('novel/book/'.$book['hash'])}}">{{$book['title']}}</a>
                                </div>
                                <div class="tw-flex-grow tw-text-right">
                                    <a class="ub-text-muted" href="{{modstart_web_url('novel/book_author/'.$book['_author']['id'])}}">{{$book['_author']['username']}}</a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
