<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($XKqER) { return ModelUtil::get('member_user', array('id' => $XKqER)); } public static function getCached($XKqER) { return Cache::remember('MemberUser:' . $XKqER, 60, function () use($XKqER) { return self::get($XKqER); }); } public static function processDefault(&$SHDjH) { goto PagHK; ulnYj: if (empty($SHDjH['avatarBig'])) { $SHDjH['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto QI_Ba; o0riH: if (empty($SHDjH['avatarMedium'])) { $SHDjH['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto ulnYj; Bd12M: if (empty($SHDjH['nickname'])) { $SHDjH['nickname'] = $SHDjH['username']; } goto G46Cu; PagHK: if (empty($SHDjH)) { return; } goto Bd12M; G46Cu: if (empty($SHDjH['avatar'])) { $SHDjH['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto o0riH; QI_Ba: } private static function processBasicFields($Yj_ty) { goto haGO0; sqSWW: return $Yj_ty; goto vcwe8; haGO0: $Garxp = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto iOLMx; iOLMx: if (null === $Yj_ty) { $Yj_ty = $Garxp; } else { goto eG9uH; eG9uH: $FlBu9 = array(); goto Z00it; tmIBS: $Yj_ty = $FlBu9; goto hUl8Q; Z00it: foreach ($Yj_ty as $ivX9g) { if ('<basic>' == $ivX9g) { $FlBu9 = array_merge($FlBu9, $Garxp); } else { $FlBu9[] = $ivX9g; } } goto tmIBS; hUl8Q: } goto sqSWW; vcwe8: } public static function fixAvatar($w1Xch) { return AssetsUtil::fixFullOrDefault($w1Xch, 'asset/image/avatar.svg'); } public static function getBasic($XKqER, $Yj_ty = null) { goto ZoTtf; BoOdR: return $aogNB; goto LH8jO; ZoTtf: $Yj_ty = self::processBasicFields($Yj_ty); goto YKKGk; imEZy: $S1TUa['avatar'] = self::fixAvatar($S1TUa['avatar']); goto snmCz; YKKGk: $S1TUa = self::get($XKqER); goto EjbtP; Bbox6: foreach ($Yj_ty as $Z1K7c) { if (isset($S1TUa[$Z1K7c])) { $aogNB[$Z1K7c] = $S1TUa[$Z1K7c]; } else { $aogNB[$Z1K7c] = null; } } goto BoOdR; EjbtP: if (empty($S1TUa)) { return null; } goto lRpXZ; lRpXZ: if (empty($S1TUa['nickname'])) { $S1TUa['nickname'] = $S1TUa['username']; } goto imEZy; snmCz: $aogNB = array(); goto Bbox6; LH8jO: } public static function listViewName($QxQj5) { goto nvSKt; d32Mh: $hiYXb = ModelUtil::allIn('member_user', 'id', $QxQj5); goto akfY5; nvSKt: $NYl0A = array(); goto d32Mh; QClv1: return $NYl0A; goto iQucK; akfY5: foreach ($hiYXb as $SHDjH) { $NYl0A[] = self::viewName($SHDjH); } goto QClv1; iQucK: } public static function listUsers($QxQj5) { return ModelUtil::allIn('member_user', 'id', $QxQj5); } public static function convertOneToBasic($SHDjH) { return array('id' => $SHDjH['id'], 'username' => $SHDjH['username'], 'nickname' => empty($SHDjH['nickname']) ? $SHDjH['username'] : $SHDjH['nickname'], 'created_at' => $SHDjH['created_at'], 'signature' => isset($SHDjH['signature']) ? $SHDjH['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($SHDjH['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($hiYXb) { return array_map(function ($S1TUa) { return array('id' => $S1TUa['id'], 'username' => $S1TUa['username'], 'nickname' => empty($S1TUa['nickname']) ? $S1TUa['username'] : $S1TUa['nickname'], 'created_at' => $S1TUa['created_at'], 'signature' => isset($S1TUa['signature']) ? $S1TUa['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($S1TUa['avatar'], 'asset/image/avatar.svg')); }, $hiYXb); } public static function listUsersBasic($QxQj5) { return self::convertToBasic(self::listUsers($QxQj5)); } public static function getViewName($XKqER) { return self::viewName(self::get($XKqER)); } public static function viewName($SHDjH) { goto NZ2Yw; oPJcD: if (!empty($SHDjH['username'])) { return $SHDjH['username']; } goto wBaYW; A9eHy: if (!empty($SHDjH['nickname'])) { return $SHDjH['nickname']; } goto oPJcD; lsjUu: if (empty($SHDjH)) { return '-'; } goto A9eHy; wBaYW: return "ID-{$SHDjH['id']}"; goto y7rcY; NZ2Yw: if ($SHDjH && is_numeric($SHDjH)) { return self::getViewName($SHDjH); } goto lsjUu; y7rcY: } public static function update($XKqER, $rRFRV) { return ModelUtil::update('member_user', array('id' => $XKqER), $rRFRV); } public static function updateBasicWithUniqueCheck($XKqER, $rRFRV) { goto y8lZd; eAWVN: self::update($XKqER, $rRFRV); goto al1Xw; xQDM8: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $xtxST => $LfAln) { if (isset($rRFRV[$xtxST])) { goto Vki1K; yqnqT: if (count($BgQL_) == 1) { if ($BgQL_[0]['id'] != $XKqER) { return Response::generate(-1, $LfAln . '重复'); } } goto zOhiv; hsPyx: $BgQL_ = ModelUtil::all('member_user', array($xtxST => $rRFRV[$xtxST])); goto MMBEu; Vki1K: if (empty($rRFRV[$xtxST])) { $rRFRV[$xtxST] = null; continue; } goto hsPyx; MMBEu: if (count($BgQL_) > 1) { return Response::generate(-1, $LfAln . '重复'); } goto yqnqT; zOhiv: } } goto eAWVN; al1Xw: return Response::generate(0, 'ok'); goto NSMV4; y8lZd: if (empty($rRFRV)) { return Response::generate(0, 'ok'); } goto xQDM8; NSMV4: } public static function login($g_JSv = '', $Z0fSd = '', $ImFZ7 = '', $dfLHv = '') { goto HB5T9; dIsDE: if (!$dfLHv) { return Response::generate(-2, '密码为空'); } goto p1837; iyBY3: $SHDjH = ModelUtil::get('member_user', $mSQXl); goto LoANq; HB5T9: $ImFZ7 = trim($ImFZ7); goto LZlz8; LZlz8: $Z0fSd = trim($Z0fSd); goto xfI6k; iYpYx: if ($SHDjH['password'] != EncodeUtil::md5WithSalt($dfLHv, $SHDjH['passwordSalt'])) { MemberUserLoginFailedEvent::fire($SHDjH['id'], $SHDjH['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto MaSJy; LoANq: if (empty($SHDjH)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto TehwL; TehwL: MemberUserLoginAttemptEvent::fire($SHDjH['id'], Request::ip(), AgentUtil::getUserAgent()); goto iYpYx; p1837: if ($ImFZ7) { if (!FormatUtil::isEmail($ImFZ7)) { return Response::generate(-3, '邮箱格式不正确'); } $mSQXl = array('email' => $ImFZ7); } else { if ($Z0fSd) { if (!preg_match('/(^1[0-9]{10}$)/', $Z0fSd)) { return Response::generate(-4, '手机格式不正确'); } $mSQXl = array('phone' => $Z0fSd); } else { if ($g_JSv) { if (strpos($g_JSv, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $mSQXl = array('username' => $g_JSv); } } } goto iyBY3; xfI6k: $g_JSv = trim($g_JSv); goto Td_kD; Td_kD: if (!($ImFZ7 || $Z0fSd || $g_JSv)) { return Response::generate(-1, '所有登录字段均为空'); } goto dIsDE; MaSJy: switch ($SHDjH['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto H2GZj; H2GZj: return Response::generateSuccessData($SHDjH); goto eWvzs; eWvzs: } public static function autoSetUsernameNickname($GMB9M, $vHc9Q) { goto xGMig; Br04R: if (preg_match('/\\{.*\\}/', $vHc9Q)) { goto fmOD5; c5AnU: $hnDPO = 0; goto OFNtF; fmOD5: $SHDjH = self::get($GMB9M); goto pzqom; bx4hT: $vHc9Q = str_replace(array_keys($mO4Dz), array_values($mO4Dz), $vHc9Q); goto c5AnU; pzqom: $mO4Dz = array('{Phone}' => $SHDjH['phone'], '{Phone4}' => substr($SHDjH['phone'], 7), '{Uid}' => $SHDjH['id']); goto bx4hT; OFNtF: } goto sz21C; xGMig: $hnDPO = 6; goto Br04R; sz21C: self::suggestUsernameNickname($GMB9M, $vHc9Q, $hnDPO); goto h1B5y; h1B5y: } public static function getSuggestUsernameNickname($CNt4K) { goto Yyuh1; iraNS: for ($C7aCV = 0; $C7aCV < 20; $C7aCV++) { $B6a5b = ModelUtil::model('member_user')->where(array('username' => $vHc9Q))->orWhere(array('nickname' => $vHc9Q))->first(); if (empty($B6a5b)) { return $vHc9Q; } $vHc9Q = $vHc9Q . Str::random(1); } goto S92hx; S92hx: return $vHc9Q . Str::random(10); goto lo5dX; Yyuh1: $vHc9Q = $CNt4K . Str::random(1); goto iraNS; lo5dX: } private static function suggestUsernameNickname($GMB9M, $vBid4 = '用户', $hnDPO = 6) { goto MzV87; RTyf4: for ($C7aCV = 0; $C7aCV < 20; $C7aCV++) { $B6a5b = ModelUtil::model('member_user')->where(array('username' => $vHc9Q))->orWhere(array('nickname' => $vHc9Q))->first(); if (empty($B6a5b)) { break; } $vHc9Q = $vHc9Q . Str::random(1); } goto EBPBv; EBPBv: ModelUtil::update('member_user', $GMB9M, array('username' => $vHc9Q, 'nickname' => $vHc9Q)); goto J3jfW; MzV87: if ($hnDPO > 0) { $vHc9Q = $vBid4 . RandomUtil::string($hnDPO); } else { $vHc9Q = $vBid4; } goto RTyf4; J3jfW: } public static function registerId($XKqER, $rRFRV = array()) { $SHDjH = ModelUtil::insert('member_user', array_merge(array('id' => $XKqER, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $rRFRV)); return Response::generate(0, 'ok', $SHDjH); } public static function registerUsername($g_JSv) { return self::register($g_JSv, '', '', '', true); } public static function registerUsernameQuick($g_JSv) { goto YQm_1; YQm_1: $QEF2G = $g_JSv; goto loRBO; zu6n5: return Response::generateError('注册失败'); goto OQyKl; loRBO: for ($C7aCV = 0; $C7aCV < 10; $C7aCV++) { $N9oGO = self::register($QEF2G, '', '', '', true); if ($N9oGO['code']) { $QEF2G = $QEF2G . Str::random(1); } else { return $N9oGO; } } goto zu6n5; OQyKl: } public static function register($g_JSv = '', $Z0fSd = '', $ImFZ7 = '', $dfLHv = '', $eqmuS = false) { goto lCelc; dHB0G: $PBlis = Str::random(16); goto s8dlS; v0v8O: if ($g_JSv) { goto EpvPH; yGRa7: if ($N9oGO['code']) { return $N9oGO; } goto Dq4Mv; uzhdD: if (Str::contains($g_JSv, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto PZNq4; PZNq4: if (preg_match('/^[0-9]{11}$/', $g_JSv)) { return Response::generate(-1, '用户名不能为纯数字'); } goto T42lM; Dq4Mv: if (strlen($g_JSv) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto uzhdD; EpvPH: $N9oGO = self::uniqueCheck('username', $g_JSv); goto yGRa7; T42lM: } else { $g_JSv = null; } goto KVumO; W5U9S: $Z0fSd = trim($Z0fSd); goto PjOT6; KVumO: if (!$eqmuS) { if (empty($dfLHv) || strlen($dfLHv) < 6) { return Response::generate(-3, '密码不合法'); } } goto dHB0G; vfqnL: if ($ImFZ7) { $N9oGO = self::uniqueCheck('email', $ImFZ7); if ($N9oGO['code']) { return $N9oGO; } } else { $ImFZ7 = null; } goto idbYj; eJSyt: return Response::generate(0, 'ok', $SHDjH); goto g0EYw; PjOT6: $g_JSv = trim($g_JSv); goto Qy63c; idbYj: if ($Z0fSd) { $N9oGO = self::uniqueCheck('phone', $Z0fSd); if ($N9oGO['code']) { return $N9oGO; } } else { $Z0fSd = null; } goto v0v8O; s8dlS: $SHDjH = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $g_JSv, 'email' => $ImFZ7, 'phone' => $Z0fSd, 'password' => $eqmuS ? null : EncodeUtil::md5WithSalt($dfLHv, $PBlis), 'passwordSalt' => $eqmuS ? null : $PBlis, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto eJSyt; lCelc: $ImFZ7 = trim($ImFZ7); goto W5U9S; Qy63c: if (!($ImFZ7 || $Z0fSd || $g_JSv)) { return Response::generate(-1, '所有注册字段均为空'); } goto vfqnL; g0EYw: } public static function uniqueCheck($mFEQT, $jExlW, $rJ7FQ = 0) { goto G4a1o; G4a1o: $jExlW = trim($jExlW); goto G1i3V; ezc2z: if ($rJ7FQ == $SHDjH['id']) { return Response::generate(0, 'ok'); } goto cHasN; G1i3V: switch ($mFEQT) { case 'email': if (!FormatUtil::isEmail($jExlW)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $jExlW)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($jExlW, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $mFEQT); } goto MV0PP; MV0PP: $SHDjH = ModelUtil::get('member_user', array($mFEQT => $jExlW)); goto Tbgak; Tbgak: if (empty($SHDjH)) { return Response::generate(0, 'ok'); } goto ADBs0; ADBs0: $TKHQh = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto ezc2z; cHasN: return Response::generate(-2, $TKHQh[$mFEQT] . '已经被占用'); goto B7tEC; B7tEC: } public static function getByUsername($g_JSv) { return ModelUtil::get('member_user', array('username' => $g_JSv)); } public static function getByEmail($ImFZ7) { return ModelUtil::get('member_user', array('email' => $ImFZ7)); } public static function getByPhone($Z0fSd) { return ModelUtil::get('member_user', array('phone' => $Z0fSd)); } public static function changeNickname($GMB9M, $voDZe) { goto B3q6Z; B3q6Z: $N9oGO = self::uniqueCheck('nickname', $voDZe, $GMB9M); goto PU3po; KXe0M: ModelUtil::update('member_user', $GMB9M, array('nickname' => $voDZe)); goto Th7u5; Th7u5: return Response::generate(0, 'ok'); goto Q3gcT; PU3po: if (Response::isError($N9oGO)) { return $N9oGO; } goto KXe0M; Q3gcT: } public static function changePassword($GMB9M, $AR_7Y, $a6Xe8 = null, $DGPVG = false) { goto Drh0T; W9Hxl: if (!$DGPVG && EncodeUtil::md5WithSalt($a6Xe8, $SHDjH['passwordSalt']) != $SHDjH['password']) { return Response::generate(-1, '旧密码不正确'); } goto Yynk0; gu2KK: $SHDjH = ModelUtil::get('member_user', array('id' => $GMB9M)); goto PUebs; aITkr: ModelUtil::update('member_user', array('id' => $SHDjH['id']), array('passwordSalt' => $PBlis, 'password' => EncodeUtil::md5WithSalt($AR_7Y, $PBlis))); goto h8tLe; h8tLe: return Response::generate(0, 'ok'); goto sFjVI; Yynk0: $PBlis = Str::random(16); goto aITkr; PUebs: if (empty($SHDjH)) { return Response::generate(-1, '用户不存在'); } goto SBxYK; Drh0T: if (!$DGPVG && empty($a6Xe8)) { return Response::generate(-1, '旧密码不能为空'); } goto gu2KK; SBxYK: if (empty($AR_7Y)) { return Response::generate(-1, '新密码为空'); } goto W9Hxl; sFjVI: } public static function setAvatar($TtVeh, $zEX_3, $I5MuL = 'jpg') { goto fcWGJ; ZnGMj: $wxfO_ = (string) Image::make($zEX_3)->resize(400, 400)->encode($I5MuL, 75); goto QJXe6; vljck: $CtXuH = (string) Image::make($zEX_3)->resize(50, 50)->encode($I5MuL, 75); goto VHAcb; mVS_v: if ($a52k6['code']) { DataManager::deleteById($MF39i['data']['id']); if ($MF39i['code']) { return Response::generate(-1, '头像存储失败（' . $a52k6['msg'] . '）'); } } goto FtXyG; QThev: $MF39i = DataManager::upload('image', 'U' . $TtVeh . '_AvatarBig.' . $I5MuL, $wxfO_, null, $naeLi); goto yyFZn; fcWGJ: if (!in_array($I5MuL, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto JRlvH; lhTpN: return Response::generateSuccess(); goto Y2Err; QJXe6: $cLXmq = (string) Image::make($zEX_3)->resize(200, 200)->encode($I5MuL, 75); goto vljck; FtXyG: $N9oGO = DataManager::upload('image', 'U_' . $TtVeh . '_Avatar.' . $I5MuL, $CtXuH, null, $naeLi); goto gLlrd; JRlvH: $SHDjH = self::get($TtVeh); goto i62Go; CNLmy: $a52k6 = DataManager::upload('image', 'U' . $TtVeh . '_AvatarMiddle.' . $I5MuL, $cLXmq, null, $naeLi); goto mVS_v; VHAcb: $naeLi = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto QThev; yyFZn: if ($MF39i['code']) { return Response::generate(-1, '头像存储失败（' . $MF39i['msg'] . '）'); } goto CNLmy; i62Go: if (empty($SHDjH)) { return Response::generate(-1, '用户不存在'); } goto g6tlE; gLlrd: if ($N9oGO['code']) { goto dzShb; dzShb: DataManager::deleteById($MF39i['data']['id']); goto yLNsu; yLNsu: DataManager::deleteById($a52k6['data']['id']); goto gZnHl; gZnHl: if ($MF39i['code']) { return Response::generate(-1, '头像存储失败（' . $N9oGO['msg'] . '）'); } goto Z3Xhf; Z3Xhf: } goto OMwa1; g6tlE: if (empty($zEX_3)) { return Response::generate(-1, '图片数据为空'); } goto ZnGMj; OMwa1: self::update($SHDjH['id'], array('avatarBig' => $MF39i['data']['fullPath'], 'avatarMedium' => $a52k6['data']['fullPath'], 'avatar' => $N9oGO['data']['fullPath'])); goto lhTpN; Y2Err: } public static function findUsers($n06ht) { goto YGIdE; yfxsG: $hiYXb = ModelUtil::model('member_user')->whereIn('id', $n06ht)->get(); goto YNZrO; edUGv: return $WUPQG; goto ttMXV; YNZrO: foreach ($hiYXb as &$k6yUc) { $WUPQG[$k6yUc->id] = $k6yUc->toArray(); } goto edUGv; w2_ht: $WUPQG = array(); goto yfxsG; YGIdE: if (empty($n06ht)) { return array(); } goto w2_ht; ttMXV: } public static function filterUserIds($n06ht) { goto ZvyPn; ZEvDH: foreach ($hiYXb as &$k6yUc) { $mO4Dz[$k6yUc->id] = true; } goto mIz9p; mIz9p: return array_keys($mO4Dz); goto c0sPf; WnhPS: $mO4Dz = array(); goto nL6vp; nL6vp: $hiYXb = ModelUtil::model('member_user')->whereIn('id', $n06ht)->get(array('id')); goto ZEvDH; ZvyPn: if (empty($n06ht)) { return array(); } goto WnhPS; c0sPf: } public static function mergeMemberUsers(&$DVq16, $Jqr0t = 'memberUserId', $POfre = '_memberUser') { ModelUtil::join($DVq16, $Jqr0t, $POfre, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$DVq16, $Jqr0t = 'memberUserId', $POfre = '_memberUser', $Yj_ty = null) { $Yj_ty = self::processBasicFields($Yj_ty); if (is_array($DVq16)) { ModelUtil::join($DVq16, $Jqr0t, $POfre, 'member_user', 'id'); foreach ($DVq16 as $ivX9g => $aSO4X) { goto osIWv; lAI2K: $SHDjH = ArrayUtil::keepKeys($aSO4X[$POfre], $Yj_ty); goto IPouJ; L0rOs: $DVq16[$ivX9g][$POfre] = $SHDjH; goto V1Lm0; IPouJ: if (empty($SHDjH['nickname'])) { $SHDjH['nickname'] = $SHDjH['username']; } goto GQdbX; osIWv: if (empty($aSO4X[$POfre])) { continue; } goto lAI2K; GQdbX: if (empty($SHDjH['avatar'])) { $SHDjH['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $SHDjH['avatar'] = AssetsUtil::fixFull($SHDjH['avatar']); } goto L0rOs; V1Lm0: } } else { ModelUtil::joinItems($DVq16, $Jqr0t, $POfre, 'member_user', 'id'); foreach ($DVq16 as $S1TUa) { goto xtq0L; kC5dD: if (empty($SHDjH['nickname'])) { $SHDjH['nickname'] = $SHDjH['username']; } goto xgE_S; BUPii: $S1TUa->{$POfre} = $SHDjH; goto j2LAh; eCGgS: $SHDjH = ArrayUtil::keepKeys($S1TUa->{$POfre}, $Yj_ty); goto kC5dD; xgE_S: if (empty($SHDjH['avatar'])) { $SHDjH['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $SHDjH['avatar'] = AssetsUtil::fixFull($SHDjH['avatar']); } goto BUPii; xtq0L: if (empty($S1TUa->{$POfre})) { continue; } goto eCGgS; j2LAh: } } } public static function insert($rRFRV) { return ModelUtil::insert('member_user', $rRFRV); } public static function getIdByOauth($Bpg83, $cnivk) { goto wjHzb; kwnd3: if (empty($St36N)) { return 0; } goto RxMVs; RxMVs: return intval($St36N['memberUserId']); goto fJG2b; wjHzb: $St36N = ModelUtil::get('member_oauth', array('type' => $Bpg83, 'openId' => $cnivk)); goto kwnd3; fJG2b: } public static function getIdByOauthAndCheck($Bpg83, $cnivk) { goto wxayR; ZxfyT: MemberUtil::forgetOauth($Bpg83, $cnivk); goto XHLOr; RBsgI: if (self::get($GMB9M)) { return $GMB9M; } goto ZxfyT; XHLOr: return 0; goto Y0dE9; wxayR: $GMB9M = self::getIdByOauth($Bpg83, $cnivk); goto RBsgI; Y0dE9: } public static function getOauthOpenId($GMB9M, $Bpg83) { goto uG4Fc; nbr_L: $St36N = ModelUtil::get('member_oauth', $mSQXl); goto TMpc2; p8Zj3: return $St36N['openId']; goto tp0xn; uG4Fc: $mSQXl = array('memberUserId' => $GMB9M, 'type' => $Bpg83); goto nbr_L; TMpc2: if (empty($St36N)) { return null; } goto p8Zj3; tp0xn: } public static function getOauth($GMB9M, $Bpg83) { $mSQXl = array('memberUserId' => $GMB9M, 'type' => $Bpg83); return ModelUtil::get('member_oauth', $mSQXl); } public static function listOauths($GMB9M) { return ModelUtil::all('member_oauth', array('memberUserId' => $GMB9M), array('*'), array('type', 'asc')); } public static function putOauth($GMB9M, $Bpg83, $cnivk, $IUh2Y = array()) { goto dZdH9; oYaCA: $c0sp9 = array_merge(array('openId' => $cnivk), $IUh2Y); goto XbZve; d36QH: $St36N = ModelUtil::get('member_oauth', $mSQXl); goto oYaCA; XbZve: if (empty($St36N)) { ModelUtil::delete('member_oauth', array('type' => $Bpg83, 'openId' => $cnivk)); ModelUtil::insert('member_oauth', array_merge($mSQXl, $c0sp9)); } else { if ($St36N['openId'] != $cnivk) { ModelUtil::update('member_oauth', $St36N['id'], $c0sp9); } } goto V8WNg; dZdH9: $mSQXl = array('memberUserId' => $GMB9M, 'type' => $Bpg83); goto szCsM; V8WNg: LockUtil::release($IjgMr); goto mkRfg; szCsM: $IjgMr = "MemberOauth:{$GMB9M}"; goto MWv_N; MWv_N: if (!LockUtil::acquire($IjgMr)) { BizException::throws('正在处理中，请稍后再试'); } goto d36QH; mkRfg: } public static function forgetOauth($Bpg83, $cnivk) { ModelUtil::delete('member_oauth', array('type' => $Bpg83, 'openId' => $cnivk)); } public static function updateNewMessageStatus($GMB9M) { ModelUtil::update('member_user', array('id' => $GMB9M), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $GMB9M, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($GMB9M) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $GMB9M), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $GMB9M)))); } } public static function paginate($CuPBX, $Oy_Ml, $fcfDg = array()) { return ModelUtil::paginate('member_user', $CuPBX, $Oy_Ml, $fcfDg); } public static function updateStatus($Jgqqv, $e3t54) { goto wWapv; Pbw5c: if (empty($Jgqqv)) { return; } goto k3a0f; k3a0f: ModelUtil::model('member_user')->whereIn('id', $Jgqqv)->update(array('status' => $e3t54)); goto o7nhe; wWapv: if (!is_array($Jgqqv)) { $Jgqqv = array($Jgqqv); } goto Pbw5c; o7nhe: } public static function delete($GMB9M) { goto aw1Mt; BrKes: $a4Bj1 = ModelUtil::all('member_oauth', array('memberUserId' => $SHDjH['id'])); goto XAsvP; XAsvP: $o7_0L['oauth'] = ArrayUtil::keepItemsKeys($a4Bj1, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto XtDEX; uGRZC: ModelUtil::transactionCommit(); goto VohCO; aw1Mt: $SHDjH = self::get($GMB9M); goto oxUsz; XtDEX: ModelUtil::insert('member_deleted', array('id' => $SHDjH['id'], 'username' => $SHDjH['username'], 'phone' => $SHDjH['phone'], 'email' => $SHDjH['email'], 'content' => json_encode($o7_0L, JSON_UNESCAPED_UNICODE))); goto AhVSg; XYQok: $o7_0L = array(); goto BrKes; oxUsz: BizException::throwsIfEmpty('用户不存在', $SHDjH); goto kBhSg; AhVSg: ModelUtil::update('member_user', $GMB9M, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto uGRZC; kBhSg: ModelUtil::transactionBegin(); goto XYQok; VohCO: } public static function fireLogin($GMB9M) { goto jnTIm; dw9Ul: ModelUtil::update('member_user', $GMB9M, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($cIFf3, 20))); goto dKzL1; dKzL1: ModelUtil::insert('member_login_log', array('memberUserId' => $GMB9M, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($cIFf3, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto ezWnF; jnTIm: $cIFf3 = Request::ip(); goto dw9Ul; ezWnF: } }