<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserUpdatedEvent; use Module\Member\Support\MemberLoginCheck; use Module\Member\Util\MemberUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Sms\SmsUtil; use Module\Vendor\Support\ResponseCodes; class MemberProfileController extends ModuleBaseController implements MemberLoginCheck { public function nickname() { goto IfuEe; hxpEW: $voDZe = $OmDFL->getTrimString('nickname'); goto Oc_t3; ZoOwK: return Response::generate(0, '修改成功', null, '[reload]'); goto jeQRi; g1CBT: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'nickname')); goto ZoOwK; kBXlc: BizException::throwsIfResponseError($N9oGO); goto g1CBT; Oc_t3: BizException::throwsIfEmpty('昵称为空', $voDZe); goto zOjYy; zOjYy: if (!CaptchaFacade::check($OmDFL->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto R53NO; R53NO: $N9oGO = MemberUtil::changeNickname(MemberUser::id(), $voDZe); goto kBXlc; IfuEe: $OmDFL = InputPackage::buildFromInput(); goto hxpEW; jeQRi: } public function password() { goto esIQu; pTnGE: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto uImvQ; S8prA: $A4EO7 = $OmDFL->getTrimString('passwordNew'); goto LEPRE; kQrB3: if (empty($SHDjH['password'])) { $N9oGO = MemberUtil::changePassword(MemberUser::id(), $A4EO7, null, true); } else { $N9oGO = MemberUtil::changePassword(MemberUser::id(), $A4EO7, $aim4s); } goto pTnGE; B3Kkz: $aim4s = $OmDFL->getTrimString('passwordOld'); goto S8prA; LEPRE: $TXCKG = $OmDFL->getTrimString('passwordRepeat'); goto npS9T; npS9T: if ($A4EO7 != $TXCKG) { return Response::generate(-1, '两次新密码输入不一致'); } goto VtRZ8; uImvQ: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'password')); goto iUqIp; iUqIp: return Response::generate(0, '修改成功', null, '[reload]'); goto jiy7g; esIQu: $OmDFL = InputPackage::buildFromInput(); goto B3Kkz; VtRZ8: $SHDjH = MemberUser::get(); goto kQrB3; jiy7g: } public function avatar() { goto qLNTz; YfTW0: if (empty($w1Xch)) { return Response::generate(-1, '头像内容为空'); } goto vptbH; vptbH: switch ($OmDFL->getTrimString('type')) { case 'cropper': goto VwRAk; GnIAX: $N9oGO = MemberUtil::setAvatar(MemberUser::id(), $w1Xch, $kZV1Y); goto cXfqT; K2rv5: if (empty($kZV1Y)) { return Response::generate(-1, '头像数据为空'); } goto w77s2; cXfqT: if ($N9oGO['code']) { return $N9oGO; } goto d6E7i; xkvVL: return Response::generate(0, '保存成功', null, '[reload]'); goto gfAre; w77s2: $w1Xch = @base64_decode($w1Xch); goto yUyaR; yUyaR: if (empty($w1Xch)) { return Response::generate(-1, '头像内容为空'); } goto GnIAX; d6E7i: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto xkvVL; VwRAk: $kZV1Y = null; goto ANyCU; ANyCU: if (Str::startsWith($w1Xch, 'data:image/jpeg;base64,')) { $kZV1Y = 'jpg'; $w1Xch = substr($w1Xch, strlen('data:image/jpeg;base64,')); } else { if (Str::startsWith($w1Xch, 'data:image/png;base64,')) { $kZV1Y = 'png'; $w1Xch = substr($w1Xch, strlen('data:image/png;base64,')); } } goto K2rv5; gfAre: default: goto lU6hE; xYgcK: $N9oGO = MemberUtil::setAvatar(MemberUser::id(), $w1Xch, $I5MuL); goto tBBsh; gZWdq: $w1Xch = FileUtil::safeGetContent($w1Xch); goto A_bpu; cOqrd: if (empty($w1Xch)) { return Response::generate(-1, '读取头像文件失败:-1'); } goto pNf1o; lU6hE: $w1Xch = FileUtil::savePathToLocalTemp($w1Xch); goto cOqrd; QiV2K: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto qho68; og681: if (!in_array($I5MuL, config('data.upload.image.extensions'))) { return Response::generate(-1, '头像格式不合法'); } goto gZWdq; pNf1o: $I5MuL = FileUtil::extension($w1Xch); goto og681; qho68: return Response::generate(0, '保存成功', null, '[reload]'); goto BVK0M; A_bpu: if (empty($w1Xch)) { return Response::generate(-1, '读取头像文件失败:-2'); } goto xYgcK; tBBsh: if ($N9oGO['code']) { return $N9oGO; } goto QiV2K; BVK0M: } goto fTKOT; qLNTz: $OmDFL = InputPackage::buildFromInput(); goto aSnBn; aSnBn: $w1Xch = $OmDFL->getTrimString('avatar'); goto YfTW0; fTKOT: } public function captchaRaw() { return CaptchaFacade::create('default'); } public function captcha() { $lRJEj = $this->captchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); } public function email() { goto OHI6L; e5Wp1: if ($VGOVr != Session::get('memberProfileEmailVerify')) { return Response::generate(-1, '验证码不正确'); } goto skWE_; E7n1J: $ImFZ7 = $OmDFL->getEmail('email'); goto ZXRPR; skWE_: if (Session::get('memberProfileEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto iGWeN; iGWeN: if ($ImFZ7 != Session::get('memberProfileEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto Ej1Qe; ym_j7: Session::forget('memberProfileEmailVerify'); goto BQV3a; CcoEX: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'email')); goto ym_j7; QmxeP: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱不能为空'); } goto oaGdZ; OHI6L: $OmDFL = InputPackage::buildFromInput(); goto E7n1J; vZ28d: if (empty($VGOVr)) { return Response::generate(-1, '验证码不能为空'); } goto e5Wp1; Ej1Qe: $uB2rG = MemberUtil::getByEmail($ImFZ7); goto BkanV; BkanV: if (!empty($uB2rG)) { if ($uB2rG['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($uB2rG['id'] == MemberUser::id() && $uB2rG['email'] == $ImFZ7) { if (!empty($uB2rG['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto WpUDE; oaGdZ: if (!FormatUtil::isEmail($ImFZ7)) { return Response::generate(-1, '邮箱格式不正确'); } goto vZ28d; ZXRPR: $VGOVr = $OmDFL->getTrimString('verify'); goto QmxeP; jLds2: Session::forget('memberProfileEmail'); goto VYY9S; WpUDE: MemberUtil::update(MemberUser::id(), array('emailVerified' => true, 'email' => $ImFZ7)); goto CcoEX; VYY9S: return Response::generate(0, '修改成功', null, '[reload]'); goto O71no; BQV3a: Session::forget('memberProfileEmailVerifyTime'); goto jLds2; O71no: } public function emailVerify() { goto J2Fie; V3mHt: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱不能为空'); } goto Px3ZA; ldXLY: $uB2rG = MemberUtil::getByEmail($ImFZ7); goto Psp3e; CRRcf: Session::put('memberProfileEmailVerifyTime', time()); goto vcHzp; Psp3e: if (!empty($uB2rG)) { if ($uB2rG['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($uB2rG['id'] == MemberUser::id() && $uB2rG['email'] == $ImFZ7) { if (!empty($uB2rG['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto ZjHBW; ZjHBW: if (Session::get('memberProfileEmailVerifyTime') && $ImFZ7 == Session::get('memberProfileEmail')) { if (Session::get('memberProfileEmailVerifyTime') + 60 * 10 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto dWB_S; dWB_S: $VGOVr = rand(100000, 999999); goto U7Yu3; b3D8I: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto ldXLY; Px3ZA: if (!FormatUtil::isEmail($ImFZ7)) { return Response::generate(-1, '邮箱格式不正确'); } goto b3D8I; rEt2K: return Response::generate(0, '验证码发送成功'); goto d5AS5; U7Yu3: Session::put('memberProfileEmailVerify', $VGOVr); goto CRRcf; vcHzp: Session::put('memberProfileEmail', $ImFZ7); goto DypBy; J2Fie: $ImFZ7 = Input::get('target'); goto V3mHt; DypBy: MailSendJob::create($ImFZ7, '验证码', 'verify', array('code' => $VGOVr)); goto rEt2K; d5AS5: } public function phone() { goto xAJIU; rhtPb: Session::forget('memberProfilePhoneVerifyTime'); goto Xd_TK; JPK1U: if (Session::get('memberProfilePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto CVzPz; E3eBK: $Z0fSd = $OmDFL->getPhone('phone'); goto y8xaD; y8xaD: $VGOVr = $OmDFL->getTrimString('verify'); goto SerDn; EYph8: MemberUtil::update(MemberUser::id(), array('phoneVerified' => true, 'phone' => $Z0fSd)); goto buUvU; Xd_TK: Session::forget('memberProfilePhone'); goto PmW6G; SerDn: if (empty($Z0fSd)) { return Response::generate(-1, '手机不能为空'); } goto T_n2F; MnRXw: if (!empty($uB2rG)) { if ($uB2rG['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($uB2rG['id'] == MemberUser::id() && $uB2rG['phone'] == $Z0fSd) { if (!empty($uB2rG['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto EYph8; PmW6G: return Response::generate(0, '修改成功', null, '[reload]'); goto WTRDb; buUvU: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'phone')); goto GTcRb; xAJIU: $OmDFL = InputPackage::buildFromInput(); goto E3eBK; CVzPz: if ($Z0fSd != Session::get('memberProfilePhone')) { return Response::generate(-1, '两次手机不一致'); } goto H9KAe; T_n2F: if (!FormatUtil::isPhone($Z0fSd)) { return Response::generate(-1, '手机格式不正确'); } goto C5z9S; C5z9S: if (empty($VGOVr)) { return Response::generate(-1, '验证码不能为空'); } goto ebbcN; GTcRb: Session::forget('memberProfilePhoneVerify'); goto rhtPb; ebbcN: if ($VGOVr != Session::get('memberProfilePhoneVerify')) { return Response::generate(-1, '验证码不正确'); } goto JPK1U; H9KAe: $uB2rG = MemberUtil::getByPhone($Z0fSd); goto MnRXw; WTRDb: } public function phoneVerify() { goto q3_wG; zqP_L: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '图片验证码错误'); } goto Y8119; fBxw9: Session::put('memberProfilePhone', $Z0fSd); goto wEVpG; hWYkp: if (!FormatUtil::isPhone($Z0fSd)) { return Response::generate(-1, '手机格式不正确'); } goto zqP_L; ElIh8: return Response::generate(0, '验证码发送成功'); goto eb2aO; q3_wG: $Z0fSd = Input::get('target'); goto B0P8j; DMoZe: if (!empty($uB2rG)) { if ($uB2rG['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($uB2rG['id'] == MemberUser::id() && $uB2rG['phone'] == $Z0fSd) { if (!empty($uB2rG['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto jeOwu; nPh4I: Session::put('memberProfilePhoneVerify', $VGOVr); goto MG8F_; MG8F_: Session::put('memberProfilePhoneVerifyTime', time()); goto fBxw9; Y8119: $uB2rG = MemberUtil::getByPhone($Z0fSd); goto DMoZe; B0P8j: if (empty($Z0fSd)) { return Response::generate(-1, '手机不能为空'); } goto hWYkp; jeOwu: if (Session::get('memberProfilePhoneVerifyTime') && $Z0fSd == Session::get('memberProfilePhone')) { if (Session::get('memberProfilePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto D59qG; wEVpG: SmsSendJob::create($Z0fSd, 'verify', array('code' => $VGOVr)); goto ElIh8; D59qG: $VGOVr = rand(100000, 999999); goto nPh4I; eb2aO: } public function oauthUnbind() { goto cBfFE; Pfg3p: BizException::throwsIfEmpty('授权方式不存在', $Hi5N0); goto ymFBt; z7yle: return Response::generate(0, '解绑成功', null, '[reload]'); goto W5M5u; cBfFE: $OmDFL = InputPackage::buildFromInput(); goto VYAmA; zTuEL: if ($cnivk) { MemberUtil::forgetOauth($Hi5N0->oauthKey(), $cnivk); } goto z7yle; jRNZW: $Hi5N0 = MemberOauth::getOrFail($mFEQT); goto Pfg3p; VYAmA: $mFEQT = $OmDFL->getTrimString('type'); goto jRNZW; ymFBt: $cnivk = MemberUtil::getOauthOpenId(MemberUser::id(), $Hi5N0->oauthKey()); goto zTuEL; W5M5u: } public function delete() { goto B7_PF; VcBYL: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => time() + TimeUtil::PERIOD_MONTH)); goto LhYEp; LhYEp: return Response::generate(0, '申请注销成功', null, '[reload]'); goto e1IOm; B7_PF: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto LRW8r; nUEyM: $OmDFL = InputPackage::buildFromInput(); goto qaOEH; qHcCS: BizException::throwsIf('请勾选同意选项', $Yn8ib != 'yes'); goto VcBYL; LRW8r: $SHDjH = MemberUser::get(); goto tZOyG; qaOEH: $Yn8ib = $OmDFL->getTrimString('agree'); goto qHcCS; tZOyG: if ($SHDjH['deleteAtTime'] > 0) { return Response::generateError('账号正在注销中'); } goto nUEyM; e1IOm: } public function deleteRevert() { goto GTAEY; CouSn: if (empty($SHDjH['deleteAtTime'])) { return Response::generateError('账号没有注销操作'); } goto LtdY7; LtdY7: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => 0)); goto HRzkZ; HRzkZ: return Response::generate(0, '撤销操作成功', null, '[reload]'); goto ujzPL; JAGfV: $SHDjH = MemberUser::get(); goto CouSn; GTAEY: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto JAGfV; ujzPL: } }