<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CurlUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\StrUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserLoginedEvent; use Module\Member\Events\MemberUserLogoutEvent; use Module\Member\Events\MemberUserPasswordResetedEvent; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Oauth\AbstractOauth; use Module\Member\Provider\RegisterProcessor\AbstractMemberRegisterProcessorProvider; use Module\Member\Provider\RegisterProcessor\MemberRegisterProcessorProvider; use Module\Member\Util\MemberUtil; use Module\Member\Util\SecurityUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Support\ResponseCodes; use Module\Vendor\Util\SessionUtil; class AuthController extends ModuleBaseController { public function checkRedirectSafety($BmUno) { goto A_do9; N_wQy: BizException::throws('登录跳转路径异常'); goto P1jJs; A_do9: if (!modstart_config('Member_LoginRedirectCheckEnable', false)) { return; } goto Zij3m; Zij3m: $IUh2Y = parse_url($BmUno); goto TlPCc; d6GLs: $q0THf = modstart_config('Member_LoginRedirectWhiteList', ''); goto c3jeu; z8t1G: $q0THf = array_filter($q0THf); goto CG5Gr; Mbjkn: if ($IUh2Y['host'] == Request::domain()) { return; } goto d6GLs; TlPCc: if (empty($IUh2Y['host'])) { return; } goto Mbjkn; c3jeu: $q0THf = explode('
', $q0THf); goto z8t1G; CG5Gr: foreach ($q0THf as $S1TUa) { if ($IUh2Y['host'] == $S1TUa) { return; } } goto N_wQy; P1jJs: } public function oauthTryLogin($Bpg83 = null) { goto qNA1F; bzBat: if (empty($ENZfE)) { return Response::generate(-1, '用户授权数据为空'); } goto vC91R; onalV: $Hi5N0 = MemberOauth::getOrFail($Bpg83); goto WBTje; ZEC3k: BizException::throwsIfResponseError($N9oGO); goto lMMKj; vkxLp: BizException::throwsIfEmpty('授权类型为空', $Bpg83); goto onalV; vC91R: if (empty($Bpg83)) { $OmDFL = InputPackage::buildFromInput(); $Bpg83 = $OmDFL->getTrimString('type'); } goto vkxLp; WBTje: $N9oGO = $Hi5N0->processTryLogin(array('userInfo' => $ENZfE)); goto ZEC3k; RIwBF: return Response::generate(0, null, array('memberUserId' => 0)); goto hOgkN; lMMKj: if ($N9oGO['data']['memberUserId'] > 0) { goto jrcZ0; qEsDm: Session::forget('oauthUserInfo'); goto PbefH; tSnzr: MemberUtil::fireLogin($N9oGO['data']['memberUserId']); goto qEsDm; jrcZ0: Session::put('memberUserId', $N9oGO['data']['memberUserId']); goto tSnzr; PbefH: return Response::generateSuccessData(array('memberUserId' => $N9oGO['data']['memberUserId'])); goto tllFp; tllFp: } goto RIwBF; qNA1F: $ENZfE = Session::get('oauthUserInfo', array()); goto bzBat; hOgkN: } public function oauthBind($Bpg83 = null) { goto WrQMv; xKJmy: $N9oGO = $Hi5N0->processBindToUser(array('memberUserId' => $GMB9M, 'userInfo' => $ENZfE)); goto eMKiV; WrQMv: $OmDFL = InputPackage::buildFromInput(); goto Tch60; G8lue: return Response::generate(0, null); goto R9HTC; vLV4D: if ($F6x8x > 0) { goto RbQZ0; GVbqZ: return Response::generate(0, null, null, $BmUno); goto jtbyq; RbQZ0: $N9oGO = $Hi5N0->processBindToUser(array('memberUserId' => $F6x8x, 'userInfo' => $ENZfE)); goto aFsqi; aFsqi: BizException::throwsIfResponseError($N9oGO); goto VX92p; VX92p: Session::forget('oauthUserInfo'); goto GVbqZ; jtbyq: } goto qTuuy; U2n2A: if (preg_match('/^\\d{11}$/', $g_JSv)) { return Response::generate(-1, '用户名不能为纯数字'); } goto AX7tz; qTuuy: $N9oGO = $Hi5N0->processTryLogin(array('userInfo' => $ENZfE)); goto J6gdi; iQkLM: $c0sp9 = array(); goto MkcD8; yoUCY: $ENZfE = Session::get('oauthUserInfo', array()); goto QbS5I; IZL2Z: if (Str::contains($g_JSv, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto U2n2A; JU2kl: if (!empty($ENZfE['avatar'])) { goto CSDR2; F38gx: if (!in_array($I5MuL, $aE1VS)) { Log::info('Member.Auth.OauthBind.AvatarExtError - ' . $I5MuL . ' - ' . $ENZfE['avatar']); $I5MuL = null; } goto Bup5E; CSDR2: $I5MuL = FileUtil::extension($ENZfE['avatar']); goto COsYN; Bup5E: $ZMA75 = CurlUtil::get($ENZfE['avatar'], array(), array('returnHeader' => true)); goto VXveZ; COsYN: $aE1VS = array('jpg', 'jpeg', 'png', 'gif'); goto F38gx; VXveZ: if (!empty($ZMA75['body'])) { if (empty($I5MuL) && !empty($N9oGO['headerMap']['content-type'])) { $I5MuL = FileUtil::mimeToExt($N9oGO['headerMap']['content-type']); if (!in_array($I5MuL, $aE1VS)) { Log::info('Member.Auth.OauthBind.AvatarExtGuessError - ' . $I5MuL . ' - ' . $ENZfE['avatar']); $I5MuL = null; } } if (!empty($I5MuL)) { MemberUtil::setAvatar($GMB9M, $ZMA75['body'], $I5MuL); } } goto Lka91; Lka91: } goto eJiVg; HeD28: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto yhBbM; MkcD8: if (modstart_config('Member_OauthBindPhoneEnable')) { $c0sp9['phoneVerified'] = true; } goto Ig6Cz; nl1nU: Session::forget('oauthUserInfo'); goto G8lue; eJiVg: Session::put('memberUserId', $GMB9M); goto uwyWP; AX7tz: $Z0fSd = $OmDFL->getPhone('phone'); goto pmA8Z; uwyWP: MemberUtil::fireLogin($GMB9M); goto nl1nU; VCgp6: EventUtil::fire(new MemberUserRegisteredEvent($GMB9M)); goto JU2kl; yhBbM: $GMB9M = $N9oGO['data']['id']; goto iQkLM; SHlF3: if (modstart_config('Member_OauthBindPhoneEnable')) { goto ymjoh; Yi0_R: if (Session::get('oauthBindPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto XBnDo; jXFu_: $uKRiv = Session::get('oauthBindPhoneVerify'); goto NWs0P; XBnDo: if ($Z0fSd != Session::get('oauthBindPhone')) { return Response::generate(-1, '两次手机不一致'); } goto RO5Do; NWs0P: if ($ORJ4R != $uKRiv) { Log::info('Member.OauthBind.PhoneVerifyError - ' . $ORJ4R . ' - ' . $uKRiv); return Response::generate(-1, '手机验证码不正确.'); } goto Yi0_R; ymjoh: if (empty($Z0fSd)) { return Response::generate(-1, '请输入手机'); } goto jXFu_; RO5Do: } goto GUwR3; o2UsX: $ImFZ7 = $OmDFL->getEmail('email'); goto mDeo9; T5RYQ: if ($N9oGO['data']['memberUserId'] > 0) { goto v0jr_; vDU35: MemberUtil::fireLogin($N9oGO['data']['memberUserId']); goto i5E5k; J0bEy: return Response::generateSuccessData(array('memberUserId' => $N9oGO['data']['memberUserId'])); goto BWpCC; v0jr_: Session::put('memberUserId', $N9oGO['data']['memberUserId']); goto vDU35; i5E5k: Session::forget('oauthUserInfo'); goto J0bEy; BWpCC: } goto tBqL0; GUwR3: if (modstart_config('Member_OauthBindEmailEnable')) { goto XaPls; PtTBN: if (Session::get('oauthBindEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto acBZY; acBZY: if ($ImFZ7 != Session::get('oauthBindEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto tE9Tp; Exo2V: if ($yQtmH != $KzbIu) { Log::info('Member.OauthBind.EmailVerifyError - ' . $yQtmH . ' - ' . $KzbIu); return Response::generate(-1, '邮箱验证码不正确.'); } goto PtTBN; pU3Qj: $KzbIu = Session::get('oauthBindEmailVerify'); goto Exo2V; XaPls: if (empty($ImFZ7)) { return Response::generate(-1, '请输入邮箱'); } goto pU3Qj; tE9Tp: } goto NZULo; GUBoI: $lRJEj = $OmDFL->getTrimString('captcha'); goto KIwL7; NZULo: $N9oGO = MemberUtil::register($g_JSv, $Z0fSd, $ImFZ7, null, true); goto HeD28; eMKiV: BizException::throwsIfResponseError($N9oGO); goto VCgp6; Tch60: $BmUno = $OmDFL->getTrimString('redirect', modstart_web_url('member')); goto nFMrY; cGpZm: if (!empty($c0sp9)) { MemberUtil::update($GMB9M, $c0sp9); } goto xKJmy; aSNyz: $Hi5N0 = MemberOauth::getOrFail($Bpg83); goto wtasw; KIwL7: if (!Session::get('oauthBindCaptchaPass', false)) { if (!CaptchaFacade::check($lRJEj)) { SessionUtil::atomicProduce('oauthBindCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto L_UXr; L_UXr: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto SHlF3; QbS5I: if (empty($ENZfE)) { return Response::generate(-1, '用户授权数据为空'); } goto aSNyz; J6gdi: BizException::throwsIfResponseError($N9oGO); goto T5RYQ; Ig6Cz: if (modstart_config('Member_OauthBindEmailEnable')) { $c0sp9['emailVerified'] = true; } goto ZUVx0; mDeo9: $yQtmH = $OmDFL->getTrimString('emailVerify'); goto GUBoI; wtasw: $F6x8x = Session::get('memberUserId', 0); goto vLV4D; ZUVx0: $c0sp9['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto cGpZm; nFMrY: $Bpg83 = $OmDFL->getTrimString('type', $Bpg83); goto yoUCY; tBqL0: if (modstart_config()->getWithEnv('registerDisable', false) && !modstart_config()->getWithEnv('registerOauthEnable', false)) { return Response::generate(-1, '用户注册已禁用'); } goto I7mCi; I7mCi: $g_JSv = $OmDFL->getTrimString('username'); goto IZL2Z; pmA8Z: $ORJ4R = $OmDFL->getTrimString('phoneVerify'); goto o2UsX; R9HTC: } public function oauthCallback($Bpg83 = null, $ggrym = null) { goto KGc4t; AdNu7: if (empty($jfvjU)) { $jfvjU = $OmDFL->getTrimString('auth_code'); } goto YgS4C; YgS4C: if (empty($jfvjU)) { return Response::generate(-1, '登录失败(code为空)', null, '/'); } goto bcADv; rbySo: if (empty($ggrym)) { $ggrym = $OmDFL->getTrimString('callback', null); } goto s6YbJ; VkK87: if ($CJrK9) { Session::put('oauthViewOpenId_' . $Bpg83, $qrLob['openid']); return Response::generateSuccess(); } goto OBFQC; euYsK: if (empty($Bpg83)) { $Bpg83 = $OmDFL->getTrimString('type'); } goto rbySo; KGc4t: $OmDFL = InputPackage::buildFromInput(); goto euYsK; OnRVG: $qrLob = $N9oGO['data']['userInfo']; goto EtgTk; IQWj3: $N9oGO = $Hi5N0->processLogin(array_merge($V1tDr, array('code' => $jfvjU, 'callback' => $ggrym))); goto FejDs; EtgTk: $CJrK9 = $OmDFL->getBoolean('view', false); goto VkK87; GjSeM: $V1tDr = Session::get('oauthLoginParam', array()); goto CvRTQ; bcADv: $Hi5N0 = MemberOauth::getOrFail($Bpg83); goto GjSeM; jnVEu: return Response::generate(0, 'ok', array('user' => $qrLob)); goto pCPfL; OBFQC: Session::put('oauthUserInfo', $qrLob); goto jnVEu; CvRTQ: Session::forget('oauthLoginParam'); goto IQWj3; ULPYf: if (0 != $N9oGO['code']) { return $N9oGO; } goto OnRVG; s6YbJ: $jfvjU = $OmDFL->getTrimString('code'); goto AdNu7; FejDs: if (!isset($N9oGO['code'])) { return Response::generate(-1, '登录失败(返回结果为空)'); } goto ULPYf; pCPfL: } public function oauthLogin($Bpg83 = null, $ggrym = null) { goto slt7L; TMq6x: $N9oGO = $Hi5N0->processRedirect($V1tDr); goto fzUTW; SUV2Z: if (empty($ggrym)) { $ggrym = $OmDFL->getTrimString('callback', 'NO_CALLBACK'); } goto KmLo3; tvFXG: if (empty($Bpg83)) { $Bpg83 = $OmDFL->getTrimString('type'); } goto SUV2Z; KeV_q: return Response::generate(0, 'ok', array('redirect' => $N9oGO['data']['redirect'])); goto Ovfqb; xjYr_: $V1tDr = array('callback' => $ggrym, 'silence' => $cVeFr); goto tkb3O; KmLo3: $cVeFr = $OmDFL->getBoolean('silence', false); goto q1dv9; fzUTW: BizException::throwsIfResponseError($N9oGO); goto KeV_q; tkb3O: Session::put('oauthLoginParam', $V1tDr); goto TMq6x; mVOK9: $OmDFL = InputPackage::buildFromInput(); goto tvFXG; q1dv9: $Hi5N0 = MemberOauth::getOrFail($Bpg83); goto xjYr_; slt7L: if ($V4So5 = modstart_config()->getWithEnv('oauthDisableText')) { return Response::generateError($V4So5); } goto mVOK9; Ovfqb: } public function ssoClientLogoutPrepare() { goto G5lkU; n5sYM: return Response::generate(0, 'ok', array('redirect' => $BmUno)); goto C7Uhi; eJi6v: if (empty($qWOW0)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto Xruib; o4DxN: $OmDFL = InputPackage::buildFromInput(); goto cWO53; cWO53: $ZMu4x = $OmDFL->getTrimString('domainUrl'); goto X7b2i; X7b2i: $qWOW0 = modstart_config('ssoClientServer', ''); goto eJi6v; Xruib: $BmUno = $qWOW0 . '_logout' . '?' . http_build_query(array('redirect' => $ZMu4x . '/sso/client_logout')); goto n5sYM; G5lkU: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto o4DxN; C7Uhi: } public function ssoClientLogout() { goto b4HD_; GoNkm: Session::forget('memberUserId'); goto Kden5; b4HD_: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto GoNkm; Kden5: return Response::generate(0, 'ok'); goto A48_Q; A48_Q: } public function ssoServerLogout() { goto XJ82s; K0wGa: Session::forget('memberUserId'); goto Tvaob; Tvaob: return Response::generate(0, 'ok'); goto ZdfXf; XJ82s: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto K0wGa; ZdfXf: } public function ssoServerSuccess() { goto f5WIU; G_Kee: $ZMu4x = $OmDFL->getTrimString('domainUrl'); goto oxi7C; xKlh5: if (empty($ZPIjV)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto FqivW; FqivW: $OmDFL = InputPackage::buildFromInput(); goto LEFi9; kwO0n: if (!$XzdQk) { return Response::generate(-1, '数据错误(2)'); } goto e6ZlQ; lUA6z: foreach ($NP3Yx as $S1TUa) { if (trim($S1TUa) == $D9F7V) { $XzdQk = true; } } goto kwO0n; f5WIU: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto CB21K; TVlpZ: if (!$GMB9M) { return Response::generate(-1, '未登录'); } goto Uujmt; LEFi9: $D9F7V = $OmDFL->getTrimString('client'); goto G_Kee; mdNF_: $a0lz0 = time(); goto JIpjC; N2o_8: $ZPIjV = modstart_config('ssoServerSecret'); goto xKlh5; e6ZlQ: $qDPeZ = $ZMu4x . '/sso/server'; goto mdNF_; fSxaY: $XzdQk = false; goto lUA6z; iyt_l: $NP3Yx = explode('
', modstart_config('ssoServerClientList', '')); goto fSxaY; oxi7C: if (empty($ZMu4x) || empty($D9F7V)) { return Response::generate(-1, '数据错误'); } goto iyt_l; ghE58: $BmUno = $D9F7V . '?server=' . urlencode($qDPeZ) . '&timestamp=' . $a0lz0 . '&username=' . urlencode(base64_encode($g_JSv)) . '&sign=' . $hX7aU; goto sMQ9u; CB21K: $GMB9M = Session::get('memberUserId', 0); goto TVlpZ; Iw6o7: $hX7aU = md5(md5($ZPIjV) . md5($a0lz0 . '') . md5($qDPeZ) . md5($g_JSv)); goto ghE58; Uujmt: $SHDjH = MemberUtil::get($GMB9M); goto N2o_8; JIpjC: $g_JSv = $SHDjH['username']; goto Iw6o7; sMQ9u: return Response::generate(0, null, array('redirect' => $BmUno)); goto dU1s8; dU1s8: } public function ssoServer() { goto jQtlp; sXKYY: if ($hX7aU != $WAtNH) { return Response::generate(-1, 'sign 错误'); } goto LTM7E; jQtlp: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto Rh3r_; SNipm: if (empty($hX7aU)) { return Response::generate(-1, 'sign 为空'); } goto qzb2G; pEGC7: $XzdQk = false; goto XS3je; Rh3r_: $OmDFL = InputPackage::buildFromInput(); goto xwnJU; EX58p: if (empty($qvPZ9)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto K9uzm; xwnJU: $D9F7V = $OmDFL->getTrimString('client'); goto G4HrZ; QXgDS: $cOkvL = false; goto qS9QK; oOq5D: if (empty($D9F7V)) { return Response::generate(-1, 'client 为空'); } goto eyLKl; URJnW: $hX7aU = $OmDFL->getTrimString('sign'); goto oOq5D; VV7EV: if (!$XzdQk) { return Response::generate(-1, '请在 同步登陆服务端增加客户端地址 ' . $D9F7V); } goto QXgDS; eyLKl: if (empty($a0lz0)) { return Response::generate(-1, 'timestamp 为空'); } goto SNipm; qzb2G: $qvPZ9 = modstart_config('ssoServerSecret'); goto EX58p; LTM7E: if (abs(time() - $a0lz0) > 3600) { return Response::generate(-1, 'timestamp 错误'); } goto aZnjj; dJgDG: return Response::generate(0, 'ok', array('isLogin' => $cOkvL)); goto MqGgb; aZnjj: $NP3Yx = explode('
', modstart_config('ssoServerClientList', '')); goto pEGC7; qS9QK: if (intval(Session::get('memberUserId', 0)) > 0) { $cOkvL = true; } goto dJgDG; K9uzm: $WAtNH = md5(md5($qvPZ9) . md5($a0lz0 . '') . md5($D9F7V)); goto sXKYY; XS3je: foreach ($NP3Yx as $S1TUa) { if (trim($S1TUa) == $D9F7V) { $XzdQk = true; } } goto VV7EV; G4HrZ: $a0lz0 = $OmDFL->getInteger('timestamp'); goto URJnW; MqGgb: } public function ssoClient() { goto iRiik; Mh3z2: MemberUtil::fireLogin($SHDjH['id']); goto iDZhJ; Mg2sF: $qDPeZ = $OmDFL->getTrimString('server'); goto jFDNA; bBRNn: $WAtNH = md5(md5($h9QjP) . md5($a0lz0 . '') . md5($qDPeZ) . md5($g_JSv)); goto VwFjK; t3uVM: Session::put('memberUserId', $SHDjH['id']); goto Mh3z2; TlSEH: $OmDFL = InputPackage::buildFromInput(); goto Mg2sF; VwFjK: if ($hX7aU != $WAtNH) { return Response::generate(-1, 'sign错误'); } goto FHC7r; GdhTo: if ($qDPeZ != $qWOW0) { return Response::generate(-1, '同步登录 服务端地址不是配置的' . $qWOW0); } goto Q3g52; iRiik: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto QC0sp; N6RBr: $h9QjP = modstart_config('ssoClientSecret'); goto O21w1; FHC7r: if (abs(time() - $a0lz0) > 3600) { return Response::generate(-1, 'timestamp错误'); } goto GdhTo; YEdSJ: $hX7aU = $OmDFL->getTrimString('sign'); goto ltJBU; O21w1: if (empty($h9QjP)) { return Response::generate(-1, '请设置 同步登录客户端通讯秘钥'); } goto TlSEH; MUDFN: if (empty($g_JSv)) { return Response::generate(-1, '同步登录返回的用户名为空'); } goto ocfUZ; iDZhJ: return Response::generate(0, 'ok'); goto van5b; QC0sp: $qWOW0 = modstart_config('ssoClientServer', ''); goto Xk0yT; ocfUZ: if (empty($a0lz0)) { return Response::generate(-1, 'timestamp为空'); } goto jtV7w; Xk0yT: if (empty($qWOW0)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto N6RBr; nzc_L: if (empty($SHDjH)) { goto I5fRj; hocZu: $SHDjH = MemberUtil::get($N9oGO['data']['id']); goto INw0t; I5fRj: $N9oGO = MemberUtil::register($g_JSv, null, null, null, true); goto vjihi; vjihi: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto hocZu; INw0t: } goto t3uVM; Q3g52: $SHDjH = MemberUtil::getByUsername($g_JSv); goto nzc_L; jFDNA: $a0lz0 = $OmDFL->getInteger('timestamp'); goto YEdSJ; ltJBU: $g_JSv = @base64_decode($OmDFL->getTrimString('username')); goto MUDFN; jtV7w: if (empty($hX7aU)) { return Response::generate(-1, 'sign为空'); } goto bBRNn; van5b: } public function ssoClientPrepare() { goto nnw1t; K0qhL: if (!Str::endsWith($D9F7V, '/sso/client')) { return Response::generate(-1, 'client参数错误'); } goto TDmSW; TDmSW: $a0lz0 = time(); goto aGdim; xDZE8: $D9F7V = $OmDFL->getTrimString('client', '/'); goto K0qhL; YyDEN: $OmDFL = InputPackage::buildFromInput(); goto xDZE8; aGdim: $hX7aU = md5(md5($h9QjP) . md5($a0lz0 . '') . md5($D9F7V)); goto cf9M7; d_Jnz: $qWOW0 = modstart_config('ssoClientServer'); goto SOg2E; SOg2E: $h9QjP = modstart_config('ssoClientSecret'); goto YyDEN; nnw1t: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, 'SSO未开启'); } goto d_Jnz; rZpE5: return Response::generate(0, 'ok', array('redirect' => $BmUno)); goto bYDVm; cf9M7: $BmUno = $qWOW0 . '?client=' . urlencode($D9F7V) . '&timestamp=' . $a0lz0 . '&sign=' . $hX7aU; goto rZpE5; bYDVm: } public function logout() { goto oHrHx; fWC3V: return Response::generateSuccess(); goto CPsZS; oHrHx: $GMB9M = MemberUser::id(); goto H1ws8; oE8et: if ($GMB9M > 0) { EventUtil::fire(new MemberUserLogoutEvent($GMB9M)); } goto fWC3V; H1ws8: Session::forget('memberUserId'); goto oE8et; CPsZS: } public function login() { goto cLhEh; WqlWb: if (!$SHDjH) { $N9oGO = MemberUtil::login($g_JSv, null, null, $dfLHv); if (0 == $N9oGO['code']) { $SHDjH = $N9oGO['data']; } } goto aePUO; aePUO: if (!$SHDjH) { $N9oGO = MemberUtil::login(null, $g_JSv, null, $dfLHv); if (0 == $N9oGO['code']) { $SHDjH = $N9oGO['data']; } } goto Ww4UF; jUmC7: Session::put('memberUserId', $SHDjH['id']); goto UYeRl; wjaS2: EventUtil::fire(new MemberUserLoginedEvent($SHDjH['id'])); goto BaSfu; CekBj: $FrWZv = null; goto WqlWb; cLhEh: $OmDFL = InputPackage::buildFromInput(); goto xMC1p; UYeRl: MemberUtil::fireLogin($SHDjH['id']); goto wjaS2; Ww4UF: if (!$SHDjH) { $N9oGO = MemberUtil::login(null, null, $g_JSv, $dfLHv); if (0 == $N9oGO['code']) { $SHDjH = $N9oGO['data']; } } goto Xnxy1; Xnxy1: if (!$SHDjH) { $Eo0SX = Session::pull('memberUserLoginFailedTip', null); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:用户或密码错误' . ($Eo0SX ? '，' . $Eo0SX : '')); } goto jUmC7; xeR0Z: $SHDjH = null; goto CekBj; Oopo5: $dfLHv = $OmDFL->getTrimString('password'); goto QU3ts; BaSfu: return Response::generateSuccess(); goto fybb2; Sw37n: if (modstart_config('loginCaptchaEnable', false)) { $PDl_Q = SecurityUtil::loginCaptchaProvider(); if ($PDl_Q) { $N9oGO = $PDl_Q->validate(); if (Response::isError($N9oGO)) { return Response::generate(-1, $N9oGO['msg']); } } else { if (!CaptchaFacade::check($OmDFL->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:图片验证码错误', null, '[js]$(\'[data-captcha]\').click();'); } } } goto xeR0Z; xMC1p: $g_JSv = $OmDFL->getTrimString('username'); goto Oopo5; Ng2FU: if (empty($dfLHv)) { return Response::generate(-1, '请输入密码'); } goto Sw37n; QU3ts: if (empty($g_JSv)) { return Response::generate(-1, '请输入用户'); } goto Ng2FU; fybb2: } public function loginCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhoneCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhone() { goto sX0TX; U3Cf8: return Response::generate(0, null); goto Mz3rx; SY3cz: $OmDFL = InputPackage::buildFromInput(); goto cKVkn; nF0WA: MemberUtil::fireLogin($SHDjH['id']); goto HCorX; WAhNa: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto IjMK5; cKVkn: $Z0fSd = $OmDFL->getPhone('phone'); goto wPrJG; OPjZV: Session::put('memberUserId', $SHDjH['id']); goto nF0WA; iS_Ec: if (empty($SHDjH)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto i_exr; VutI3: Session::forget('loginPhone'); goto OPjZV; HCorX: EventUtil::fire(new MemberUserLoginedEvent($SHDjH)); goto U3Cf8; w0GzN: $kqo6R = Session::get('loginPhoneVerify'); goto z02Ua; Xbsj0: Session::forget('loginPhoneVerifyTime'); goto VutI3; f_eMz: if ($Z0fSd != Session::get('loginPhone')) { return Response::generate(-1, '两次手机不一致'); } goto WAhNa; sX0TX: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto SY3cz; G1eHl: if (empty($VGOVr)) { return Response::generate(-1, '验证码不能为空'); } goto w0GzN; z02Ua: if ($VGOVr != $kqo6R) { Log::info('Member.LoginPhone.LoginVerifyError - ' . $VGOVr . ' - ' . $kqo6R); return Response::generate(-1, '手机验证码不正确'); } goto nAFvM; i_exr: Session::forget('loginPhoneVerify'); goto Xbsj0; fVBh0: if (empty($Z0fSd)) { return Response::generate(-1, '手机为空或不正确'); } goto G1eHl; wPrJG: $VGOVr = $OmDFL->getTrimString('verify'); goto fVBh0; nAFvM: if (Session::get('loginPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto f_eMz; IjMK5: if (empty($SHDjH) && modstart_config('Member_LoginPhoneAutoRegister', false)) { goto gIwZv; hO0eV: $N9oGO = MemberUtil::register(null, $Z0fSd, null, null, true); goto GKqqz; GKqqz: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto IZ9SV; rsbsC: EventUtil::fire(new MemberUserRegisteredEvent($GMB9M)); goto cWPmt; Qi8CB: $c0sp9 = array(); goto Tjvvw; IZ9SV: $GMB9M = $N9oGO['data']['id']; goto UIxzC; nNFj0: if (!empty($c0sp9)) { MemberUtil::update($GMB9M, $c0sp9); } goto rsbsC; Tjvvw: $c0sp9['phoneVerified'] = true; goto FaEGO; UIxzC: MemberUtil::autoSetUsernameNickname($GMB9M, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto Qi8CB; cWPmt: Session::forget('registerCaptchaPass'); goto star2; gIwZv: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $N9oGO = $YeISX->preCheck(); if (Response::isError($N9oGO)) { return $N9oGO; } } goto hO0eV; star2: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $YeISX->postProcess($GMB9M); } goto beDXP; beDXP: $SHDjH = MemberUtil::get($GMB9M); goto LybJ7; FaEGO: $c0sp9['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto nNFj0; LybJ7: } goto iS_Ec; Mz3rx: } public function loginPhoneVerify() { goto EntAo; FaSmx: if (empty($SHDjH) && !modstart_config('Member_LoginPhoneAutoRegister', false)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto ual0R; ZuWhE: $Z0fSd = $OmDFL->getPhone('target'); goto KNy3I; EntAo: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto fQ28W; m4cu1: Session::put('loginPhoneVerify', $VGOVr); goto FFblN; QSINJ: Session::put('loginPhone', $Z0fSd); goto ketJY; BZfe4: $YeISX = SecurityUtil::loginCaptchaProvider(); goto l3ECA; fMzzu: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto FaSmx; fQ28W: $OmDFL = InputPackage::buildFromInput(); goto ZuWhE; zKgNI: $VGOVr = rand(100000, 999999); goto m4cu1; ketJY: SmsSendJob::create($Z0fSd, 'verify', array('code' => $VGOVr)); goto uLynO; l3ECA: if ($YeISX) { $N9oGO = $YeISX->validate(); if (Response::isError($N9oGO)) { return $N9oGO; } } else { $lRJEj = $OmDFL->getTrimString('captcha'); if (!CaptchaFacade::check($lRJEj)) { return Response::generate(-1, '图片验证码错误'); } } goto fMzzu; FFblN: Session::put('loginPhoneVerifyTime', time()); goto QSINJ; KNy3I: if (empty($Z0fSd)) { return Response::generate(-1, '手机为空或格式不正确'); } goto BZfe4; ual0R: if (Session::get('loginPhoneVerifyTime') && $Z0fSd == Session::get('loginPhone')) { if (Session::get('loginPhoneVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto zKgNI; uLynO: return Response::generate(0, '验证码发送成功'); goto OG593; OG593: } public function loginPhoneCaptcha() { $lRJEj = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); } public function loginCaptcha() { $lRJEj = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); } public function registerPhone() { goto KXdO0; QLGPQ: MemberUtil::autoSetUsernameNickname($GMB9M, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto z8QG1; npA2x: if ($Z0fSd != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto SD5ew; FLp7K: if ($ORJ4R != $uKRiv) { Log::info('Member.RegisterPhone.PhoneVerifyError - ' . $ORJ4R . ' - ' . $uKRiv); return Response::generate(-1, '手机验证码不正确.'); } goto oIojF; YkJcs: $Z0fSd = $OmDFL->getPhone('phone'); goto mcJOg; jmyym: $OmDFL = InputPackage::buildFromInput(); goto crctq; MUdDT: if (empty($Z0fSd)) { return Response::generate(-1, '请输入手机'); } goto HCgVM; HCgVM: $uKRiv = Session::get('registerPhoneVerify'); goto FLp7K; SD5ew: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $N9oGO = $YeISX->preCheck(); if (Response::isError($N9oGO)) { return $N9oGO; } } goto rf3sb; TpkNQ: $c0sp9['phoneVerified'] = true; goto iy2zf; crctq: if (modstart_config('Member_AgreementEnable', false)) { if (!$OmDFL->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto YkJcs; rf3sb: $N9oGO = MemberUtil::register(null, $Z0fSd, null, null, true); goto anzF_; kuQIF: Session::put('memberUserId', $GMB9M); goto QPjrt; kc4Uv: if (!empty($c0sp9)) { MemberUtil::update($GMB9M, $c0sp9); } goto QGliS; oIojF: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto npA2x; iy2zf: $c0sp9['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto kc4Uv; yFyGu: Session::forget('registerCaptchaPass'); goto lT3qY; QGliS: EventUtil::fire(new MemberUserRegisteredEvent($GMB9M)); goto yFyGu; E8C6l: $GMB9M = $N9oGO['data']['id']; goto QLGPQ; UmVhP: if (!modstart_config('Member_RegisterPhoneEnable', false)) { return Response::generate(-1, '手机快速注册未开启'); } goto jmyym; mcJOg: $ORJ4R = $OmDFL->getTrimString('phoneVerify'); goto MUdDT; lT3qY: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $YeISX->postProcess($GMB9M); } goto kuQIF; anzF_: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto E8C6l; WWSOH: return Response::generate(0, '注册成功', array('id' => $GMB9M)); goto ACw15; KXdO0: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto UmVhP; z8QG1: $c0sp9 = array(); goto TpkNQ; qLEmq: EventUtil::fire(new MemberUserLoginedEvent($GMB9M)); goto WWSOH; QPjrt: MemberUtil::fireLogin($GMB9M); goto qLEmq; ACw15: } public function register() { goto YSc8j; JuRdo: if (modstart_config('Member_AgreementEnable', false)) { if (!$OmDFL->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto sb14G; YgvTY: $ImFZ7 = $OmDFL->getEmail('email'); goto kV5JJ; SKOnc: $GMB9M = $N9oGO['data']['id']; goto IN4En; jffOQ: $dfLHv = $OmDFL->getTrimString('password'); goto SzD0l; sb14G: $g_JSv = $OmDFL->getTrimString('username'); goto FvmVb; yUPlY: $OmDFL = InputPackage::buildFromInput(); goto JuRdo; vHvyb: if (Str::contains($g_JSv, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto yC33k; FAb1l: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $N9oGO = $YeISX->preCheck(); if (Response::isError($N9oGO)) { return $N9oGO; } } goto ZmD09; SzD0l: $TXCKG = $OmDFL->getTrimString('passwordRepeat'); goto rbcvX; NXw1X: if (!Session::get('registerCaptchaPass', false)) { if (!CaptchaFacade::check($lRJEj)) { SessionUtil::atomicProduce('registerCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto fm_h7; FNLWN: foreach (MemberRegisterProcessorProvider::listAll() as $YeISX) { $YeISX->postProcess($GMB9M); } goto ctm5L; mntcx: if (empty($dfLHv)) { return Response::generate(-1, '请输入密码'); } goto D5nf6; D5nf6: if ($dfLHv != $TXCKG) { return Response::generate(-1, '两次输入密码不一致'); } goto FAb1l; kXcCZ: Session::forget('registerCaptchaPass'); goto FNLWN; ZmD09: $N9oGO = MemberUtil::register($g_JSv, $Z0fSd, $ImFZ7, $dfLHv); goto B4sEq; FvmVb: $Z0fSd = $OmDFL->getPhone('phone'); goto T6C2G; YSc8j: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto yUPlY; O21Uf: $c0sp9['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto Qx6fw; MEV92: if (modstart_config('registerEmailEnable')) { $c0sp9['emailVerified'] = true; } goto O21Uf; fm_h7: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto patmk; TdZgb: EventUtil::fire(new MemberUserRegisteredEvent($GMB9M)); goto kXcCZ; kV5JJ: $yQtmH = $OmDFL->getTrimString('emailVerify'); goto jffOQ; patmk: if (modstart_config('registerPhoneEnable')) { goto uPNmq; ZlZhs: $uKRiv = Session::get('registerPhoneVerify'); goto nwok1; zKS9a: if ($Z0fSd != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto pQVWJ; uPNmq: if (empty($Z0fSd)) { return Response::generate(-1, '请输入手机'); } goto ZlZhs; nwok1: if ($ORJ4R != $uKRiv) { Log::info('Member.Register.PhoneVerifyError - ' . $ORJ4R . ' - ' . $uKRiv); return Response::generate(-1, '手机验证码不正确.'); } goto OV7dG; OV7dG: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto zKS9a; pQVWJ: } goto c6knP; Qx6fw: if (!empty($c0sp9)) { MemberUtil::update($GMB9M, $c0sp9); } goto TdZgb; IN4En: $c0sp9 = array(); goto UIn9g; UIn9g: if (modstart_config('registerPhoneEnable')) { $c0sp9['phoneVerified'] = true; } goto MEV92; bShBW: if (empty($g_JSv)) { return Response::generate(-1, '用户名不能为空'); } goto vHvyb; rbcvX: $lRJEj = $OmDFL->getTrimString('captcha'); goto bShBW; T6C2G: $ORJ4R = $OmDFL->getTrimString('phoneVerify'); goto YgvTY; yC33k: if (preg_match('/^\\d{11}$/', $g_JSv)) { return Response::generate(-1, '用户名不能为纯数字'); } goto NXw1X; c6knP: if (modstart_config('registerEmailEnable')) { goto RxjDY; u_71U: $KzbIu = Session::get('registerEmailVerify'); goto Mtjzj; Mtjzj: if ($yQtmH != $KzbIu) { Log::info('Member.Register.EmailVerifyError - ' . $yQtmH . ' - ' . $KzbIu); return Response::generate(-1, '邮箱验证码不正确.'); } goto rvdGa; rvdGa: if (Session::get('registerEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto V9_WC; V9_WC: if ($ImFZ7 != Session::get('registerEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto KeITw; RxjDY: if (empty($ImFZ7)) { return Response::generate(-1, '请输入邮箱'); } goto u_71U; KeITw: } goto mntcx; ctm5L: return Response::generate(0, '注册成功', array('id' => $GMB9M)); goto vZMzJ; B4sEq: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto SKOnc; vZMzJ: } public function registerEmailVerify() { goto t1_YP; QJiWO: $VGOVr = rand(100000, 999999); goto OuQNc; nhH6D: return Response::generate(0, '验证码发送成功'); goto t1qFa; v2EFy: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto cms14; ycQN8: $ImFZ7 = $OmDFL->getEmail('target'); goto qBd_Q; zAvzn: if (!modstart_config('registerEmailEnable')) { return Response::generate(-1, '注册未开启邮箱'); } goto XSkxQ; UTNKR: Session::put('registerEmailVerifyTime', time()); goto Fj8p0; t1_YP: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto zAvzn; XSkxQ: $OmDFL = InputPackage::buildFromInput(); goto ycQN8; OuQNc: MailSendJob::create($ImFZ7, '注册账户验证码', 'verify', array('code' => $VGOVr)); goto R5Ovb; A5B2R: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto v2EFy; Fj8p0: Session::put('registerEmail', $ImFZ7); goto nhH6D; GUZTX: if (!empty($SHDjH)) { return Response::generate(-1, '邮箱已经被占用'); } goto vPQQp; cms14: $SHDjH = MemberUtil::getByEmail($ImFZ7); goto GUZTX; R5Ovb: Session::put('registerEmailVerify', $VGOVr); goto UTNKR; qBd_Q: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱不能为空'); } goto A5B2R; vPQQp: if (Session::get('registerEmailVerifyTime') && $ImFZ7 == Session::get('registerEmail')) { if (Session::get('registerEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto QJiWO; t1qFa: } public function registerPhoneVerify() { goto tz_z1; y7bOi: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto O1lrr; vLPDR: $VGOVr = rand(100000, 999999); goto IJ3D3; lso6I: if (!modstart_config('registerPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto zeusL; dRO8F: if (empty($Z0fSd)) { return Response::generate(-1, '手机不能为空'); } goto y7bOi; nmUti: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto Tvg0u; tz_z1: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto lso6I; IVfYz: Session::put('registerPhoneVerifyTime', time()); goto Nyrwe; dvCLz: $Z0fSd = $OmDFL->getPhone('target'); goto dRO8F; zeusL: $OmDFL = InputPackage::buildFromInput(); goto dvCLz; fV389: return Response::generate(0, '验证码发送成功'); goto ci4yl; fQDsO: Session::put('registerPhoneVerify', $VGOVr); goto IVfYz; IJ3D3: SmsSendJob::create($Z0fSd, 'verify', array('code' => $VGOVr)); goto fQDsO; ViYlG: if (Session::get('registerPhoneVerifyTime') && $Z0fSd == Session::get('registerPhone')) { if (Session::get('registerPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto vLPDR; Nyrwe: Session::put('registerPhone', $Z0fSd); goto fV389; Tvg0u: if (!empty($SHDjH)) { return Response::generate(-1, '手机已经被占用'); } goto ViYlG; O1lrr: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto nmUti; ci4yl: } public function registerCaptchaVerify() { goto U0por; HqSGB: if ($YeISX) { $N9oGO = $YeISX->validate(); if (Response::isError($N9oGO)) { return $N9oGO; } } else { goto IHxxT; bS5LF: if (!CaptchaFacade::check($lRJEj)) { SessionUtil::atomicRemove('registerCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto N61CJ; RiUY5: $lRJEj = $OmDFL->getTrimString('captcha'); goto bS5LF; IHxxT: $OmDFL = InputPackage::buildFromInput(); goto RiUY5; N61CJ: } goto hkPDF; qXtoc: $gqOy7 = 1; goto S32Kl; S32Kl: if (modstart_config('registerEmailEnable')) { $gqOy7++; } goto qT8T8; OiEY8: return Response::generateSuccess(); goto Srx4g; qT8T8: if (modstart_config('registerPhoneEnable')) { $gqOy7++; } goto EVo_K; hkPDF: Session::put('registerCaptchaPass', true); goto qXtoc; EVo_K: SessionUtil::atomicProduce('registerCaptchaPassCount', $gqOy7); goto OiEY8; U0por: $YeISX = SecurityUtil::registerCaptchaProvider(); goto HqSGB; Srx4g: } public function oauthBindCaptchaVerify() { goto QIxB4; uAVqi: $J7nIU = 1; goto p8r2k; Y37eB: if (modstart_config('Member_OauthBindEmailEnable')) { $J7nIU++; } goto l5O37; p8r2k: if (modstart_config('Member_OauthBindPhoneEnable')) { $J7nIU++; } goto Y37eB; l5O37: SessionUtil::atomicProduce('oauthBindCaptchaPassCount', $J7nIU); goto zkl1q; QwCVN: Session::put('oauthBindCaptchaPass', true); goto uAVqi; zkl1q: return Response::generateSuccess(); goto xjc_X; QIxB4: $OmDFL = InputPackage::buildFromInput(); goto Xh0or; Xh0or: $lRJEj = $OmDFL->getTrimString('captcha'); goto mSbX2; mSbX2: if (!CaptchaFacade::check($lRJEj)) { SessionUtil::atomicRemove('oauthBindCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto QwCVN; xjc_X: } public function oauthBindCaptchaRaw() { return CaptchaFacade::create('default'); } public function oauthBindCaptcha() { goto Ryt3m; Ryt3m: Session::forget('oauthBindCaptchaPass'); goto NZnPl; p4l6B: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); goto E8yca; NZnPl: $lRJEj = $this->oauthBindCaptchaRaw(); goto p4l6B; E8yca: } public function oauthBindEmailVerify() { goto PI3Mq; sAzcv: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto NJsB4; PH7TJ: return Response::generate(0, '验证码发送成功'); goto gkkTo; YAk_V: MailSendJob::create($ImFZ7, '注册账户验证码', 'verify', array('code' => $VGOVr)); goto mVIwJ; O6OC5: $VGOVr = rand(100000, 999999); goto YAk_V; DkpKJ: $SHDjH = MemberUtil::getByEmail($ImFZ7); goto Nls0M; Sbu3K: Session::put('oauthBindEmailVerifyTime', time()); goto MdwAZ; gZxQl: $OmDFL = InputPackage::buildFromInput(); goto fZaMz; mVIwJ: Session::put('oauthBindEmailVerify', $VGOVr); goto Sbu3K; K3Fhs: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱不能为空'); } goto sAzcv; PI3Mq: if (!modstart_config('Member_OauthBindEmailEnable')) { return Response::generate(-1, '授权登录未开启邮箱'); } goto gZxQl; Nls0M: if (!empty($SHDjH)) { return Response::generate(-1, '邮箱已经被占用'); } goto tBxGE; MdwAZ: Session::put('oauthBindEmail', $ImFZ7); goto PH7TJ; fZaMz: $ImFZ7 = $OmDFL->getEmail('target'); goto K3Fhs; tBxGE: if (Session::get('oauthBindEmailVerifyTime') && $ImFZ7 == Session::get('oauthBindEmail')) { if (Session::get('oauthBindEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto O6OC5; NJsB4: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto DkpKJ; gkkTo: } public function oauthBindPhoneVerify() { goto viDNu; ppTpy: $Z0fSd = $OmDFL->getPhone('target'); goto RYVBk; B2Brg: Session::put('oauthBindPhoneVerify', $VGOVr); goto TUD7u; Zo0iC: $VGOVr = rand(100000, 999999); goto mob4e; KOlBU: if (Session::get('oauthBindPhoneVerifyTime') && $Z0fSd == Session::get('oauthBindPhone')) { if (Session::get('oauthBindPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto Zo0iC; bAUUG: Session::put('oauthBindPhone', $Z0fSd); goto QaLiL; QaLiL: return Response::generate(0, '验证码发送成功'); goto NBl3u; cJS0B: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto waHKd; RYVBk: if (empty($Z0fSd)) { return Response::generate(-1, '手机不能为空'); } goto c4nil; BcCVE: if (!empty($SHDjH)) { return Response::generate(-1, '手机已经被占用'); } goto KOlBU; TUD7u: Session::put('oauthBindPhoneVerifyTime', time()); goto bAUUG; viDNu: if (!modstart_config('Member_OauthBindPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto mmc22; mmc22: $OmDFL = InputPackage::buildFromInput(); goto ppTpy; waHKd: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto BcCVE; c4nil: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto cJS0B; mob4e: SmsSendJob::create($Z0fSd, 'verify', array('code' => $VGOVr)); goto B2Brg; NBl3u: } public function registerCaptchaRaw() { return CaptchaFacade::create('default'); } public function registerCaptcha() { goto OQ6Tv; ndY6U: $lRJEj = $this->registerCaptchaRaw(); goto PiCHc; OQ6Tv: Session::forget('registerCaptchaPass'); goto ndY6U; PiCHc: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); goto fK1rs; fK1rs: } public function retrievePhone() { goto SK4Dj; AHufF: if (!modstart_config('retrievePhoneEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto nbXVs; bQrYi: if ($VGOVr != $kqo6R) { Log::info('Member.RetrievePhone.PhoneVerifyError - ' . $VGOVr . ' - ' . $kqo6R); return Response::generate(-1, '手机验证码不正确'); } goto MVySl; hYKS_: if (empty($Z0fSd)) { return Response::generate(-1, '手机为空或不正确'); } goto wNoE3; E5CSz: $kqo6R = Session::get('retrievePhoneVerify'); goto bQrYi; UJgkb: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto ldrVZ; CbLmP: Session::forget('retrievePhone'); goto rx2lm; k2Kpj: Session::forget('retrievePhoneVerifyTime'); goto CbLmP; nbXVs: $Z0fSd = $OmDFL->getPhone('phone'); goto MO7Nw; ldrVZ: if (empty($SHDjH)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto q1d5w; MVySl: if (Session::get('retrievePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto Emvue; q4Q00: $OmDFL = InputPackage::buildFromInput(); goto AHufF; MO7Nw: $VGOVr = $OmDFL->getTrimString('verify'); goto hYKS_; SK4Dj: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto q4Q00; wNoE3: if (empty($VGOVr)) { return Response::generate(-1, '验证码不能为空'); } goto E5CSz; Emvue: if ($Z0fSd != Session::get('retrievePhone')) { return Response::generate(-1, '两次手机不一致'); } goto UJgkb; q1d5w: Session::forget('retrievePhoneVerify'); goto k2Kpj; Z7X8n: return Response::generate(0, null); goto y9DGn; rx2lm: Session::put('retrieveMemberUserId', $SHDjH['id']); goto Z7X8n; y9DGn: } public function retrievePhoneVerify() { goto E4jWG; HYlm4: if (!CaptchaFacade::check($lRJEj)) { return Response::generate(-1, '图片验证码错误'); } goto dhHH2; E4jWG: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto gcTJk; uCKKt: return Response::generate(0, '验证码发送成功'); goto dZP06; MPA2I: $VGOVr = rand(100000, 999999); goto mU0NJ; seGMg: $lRJEj = $OmDFL->getTrimString('captcha'); goto HYlm4; Lzjdo: Session::put('retrievePhoneVerifyTime', time()); goto IkFpf; NO7EX: $Z0fSd = $OmDFL->getPhone('target'); goto Mhamg; IHFe2: if (empty($SHDjH)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto eLUB9; gcTJk: $OmDFL = InputPackage::buildFromInput(); goto NO7EX; eLUB9: if (Session::get('retrievePhoneVerifyTime') && $Z0fSd == Session::get('retrievePhone')) { if (Session::get('retrievePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto MPA2I; H42OH: SmsSendJob::create($Z0fSd, 'verify', array('code' => $VGOVr)); goto uCKKt; Mhamg: if (empty($Z0fSd)) { return Response::generate(-1, '手机为空或格式不正确'); } goto seGMg; mU0NJ: Session::put('retrievePhoneVerify', $VGOVr); goto Lzjdo; dhHH2: $SHDjH = MemberUtil::getByPhone($Z0fSd); goto IHFe2; IkFpf: Session::put('retrievePhone', $Z0fSd); goto H42OH; dZP06: } public function retrieveEmail() { goto WemHg; xOsSz: if ($ImFZ7 != Session::get('retrieveEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto jBZHC; fvRnL: if (empty($SHDjH)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto WlK3W; ylmcm: $VGOVr = $OmDFL->getTrimString('verify'); goto KsZ8H; KsZ8H: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱为空或格式不正确'); } goto VEo3I; WemHg: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto dqW78; jBZHC: $SHDjH = MemberUtil::getByEmail($ImFZ7); goto fvRnL; Ynw0S: $OmDFL = InputPackage::buildFromInput(); goto aTmzf; WlK3W: Session::forget('retrieveEmailVerify'); goto oyAh1; VEo3I: if (empty($VGOVr)) { return Response::generate(-1, '验证码不能为空'); } goto dRU4u; u22nj: Session::put('retrieveMemberUserId', $SHDjH['id']); goto jMju8; iK5LO: if (Session::get('retrieveEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '邮箱验证码已过期'); } goto xOsSz; dRU4u: $kqo6R = Session::get('retrieveEmailVerify'); goto WcIeX; aTmzf: $ImFZ7 = $OmDFL->getEmail('email'); goto ylmcm; WcIeX: if ($VGOVr != $kqo6R) { Log::info('Member.RetrieveEmail.PhoneVerifyError - ' . $VGOVr . '- ' . $kqo6R); return Response::generate(-1, '邮箱验证码不正确'); } goto iK5LO; dqW78: if (!modstart_config('retrieveEmailEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto Ynw0S; jUWYZ: Session::forget('retrieveEmail'); goto u22nj; oyAh1: Session::forget('retrieveEmailVerifyTime'); goto jUWYZ; jMju8: return Response::generate(0, null); goto gr2z7; gr2z7: } public function retrieveEmailVerify() { goto qbE49; j74Yh: $OmDFL = InputPackage::buildFromInput(); goto y2M_3; SH5YK: $lRJEj = $OmDFL->getTrimString('captcha'); goto jmJZN; AMfge: MailSendJob::create($ImFZ7, '找回密码验证码', 'verify', array('code' => $VGOVr)); goto wq0zz; SKx3K: if (Session::get('retrieveEmailVerifyTime') && $ImFZ7 == Session::get('retrieveEmail')) { if (Session::get('retrieveEmailVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto fp3Go; Y7sCV: if (empty($SHDjH)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto SKx3K; fp3Go: $VGOVr = rand(100000, 999999); goto AMfge; y2M_3: $ImFZ7 = $OmDFL->getEmail('target'); goto RAXeA; QQ8I5: return Response::generate(0, '验证码发送成功'); goto SO0R1; CqUtP: Session::put('retrieveEmailVerifyTime', time()); goto j1uZi; Q6mYe: $SHDjH = MemberUtil::getByEmail($ImFZ7); goto Y7sCV; RAXeA: if (empty($ImFZ7)) { return Response::generate(-1, '邮箱格式不正确或为空'); } goto SH5YK; qbE49: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto j74Yh; j1uZi: Session::put('retrieveEmail', $ImFZ7); goto QQ8I5; wq0zz: Session::put('retrieveEmailVerify', $VGOVr); goto CqUtP; jmJZN: if (!CaptchaFacade::check($lRJEj)) { return Response::generate(-1, '图片验证码错误'); } goto Q6mYe; SO0R1: } public function retrieveResetInfo() { goto YnrXK; wwVqs: if (empty($g_JSv)) { $g_JSv = $SHDjH['email']; } goto d8RaK; cdpCP: if (empty($g_JSv)) { $g_JSv = $SHDjH['phone']; } goto wwVqs; d8RaK: return Response::generate(0, null, array('memberUser' => array('username' => $g_JSv))); goto sfm1W; qHbCX: $SHDjH = MemberUtil::get($qsV6a); goto XsaVf; XsaVf: $g_JSv = $SHDjH['username']; goto cdpCP; YnrXK: $qsV6a = Session::get('retrieveMemberUserId'); goto Eaf6r; Eaf6r: if (empty($qsV6a)) { return Response::generate(-1, '请求错误'); } goto qHbCX; sfm1W: } public function retrieveReset() { goto tEJh2; HnwkB: $qsV6a = Session::get('retrieveMemberUserId'); goto UshsG; RiWhY: if (empty($SHDjH)) { return Response::generate(-1, '用户不存在'); } goto wweUG; ty0ri: $TXCKG = $OmDFL->getTrimString('passwordRepeat'); goto q_C2d; UshsG: if (empty($qsV6a)) { return Response::generate(-1, '请求错误'); } goto NGxRq; tEJh2: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto PTVn4; PTVn4: $OmDFL = InputPackage::buildFromInput(); goto HnwkB; yx4M8: if ($N9oGO['code']) { return Response::generate(-1, $N9oGO['msg']); } goto ngPcK; qPZfd: return Response::generate(0, '成功设置新密码,请您登录'); goto kafqF; QBJQF: $SHDjH = MemberUtil::get($qsV6a); goto RiWhY; q_C2d: if (empty($dfLHv)) { return Response::generate(-1, '请输入密码'); } goto N7akj; NGxRq: $dfLHv = $OmDFL->getTrimString('password'); goto ty0ri; wweUG: $N9oGO = MemberUtil::changePassword($SHDjH['id'], $dfLHv, null, true); goto yx4M8; ngPcK: EventUtil::fire(new MemberUserPasswordResetedEvent($SHDjH['id'], $dfLHv)); goto ramc2; ramc2: Session::forget('retrieveMemberUserId'); goto qPZfd; N7akj: if ($dfLHv != $TXCKG) { return Response::generate(-1, '两次输入密码不一致'); } goto QBJQF; kafqF: } public function retrieveCaptchaRaw() { return CaptchaFacade::create('default'); } public function retrieveCaptcha() { $lRJEj = $this->retrieveCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($lRJEj->getOriginalContent()))); } }