<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $lrs14) { $lrs14->init('member_user')->field(function ($lrs14) { $lrs14->id('id', 'ID'); MemberAdminList::callGridField($lrs14); $lrs14->display('avatar', '头像')->hookRendering(function (AbstractField $xtxST, $S1TUa, $XfWHs) { $JN03g = AssetsUtil::fixOrDefault($S1TUa->avatar, 'asset/image/avatar.svg'); $asecO = AssetsUtil::fixOrDefault($S1TUa->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$asecO}' class='tw-inline-block' data-image-preview>\n                        <img src='{$JN03g}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $lrs14->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $xtxST, $S1TUa, $XfWHs) { switch ($xtxST->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($S1TUa->username), modstart_admin_url('member/show', array('_id' => $S1TUa->id)))->width('90%')->height('90%')->render()); break; } }); $lrs14->text('email', '邮箱'); $lrs14->text('phone', '手机'); $lrs14->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $lrs14->display('_oauth', '授权')->hookRendering(function (AbstractField $xtxST, $S1TUa, $XfWHs) { $AdSEk = array(); $SBGJ2 = MemberUtil::listOauths($S1TUa->id); foreach ($SBGJ2 as $fzohp) { goto W4phH; W4phH: $rybEC = null; goto sccgx; opEHw: $Hi5N0 = MemberOauth::getByOauthKey($fzohp['type']); goto krZGn; ox08b: $AdSEk[] = '<a style="color:' . $rybEC . ';" href="javascript:;" data-tip-popover="' . $Rsou0 . '"><i class="iconfont icon-dot"></i></a>'; goto Uaw4i; BtNBA: if (empty($rybEC)) { $rybEC = ColorUtil::pick($fzohp['type']); } goto ox08b; sccgx: $Rsou0 = $fzohp['type']; goto opEHw; krZGn: if ($Hi5N0) { $rybEC = $Hi5N0->color(); $Rsou0 = $Hi5N0->title(); } goto BtNBA; Uaw4i: } return join('', $AdSEk); }); } $lrs14->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $B28Vn = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($B28Vn) { $lrs14->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $TTPvP = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($TTPvP) { $lrs14->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $lrs14->date('vipExpire', 'VIP过期'); } $lrs14->display('registerIp', '注册IP'); $lrs14->display('created_at', '注册时间'); $lrs14->canBatchSelect(true); $lrs14->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $GAnRo) { $GAnRo->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $GAnRo) { $GAnRo->eq('id', L('ID')); $GAnRo->like('username', '用户名'); $GAnRo->like('email', '邮箱')->autoHide(true); $GAnRo->like('phone', '手机')->autoHide(true); $GAnRo->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $GAnRo->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $GAnRo->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $ksfY5) { $S1TUa = $ksfY5->item(); $ksfY5->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $S1TUa->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $CuPBX) { goto kFBYi; kFBYi: $wSgB9 = Form::make(''); goto FDEVH; gbpRH: $wSgB9->showSubmit(false)->showReset(false); goto ePem7; UdzrR: $wSgB9->layoutPanel('高级', function (Form $wSgB9) { $wSgB9->text('nickname', '昵称'); $wSgB9->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $wSgB9->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $wSgB9->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $wSgB9->date('vipExpire', 'VIP过期'); } }); goto gbpRH; FDEVH: $wSgB9->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $wSgB9) { $wSgB9->text('username', '用户名'); $wSgB9->text('phone', '手机'); $wSgB9->text('email', '邮箱'); $wSgB9->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto UdzrR; ePem7: return $CuPBX->pageTitle('创建用户')->body($wSgB9)->handleForm($wSgB9, function (Form $wSgB9) { AdminPermission::demoCheck(); $rRFRV = $wSgB9->dataForming(); $g_JSv = !empty($rRFRV['username']) ? $rRFRV['username'] : null; $Z0fSd = !empty($rRFRV['phone']) ? $rRFRV['phone'] : null; $ImFZ7 = !empty($rRFRV['email']) ? $rRFRV['email'] : null; $BaM2b = ArrayUtil::keepKeys($rRFRV, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $N9oGO = MemberUtil::register($g_JSv, $Z0fSd, $ImFZ7, $rRFRV['password']); BizException::throwsIfResponseError($N9oGO); if (!empty($BaM2b)) { if (isset($BaM2b['vipExpire']) && TimeUtil::isDateEmpty($BaM2b['vipExpire'])) { $BaM2b['vipExpire'] = null; } MemberUtil::update($N9oGO['data']['id'], $BaM2b); } EventUtil::fire(new MemberUserRegisteredEvent($N9oGO['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto DkKun; DkKun: } public function edit(AdminDialogPage $CuPBX) { goto mpcZA; l8I7y: $wSgB9->item($SHDjH)->fillFields(); goto yuJbG; R1UfF: return $CuPBX->pageTitle('修改信息')->body($wSgB9)->handleForm($wSgB9, function (Form $wSgB9) use($SHDjH) { AdminPermission::demoCheck(); $rRFRV = $wSgB9->dataForming(); $H9NJV = ArrayUtil::keepKeys($rRFRV, array('username', 'phone', 'email')); $BaM2b = ArrayUtil::keepKeys($rRFRV, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $N9oGO = MemberUtil::updateBasicWithUniqueCheck($SHDjH['id'], $H9NJV); BizException::throwsIfResponseError($N9oGO); if (isset($BaM2b['vipExpire']) && TimeUtil::isDateEmpty($BaM2b['vipExpire'])) { $BaM2b['vipExpire'] = null; } MemberUtil::update($SHDjH['id'], $BaM2b); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto xjCjo; Rg5Z1: if (Request::isPost()) { goto LPv1X; LPv1X: AdminPermission::demoCheck(); goto y0nF_; hWepi: switch ($OmDFL->getTrimString('_action')) { case 'itemCellEdit': goto rB1GF; l1Cy7: switch ($OmDFL->getTrimString('column')) { case 'status': $c0sp9['status'] = $OmDFL->getInteger('value'); break; } goto KFkPW; rB1GF: $c0sp9 = array(); goto l1Cy7; KFkPW: if (!empty($c0sp9)) { MemberUtil::update($SHDjH['id'], $c0sp9); } goto Ba02E; Ba02E: return Response::generateSuccess(); goto nKLWZ; nKLWZ: } goto gm5ii; y0nF_: $OmDFL = InputPackage::buildFromInput(); goto hWepi; gm5ii: } goto LPfGT; yuJbG: $wSgB9->showSubmit(false)->showReset(false); goto R1UfF; mpcZA: $SHDjH = ModelUtil::get('member_user', CRUDUtil::id()); goto NCVa5; Uo5L6: $wSgB9->layoutPanel('基础', function (Form $wSgB9) { $wSgB9->display('id', '用户ID')->addable(true); $wSgB9->text('username', '用户名'); $wSgB9->text('phone', '手机'); $wSgB9->text('email', '邮箱'); }); goto noXwd; NCVa5: BizException::throwsIfEmpty('用户不存在', $SHDjH); goto Rg5Z1; noXwd: $wSgB9->layoutPanel('高级', function (Form $wSgB9) { $wSgB9->text('nickname', '昵称'); $wSgB9->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $wSgB9->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $wSgB9->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $wSgB9->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto l8I7y; LPfGT: $wSgB9 = Form::make(''); goto Uo5L6; xjCjo: } public function select(AdminDialogPage $CuPBX) { goto yTG1o; SsiIR: if (Request::isPost()) { return $Ib5tl->request(); } goto gCENP; yTG1o: $Ib5tl = $this->grid(); goto VPmtl; Ptipo: CRUDUtil::registerGridResource($Ib5tl, '\\' . __CLASS__); goto SsiIR; gCENP: return $CuPBX->pageTitle('选择用户')->body($Ib5tl); goto oVUok; wI0_h: $Ib5tl->canSingleSelectItem(true); goto Ptipo; VPmtl: $Ib5tl->disableCUD(); goto wI0_h; oVUok: } public function search() { goto hkz6a; FxsBZ: $fcfDg = array(); goto aOHqW; QzuTl: $RFnEp = MemberUtil::paginate(1, 10, $fcfDg); goto rYRyT; J3JwE: $GB1AX = $OmDFL->getTrimString('keywords'); goto FxsBZ; rYRyT: $DVq16 = array_map(function ($S1TUa) { return array('value' => intval($S1TUa['id']), 'name' => htmlspecialchars(MemberUtil::viewName($S1TUa)), 'avatar' => AssetsUtil::fixOrDefault($S1TUa['avatar'], 'asset/image/avatar.svg')); }, $RFnEp['records']); goto G3Zzx; G3Zzx: return Response::jsonSuccessData($DVq16); goto YJyhV; hkz6a: $OmDFL = InputPackage::buildFromInput(); goto J3JwE; aOHqW: $fcfDg['whereOperate'] = array('username', 'like', "%{$GB1AX}%"); goto QzuTl; YJyhV: } public function resetPassword(AdminConfigBuilder $lrs14) { goto jaANk; qJTUP: $lrs14->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto f4Sj3; Xex4h: $lrs14->pageTitle('重置密码'); goto qJTUP; vagPy: $lrs14->useDialog(); goto Xex4h; jaANk: $XKqER = CRUDUtil::id(); goto TTBc_; TTBc_: $SHDjH = MemberUtil::get($XKqER); goto UsPPe; f4Sj3: if (Request::isPost()) { return $lrs14->formRequest(function (Form $wSgB9) use($SHDjH) { AdminPermission::demoCheck(); $rRFRV = $wSgB9->dataForming(); $N9oGO = MemberUtil::changePassword($SHDjH['id'], $rRFRV['passwordNew'], null, true); BizException::throwsIfResponseError($N9oGO); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto nHdT2; nHdT2: return $lrs14; goto C1Inb; UsPPe: BizException::throwsIfEmpty('用户不存在', $SHDjH); goto vagPy; C1Inb: } public function sendMessage(AdminConfigBuilder $lrs14) { goto yS7yg; Wztsc: BizException::throwsIfEmpty('用户不存在', $SHDjH); goto nkSj2; yS7yg: $XKqER = CRUDUtil::id(); goto vzfSQ; aiihD: if (Request::isPost()) { return $lrs14->formRequest(function (Form $wSgB9) use($SHDjH) { AdminPermission::demoCheck(); $rRFRV = $wSgB9->dataForming(); $N9oGO = MemberMessageUtil::send($SHDjH['id'], $rRFRV['content']); BizException::throwsIfResponseError($N9oGO); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto U8FT2; vzfSQ: $SHDjH = MemberUtil::get($XKqER); goto Wztsc; ROZao: $lrs14->richHtml('content', '消息内容')->required(); goto aiihD; vlbEH: $lrs14->pageTitle('发送消息'); goto ROZao; U8FT2: return $lrs14; goto lA2fq; nkSj2: $lrs14->useDialog(); goto vlbEH; lA2fq: } public function show() { goto kcJkQ; VZ20b: return view('module::Member.View.admin.memberUser.show', array('record' => $q_6_i, 'showPanelProviders' => $pUq7L)); goto VpORW; PV0e3: $pUq7L = MemberAdminShowPanelProvider::listAll(); goto VZ20b; kcJkQ: $q_6_i = MemberUtil::get(CRUDUtil::id()); goto PV0e3; VpORW: } public function delete() { goto SV3mS; CxCn4: return Response::redirect(CRUDUtil::jsGridRefresh()); goto g4gms; SV3mS: AdminPermission::demoCheck(); goto Ojk9U; Ojk9U: MemberUtil::delete(CRUDUtil::id()); goto CxCn4; g4gms: } public function statusForbidden() { goto Qgt8h; Q7tDP: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto CKUvx; Qgt8h: AdminPermission::demoCheck(); goto Q7tDP; CKUvx: return Response::redirect(CRUDUtil::jsGridRefresh()); goto gDNv_; gDNv_: } public function export(ExportHandle $lUS2h) { $wyK8U = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $lUS2h->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($wyK8U)->handleFetch(function ($CuPBX, $Oy_Ml, $tsZoI, $V1tDr) { $bZNIl = ModelUtil::model('member_user'); $bZNIl = $bZNIl->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($tsZoI as $qqjHv) { if (!empty($qqjHv['id']['eq'])) { $bZNIl = $bZNIl->where('id', $qqjHv['id']['eq']); } elseif (!empty($qqjHv['status']['eq'])) { $bZNIl = $bZNIl->where('status', $qqjHv['status']['eq']); } elseif (!empty($qqjHv['groupId']['eq'])) { $bZNIl = $bZNIl->where('groupId', $qqjHv['groupId']['eq']); } elseif (!empty($qqjHv['vipId']['eq'])) { $bZNIl = $bZNIl->where('vipId', $qqjHv['vipId']['eq']); } elseif (!empty($qqjHv['username']['like'])) { $bZNIl = $bZNIl->where('username', 'like', '%' . $qqjHv['username']['like'] . '%'); } elseif (!empty($qqjHv['email']['like'])) { $bZNIl = $bZNIl->where('email', 'like', '%' . $qqjHv['email']['like'] . '%'); } elseif (!empty($qqjHv['phone']['like'])) { $bZNIl = $bZNIl->where('phone', 'like', '%' . $qqjHv['phone']['like'] . '%'); } } $aogNB = $bZNIl->paginate($Oy_Ml, array('*'), 'page', $CuPBX)->toArray(); $a82A0 = array(); foreach ($aogNB['data'] as $S1TUa) { goto WuW2L; PNPV5: $Cx9uh[] = $S1TUa['phone']; goto igGmk; WuW2L: $Cx9uh = array(); goto W8m5o; AUJZp: $Cx9uh[] = TypeUtil::name(Gender::class, $S1TUa['gender']); goto F5pYu; W8m5o: $Cx9uh[] = $S1TUa['id']; goto b_zSe; JeLjv: $Cx9uh[] = $S1TUa['email']; goto PNPV5; TXjJi: $Cx9uh[] = $S1TUa['signature']; goto AH0eK; igGmk: $Cx9uh[] = $S1TUa['created_at']; goto AUJZp; AH0eK: $a82A0[] = $Cx9uh; goto Jq_lj; b_zSe: $Cx9uh[] = $S1TUa['username']; goto JeLjv; F5pYu: $Cx9uh[] = $S1TUa['realname']; goto TXjJi; Jq_lj: } return array('list' => $a82A0, 'total' => $aogNB['total']); })->performCommon(); } }