<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($lUwSs, \Closure $lRncP = null) { goto caoyu; zUg6T: $this->repository = Repository::instance($lUwSs); goto J6aIi; Kilxi: $this->setupRepositoryFilter(); goto F3aS3; J6aIi: $this->setupFields(); goto aWk5J; caoyu: $this->id = IdUtil::generate('Grid'); goto zUg6T; aWk5J: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto Kilxi; F3aS3: $this->builder($lRncP); goto eXxNe; eXxNe: } public static function make($XcdGB = null, \Closure $lRncP = null) { if (is_object($XcdGB) || class_exists($XcdGB) && is_subclass_of($XcdGB, Model::class)) { return new Form($XcdGB, $lRncP); } return new Form(DynamicModel::make($XcdGB), $lRncP); } public function asTree($gO0VD = 'id', $NonoW = 'pid', $iIQwI = 'sort', $hYwmi = 'title') { goto T7U3p; QK3iP: return $this; goto oCgyP; DgNES: $this->repository->setTreePidColumn($NonoW); goto XCcWg; HIhtE: $this->canSort(true); goto QK3iP; T7U3p: $this->repository->setKeyName($gO0VD); goto DgNES; mHta3: $this->engine = FormEngine::TREE; goto HIhtE; WJ2I9: $this->repository->setTreeTitleColumn($hYwmi); goto mHta3; XCcWg: $this->repository->setSortColumn($iIQwI); goto WJ2I9; oCgyP: } public function asTreeMass($aD9UU = 0, $gO0VD = 'id', $NonoW = 'pid', $iIQwI = 'sort', $hYwmi = 'title') { goto vKzxR; vKzxR: $this->repository->setKeyName($gO0VD); goto Fu3Ud; kb663: $this->repository->setTreeTitleColumn($hYwmi); goto QpFD_; QpFD_: $this->engine = FormEngine::TREE_MASS; goto J29Fh; fLfR5: $this->repository->setSortColumn($iIQwI); goto kb663; J29Fh: $this->canSort(true); goto coF8U; coF8U: return $this; goto SsM2w; Fu3Ud: $this->repository->setTreePidColumn($NonoW); goto fLfR5; SsM2w: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $v_7yw = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $v_7yw->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $v_7yw = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $v_7yw->value(0); } $this->prependField($v_7yw); } else { if ($this->engine == FormEngine::TREE_MASS) { goto fCMMr; EIb6J: $this->prependField($v_7yw); goto QBjut; fCMMr: $v_7yw = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto Phu5y; Phu5y: $v_7yw->addable(true)->editable(true)->listable(false); goto V5CO0; V5CO0: $v_7yw->hookRendering(function (AbstractField $v_7yw, $B1nVE, $qGrYn) { if (empty($B1nVE)) { $fFoOp = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $fFoOp = $B1nVE->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $fFoOp); $xBRVw = $this->repository->getTreeAncestorItems(); $UuhSQ = array(); $UuhSQ[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($xBRVw as $IxbVw) { $UuhSQ[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($IxbVw->{$this->repository->getTreeTitleColumn()}); } $UuhSQ[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($fFoOp) . '" />'; return AutoRenderedFieldValue::make(join('', $UuhSQ)); }); goto EIb6J; QBjut: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($cXZY7, $cdcZ5) { goto T1Vri; wCL0J: return $fP5gT; goto z_ean; cPRHb: if (empty($fP5gT)) { return false; } goto wCL0J; PBa27: foreach ($cXZY7 as $v_7yw) { if (!($fZaEo = $v_7yw->getValidator($cdcZ5))) { continue; } if ($fZaEo instanceof Validator) { try { if (!$fZaEo->passes()) { $NEfEW[] = $fZaEo; } } catch (\Exception $TIJlS) { BizException::throws('Form.fieldValidateMessages.Error - ' . SerializeUtil::jsonEncode($fZaEo->getRules())); } } } goto Auazf; as1Kx: foreach ($NEfEW as $fZaEo) { foreach ($fZaEo->messages()->getMessages() as $ciwv1 => $ewKIW) { $fP5gT[$ciwv1] = $ewKIW; } } goto cPRHb; T1Vri: $NEfEW = array(); goto PBa27; Auazf: $fP5gT = array(); goto as1Kx; z_ean: } private function convertBizExceptionToResponse($T3U2G) { goto SinRe; qLOah: return Response::jsonError($ZJm87); goto N8C0T; SinRe: $ZJm87 = $T3U2G->getMessage(); goto UXIxC; UXIxC: $R52GT = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto lvxg0; lvxg0: foreach ($R52GT as $MXQhG) { if (Str::startsWith($ZJm87, $MXQhG[0])) { goto KgukY; KgukY: list($xKfax, $Yj3Zs) = explode(':', $ZJm87); goto Gf51f; rrEyY: if ($v_7yw) { return Response::jsonError(L($MXQhG[1], $v_7yw->label())); } goto zWzX6; Gf51f: $v_7yw = $this->getFieldByColumn($Yj3Zs); goto rrEyY; zWzX6: } } goto qLOah; N8C0T: } private function validateFields($cXZY7, $Q7kxa) { goto C153X; iaOgD: return Response::generateSuccess(); goto y8aR6; uhGne: if ($PqJQE = $this->fieldValidateMessages($cXZY7, $Q7kxa)) { $ZYBSo = array_merge($ZYBSo, $PqJQE); } goto l4FNH; l4FNH: foreach ($ZYBSo as $ciwv1 => $fP5gT) { foreach ($fP5gT as $gm23_) { return Response::generateError($gm23_); } } goto iaOgD; C153X: $ZYBSo = array(); goto uhGne; y8aR6: } private function removeReservedFields() { goto xpWB0; Wfnyn: $this->fields = $this->fields()->reject($yPlyO); goto PEUVl; xpWB0: $e6vzp = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto UI8UB; UI8UB: $yPlyO = function (AbstractField $v_7yw) use(&$e6vzp) { return in_array($v_7yw->column(), $e6vzp, true) && $v_7yw instanceof \ModStart\Field\Display; }; goto Wfnyn; PEUVl: } public function hookCall($MWW3J) { if ($MWW3J instanceof Closure) { $P5qm8 = call_user_func($MWW3J, $this); if (null !== $P5qm8) { return $P5qm8; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($MWW3J, array $Q7kxa = null) { goto QF_5Z; tVTp3: $this->dataSubmitted = $Q7kxa ? $Q7kxa : Input::all(); goto Jkjky; DbVSo: $this->build(); goto tVTp3; Jkjky: try { goto d572Q; S02Sz: if (null !== $P5qm8) { if (Response::isError($P5qm8)) { return Response::jsonFromGenerate($P5qm8); } } goto Mp0xg; Mp0xg: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto TGfqC; w38UT: $P5qm8 = call_user_func($MWW3J, $this); goto S02Sz; wYyCl: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto uTFRd; Xg6Sr: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto w38UT; tXcdc: $this->removeReservedFields(); goto Tcbaf; d572Q: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto wMewQ; TGfqC: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto qcTya; qcTya: if (null !== $P5qm8) { return Response::jsonFromGenerate($P5qm8); } goto wYyCl; OMT21: $this->dataForming = array(); goto tXcdc; wMewQ: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto OMT21; Tcbaf: foreach ($this->addableFields() as $v_7yw) { goto Uuqsu; nPFuB: $q24ck = $v_7yw->serializeValue($q24ck, $v_7yw); goto WI0EP; ko_Bp: $this->dataForming[$v_7yw->column()] = $q24ck; goto ppa4V; WI0EP: if ($v_7yw->hookValueSerialize()) { $q24ck = call_user_func($v_7yw->hookValueSerialize(), $q24ck, $v_7yw); } goto ko_Bp; AAOJR: $q24ck = isset($this->dataSubmitted[$v_7yw->column()]) ? $this->dataSubmitted[$v_7yw->column()] : null; goto bf2kj; bf2kj: $q24ck = $v_7yw->prepareInput($q24ck, $this->dataSubmitted); goto nPFuB; Uuqsu: if ($v_7yw->isLayoutField()) { continue; } goto AAOJR; ppa4V: } goto Xg6Sr; uTFRd: return Response::jsonSuccess(L('Save Success')); goto vcUvo; vcUvo: } catch (BizException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } catch (ResultException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } goto XtNu1; QF_5Z: $this->mode(FormMode::FORM); goto DbVSo; XtNu1: } public function add() { goto jn7So; nXeX6: return $this; goto g2cvd; cqoNH: $this->build(); goto YEwKB; jn7So: $this->mode(FormMode::ADD); goto HO5k2; HO5k2: $mfIK2 = false; goto jt1VR; YEwKB: if ($mfIK2) { $this->fillFields(); } goto nXeX6; jt1VR: if ($this->canCopy()) { $s4Q1z = CRUDUtil::copyId(); if ($s4Q1z) { goto TDN5U; FF27S: $this->item($this->repository()->editing($this)); goto fuLEh; uNR2T: $mfIK2 = true; goto Ra1hr; fuLEh: $this->itemId(0); goto uNR2T; TDN5U: $this->itemId($s4Q1z); goto FF27S; Ra1hr: } } goto cqoNH; g2cvd: } public function addRequest(array $Q7kxa = null) { goto Gt8b7; pxHww: $this->dataSubmitted = $Q7kxa ? $Q7kxa : Input::all(); goto SY93R; SY93R: try { goto UexON; ZYjDK: return Response::jsonSuccess(L('Add Success')); goto RmlK9; vVDri: $a8lJE = $this->repository->add($this); goto jvija; X2Vdr: foreach ($this->addableFields() as $v_7yw) { goto dtd2R; Q0tuu: if ($v_7yw->hookValueSerialize()) { $q24ck = call_user_func($v_7yw->hookValueSerialize(), $q24ck, $v_7yw); } goto tgejp; RzTPS: $q24ck = isset($this->dataSubmitted[$v_7yw->column()]) ? $this->dataSubmitted[$v_7yw->column()] : null; goto VBBYp; VBBYp: $q24ck = $v_7yw->prepareInput($q24ck, $this->dataSubmitted); goto icebb; tgejp: $this->dataAdding[$v_7yw->column()] = $q24ck; goto BquTc; icebb: $q24ck = $v_7yw->serializeValue($q24ck, $v_7yw); goto Q0tuu; dtd2R: if ($v_7yw->isLayoutField() || $v_7yw->isCustomField()) { continue; } goto RzTPS; BquTc: } goto vVDri; zuJXF: $this->removeReservedFields(); goto X2Vdr; qYd7n: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto ZYjDK; Lmihz: $this->dataAdding = array(); goto zuJXF; UexON: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto Ve17t; jvija: foreach ($this->addableFields() as $v_7yw) { if ($v_7yw->hookValueSaved()) { call_user_func($v_7yw->hookValueSaved(), $a8lJE, $v_7yw); } } goto qYd7n; Ve17t: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto Lmihz; RmlK9: } catch (BizException $TIJlS) { return $this->convertBizExceptionToResponse($TIJlS); } catch (ResultException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } goto F86RY; jLPnD: $this->mode(FormMode::ADD); goto l5pad; l5pad: $this->build(); goto pxHww; Gt8b7: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto jLPnD; F86RY: } public function edit($a8lJE) { try { goto rAVRT; hLGuC: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto HrsBb; rAVRT: $this->mode(FormMode::EDIT); goto GtF8c; x0wcO: $this->item($this->repository()->editing($this)); goto hLGuC; Ip3yC: $this->fillFields(); goto nMcTJ; GtF8c: $this->itemId($a8lJE); goto x0wcO; nMcTJ: return $this; goto YSn3m; HrsBb: $this->build(); goto Ip3yC; YSn3m: } catch (BizException $TIJlS) { return Response::sendError($TIJlS->getMessage()); } } public function editRequest($a8lJE, array $Q7kxa = null) { goto KL6va; KL6va: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto cv8eH; cv8eH: $this->dataSubmitted = $Q7kxa ? $Q7kxa : Input::all(); goto uZcyu; uZcyu: try { goto teJi1; z_7ns: $yhST6 = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto RaNuT; iTN80: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto ScOUJ; lsfmT: $this->dataEditing = array(); goto uh6vM; ScOUJ: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto lsfmT; uh6vM: $this->removeReservedFields(); goto z_7ns; N16os: return Response::jsonSuccess(L('Edit Success')); goto GdCVS; RaNuT: if ('itemCellEdit' == $yhST6) { goto EeBig; kuhhO: if ($ciwv1) { foreach ($this->editableFields() as $v_7yw) { if ($v_7yw->isLayoutField() || $v_7yw->isCustomField()) { continue; } if ($v_7yw->column() == $ciwv1) { goto ixjh1; psEXW: $q24ck = $v_7yw->serializeValue($q24ck, $v_7yw); goto c9w0I; ZaC3h: break; goto Ch8G8; EAHG4: $this->dataEditing[$v_7yw->column()] = $q24ck; goto ZaC3h; c9w0I: if ($v_7yw->hookValueSerialize()) { $q24ck = call_user_func($v_7yw->hookValueSerialize(), $q24ck, $v_7yw); } goto EAHG4; ixjh1: $q24ck = $v_7yw->prepareInput($q24ck, $this->dataSubmitted); goto psEXW; Ch8G8: } } } goto DggY9; EeBig: $ciwv1 = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto TV4i6; TV4i6: $q24ck = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto kuhhO; DggY9: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto ZF27i; ZF27i: } else { foreach ($this->editableFields() as $v_7yw) { goto f1EfC; mpAop: $q24ck = isset($this->dataSubmitted[$v_7yw->column()]) ? $this->dataSubmitted[$v_7yw->column()] : null; goto SPjvH; WQJMM: $q24ck = $v_7yw->serializeValue($q24ck, $v_7yw); goto p1ubg; mm3ed: $this->dataEditing[$v_7yw->column()] = $q24ck; goto BhL7A; f1EfC: if ($v_7yw->isLayoutField() || $v_7yw->isCustomField()) { continue; } goto mpAop; SPjvH: $q24ck = $v_7yw->prepareInput($q24ck, $this->dataSubmitted); goto WQJMM; p1ubg: if ($v_7yw->hookValueSerialize()) { $q24ck = call_user_func($v_7yw->hookValueSerialize(), $q24ck, $v_7yw); } goto mm3ed; BhL7A: } } goto rQGIz; teJi1: $this->edit($a8lJE); goto iTN80; rQGIz: $this->repository()->edit($this); goto ADrDj; ADrDj: if ('itemCellEdit' == $yhST6) { foreach ($this->editableFields() as $v_7yw) { if ($v_7yw->column() == $ciwv1 && $v_7yw->hookValueSaved()) { call_user_func($v_7yw->hookValueSaved(), $this->itemId(), $v_7yw); } } } else { foreach ($this->editableFields() as $v_7yw) { if ($v_7yw->hookValueSaved()) { call_user_func($v_7yw->hookValueSaved(), $this->itemId(), $v_7yw); } } } goto wwO1A; wwO1A: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto N16os; GdCVS: } catch (BizException $TIJlS) { return $this->convertBizExceptionToResponse($TIJlS); } catch (ResultException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } goto zohzq; zohzq: } public function deleteRequest($qdV42) { goto CiUC1; CiUC1: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto yzujr; yzujr: $this->mode(FormMode::DELETE); goto U107n; U107n: $this->itemId($qdV42); goto Hr6tM; iX9et: try { goto AfmAB; AfmAB: $Q7kxa = $this->repository->deleting($this); goto YEAL2; jqXl7: $this->itemId(collect($Q7kxa)->map(function ($xAbXc) { return $xAbXc->{$this->repository()->getKeyName()}; })->toArray()); goto c27ii; fuKWq: return Response::jsonSuccess(L('Delete Success')); goto rRlBI; c27ii: $vRrRP = $this->repository->delete($this, $Q7kxa); goto fuKWq; YEAL2: $this->item($Q7kxa); goto jqXl7; rRlBI: } catch (BizException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } catch (ResultException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } goto sqjLb; Hr6tM: $this->build(); goto iX9et; sqjLb: } public function sortRequest($qdV42) { goto tq73b; VuLti: $this->itemId($qdV42); goto ebSxn; ebSxn: $cdcZ5 = InputPackage::buildFromInput(); goto Ct3vw; iysF9: $this->mode(FormMode::SORT); goto VuLti; eISAb: $this->build(); goto JO70_; tq73b: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto iysF9; JO70_: try { goto aTtgy; GM8V5: return Response::jsonSuccess(L('Operate Success')); goto sKlGj; aTtgy: $vRrRP = $this->repository->sortEdit($this); goto IiFWB; IiFWB: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto GM8V5; sKlGj: } catch (BizException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } catch (ResultException $TIJlS) { return Response::jsonError($TIJlS->getMessage()); } goto ydrU4; Ct3vw: $this->repository->setArgument('direction', $cdcZ5->getType('direction', SortDirection::class)); goto eISAb; ydrU4: } public function render() { goto bJBzv; aDMQT: switch ($this->mode) { case FormMode::FORM: $Q7kxa['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto tcDS7; yEoUM: $Q7kxa['fields'] = $this->addableFields(true); goto eAheA; tcDS7: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto yEoUM; eAheA: break; goto Bj70r; Bj70r: case FormMode::EDIT: goto aKf9i; RZmaI: break; goto dhvSp; US7tb: $Q7kxa['fields'] = $this->editableFields(true); goto RZmaI; aKf9i: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto US7tb; dhvSp: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto ymMFn; ymMFn: $Q7kxa = array_merge($this->fluentAttributeVariables(), $Q7kxa); goto bzvLD; bzvLD: return view($this->view, $Q7kxa)->render(); goto q47L5; bJBzv: $Q7kxa = array(); goto aDMQT; q47L5: } public function __call($Tv0zD, $mbEkU) { goto KGnX2; KGnX2: switch ($Tv0zD) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': return $this; } goto GnuJ4; vTpt8: return FieldManager::call($this, $Tv0zD, $mbEkU); goto lJraE; GnuJ4: if ($this->isFluentAttribute($Tv0zD)) { switch ($Tv0zD) { case 'item': if (isset($mbEkU[0]) && is_array($mbEkU[0])) { $mbEkU[0] = RepositoryUtil::itemFromArray($mbEkU[0]); } break; } return $this->fluentAttribute($Tv0zD, $mbEkU); } goto vTpt8; lJraE: } public function __toString() { try { return $this->render(); } catch (\Exception $TIJlS) { return $TIJlS->getMessage(); } } }