@extends('modstart::layout.frame')

@section('pageFavIco'){{\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco'))}}@endsection
@section('pageTitle')@yield('pageTitleMain','') | {{modstart_config('siteName')}}@endsection
@section('pageKeywords'){{modstart_config('siteKeywords')}}@endsection
@section('pageDescription'){{modstart_config('siteDescription')}}@endsection

@section('headAppend')
    @parent
    <link rel="stylesheet"
          href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/css/style.css')}}"/>
    @if($c=modstart_config('sitePrimaryColor'))
        <style type="text/css">
            :root{
                --theme-color-primary: {{$c}};
                --theme-color-primary-light: {{\ModStart\Core\Util\ColorUtil::adjust($c,20)}};
                --theme-color-primary-dark: {{\ModStart\Core\Util\ColorUtil::adjust($c,-20)}};
            }
        </style>
    @endif
    {!! \ModStart\Core\Hook\ModStartHook::fireInView('PageHeadAppend',$this); !!}
@endsection

@section('bodyAppend')
    @parent
    {!! \ModStart\Core\Hook\ModStartHook::fireInView('PageBodyAppend',$this); !!}
@endsection

@section('body')

    @include('theme.default.pc.share.header')

    @section('bodyContent')
    @show

    @include('theme.default.pc.share.footer')

    @if(\ModStart\Core\Util\AgentUtil::isMobile())
        <div class="ub-nav-mobile-foot-spacer"></div>
        <div class="ub-nav-mobile-foot">
            <a class="item {{modstart_baseurl_active('')}}" href="{{modstart_web_url('')}}">
                <div class="icon"><i class="img iconfont icon-home"></i></div>
                <div class="title">首页</div>
            </a>
            <a class="item {{modstart_baseurl_active('credit_shop/goods*')}}"
               href="{{modstart_web_url('credit_shop/goods')}}">
                <div class="icon"><i class="img iconfont icon-category"></i></div>
                <div class="title">商品</div>
            </a>
            <a class="item {{modstart_baseurl_active('credit_shop/cart')}}" href="{{modstart_web_url('credit_shop/cart')}}">
                <div class="icon"><i class="img iconfont icon-cart"></i></div>
                <div class="title">购物车</div>
                <?php $count = \Module\CreditShop\Util\CartUtil::getUserCartCount(\Module\Member\Auth\MemberUser::id()); ?>
                <div class="badge @if(!$count) tw-hidden @endif" data-shop-cart-count>{{$count}}</div>
            </a>
            <a class="item {{modstart_baseurl_active('member/*')}}" href="{{modstart_web_url('member')}}">
                <div class="icon"><i class="img iconfont icon-user"></i></div>
                <div class="title">我的</div>
            </a>
        </div>
    @endif

@endsection
