<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($Wa6dC) { return ModelUtil::get('member_user', array('id' => $Wa6dC)); } public static function getCached($Wa6dC) { return Cache::remember('MemberUser:' . $Wa6dC, 60, function () use($Wa6dC) { return self::get($Wa6dC); }); } public static function processDefault(&$UEMJp) { goto UhYXc; G20mJ: if (empty($UEMJp['avatarMedium'])) { $UEMJp['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto aedr8; r0dfN: if (empty($UEMJp['nickname'])) { $UEMJp['nickname'] = $UEMJp['username']; } goto yi2Du; yi2Du: if (empty($UEMJp['avatar'])) { $UEMJp['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto G20mJ; aedr8: if (empty($UEMJp['avatarBig'])) { $UEMJp['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto nJ7f2; UhYXc: if (empty($UEMJp)) { return; } goto r0dfN; nJ7f2: } private static function processBasicFields($s8eWv) { goto lV51D; uKL4t: return $s8eWv; goto QCocw; BfRRh: if (null === $s8eWv) { $s8eWv = $Elmcl; } else { goto FVJNm; skM1r: $s8eWv = $NpPUJ; goto n_fkD; dZ2X1: foreach ($s8eWv as $sSfNd) { if ('<basic>' == $sSfNd) { $NpPUJ = array_merge($NpPUJ, $Elmcl); } else { $NpPUJ[] = $sSfNd; } } goto skM1r; FVJNm: $NpPUJ = array(); goto dZ2X1; n_fkD: } goto uKL4t; lV51D: $Elmcl = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto BfRRh; QCocw: } public static function fixAvatar($IlYOu) { return AssetsUtil::fixFullOrDefault($IlYOu, 'asset/image/avatar.svg'); } public static function getBasic($Wa6dC, $s8eWv = null) { goto A5jOq; P4s1p: if (empty($a6udn)) { return null; } goto ZvLVl; kZSic: $a6udn['avatar'] = self::fixAvatar($a6udn['avatar']); goto WJSBj; FjphH: foreach ($s8eWv as $UySWC) { if (isset($a6udn[$UySWC])) { $P0SDd[$UySWC] = $a6udn[$UySWC]; } else { $P0SDd[$UySWC] = null; } } goto jbjSm; swrjP: $a6udn = self::get($Wa6dC); goto P4s1p; WJSBj: $P0SDd = array(); goto FjphH; A5jOq: $s8eWv = self::processBasicFields($s8eWv); goto swrjP; ZvLVl: if (empty($a6udn['nickname'])) { $a6udn['nickname'] = $a6udn['username']; } goto kZSic; jbjSm: return $P0SDd; goto ui4qm; ui4qm: } public static function listViewName($VmVlK) { goto k_8Pu; k_8Pu: $RcNsa = array(); goto C6sqN; m4KxY: foreach ($Yk0lg as $UEMJp) { $RcNsa[] = self::viewName($UEMJp); } goto gdPuW; gdPuW: return $RcNsa; goto giZlI; C6sqN: $Yk0lg = ModelUtil::allIn('member_user', 'id', $VmVlK); goto m4KxY; giZlI: } public static function listUsers($VmVlK) { return ModelUtil::allIn('member_user', 'id', $VmVlK); } public static function convertOneToBasic($UEMJp) { return array('id' => $UEMJp['id'], 'username' => $UEMJp['username'], 'nickname' => empty($UEMJp['nickname']) ? $UEMJp['username'] : $UEMJp['nickname'], 'created_at' => $UEMJp['created_at'], 'signature' => isset($UEMJp['signature']) ? $UEMJp['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($UEMJp['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($Yk0lg) { return array_map(function ($a6udn) { return array('id' => $a6udn['id'], 'username' => $a6udn['username'], 'nickname' => empty($a6udn['nickname']) ? $a6udn['username'] : $a6udn['nickname'], 'created_at' => $a6udn['created_at'], 'signature' => isset($a6udn['signature']) ? $a6udn['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($a6udn['avatar'], 'asset/image/avatar.svg')); }, $Yk0lg); } public static function listUsersBasic($VmVlK) { return self::convertToBasic(self::listUsers($VmVlK)); } public static function getViewName($Wa6dC) { return self::viewName(self::get($Wa6dC)); } public static function viewName($UEMJp) { goto wlQH3; nyatS: if (!empty($UEMJp['nickname'])) { return $UEMJp['nickname']; } goto m06x3; wlQH3: if ($UEMJp && is_numeric($UEMJp)) { return self::getViewName($UEMJp); } goto QaQsW; PnDN3: return "ID-{$UEMJp['id']}"; goto wFxHU; m06x3: if (!empty($UEMJp['username'])) { return $UEMJp['username']; } goto PnDN3; QaQsW: if (empty($UEMJp)) { return '-'; } goto nyatS; wFxHU: } public static function update($Wa6dC, $EXOSv) { return ModelUtil::update('member_user', array('id' => $Wa6dC), $EXOSv); } public static function updateBasicWithUniqueCheck($Wa6dC, $EXOSv) { goto WVS_0; WVS_0: if (empty($EXOSv)) { return Response::generate(0, 'ok'); } goto DnOtt; Nb264: return Response::generate(0, 'ok'); goto cg6uB; Byijk: self::update($Wa6dC, $EXOSv); goto Nb264; DnOtt: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $puq_G => $NzxMm) { if (isset($EXOSv[$puq_G])) { goto IKGVD; wBr1A: if (count($VSWD2) > 1) { return Response::generate(-1, $NzxMm . '重复'); } goto TA0KP; hawcN: $VSWD2 = ModelUtil::all('member_user', array($puq_G => $EXOSv[$puq_G])); goto wBr1A; IKGVD: if (empty($EXOSv[$puq_G])) { $EXOSv[$puq_G] = null; continue; } goto hawcN; TA0KP: if (count($VSWD2) == 1) { if ($VSWD2[0]['id'] != $Wa6dC) { return Response::generate(-1, $NzxMm . '重复'); } } goto wH3aC; wH3aC: } } goto Byijk; cg6uB: } public static function login($UMt86 = '', $gqRDd = '', $kTwUc = '', $aQTzY = '') { goto aKci0; spOxT: $gqRDd = trim($gqRDd); goto sFCcr; aKci0: $kTwUc = trim($kTwUc); goto spOxT; GcC3U: MemberUserLoginAttemptEvent::fire($UEMJp['id'], Request::ip(), AgentUtil::getUserAgent()); goto jHnWm; T1tbO: $UEMJp = ModelUtil::get('member_user', $mwycd); goto LKasg; jHnWm: if ($UEMJp['password'] != EncodeUtil::md5WithSalt($aQTzY, $UEMJp['passwordSalt'])) { MemberUserLoginFailedEvent::fire($UEMJp['id'], $UEMJp['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto SewZT; sFCcr: $UMt86 = trim($UMt86); goto e2Mwg; LKasg: if (empty($UEMJp)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto GcC3U; YTHIK: if ($kTwUc) { if (!FormatUtil::isEmail($kTwUc)) { return Response::generate(-3, '邮箱格式不正确'); } $mwycd = array('email' => $kTwUc); } else { if ($gqRDd) { if (!preg_match('/(^1[0-9]{10}$)/', $gqRDd)) { return Response::generate(-4, '手机格式不正确'); } $mwycd = array('phone' => $gqRDd); } else { if ($UMt86) { if (strpos($UMt86, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $mwycd = array('username' => $UMt86); } } } goto T1tbO; PKWKm: return Response::generateSuccessData($UEMJp); goto KD6vs; SewZT: switch ($UEMJp['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto PKWKm; yZfEl: if (!$aQTzY) { return Response::generate(-2, '密码为空'); } goto YTHIK; e2Mwg: if (!($kTwUc || $gqRDd || $UMt86)) { return Response::generate(-1, '所有登录字段均为空'); } goto yZfEl; KD6vs: } public static function autoSetUsernameNickname($qhywZ, $xyapV) { goto z3MYQ; eisQE: if (preg_match('/\\{.*\\}/', $xyapV)) { goto VGa66; ddeeX: $NVJ2c = 0; goto tGlIN; O5C67: $sg8RX = array('{Phone}' => $UEMJp['phone'], '{Phone4}' => substr($UEMJp['phone'], 7), '{Uid}' => $UEMJp['id']); goto BaLNa; BaLNa: $xyapV = str_replace(array_keys($sg8RX), array_values($sg8RX), $xyapV); goto ddeeX; VGa66: $UEMJp = self::get($qhywZ); goto O5C67; tGlIN: } goto DqmUl; DqmUl: self::suggestUsernameNickname($qhywZ, $xyapV, $NVJ2c); goto l1Eoz; z3MYQ: $NVJ2c = 6; goto eisQE; l1Eoz: } public static function getSuggestUsernameNickname($BqXGK) { goto PqxBz; PqxBz: $xyapV = $BqXGK . Str::random(1); goto TUhuw; sYolz: return $xyapV . Str::random(10); goto yxNY_; TUhuw: for ($j2HkI = 0; $j2HkI < 20; $j2HkI++) { $HfROZ = ModelUtil::model('member_user')->where(array('username' => $xyapV))->orWhere(array('nickname' => $xyapV))->first(); if (empty($HfROZ)) { return $xyapV; } $xyapV = $xyapV . Str::random(1); } goto sYolz; yxNY_: } private static function suggestUsernameNickname($qhywZ, $z6dqX = '用户', $NVJ2c = 6) { goto fVq6w; ierX4: ModelUtil::update('member_user', $qhywZ, array('username' => $xyapV, 'nickname' => $xyapV)); goto bOz64; TQgJr: for ($j2HkI = 0; $j2HkI < 20; $j2HkI++) { $HfROZ = ModelUtil::model('member_user')->where(array('username' => $xyapV))->orWhere(array('nickname' => $xyapV))->first(); if (empty($HfROZ)) { break; } $xyapV = $xyapV . Str::random(1); } goto ierX4; fVq6w: if ($NVJ2c > 0) { $xyapV = $z6dqX . RandomUtil::string($NVJ2c); } else { $xyapV = $z6dqX; } goto TQgJr; bOz64: } public static function registerId($Wa6dC, $EXOSv = array()) { $UEMJp = ModelUtil::insert('member_user', array_merge(array('id' => $Wa6dC, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $EXOSv)); return Response::generate(0, 'ok', $UEMJp); } public static function registerUsername($UMt86) { return self::register($UMt86, '', '', '', true); } public static function registerUsernameQuick($UMt86) { goto fSdRJ; T3Lur: return Response::generateError('注册失败'); goto eBrT1; fSdRJ: $QSR9X = $UMt86; goto zOFtT; zOFtT: for ($j2HkI = 0; $j2HkI < 10; $j2HkI++) { $iezr4 = self::register($QSR9X, '', '', '', true); if ($iezr4['code']) { $QSR9X = $QSR9X . Str::random(1); } else { return $iezr4; } } goto T3Lur; eBrT1: } public static function register($UMt86 = '', $gqRDd = '', $kTwUc = '', $aQTzY = '', $cIFjp = false) { goto i6nAL; C6Xhp: if ($UMt86) { goto Bfu6x; JVzmh: if (strlen($UMt86) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto F1GqO; EpNKC: if (preg_match('/^[0-9]{11}$/', $UMt86)) { return Response::generate(-1, '用户名不能为纯数字'); } goto F8xY9; D2AXn: if ($iezr4['code']) { return $iezr4; } goto JVzmh; Bfu6x: $iezr4 = self::uniqueCheck('username', $UMt86); goto D2AXn; F1GqO: if (Str::contains($UMt86, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto EpNKC; F8xY9: } else { $UMt86 = null; } goto ljRMV; aw38d: return Response::generate(0, 'ok', $UEMJp); goto RViLc; lb5WA: if ($gqRDd) { $iezr4 = self::uniqueCheck('phone', $gqRDd); if ($iezr4['code']) { return $iezr4; } } else { $gqRDd = null; } goto C6Xhp; i6nAL: $kTwUc = trim($kTwUc); goto sgmpV; ljRMV: if (!$cIFjp) { if (empty($aQTzY) || strlen($aQTzY) < 6) { return Response::generate(-3, '密码不合法'); } } goto EX6in; EX6in: $oqTrZ = Str::random(16); goto w2m5y; R2Wgg: if (!($kTwUc || $gqRDd || $UMt86)) { return Response::generate(-1, '所有注册字段均为空'); } goto UorBi; w2m5y: $UEMJp = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $UMt86, 'email' => $kTwUc, 'phone' => $gqRDd, 'password' => $cIFjp ? null : EncodeUtil::md5WithSalt($aQTzY, $oqTrZ), 'passwordSalt' => $cIFjp ? null : $oqTrZ, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto aw38d; xPfmC: $UMt86 = trim($UMt86); goto R2Wgg; UorBi: if ($kTwUc) { $iezr4 = self::uniqueCheck('email', $kTwUc); if ($iezr4['code']) { return $iezr4; } } else { $kTwUc = null; } goto lb5WA; sgmpV: $gqRDd = trim($gqRDd); goto xPfmC; RViLc: } public static function uniqueCheck($wIjq3, $JXs6j, $Lg30u = 0) { goto X5BJj; X5BJj: $JXs6j = trim($JXs6j); goto HYngn; iyR3c: if (empty($UEMJp)) { return Response::generate(0, 'ok'); } goto eQCKN; dwZ2G: $UEMJp = ModelUtil::get('member_user', array($wIjq3 => $JXs6j)); goto iyR3c; CB6jF: if ($Lg30u == $UEMJp['id']) { return Response::generate(0, 'ok'); } goto iRUY0; eQCKN: $tkaNd = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto CB6jF; iRUY0: return Response::generate(-2, $tkaNd[$wIjq3] . '已经被占用'); goto FcYs8; HYngn: switch ($wIjq3) { case 'email': if (!FormatUtil::isEmail($JXs6j)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $JXs6j)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($JXs6j, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $wIjq3); } goto dwZ2G; FcYs8: } public static function getByUsername($UMt86) { return ModelUtil::get('member_user', array('username' => $UMt86)); } public static function getByEmail($kTwUc) { return ModelUtil::get('member_user', array('email' => $kTwUc)); } public static function getByPhone($gqRDd) { return ModelUtil::get('member_user', array('phone' => $gqRDd)); } public static function changeNickname($qhywZ, $q4XFI) { goto oXppP; oXppP: $iezr4 = self::uniqueCheck('nickname', $q4XFI, $qhywZ); goto IsDjF; rmHPE: return Response::generate(0, 'ok'); goto a0DIb; IsDjF: if (Response::isError($iezr4)) { return $iezr4; } goto S7z6w; S7z6w: ModelUtil::update('member_user', $qhywZ, array('nickname' => $q4XFI)); goto rmHPE; a0DIb: } public static function changePassword($qhywZ, $qxkRV, $M0f2C = null, $gzF1_ = false) { goto ckbUI; Iu5NK: $oqTrZ = Str::random(16); goto Eq_SO; ckbUI: if (!$gzF1_ && empty($M0f2C)) { return Response::generate(-1, '旧密码不能为空'); } goto bVMCf; Eq_SO: ModelUtil::update('member_user', array('id' => $UEMJp['id']), array('passwordSalt' => $oqTrZ, 'password' => EncodeUtil::md5WithSalt($qxkRV, $oqTrZ))); goto lS524; bVMCf: $UEMJp = ModelUtil::get('member_user', array('id' => $qhywZ)); goto J2mTd; lS524: return Response::generate(0, 'ok'); goto Y2JAL; J5UAp: if (empty($qxkRV)) { return Response::generate(-1, '新密码为空'); } goto p4mWJ; J2mTd: if (empty($UEMJp)) { return Response::generate(-1, '用户不存在'); } goto J5UAp; p4mWJ: if (!$gzF1_ && EncodeUtil::md5WithSalt($M0f2C, $UEMJp['passwordSalt']) != $UEMJp['password']) { return Response::generate(-1, '旧密码不正确'); } goto Iu5NK; Y2JAL: } public static function setAvatar($hWPt7, $n_Nnr, $HB_hM = 'jpg') { goto MC3Ln; Wfg8T: if ($iezr4['code']) { goto JgQpn; oMzF4: DataManager::deleteById($dOfqw['data']['id']); goto timHN; JgQpn: DataManager::deleteById($DNwe8['data']['id']); goto oMzF4; timHN: if ($DNwe8['code']) { return Response::generate(-1, '头像存储失败（' . $iezr4['msg'] . '）'); } goto bu0Mj; bu0Mj: } goto MCgIC; qe7Fn: $AGpj1 = (string) Image::make($n_Nnr)->resize(200, 200)->encode($HB_hM, 75); goto GX26i; QVJka: $ilMYR = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto RKGi7; MQgLd: if (empty($UEMJp)) { return Response::generate(-1, '用户不存在'); } goto ERIzU; ERIzU: if (empty($n_Nnr)) { return Response::generate(-1, '图片数据为空'); } goto IPA2M; YLpca: $iezr4 = DataManager::upload('image', 'U_' . $hWPt7 . '_Avatar.' . $HB_hM, $UE2B7, null, $ilMYR); goto Wfg8T; o_sUE: if ($dOfqw['code']) { DataManager::deleteById($DNwe8['data']['id']); if ($DNwe8['code']) { return Response::generate(-1, '头像存储失败（' . $dOfqw['msg'] . '）'); } } goto YLpca; MCgIC: self::update($UEMJp['id'], array('avatarBig' => $DNwe8['data']['fullPath'], 'avatarMedium' => $dOfqw['data']['fullPath'], 'avatar' => $iezr4['data']['fullPath'])); goto RbMEp; RKGi7: $DNwe8 = DataManager::upload('image', 'U' . $hWPt7 . '_AvatarBig.' . $HB_hM, $tFX7y, null, $ilMYR); goto gDB3k; GX26i: $UE2B7 = (string) Image::make($n_Nnr)->resize(50, 50)->encode($HB_hM, 75); goto QVJka; PgNBJ: $dOfqw = DataManager::upload('image', 'U' . $hWPt7 . '_AvatarMiddle.' . $HB_hM, $AGpj1, null, $ilMYR); goto o_sUE; JYfUv: $UEMJp = self::get($hWPt7); goto MQgLd; RbMEp: return Response::generateSuccess(); goto yYwpc; MC3Ln: if (!in_array($HB_hM, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto JYfUv; gDB3k: if ($DNwe8['code']) { return Response::generate(-1, '头像存储失败（' . $DNwe8['msg'] . '）'); } goto PgNBJ; IPA2M: $tFX7y = (string) Image::make($n_Nnr)->resize(400, 400)->encode($HB_hM, 75); goto qe7Fn; yYwpc: } public static function findUsers($t3j_L) { goto gLqFt; GFrck: $Yk0lg = ModelUtil::model('member_user')->whereIn('id', $t3j_L)->get(); goto LeTVb; SH0d6: $gpMWG = array(); goto GFrck; Yb5Ec: return $gpMWG; goto kFrOz; LeTVb: foreach ($Yk0lg as &$bdQYC) { $gpMWG[$bdQYC->id] = $bdQYC->toArray(); } goto Yb5Ec; gLqFt: if (empty($t3j_L)) { return array(); } goto SH0d6; kFrOz: } public static function filterUserIds($t3j_L) { goto WXGA9; WXGA9: if (empty($t3j_L)) { return array(); } goto gHJqW; gHJqW: $sg8RX = array(); goto d_gxa; lHX1z: return array_keys($sg8RX); goto rqdVF; E9iKx: foreach ($Yk0lg as &$bdQYC) { $sg8RX[$bdQYC->id] = true; } goto lHX1z; d_gxa: $Yk0lg = ModelUtil::model('member_user')->whereIn('id', $t3j_L)->get(array('id')); goto E9iKx; rqdVF: } public static function mergeMemberUsers(&$a203a, $s0v17 = 'memberUserId', $Feosz = '_memberUser') { ModelUtil::join($a203a, $s0v17, $Feosz, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$a203a, $s0v17 = 'memberUserId', $Feosz = '_memberUser', $s8eWv = null) { $s8eWv = self::processBasicFields($s8eWv); if (is_array($a203a)) { ModelUtil::join($a203a, $s0v17, $Feosz, 'member_user', 'id'); foreach ($a203a as $sSfNd => $BZfyx) { goto LJEz3; lStuO: $a203a[$sSfNd][$Feosz] = $UEMJp; goto uAgxi; exj28: $UEMJp = ArrayUtil::keepKeys($BZfyx[$Feosz], $s8eWv); goto qENp8; LJEz3: if (empty($BZfyx[$Feosz])) { continue; } goto exj28; IK3yY: if (empty($UEMJp['avatar'])) { $UEMJp['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $UEMJp['avatar'] = AssetsUtil::fixFull($UEMJp['avatar']); } goto lStuO; qENp8: if (empty($UEMJp['nickname'])) { $UEMJp['nickname'] = $UEMJp['username']; } goto IK3yY; uAgxi: } } else { ModelUtil::joinItems($a203a, $s0v17, $Feosz, 'member_user', 'id'); foreach ($a203a as $a6udn) { goto UrKlb; gYE7p: $UEMJp = ArrayUtil::keepKeys($a6udn->{$Feosz}, $s8eWv); goto K7Jqv; UrKlb: if (empty($a6udn->{$Feosz})) { continue; } goto gYE7p; K7Jqv: if (empty($UEMJp['nickname'])) { $UEMJp['nickname'] = $UEMJp['username']; } goto VP74m; VP74m: if (empty($UEMJp['avatar'])) { $UEMJp['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $UEMJp['avatar'] = AssetsUtil::fixFull($UEMJp['avatar']); } goto RH97h; RH97h: $a6udn->{$Feosz} = $UEMJp; goto Qv9m9; Qv9m9: } } } public static function insert($EXOSv) { return ModelUtil::insert('member_user', $EXOSv); } public static function getIdByOauth($bP8kA, $z7CxK) { goto bxEKY; SxeDl: if (empty($JH0bA)) { return 0; } goto hCCG5; hCCG5: return intval($JH0bA['memberUserId']); goto QqT86; bxEKY: $JH0bA = ModelUtil::get('member_oauth', array('type' => $bP8kA, 'openId' => $z7CxK)); goto SxeDl; QqT86: } public static function getIdByOauthAndCheck($bP8kA, $z7CxK) { goto JByaH; DfquK: if (self::get($qhywZ)) { return $qhywZ; } goto keF7P; VZBZ8: return 0; goto doMXM; keF7P: MemberUtil::forgetOauth($bP8kA, $z7CxK); goto VZBZ8; JByaH: $qhywZ = self::getIdByOauth($bP8kA, $z7CxK); goto DfquK; doMXM: } public static function getOauthOpenId($qhywZ, $bP8kA) { goto QZRsM; SiDQt: $JH0bA = ModelUtil::get('member_oauth', $mwycd); goto sjFGk; QZRsM: $mwycd = array('memberUserId' => $qhywZ, 'type' => $bP8kA); goto SiDQt; ZOPO6: return $JH0bA['openId']; goto DR9ea; sjFGk: if (empty($JH0bA)) { return null; } goto ZOPO6; DR9ea: } public static function getOauth($qhywZ, $bP8kA) { $mwycd = array('memberUserId' => $qhywZ, 'type' => $bP8kA); return ModelUtil::get('member_oauth', $mwycd); } public static function listOauths($qhywZ) { return ModelUtil::all('member_oauth', array('memberUserId' => $qhywZ), array('*'), array('type', 'asc')); } public static function putOauth($qhywZ, $bP8kA, $z7CxK, $HyAj7 = array()) { goto YWAkO; d7yco: LockUtil::release($PLVIF); goto lALiw; pOKTS: $PLVIF = "MemberOauth:{$qhywZ}"; goto ejBW5; ejBW5: if (!LockUtil::acquire($PLVIF)) { BizException::throws('正在处理中，请稍后再试'); } goto gKVj6; zWZdX: $t0YJy = array_merge(array('openId' => $z7CxK), $HyAj7); goto GNQeF; gKVj6: $JH0bA = ModelUtil::get('member_oauth', $mwycd); goto zWZdX; YWAkO: $mwycd = array('memberUserId' => $qhywZ, 'type' => $bP8kA); goto pOKTS; GNQeF: if (empty($JH0bA)) { ModelUtil::delete('member_oauth', array('type' => $bP8kA, 'openId' => $z7CxK)); ModelUtil::insert('member_oauth', array_merge($mwycd, $t0YJy)); } else { if ($JH0bA['openId'] != $z7CxK) { ModelUtil::update('member_oauth', $JH0bA['id'], $t0YJy); } } goto d7yco; lALiw: } public static function forgetOauth($bP8kA, $z7CxK) { ModelUtil::delete('member_oauth', array('type' => $bP8kA, 'openId' => $z7CxK)); } public static function updateNewMessageStatus($qhywZ) { ModelUtil::update('member_user', array('id' => $qhywZ), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $qhywZ, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($qhywZ) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $qhywZ), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $qhywZ)))); } } public static function paginate($Jpimu, $hY9Ev, $VL2vM = array()) { return ModelUtil::paginate('member_user', $Jpimu, $hY9Ev, $VL2vM); } public static function updateStatus($e9IBw, $LyYEA) { goto a1cHI; a1cHI: if (!is_array($e9IBw)) { $e9IBw = array($e9IBw); } goto G7tSr; G7tSr: if (empty($e9IBw)) { return; } goto Z713a; Z713a: ModelUtil::model('member_user')->whereIn('id', $e9IBw)->update(array('status' => $LyYEA)); goto QyVcQ; QyVcQ: } public static function delete($qhywZ) { goto eXQCp; eXQCp: $UEMJp = self::get($qhywZ); goto cf0HX; cf0HX: BizException::throwsIfEmpty('用户不存在', $UEMJp); goto ky51L; tMkfR: $Yzv0l['oauth'] = ArrayUtil::keepItemsKeys($gi3gp, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto LG5LX; l14Mu: $Yzv0l = array(); goto Sgr0v; Sah0E: ModelUtil::transactionCommit(); goto R_LuR; Sgr0v: $gi3gp = ModelUtil::all('member_oauth', array('memberUserId' => $UEMJp['id'])); goto tMkfR; LG5LX: ModelUtil::insert('member_deleted', array('id' => $UEMJp['id'], 'username' => $UEMJp['username'], 'phone' => $UEMJp['phone'], 'email' => $UEMJp['email'], 'content' => json_encode($Yzv0l, JSON_UNESCAPED_UNICODE))); goto ANuOS; ky51L: ModelUtil::transactionBegin(); goto l14Mu; ANuOS: ModelUtil::update('member_user', $qhywZ, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto Sah0E; R_LuR: } public static function fireLogin($qhywZ) { goto Z08j1; RBf0Y: ModelUtil::insert('member_login_log', array('memberUserId' => $qhywZ, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($d_4QJ, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto Nqp2Y; xd6uT: ModelUtil::update('member_user', $qhywZ, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($d_4QJ, 20))); goto RBf0Y; Z08j1: $d_4QJ = Request::ip(); goto xd6uT; Nqp2Y: } }