<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $wU9fK) { $wU9fK->init('member_user')->field(function ($wU9fK) { $wU9fK->id('id', 'ID'); MemberAdminList::callGridField($wU9fK); $wU9fK->display('avatar', '头像')->hookRendering(function (AbstractField $puq_G, $a6udn, $Lokw6) { $i5qNh = AssetsUtil::fixOrDefault($a6udn->avatar, 'asset/image/avatar.svg'); $ynQlT = AssetsUtil::fixOrDefault($a6udn->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$ynQlT}' class='tw-inline-block' data-image-preview>\n                        <img src='{$i5qNh}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $wU9fK->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $puq_G, $a6udn, $Lokw6) { switch ($puq_G->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($a6udn->username), modstart_admin_url('member/show', array('_id' => $a6udn->id)))->width('90%')->height('90%')->render()); break; } }); $wU9fK->text('email', '邮箱'); $wU9fK->text('phone', '手机'); $wU9fK->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $wU9fK->display('_oauth', '授权')->hookRendering(function (AbstractField $puq_G, $a6udn, $Lokw6) { $JF2tR = array(); $p_a9Z = MemberUtil::listOauths($a6udn->id); foreach ($p_a9Z as $i_V1F) { goto bG2If; bG2If: $j_2db = null; goto Ilsdn; Ilsdn: $wd0Qq = $i_V1F['type']; goto QIn1k; PBAht: $JF2tR[] = '<a style="color:' . $j_2db . ';" href="javascript:;" data-tip-popover="' . $wd0Qq . '"><i class="iconfont icon-dot"></i></a>'; goto vPG2k; QwB6h: if (empty($j_2db)) { $j_2db = ColorUtil::pick($i_V1F['type']); } goto PBAht; QIn1k: $MRmGm = MemberOauth::getByOauthKey($i_V1F['type']); goto Qrbsc; Qrbsc: if ($MRmGm) { $j_2db = $MRmGm->color(); $wd0Qq = $MRmGm->title(); } goto QwB6h; vPG2k: } return join('', $JF2tR); }); } $wU9fK->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $IDaIy = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($IDaIy) { $wU9fK->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $qtwAJ = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($qtwAJ) { $wU9fK->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $wU9fK->date('vipExpire', 'VIP过期'); } $wU9fK->display('registerIp', '注册IP'); $wU9fK->display('created_at', '注册时间'); $wU9fK->canBatchSelect(true); $wU9fK->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $PQCuK) { $PQCuK->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $PQCuK) { $PQCuK->eq('id', L('ID')); $PQCuK->like('username', '用户名'); $PQCuK->like('email', '邮箱')->autoHide(true); $PQCuK->like('phone', '手机')->autoHide(true); $PQCuK->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $PQCuK->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $PQCuK->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $u9PCG) { $a6udn = $u9PCG->item(); $u9PCG->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $a6udn->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $Jpimu) { goto dBBvJ; dDWg5: $E5fZ1->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $E5fZ1) { $E5fZ1->text('username', '用户名'); $E5fZ1->text('phone', '手机'); $E5fZ1->text('email', '邮箱'); $E5fZ1->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto vYw8K; dBBvJ: $E5fZ1 = Form::make(''); goto dDWg5; VTNYu: return $Jpimu->pageTitle('创建用户')->body($E5fZ1)->handleForm($E5fZ1, function (Form $E5fZ1) { AdminPermission::demoCheck(); $EXOSv = $E5fZ1->dataForming(); $UMt86 = !empty($EXOSv['username']) ? $EXOSv['username'] : null; $gqRDd = !empty($EXOSv['phone']) ? $EXOSv['phone'] : null; $kTwUc = !empty($EXOSv['email']) ? $EXOSv['email'] : null; $fmrwz = ArrayUtil::keepKeys($EXOSv, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $iezr4 = MemberUtil::register($UMt86, $gqRDd, $kTwUc, $EXOSv['password']); BizException::throwsIfResponseError($iezr4); if (!empty($fmrwz)) { if (isset($fmrwz['vipExpire']) && TimeUtil::isDateEmpty($fmrwz['vipExpire'])) { $fmrwz['vipExpire'] = null; } MemberUtil::update($iezr4['data']['id'], $fmrwz); } EventUtil::fire(new MemberUserRegisteredEvent($iezr4['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto SBraX; RRgMZ: $E5fZ1->showSubmit(false)->showReset(false); goto VTNYu; vYw8K: $E5fZ1->layoutPanel('高级', function (Form $E5fZ1) { $E5fZ1->text('nickname', '昵称'); $E5fZ1->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $E5fZ1->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $E5fZ1->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $E5fZ1->date('vipExpire', 'VIP过期'); } }); goto RRgMZ; SBraX: } public function edit(AdminDialogPage $Jpimu) { goto Vlfud; zmnIb: BizException::throwsIfEmpty('用户不存在', $UEMJp); goto hmKEB; hmKEB: if (Request::isPost()) { goto s_sCH; w7o1S: $FQCvA = InputPackage::buildFromInput(); goto w1fO6; w1fO6: switch ($FQCvA->getTrimString('_action')) { case 'itemCellEdit': goto ixF4a; ixF4a: $t0YJy = array(); goto aVCU8; H1XYG: return Response::generateSuccess(); goto eG184; aVCU8: switch ($FQCvA->getTrimString('column')) { case 'status': $t0YJy['status'] = $FQCvA->getInteger('value'); break; } goto WLHPc; WLHPc: if (!empty($t0YJy)) { MemberUtil::update($UEMJp['id'], $t0YJy); } goto H1XYG; eG184: } goto TS8qc; s_sCH: AdminPermission::demoCheck(); goto w7o1S; TS8qc: } goto uSsPf; s9InY: $E5fZ1->item($UEMJp)->fillFields(); goto Wnj_0; vgCPH: return $Jpimu->pageTitle('修改信息')->body($E5fZ1)->handleForm($E5fZ1, function (Form $E5fZ1) use($UEMJp) { AdminPermission::demoCheck(); $EXOSv = $E5fZ1->dataForming(); $KfVM8 = ArrayUtil::keepKeys($EXOSv, array('username', 'phone', 'email')); $fmrwz = ArrayUtil::keepKeys($EXOSv, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $iezr4 = MemberUtil::updateBasicWithUniqueCheck($UEMJp['id'], $KfVM8); BizException::throwsIfResponseError($iezr4); if (isset($fmrwz['vipExpire']) && TimeUtil::isDateEmpty($fmrwz['vipExpire'])) { $fmrwz['vipExpire'] = null; } MemberUtil::update($UEMJp['id'], $fmrwz); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto W91vD; da0KV: $E5fZ1->layoutPanel('基础', function (Form $E5fZ1) { $E5fZ1->display('id', '用户ID')->addable(true); $E5fZ1->text('username', '用户名'); $E5fZ1->text('phone', '手机'); $E5fZ1->text('email', '邮箱'); }); goto U7W_B; Vlfud: $UEMJp = ModelUtil::get('member_user', CRUDUtil::id()); goto zmnIb; Wnj_0: $E5fZ1->showSubmit(false)->showReset(false); goto vgCPH; U7W_B: $E5fZ1->layoutPanel('高级', function (Form $E5fZ1) { $E5fZ1->text('nickname', '昵称'); $E5fZ1->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $E5fZ1->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $E5fZ1->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $E5fZ1->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto s9InY; uSsPf: $E5fZ1 = Form::make(''); goto da0KV; W91vD: } public function select(AdminDialogPage $Jpimu) { goto KwO64; EmtmC: $j_upA->disableCUD(); goto jtBE8; KwO64: $j_upA = $this->grid(); goto EmtmC; jtBE8: $j_upA->canSingleSelectItem(true); goto LslFy; bORaH: return $Jpimu->pageTitle('选择用户')->body($j_upA); goto IrjVz; LslFy: CRUDUtil::registerGridResource($j_upA, '\\' . __CLASS__); goto L8wb1; L8wb1: if (Request::isPost()) { return $j_upA->request(); } goto bORaH; IrjVz: } public function search() { goto qJrrb; da4oE: $VL2vM['whereOperate'] = array('username', 'like', "%{$XOhB3}%"); goto xhHmt; Iej16: return Response::jsonSuccessData($a203a); goto qCdAt; QjBj9: $a203a = array_map(function ($a6udn) { return array('value' => intval($a6udn['id']), 'name' => htmlspecialchars(MemberUtil::viewName($a6udn)), 'avatar' => AssetsUtil::fixOrDefault($a6udn['avatar'], 'asset/image/avatar.svg')); }, $h08Wk['records']); goto Iej16; xhHmt: $h08Wk = MemberUtil::paginate(1, 10, $VL2vM); goto QjBj9; ezoLj: $VL2vM = array(); goto da4oE; cfM39: $XOhB3 = $FQCvA->getTrimString('keywords'); goto ezoLj; qJrrb: $FQCvA = InputPackage::buildFromInput(); goto cfM39; qCdAt: } public function resetPassword(AdminConfigBuilder $wU9fK) { goto U9oaN; zuB3y: BizException::throwsIfEmpty('用户不存在', $UEMJp); goto ZaCNz; azg8G: if (Request::isPost()) { return $wU9fK->formRequest(function (Form $E5fZ1) use($UEMJp) { AdminPermission::demoCheck(); $EXOSv = $E5fZ1->dataForming(); $iezr4 = MemberUtil::changePassword($UEMJp['id'], $EXOSv['passwordNew'], null, true); BizException::throwsIfResponseError($iezr4); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto p8vwa; uGDvp: $wU9fK->pageTitle('重置密码'); goto RNzPA; ZaCNz: $wU9fK->useDialog(); goto uGDvp; RNzPA: $wU9fK->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto azg8G; U9oaN: $Wa6dC = CRUDUtil::id(); goto J_Mez; J_Mez: $UEMJp = MemberUtil::get($Wa6dC); goto zuB3y; p8vwa: return $wU9fK; goto u0MVx; u0MVx: } public function sendMessage(AdminConfigBuilder $wU9fK) { goto hgy2Q; x91o1: $UEMJp = MemberUtil::get($Wa6dC); goto ot0EB; k25ZP: $wU9fK->pageTitle('发送消息'); goto TZU06; hgy2Q: $Wa6dC = CRUDUtil::id(); goto x91o1; TkEl3: return $wU9fK; goto ERVDR; ot0EB: BizException::throwsIfEmpty('用户不存在', $UEMJp); goto tHFdS; gKFpT: if (Request::isPost()) { return $wU9fK->formRequest(function (Form $E5fZ1) use($UEMJp) { AdminPermission::demoCheck(); $EXOSv = $E5fZ1->dataForming(); $iezr4 = MemberMessageUtil::send($UEMJp['id'], $EXOSv['content']); BizException::throwsIfResponseError($iezr4); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto TkEl3; TZU06: $wU9fK->richHtml('content', '消息内容')->required(); goto gKFpT; tHFdS: $wU9fK->useDialog(); goto k25ZP; ERVDR: } public function show() { goto IzD7r; IzD7r: $Fm2q6 = MemberUtil::get(CRUDUtil::id()); goto P59K3; vccbX: return view('module::Member.View.admin.memberUser.show', array('record' => $Fm2q6, 'showPanelProviders' => $ETxL6)); goto gxeJb; P59K3: $ETxL6 = MemberAdminShowPanelProvider::listAll(); goto vccbX; gxeJb: } public function delete() { goto aRHUM; aRHUM: AdminPermission::demoCheck(); goto hk008; hk008: MemberUtil::delete(CRUDUtil::id()); goto t8qw8; t8qw8: return Response::redirect(CRUDUtil::jsGridRefresh()); goto oDIPH; oDIPH: } public function statusForbidden() { goto TqGh5; YZrJp: return Response::redirect(CRUDUtil::jsGridRefresh()); goto ai4S_; feCVQ: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto YZrJp; TqGh5: AdminPermission::demoCheck(); goto feCVQ; ai4S_: } public function export(ExportHandle $BUZHN) { $wUBpz = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $BUZHN->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($wUBpz)->handleFetch(function ($Jpimu, $hY9Ev, $LfT4s, $wIjy7) { $iDBqJ = ModelUtil::model('member_user'); $iDBqJ = $iDBqJ->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($LfT4s as $Dyu_F) { if (!empty($Dyu_F['id']['eq'])) { $iDBqJ = $iDBqJ->where('id', $Dyu_F['id']['eq']); } elseif (!empty($Dyu_F['status']['eq'])) { $iDBqJ = $iDBqJ->where('status', $Dyu_F['status']['eq']); } elseif (!empty($Dyu_F['groupId']['eq'])) { $iDBqJ = $iDBqJ->where('groupId', $Dyu_F['groupId']['eq']); } elseif (!empty($Dyu_F['vipId']['eq'])) { $iDBqJ = $iDBqJ->where('vipId', $Dyu_F['vipId']['eq']); } elseif (!empty($Dyu_F['username']['like'])) { $iDBqJ = $iDBqJ->where('username', 'like', '%' . $Dyu_F['username']['like'] . '%'); } elseif (!empty($Dyu_F['email']['like'])) { $iDBqJ = $iDBqJ->where('email', 'like', '%' . $Dyu_F['email']['like'] . '%'); } elseif (!empty($Dyu_F['phone']['like'])) { $iDBqJ = $iDBqJ->where('phone', 'like', '%' . $Dyu_F['phone']['like'] . '%'); } } $P0SDd = $iDBqJ->paginate($hY9Ev, array('*'), 'page', $Jpimu)->toArray(); $xFnhz = array(); foreach ($P0SDd['data'] as $a6udn) { goto oifmg; LqKJT: $iu6KQ[] = $a6udn['username']; goto OoBS4; fLgWs: $xFnhz[] = $iu6KQ; goto e6fGZ; oifmg: $iu6KQ = array(); goto JWvfS; Pv2Sv: $iu6KQ[] = $a6udn['signature']; goto fLgWs; i1U6h: $iu6KQ[] = $a6udn['realname']; goto Pv2Sv; Zit_g: $iu6KQ[] = $a6udn['phone']; goto kMzNl; kMzNl: $iu6KQ[] = $a6udn['created_at']; goto JSfRP; OoBS4: $iu6KQ[] = $a6udn['email']; goto Zit_g; JSfRP: $iu6KQ[] = TypeUtil::name(Gender::class, $a6udn['gender']); goto i1U6h; JWvfS: $iu6KQ[] = $a6udn['id']; goto LqKJT; e6fGZ: } return array('list' => $xFnhz, 'total' => $P0SDd['total']); })->performCommon(); } }