<div class="tw-bg-white tw-mb-2 tw-rounded-sm tw-border tw-border-solid tw-border-gray-200">
    <div class="tw-p-2 tw-flex tw-border-gray-200 tw-border-solid tw-border-0 tw-border-b">
        <div class="tw-flex-grow">
            <span class="tw-font-bold margin-right">{{\Carbon\Carbon::parse($item->created_at)->toDateString()}}</span>
            订单号：{{$item->sn}}
        </div>
        <div class="status">
            @if($item->status==\Module\Vendor\Type\OrderStatus::WAIT_PAY)
                <span class="ub-text-danger">等待付款</span>
            @elseif($item->status==\Module\Vendor\Type\OrderStatus::WAIT_SHIPPING)
                <span class="ub-text-warning">待发货</span>
            @elseif($item->status==\Module\Vendor\Type\OrderStatus::WAIT_CONFIRM)
                <span class="ub-text-warning">待确认收货</span>
            @elseif($item->status==\Module\Vendor\Type\OrderStatus::COMPLETED)
                <span class="ub-text-success">已完成</span>
            @elseif($item->status==\Module\Vendor\Type\OrderStatus::CANCEL_EXPIRED||$item->status==\Module\Vendor\Type\OrderStatus::CANCEL)
                <span class="ub-text-success">已取消</span>
            @endif
        </div>
    </div>
    <div class="tw-p-2">
        @foreach($orderGoodsList as $orderGoods)
            <div class="tw-p-2 tw-flex">
                <div class="tw-w-16 tw-flex-shrink-0">
                    <a href="{{modstart_web_url('credit_shop/goods/'.$orderGoods['goodsId'].'?snapshotId='.$orderGoods['goodsSnapshotId'])}}" class="ub-cover-1-1" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($orderGoods['_goodsSnapshot']['cover'])}})"></a>
                </div>
                <div class="tw-flex-grow tw-pl-2">
                    <a class="tw-text-gray-900" href="{{modstart_web_url('credit_shop/goods/'.$orderGoods['goodsId'].'?snapshotId='.$orderGoods['goodsSnapshotId'])}}">{{$orderGoods['_goodsSnapshot']['title']}}</a>
                    <div class="tw-text-gray-400 margin-top">
                        @if(!empty($orderGoods['_goodsSnapshot']['specSpec']))
                            @foreach($orderGoods['_goodsSnapshot']['specSpec'] as $k=>$v)
                                <span class="margin-right">
                                    {{$k}}：{{$v}}
                                </span>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="tw-w-16 tw-flex-shrink-0 tw-text-right">
                    @if($orderGoods['_goodsSnapshot']['specSpec'])
                        <div>积分{{$orderGoods['_goodsSnapshot']['specCredit']}}</div>
                    @else
                        <div>积分{{$orderGoods['_goodsSnapshot']['credit']}}</div>
                    @endif
                    <div>x{{$orderGoods['amount']}}</div>
                </div>
            </div>
        @endforeach
    </div>
    <div class="tw-p-2 tw-text-right tw-border-gray-200 tw-border-solid tw-border-0 tw-border-t">
        <div class="tw-float-left">
            支付积分：<span class="tw-font-bold ub-text-primary">{{$item->credit}}</span>积分
        </div>
        @if($item->status==\Module\Vendor\Type\OrderStatus::WAIT_CONFIRM)
            <a href="javascript:;" data-dialog-request="{{modstart_web_url('credit_shop/member_order/shipping/'.$item->id)}}" class="btn">查看物流</a>
            <a href="javascript:;" data-ajax-request-loading data-ajax-request="{{modstart_web_url('credit_shop/member_order/confirm/'.$item->id)}}" class="btn btn-primary">确认收货</a>
        @elseif($item->status==\Module\Vendor\Type\OrderStatus::COMPLETED)
            <a href="javascript:;" data-dialog-request="{{modstart_web_url('credit_shop/member_order/shipping/'.$item->id)}}" class="btn">查看物流</a>
        @endif
        <a href="{{modstart_web_url('credit_shop/member_order/detail/'.$item->id)}}" class="btn">订单详情</a>
    </div>
</div>

