@extends($_viewMemberFrame)

@section('pageTitleMain')订单详情@endsection
@section('pageKeywords')订单详情@endsection
@section('pageDescription')订单详情@endsection

@section('memberBodyContent')

    <div class="ub-panel">
        <div class="head">
            <div class="title">
                <div class="ub-breadcrumb" style="padding:0;min-height:auto;">
                    <a href="{{modstart_web_url('credit_shop/member_order')}}">我的订单</a>
                    <a class="active" href="javascript:;">订单详情</a>
                </div>
            </div>
        </div>
        <div class="body">

            @include('module::CreditShop.View.pc.creditShop.memberOrder.item',[
                'item'=>\ModStart\Repository\RepositoryUtil::itemFromArray($order),
                'orderGoodsList'=>$order['_orderGoods']
            ])




            {{--                @if($order['shippingType'])--}}
            {{--                    <div class="shipping-type">--}}
            {{--                        <div class="title"><i class="uk-icon-clock-o"></i> 发货时间</div>--}}
            {{--                        <div class="content">--}}
            {{--                            @if($order['shippingType']==ShippingType::ASAP)--}}
            {{--                                尽快发货--}}
            {{--                            @endif--}}
            {{--                            @if($order['shippingType']==ShippingType::BOOK)--}}
            {{--                                {{$order['shippingDate']}} {{$order['shippingTime']}}--}}
            {{--                            @endif--}}
            {{--                        </div>--}}
            {{--                    </div>--}}
            {{--                @endif--}}

        </div>
    </div>

    <div class="ub-panel">
        <div class="head">
            <div class="title">
                物流信息
            </div>
        </div>
        <div class="body">
            @if($order['addressName'])
                <div class="ub-pair">
                    <div class="name"><i class="iconfont icon-address"></i> 地址</div>
                    <div class="value tw-leading-6">
                        <div class="tw-font-bold">收货人：{{$order['addressName']}} {{$order['addressPhone']}}</div>
                        <div class="">地址：{{$order['addressArea']}} {{$order['addressDetail']}} {{$order['addressPost']}}</div>
                    </div>
                </div>
                <div class="ub-pair">
                    <div class="name"><i class="iconfont icon-transport"></i> 物流</div>
                    <div class="value">
                        @if($order['_shippingCompanyName'])
                            {{$order['_shippingCompanyName']}}
                        @else
                            <span class="ub-text-muted">[暂无物流公司]</span>
                        @endif
                        &nbsp;&nbsp;&nbsp;&nbsp;
                        @if($order['shippingCode'])
                            {{$order['shippingCode']}}
                        @else
                            <span class="ub-text-muted">[暂无单号]</span>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>

    <div class="ub-panel">
        <div class="head">
            <div class="title">
                快递跟踪
                {{$order['_shippingTransportStatus']}}
            </div>
        </div>
        <div class="body">
            <div class="tw-bg-gray-100 tw-rounded tw-p-2">
                @foreach($order['_shippingTransportDetail'] as $one)
                    <div class="tw-py-1">
                        <div class="tw-text-gray-500">{{$one['time']}}</div>
                        <div>{{$one['content']}}</div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="ub-panel">
        <div class="head">
            <div class="title">
                订单备注
            </div>
        </div>
        <div class="body">
            {{$order['remark']?$order['remark']:'-'}}
        </div>
    </div>

@endsection
