@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' - '.modstart_config('siteSlogan')}}@endsection

@section('bodyContent')

    {!! \ModStart\ModStart::css('vendor/CreditShop/style/shop.css') !!}
    <div class="ub-container margin-top">
        <div class="pb-home-banner">
            <div class="left-menu">
                @foreach(\Module\CreditShop\Util\GoodsCategoryUtil::tree() as $category)
                    <div class="item">
                        <a href="{{modstart_web_url('credit_shop/goods',['categoryId'=>$category['id']])}}" class="item-title">
                            <i class="iconfont icon-angle-right"></i>
                            {{$category['title']}}
                        </a>
                        <div class="item-children">
                            <div class="row">
                                @if(!empty($category['_child']))
                                    @foreach($category['_child'] as $c)
                                        <div class="col-md-3">
                                            <a class="child-item" href="{{modstart_web_url('credit_shop/goods',['categoryId'=>$c['id']])}}">
                                                <span class="cover ub-cover-1-1 tw-w-8" style="background-image:url( {{\ModStart\Core\Assets\AssetsUtil::fix($c['cover'])}} );"></span>
                                                <span class="text">{{$c['title']}}</span>
                                            </a>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="right-banner">
                {!! \Module\Banner\View\BannerView::basic('creditShopHome') !!}
            </div>
        </div>
    </div>

    @if(modstart_module_enabled('Ad'))
        <div class="ub-container margin-top">
            {!! \Module\Ad\View\AdView::simple('shopCreditHome') !!}
        </div>
    @endif

    <?php $recommends = \Module\CreditShop\Util\GoodsUtil::recommendGoods(); ?>
    @if(!empty($recommends))
        <div class="ub-container margin-top">
            <div class="ub-panel transparent">
                <div class="head">
                    <div class="title">
                        <i class="iconfont icon-gift"></i>
                        推荐
                    </div>
                </div>
                <div class="body">
                    @include('module::CreditShop.View.inc.goodsRecords',['records'=>$recommends])
                </div>
            </div>
        </div>
    @endif

    @foreach(\Module\CreditShop\Util\GoodsCategoryUtil::tree() as $category)
        <div class="ub-container margin-top">
            <div class="ub-panel transparent">
                <div class="head">
                    <div class="title">{{$category['title']}}</div>
                </div>
                <div class="body">
                    @include('module::CreditShop.View.inc.goodsRecords',['records'=>\Module\CreditShop\Util\GoodsUtil::listLatestByCategoryId($category['id'],4)])
                </div>
            </div>
        </div>
    @endforeach

    <div class="ub-container">
        @if(modstart_module_enabled('Partner'))
            {!! \Module\Partner\View\PartnerView::simple('creditShopHome') !!}
        @endif
    </div>

@endsection
