@extends($_viewFrame)

@section('pageTitleMain'){{$goods['title']}}@endsection
@section('pageKeywords'){{$goods['title']}}@endsection
@section('pageDescription'){{$goods['title']}}@endsection

{!! \ModStart\ModStart::css('asset/vendor/swiper/swiper.css') !!}
{!! \ModStart\ModStart::js('asset/vendor/swiper/swiper.js') !!}
{!! \ModStart\ModStart::style('.pb-goods-images .small .swiper-slide{border: 2px solid transparent;}') !!}
{!! \ModStart\ModStart::style('.pb-goods-images .small .swiper-slide-thumb-active{border: 2px solid var(--color-primary);}') !!}
{!! \ModStart\ModStart::css('vendor/CreditShop/style/image-zoom.css') !!}
{!! \ModStart\ModStart::js('vendor/CreditShop/js/image-zoom.js') !!}
{!! \ModStart\ModStart::script('window.MS.imageZoom("[data-goods-covers]",".pb-image-zoom-preview")') !!}
@section('bodyAppend')
    @parent
    <script>
        $(function () {
            window.__goodsSlider = new Swiper('.pb-goods-images .big', {
                thumbs: {
                    swiper: new Swiper('.pb-goods-images .small', {
                        spaceBetween: 10,
                        slidesPerView: 'auto',
                        freeMode: true,
                        watchSlidesVisibility: true,
                        watchSlidesProgress: true,
                        on: {
                            click: function () {
                                window.__data && window.__data.doShowSlideCover && window.__data.doShowSlideCover();
                            }
                        }
                    }),
                },
                autoplay: {
                    delay: 3000,
                    pauseOnMouseEnter: true,
                },
                on: {
                    init: function (swiper) {
                        $('.pb-image-zoom-image').css('background-image', 'url('+$(swiper.slides[swiper.activeIndex]).attr('data-background-image')+')');
                        $('.pb-goods-images .small .swiper-slide').on('mouseover',function(){
                            swiper.slideTo($(this).index());
                        });
                    },
                    activeIndexChange: function (swiper) {
                        $('.pb-image-zoom-image').css('background-image', 'url('+$(swiper.slides[swiper.activeIndex]).attr('data-background-image')+')');
                    }
                }
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('credit_shop/goods')}}">积分商城</a>
            <a class="active" href="{{modstart_web_url('credit_shop/goods/'.$goods['id'])}}">{{$goods['title']}}</a>
        </div>

        @if(!empty($goodsSnapshot))
            <div class="ub-alert warning ub-text-center">
                <i class="iconfont icon-warning"></i>
                当前页面为商品购买快照，
                <a href="{{modstart_web_url('credit_shop/goods/'.$goods['id'])}}">点击这里</a>
                查看最新商品信息
            </div>
        @endif

        <div class="tw-bg-white tw-p-4">
            <div class="pb-image-zoom-preview">
                <div class="pb-image-zoom-image"></div>
            </div>
            <div class="row">
                <div class="col-md-5">
                    <div class="pb-goods-images">
                        <div class="swiper-container tw-border-gray-100 tw-border-solid tw-border tw-overflow-hidden"
                             style="width:0;height:0;" data-goods-spec-cover>
                            <div class="ub-cover-1-1 contain"></div>
                        </div>
                        <div class="big swiper-container tw-border-gray-100 tw-border-solid tw-border tw-overflow-hidden pb-image-zoom"
                             data-goods-covers>
                            <div class="swiper-wrapper">
                                <div class="swiper-slide active">
                                    <div class="cover ub-cover-1-1 contain" data-background-image="{{\ModStart\Core\Assets\AssetsUtil::fix($goods['cover'])}}"
                                         style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($goods['cover'])}});"></div>
                                </div>
                                @if(!empty($goodsDetail['images']))
                                    @foreach($goodsDetail['images'] as $image)
                                        <div class="swiper-slide">
                                            <div class="cover ub-cover-1-1 contain" data-background-image="{{\ModStart\Core\Assets\AssetsUtil::fix($image)}}"
                                                 style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($image)}});"></div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="zoom-mask"></div>
                        </div>
                        <div class="small swiper-container tw-border-gray-100 tw-border-solid tw-border tw-pl-2">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide active ub-cover-1-1 contain"
                                     style="width:3rem;height:3rem;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($goods['cover'])}});"></div>
                                @if(!empty($goodsDetail['images']))
                                    @foreach($goodsDetail['images'] as $image)
                                        <div class="swiper-slide ub-cover-1-1 contain"
                                             style="width:3rem;height:3rem;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($image)}});"></div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="tw-px-4">
                        <h1 class="tw-p-0 tw-m-0">{{$goods['title']}}</h1>
                        @if(!empty($goods['slogan']))
                            <div class="tw-border-solid tw-border-gray-100 tw-border-0 tw-border-b tw-text-gray-400 tw-py-2">{{$goods['slogan']}}</div>
                        @endif
                        @if($goodsSnapshot)
                            <div class="tw-pt-4">
                                <div class="ub-pair tw-align-middle">
                                    <div class="name tw-mt-0.5">所需积分</div>
                                    <div class="value">
                                        <div class="tw-text-lg ub-text-primary tw-font-bold">
                                            @if(empty($goodsSnapshot['specSpec']))
                                                <span class="">{{$goodsSnapshot['credit']}}</span>
                                            @else
                                                <span class="">{{$goodsSnapshot['specCredit']}}</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @if(!empty($goodsSnapshot['specSpec']))
                                    @foreach($goodsSnapshot['specSpec'] as $k=>$v)
                                        <div class="ub-pair">
                                            <div class="name tw-mt-0.5">{{$k}}</div>
                                            <div class="value">
                                                {{$v}}
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        @else
                            <div id="goodsSpecWidget"></div>
                            <script>
                                window.__data = {
                                    goodsId: {!! json_encode($goods['id']) !!},
                                    IsLogined: {!! json_encode(empty($_memberUserId)?false:true) !!}
                                };
                            </script>
                            {!! \ModStart\ModStart::js('asset/vendor/vue.js') !!}
                            {!! \ModStart\ModStart::js('asset/vendor/element-ui/index.js') !!}
                            {!! \ModStart\ModStart::js('vendor/CreditShop/entry/goodsSpecWidget.js') !!}
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {!! \ModStart\ModStart::js('asset/vendor/jquery.sticky.js') !!}
        {!! \ModStart\ModStart::script('$("[data-content-tab-container]").sticky({position:"top",className:"tw-shadow-lg"});') !!}
        <div class="tw-h-4"></div>
        <div class="tw-bg-white tw-p-4 tw-rounded" data-content-tab-container>
            <div class="ub-nav-tab" data-content-tab>
                <a href="javascript:;" class="active">商品详情</a>
                <a href="javascript:;">商品属性</a>
            </div>
        </div>
        <div data-content-body>
            <div class="tw-bg-white tw-p-4 tw-rounded">
                <div class="ub-html lg">{!! $goodsDetail['content'] !!}</div>
            </div>
            <div class="tw-bg-white tw-p-4 tw-rounded tw-mt-1">
                <div class="tw-p-4">
                    @foreach($goodsAttr as $attr)
                        <div class="ub-pair">
                            <div class="name">
                                {{$attr['name']}}
                            </div>
                            <div class="value">
                                {{$attr['value']}}
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        {!! \ModStart\ModStart::js('asset/common/ui.js') !!}
        {!! \ModStart\ModStart::script("MS.ui.tabScroller('[data-content-tab] > *','[data-content-body] > *',{scrollOffset:83})") !!}

    </div>

@endsection





