@extends($_viewFrame)

@section('pageTitleMain')提交订单@endsection
@section('pageKeywords')提交订单@endsection
@section('pageDescription')提交订单@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('credit_shop/goods')}}">积分商城</a>
            <a href="{{modstart_web_url('credit_shop/cart')}}">我的购物车</a>
            <a class="active" href="{{modstart_web_url('credit_shop/cart/checkout')}}">提交订单</a>
        </div>

        <div style="max-width:800px;margin:0 auto;">
            <form action="{{modstart_api_url('credit_shop/cart/checkout')}}" data-ajax-form method="post">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">收货地址</div>
                    </div>
                    <div class="body">
                        <div class="row">
                            <script>
                                window.__grids = {
                                    get:function(index){
                                        return {
                                            lister:{
                                                refresh:function () {
                                                    window.location.reload();
                                                }
                                            }
                                        };
                                    }
                                };
                            </script>
                            @foreach($memberAddressList as $memberAddressIndex=>$memberAddress)
                                <div class="col-md-6">
                                    <div class="tw-bg-white tw-rounded-lg tw-mb-2 tw-box tw-px-5 tw-py-3 tw-mb-3 tw-zoom-in tw-border-2 tw-border-solid tw-border-gray-100"
                                        onclick="$(this).find('input').prop('checked',true);">
                                        <div class="tw-flex tw-items-center">
                                            <div class="tw-mr-2">
                                                <input type="radio" name="addressId" @if(!$memberAddressIndex) checked @endif value="{{$memberAddress['id']}}" />
                                            </div>
                                            <div class="tw-font-medium">
                                                {{$memberAddress['name']}}
                                            </div>
                                            <div class="tw-flex-grow tw-text-right">
                                                <i class="iconfont icon-phone"></i>
                                                {{$memberAddress['phone']}}
                                            </div>
                                        </div>
                                        <div class="tw-pt-2 tw-text-gray-400">
                                            {{$memberAddress['area']}}
                                            {{$memberAddress['detail']}}
                                            {{$memberAddress['post']}}
                                        </div>
                                        <div class="tw-text-right">
                                            <a href="javascript:;" data-dialog-request="{{modstart_web_url('member_address/edit?_id='.$memberAddress['id'])}}" class="ub-lister-action ub-text-muted">编辑</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-md-6">
                                <div class="tw-bg-white tw-rounded-lg tw-mb-2 tw-box tw-px-5 tw-py-3 tw-mb-3 tw-zoom-in tw-border-2 tw-border-solid tw-border-gray-100" data-repeat="3">
                                    <a style="line-height:72px;display:block;color:#999;text-align:center;" href="javascript:;" data-dialog-request="{{modstart_web_url('member_address/add')}}">
                                        添加新地址
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">商品信息</div>
                    </div>
                    <div class="body">
                        @foreach($carts as $cart)
                            <div class="tw-bg-white tw-mb-2 tw-rounded-sm tw-border-solid tw-border-gray-100 tw-border-0 tw-border-b">
                                <div class="tw-p-2">
                                    <div class="tw-p-2 tw-flex">
                                        <div class="tw-w-16 tw-flex-shrink-0">
                                            <div class="ub-cover-1-1" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($cart['_goods']['cover'])}})"></div>
                                        </div>
                                        <div class="tw-flex-grow tw-pl-2">
                                            <div class="">{{$cart['_goods']['title']}}</div>
                                            <div class="tw-text-gray-400">
                                                @if(!empty($cart['spec']))
                                                    @foreach($cart['spec'] as $k=>$v)
                                                        {{$k}}：{{$v}}
                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>
                                        <div class="tw-w-16 tw-flex-shrink-0 tw-text-right">
                                            <div class="tw-text-black tw-text-sm">{{$cart['goodsSpecCredit']}}积分</div>
                                            <div class="tw-text-gray-400">x{{$cart['amount']}}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">订单结算</div>
                    </div>
                    <div class="body">
                        <div class="ub-pair">
                            <div class="name">所需积分</div>
                            <div class="value">{{$creditTotal}}</div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">我的积分</div>
                            <div class="value">{{\Module\Member\Util\MemberCreditUtil::getTotal(\Module\Member\Auth\MemberUser::id())}}</div>
                        </div>
                        <div class="margin-top tw-text-center margin-top">
                            <button class="btn btn-lg btn-primary" type="submit">确定兑换</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>

@endsection





