@extends('modstart::admin.dialogFrame')

@section('pageTitle')订单详情@endsection

@section('bodyContent')
    <div class="ub-panel">
        <div class="head">
            <div class="title">订单详情</div>
        </div>
        <div class="body">
            <div class="ub-form">
                <input type="hidden" name="_id" value="{{\Illuminate\Support\Facades\Input::get('_id','')}}"/>
                <table class="ub-table">
                    <tbody>
                    <tr>
                        <td>
                            <div class="row">
                                <div class="col-4">
                                    <div class="line">
                                        <div class="label">
                                            订单号
                                        </div>
                                        <div class="field">
                                            {{$record['sn']}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="line">
                                        <div class="label">
                                            下单时间
                                        </div>
                                        <div class="field">
                                            {{$record['created_at']}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="line">
                                        <div class="label">
                                            状态
                                        </div>
                                        <div class="field">
                                            {{\ModStart\Core\Type\TypeUtil::name(\Module\Vendor\Type\OrderStatus::class,$record['status'])}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @if($record['addressName'])
                        <tr>
                            <td>
                                <div class="line">
                                    <div class="label">
                                        收货信息
                                    </div>
                                    <div class="field">
                                        {{$record['addressName']}} {{$record['addressPhone']}}
                                        {{$record['addressArea']}} {{$record['addressDetail']}} {{$record['addressPost']}}
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="line">
                                            <div class="label">物流公司</div>
                                            <div class="field">
                                                {{empty($record['shippingName'])?'':$record['shippingName']}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="line">
                                            <div class="label">物流单号</div>
                                            <div class="field">
                                                {{empty($record['shippingCode'])?'':$record['shippingCode']}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endif
                    @if($record['remark'])
                        <tr>
                            <td>
                                <div class="line">
                                    <div class="label">订单留言</div>
                                    <div class="field">
                                        {{$record['remark']}}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <td>
                            <div class="line">
                                <div class="label">订单信息</div>
                                <div class="value">

                                    <table class="ub-table mini border">
                                        <thead>
                                        <tr>
                                            <th>商品ID</th>
                                            <th>商品</th>
                                            <th>参数</th>
                                            <th>数量</th>
                                            <th>总计</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($record['_orderGoods'] as $goodsIndex=>$goods)
                                            <tr>
                                                <td>
                                                    {{$goods['_goodsSnapshot']['goodsId']}}
                                                </td>
                                                <td>
                                                    <a class="title"
                                                       href="{{modstart_web_url('credit_shop/goods')}}/{{$goods['_goodsSnapshot']['goodsId']}}?snapshot={{$goods['_goodsSnapshot']['id']}}"
                                                       target="_blank">
                                                        {{$goods['_goodsSnapshot']['title']}}
                                                    </a>
                                                </td>
                                                <td width="200">
                                                    @if(!empty($goods['_goodsSnapshot']['specSpec']))
                                                        <div class="spec">
                                                            @foreach($goods['_goodsSnapshot']['specSpec'] as $k=>$v)
                                                                {{$k}}:{{$v}}
                                                                <br/>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </td>
                                                <td width="80">
                                                    x{{$goods['amount']}}
                                                </td>
                                                <td>
                                                    {{$goods['credit']}}
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th colspan="5" class="ub-text-right">
                                                <div>
                                                    总计：{{$record['credit']}}积分
                                                </div>
                                            </th>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
