<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\CreditShop\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use ModStart\Widget\TextDialogRequest; use Module\CreditShop\Util\GoodsUtil; use Module\CreditShop\Util\OrderUtil; use Module\Express\Util\ExpressUtil; use Module\Member\Util\MemberCmsUtil; use Module\Vendor\Type\OrderStatus; class OrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $wU9fK) { $wU9fK->init('cs_order')->field(function ($wU9fK) { $wU9fK->id('id', '业务订单ID'); $wU9fK->display('created_at', '时间'); $wU9fK->display('sn', '订单号')->width(200); $wU9fK->display('memberUserId', '用户')->hookRendering(function (AbstractField $puq_G, $a6udn, $Lokw6) { return MemberCmsUtil::showFromId($a6udn->memberUserId); })->width(200); $wU9fK->display('_goods', '商品')->hookRendering(function (AbstractField $puq_G, $a6udn, $Lokw6) { $Y22Q3 = OrderUtil::getOrderInfo($a6udn->id); return AutoRenderedFieldValue::makeView('module::CreditShop.View.admin.order.listGoodsItem', array('item' => $a6udn, 'orderInfo' => $Y22Q3)); })->width(350); $wU9fK->type('status', '状态')->type(OrderStatus::class)->editable(false); $wU9fK->number('credit', '积分'); })->gridFilter(function (GridFilter $PQCuK) { $PQCuK->eq('id', '业务订单ID'); })->hookItemOperateRendering(function (ItemOperate $u9PCG) { $a6udn = $u9PCG->item(); $u9PCG->getField()->width(400); switch ($a6udn->status) { case OrderStatus::WAIT_SHIPPING: $u9PCG->prepend(TextDialogRequest::primary('确认发货', action('\\' . __CLASS__ . '@shipping', array('_id' => $a6udn->id)))); break; case OrderStatus::WAIT_CONFIRM: goto UlUcK; MlgT1: break; goto D4O46; dmBuh: $u9PCG->prepend(TextDialogRequest::primary('修改物流', action('\\' . __CLASS__ . '@shipping', array('_id' => $a6udn->id)))); goto MlgT1; UlUcK: $u9PCG->prepend(TextAjaxRequest::primary('确认收货', action('\\' . __CLASS__ . '@confirm', array('_id' => $a6udn->id)))); goto dmBuh; D4O46: } $u9PCG->push(TextDialogRequest::make('primary', '订单详情', action('\\' . __CLASS__ . '@detail', array('_id' => $a6udn->id)))->width('90%')); })->title('订单管理')->canShow(false)->canDelete(false); } private function listForStatus($LyYEA) { goto kCm0a; kCm0a: $j_upA = $this->grid(); goto hCcQc; ZlLh8: $j_upA->repositoryFilter(function (RepositoryFilter $PQCuK) use($LyYEA) { $PQCuK->where('status', $LyYEA); }); goto wJeyN; OG36V: CRUDUtil::registerGridResource($j_upA, '\\' . __CLASS__); goto vBLtb; vBLtb: if (Request::isPost()) { return $j_upA->request(); } goto RvxZy; hCcQc: $j_upA->build(); goto ZlLh8; wJeyN: $j_upA->gridFilter(function (GridFilter $PQCuK) { $PQCuK->clearFilter(); $PQCuK->eq('id', L('ID')); $PQCuK->eq('sn', '订单号'); }); goto OG36V; RvxZy: return app(AdminPage::class)->pageTitle(TypeUtil::name(OrderStatus::class, $LyYEA))->body($j_upA); goto jBsfa; jBsfa: } public function cancel() { goto zKAfV; dgO5i: return Response::jsonError('订单状态错误'); goto usNzz; iivFW: BizException::throwsIfEmpty('订单不存在', $GNwZm); goto f4lx2; pD25b: $Wa6dC = CRUDUtil::id(); goto fzJ8L; fzJ8L: $GNwZm = ModelUtil::get('order', array('id' => $Wa6dC)); goto iivFW; f4lx2: switch ($GNwZm['status']) { case OrderStatus::WAIT_PAY: ModelUtil::update('cs_order', array('id' => $Wa6dC), array('status' => OrderStatus::CANCEL)); return Response::redirect(CRUDUtil::jsGridRefresh()); } goto dgO5i; zKAfV: AdminPermission::demoCheck(); goto pD25b; usNzz: } public function confirm() { goto QY7U9; Px8JC: $Wa6dC = CRUDUtil::id(); goto IvRAT; IvRAT: $GNwZm = ModelUtil::get('order', array('id' => $Wa6dC)); goto vuPUv; QY7U9: AdminPermission::demoCheck(); goto Px8JC; ieIhB: switch ($GNwZm['status']) { case OrderStatus::WAIT_CONFIRM: ModelUtil::update('cs_order', array('id' => $Wa6dC), array('status' => OrderStatus::COMPLETED)); return Response::redirect(CRUDUtil::jsGridRefresh()); } goto os1Zq; vuPUv: BizException::throwsIfEmpty('订单不存在', $GNwZm); goto ieIhB; os1Zq: return Response::jsonError('订单状态错误'); goto MJBgC; MJBgC: } public function listWaitPay() { return $this->listForStatus(OrderStatus::WAIT_PAY); } public function listWaitShipping() { return $this->listForStatus(OrderStatus::WAIT_SHIPPING); } public function listWaitConfirm() { return $this->listForStatus(OrderStatus::WAIT_CONFIRM); } public function listCompleted() { return $this->listForStatus(OrderStatus::COMPLETED); } public function listCancelExpired() { return $this->listForStatus(OrderStatus::CANCEL_EXPIRED); } public function listCancel() { return $this->listForStatus(OrderStatus::CANCEL); } public function shipping(AdminConfigBuilder $wU9fK) { goto sDnSZ; jrvtD: $wU9fK->pageTitle('物流设置'); goto a3v2u; sDnSZ: $GNwZm = ModelUtil::get('cs_order', CRUDUtil::id()); goto rq46O; JYPJw: $wU9fK->text('shippingCode', '物流单号'); goto BeBza; rq46O: BizException::throwsIfEmpty('订单不存在', $GNwZm); goto FeeyX; FeeyX: $wU9fK->useDialog(); goto jrvtD; a3v2u: $wU9fK->select('shippingName', '物流公司')->options(ExpressUtil::listEnableMap()); goto JYPJw; BeBza: $a6udn = RepositoryUtil::itemFromArray(ArrayUtil::keepKeys($GNwZm, array('shippingName', 'shippingCode'))); goto XLOoR; XLOoR: return $wU9fK->perform($a6udn, function (Form $E5fZ1) { AdminPermission::demoCheck(); ModelUtil::update('cs_order', CRUDUtil::id(), array_merge($E5fZ1->dataForming(), array('status' => OrderStatus::WAIT_CONFIRM))); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto x9IgB; x9IgB: } public function detail() { $Fm2q6 = OrderUtil::getOrderInfo(CRUDUtil::id()); return view('module::CreditShop.View.admin.order.detail', array('record' => $Fm2q6)); } }