@extends($_viewFrame)

@section('pageTitleMain'){{'防伪查询:'.$code}}@endsection
@section('pageKeywords'){{'防伪查询:'.$code}}@endsection
@section('pageDescription'){{'防伪查询:'.$code}}@endsection

@section('body')

    <div class="ub-search-block">
        <div class="title">
            防伪查询结果
        </div>
        <div class="tw-pt-4 tw-text-white">
            防伪码 <span class="tw-font-mono">{{$code}}</span>
        </div>
    </div>

    <div class="ub-container margin-top" style="max-width:600px;">
        @if(empty($record))
            <div class="tw-py-4">
                <div class="ub-html lg">
                    {!! modstart_config('Tracking_ResultNotFound',null) !!}
                </div>
            </div>
        @else
            <div class="ub-panel">
                <div class="head"></div>
                <div class="body">
                    <div class="ub-html lg">
                        @if($record['hits']==1)
                            {!! \Module\Tracking\Util\CodeUtil::replaceCodeParam(modstart_config('Tracking_ResultFirstContent'),$record) !!}
                        @else
                            {!! \Module\Tracking\Util\CodeUtil::replaceCodeParam(modstart_config('Tracking_ResultContent'),$record) !!}
                        @endif
                    </div>
                </div>
            </div>

            @if(!empty($record['_events']))
                @foreach($record['_events'] as $e)
                    <div class="ub-content-box margin-bottom">
                        <a href="{{$e['_url']}}">
                            <img class="tw-w-full" src="{{$e['linkCover']}}" />
                        </a>
                    </div>
                @endforeach
            @endif

            @if(modstart_config('Tracking_ShowProduct',false) && !empty($record['_product']))
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            <i class="iconfont icon-details"></i>
                            产品信息
                        </div>
                    </div>
                    <div class="body">
                        <div class="tw-font-bold tw-text-lg">
                            {{$record['_product']['title']}}
                        </div>
                        <div class="ub-pair">
                            <div class="name">条码</div>
                            <div class="value">{{$record['_product']['barcode']}}</div>
                        </div>
                        @if(!empty($record['_product']['cover']))
                            <div>
                                <img class="tw-w-full" src="{{\ModStart\Core\Assets\AssetsUtil::fix($record['_product']['cover'])}}" />
                            </div>
                        @endif
                        @if(!empty($record['_product']['content']))
                            <div>
                                <div class="ub-html lg">{!! $record['_product']['content'] !!}</div>
                            </div>
                        @endif
                    </div>
                </div>
                @if(!empty($record['_product']['_sections']))
                    @foreach($record['_product']['_sections'] as $section)
                        <div class="ub-panel">
                            <div class="head">
                                <div class="title">{{$section['title']}}</div>
                            </div>
                            <div class="body">
                                <div class="ub-html lg">{!! $section['content'] !!}</div>
                            </div>
                        </div>
                    @endforeach
                @endif
            @endif

            @if(modstart_config('Tracking_ShowProcess',false) && !empty($record['_processItems']))
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            <i class="iconfont icon-transport"></i>
                            溯源流程
                        </div>
                    </div>
                    <div class="body">
                        <div>
                            <ul class="tw--mb-8">
                                @foreach($record['_processes'] as $process)
                                    <?php $items = array_filter($record['_processItems'],function($item)use($process){ return $item['processId']==$process['id']; }); ?>
                                    <li>
                                        <div class="tw-relative tw-pb-8">
                                            <div class="tw-relative tw-flex tw-items-start tw-space-x-3">
                                                <div>
                                                    <div class="tw-relative tw-px-1">
                                                        <div class="tw-h-8 tw-w-8 ub-bg-primary tw-rounded-full tw-ring-8 tw-ring-white tw-flex tw-items-center tw-justify-center">
                                                            <i class="iconfont icon-card tw-text-white"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tw-min-w-0 tw-flex-1 tw-py-0">
                                                    <div class="tw-text-lg tw-text-gray-500">
                                                        <div class="tw-font-medium tw-text-gray-900 tw-mr-2">
                                                            {{$process['title']}}
                                                        </div>
                                                    </div>
                                                    <div class="tw-mt-2 tw-text-gray-400">
                                                        @foreach($items as $item)
                                                            <div class="tw-bg-gray-100 tw-rounded tw-p-2">
                                                                <i class="iconfont icon-time"></i>
                                                                {{$item['operateTime']}}
                                                                <i class="iconfont icon-user"></i>
                                                                {{$item['operator']}}
                                                                <br>
                                                                {{$item['remark']}}
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            @if(modstart_config('Tracking_ShowAgent',false) && !empty($record['_agent']))
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            <i class="iconfont icon-users"></i>
                            经销商
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-pair">
                            <div class="name">名称</div>
                            <div class="value">{{$record['_agent']['name']}}</div>
                        </div>
                    </div>
                </div>
            @endif

        @endif
    </div>
@endsection
