@extends($_viewFrame)

@section('pageTitleMain'){{'一物一码溯源防伪系统'}}@endsection

@section('bodyContent')

    <div class="ub-container margin-top margin-bottom tw-bg-cover"
         style="background-image:url(@asset('vendor/Tracking/image/world.png'))"
    >
        <div class="ub-content-box tw-text-center" style="background:transparent;">
            <div class="tw-py-5">
                <div class="tw-inline-block tw-align-middle">
                    @if($l = modstart_config('Tracking_Logo',''))
                        <img src="{{\ModStart\Core\Assets\AssetsUtil::fixFull($l)}}" />
                    @else
                        <i class="iconfont icon-shield-check ub-text-primary" style="font-size:2rem;"></i>
                    @endif
                </div>
                <div class="tw-inline-block tw-align-middle tw-text-2xl">
                    {{modstart_config('Tracking_Title','一物一码溯源防伪系统')}}
                </div>
            </div>
            <div class="tw-py-5 tw-max-w-2xl tw-mx-auto">
                <form action="{{modstart_web_url('tracking/submit')}}" method="post" data-ajax-form>
                    <div class="ub-search-block-a lg">
                        <input class="input" type="text" name="code" value="" placeholder="输入防伪码点击查询" />
                        <a class="search-btn" href="javascript:;"
                           onclick="$(this).closest('form').submit();">
                            <i class="iconfont icon-sarch"></i>
                            立即查询
                        </a>
                    </div>
                </form>
                <div>
                    @if(modstart_config('Tracking_QueryContent',null))
                        <div class="tw-py-4">
                            <div class="ub-html lg">
                                {!! modstart_config('Tracking_QueryContent',null) !!}
                            </div>
                        </div>
                    @endif
                </div>
                @if(0&&modstart_config('Tracking_QueryCaptchaProvider',null))
                    <div class="tw-shadow-lg tw-my-3 tw-mx-auto tw-max-w-sm tw-p-3 tw-rounded-lg">
                        {!! \Module\Vendor\Provider\Captcha\CaptchaProvider::get(modstart_config('Tracking_QueryCaptchaProvider',null))->render() !!}
                    </div>
                @endif
            </div>
        </div>
    </div>

    @if(modstart_module_enabled('News'))
        <div class="ub-container margin-bottom">
            {!! \Module\News\View\NewsView::latestRich() !!}
        </div>
    @endif

    @if(modstart_module_enabled('Partner'))
        <div class="ub-container margin-bottom">
            {!! \Module\Partner\View\PartnerView::text('Tracking_Home') !!}
        </div>
    @endif

@endsection
