<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Tracking\Admin\Controller; use Illuminate\Routing\Controller; use Maatwebsite\Excel\Facades\Excel; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Field\AbstractField; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\GridFilter; use ModStart\ModStart; use ModStart\Support\Concern\HasFields; use ModStart\Widget\Box; use Module\Tracking\Provider\TrackingCodeProvider; use Module\Tracking\Type\CodeBatchIdentityType; use Module\Tracking\Type\CodeCreateCodeType; use Module\Tracking\Type\CodeTransportCodeType; use Module\Tracking\Type\CodeVerifyCodeType; use Module\Tracking\Util\CodeUtil; class CodeController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $p5Kcp) { ModStart::js('asset/common/qrcode.js'); $p5Kcp->init('tracking_code')->field(function ($p5Kcp) { $p5Kcp->id('id', 'ID'); $p5Kcp->text('code', '防伪码')->required()->ruleUnique('tracking_code')->hookRendering(function (AbstractField $ccNNj, $BB065, $uM5KM) { switch ($ccNNj->renderMode()) { case FieldRenderMode::GRID: goto rEGqu; qSE01: return '<code>' . $BB065->code . "</code> {$qbxFr}"; goto jOUUQ; iqrqY: $qbxFr = "<a href='javascript:;' data-qrcode-content='{$qqjcl}'><i class='iconfont icon-qr-code'></i></a>"; goto qSE01; rEGqu: $qqjcl = Request::domainUrl() . modstart_web_url('tracking/show/code_' . $BB065->code); goto iqrqY; jOUUQ: } })->width(200); $p5Kcp->text('batch', '批次')->required(); $p5Kcp->text('verifyCode', '校验码'); $p5Kcp->text('transportCode', '物流码')->required()->ruleUnique('tracking_code'); $p5Kcp->select('productId', '产品')->required()->optionModel('tracking_product', 'id', 'title')->selectSearch(true); $p5Kcp->select('agentId', '经销商')->required()->optionModel('tracking_agent', 'id', 'name'); $p5Kcp->switch('enable', '启用')->required()->optionsYesNo(); $p5Kcp->datetime('enableTime', '启用时间'); foreach (TrackingCodeProvider::listAll() as $PGmY1) { $PGmY1->formCrud($p5Kcp); } $p5Kcp->display('created_at', L('Created At'))->listable(false); $p5Kcp->display('updated_at', L('Updated At'))->listable(false); })->gridFilter(function (GridFilter $hxiq7) { $hxiq7->eq('id', L('ID')); $hxiq7->like('code', '防伪码'); $hxiq7->like('batch', '批次'); $hxiq7->like('transportCode', '物流码'); $hxiq7->eq('productId', '产品')->selectModel('tracking_product', 'id', 'title')->field()->selectSearch(true); })->title('防伪码'); } public function create(AdminPage $pI9Cu) { goto K5YFt; K5YFt: $HFZFF = Form::make('')->formClass('wide'); goto neJ4a; drNYB: $HFZFF->number('codeLength', '防伪码长度')->defaultValue(12)->help('建议8-18位，改长度为包含前缀的长度')->required(); goto swqMT; df0lN: $HFZFF->select('codeType', '防伪码生成方式')->optionType(CodeCreateCodeType::class)->required(); goto AVSor; R06Xf: return $pI9Cu->pageTitle('批量生成防伪码')->body(new Box($HFZFF, '批量生成防伪码')); goto Msdjq; ddwlV: $HFZFF->select('transportCodeType', '物流码样式')->optionType(CodeTransportCodeType::class)->required(); goto TZ54v; mp8dQ: $HFZFF->select('agentId', '产品所属经销商')->optionModel('tracking_agent', 'id', 'name')->help('可在防伪码不变的情况下批量修改。'); goto V8jR0; TZ54v: $HFZFF->number('transportCodeLength', '物流码长度')->defaultValue(8)->help('物流码可用于扫码发货，流程记录和溯源管理等')->required(); goto gry8H; BcRbn: foreach (TrackingCodeProvider::listAll() as $PGmY1) { $PGmY1->formCreate($HFZFF); } goto tS3D3; gry8H: $HFZFF->number('count', '生成数量')->defaultValue(1)->help('建议一次生成10万条以内。')->required(); goto urYiF; swqMT: $HFZFF->select('verifyCodeType', '校验码样式')->optionType(CodeVerifyCodeType::class)->defaultValue(CodeVerifyCodeType::NONE)->when('!=', CodeVerifyCodeType::NONE, function (Form $HFZFF) { $HFZFF->number('verifyCodeLength', '校验码长度')->defaultValue(6)->help('物流码可辅助防伪码管理等操作'); }); goto ddwlV; tS3D3: if (Request::isPost()) { return $HFZFF->formRequest(function (Form $HFZFF) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $P1CdK['codePrefix'] = trim($P1CdK['codePrefix']); BizException::throwsIf('防伪码长度不符合规范', $P1CdK['codeLength'] < 8 || $P1CdK['codeLength'] > 50); BizException::throwsIf('防伪码长度不符合规范', $P1CdK['codeLength'] <= strlen($P1CdK['codePrefix'])); BizException::throwsIf('物流码长度不符合规范', $P1CdK['transportCodeLength'] < 8 || $P1CdK['transportCodeLength'] > 50); BizException::throwsIf('生成数量不符合规范', $P1CdK['count'] < 1 || $P1CdK['count'] > 100000); $G0xOi = $P1CdK['codeLength'] - strlen($P1CdK['codePrefix']); $Tjf_l = 0; $Wf4tk = array('code' => '', 'batch' => $P1CdK['batch'], 'transportCode' => '', 'productId' => $P1CdK['productId'], 'agentId' => $P1CdK['agentId'], 'enable' => $P1CdK['enable']); if ($Wf4tk['enable']) { $Wf4tk['enableTime'] = date('Y-m-d H:i:s'); } foreach (TrackingCodeProvider::listAll() as $PGmY1) { $Wf4tk = $PGmY1->formCreatePrepareInsert($Wf4tk, $P1CdK); } ModelUtil::transactionBegin(); for ($IEIMr = 0; $IEIMr < $P1CdK['count']; $IEIMr++) { $T8hPr = array('code' => $P1CdK['codePrefix'], 'verifyCode' => '', 'transportCode' => ''); switch ($P1CdK['codeType']) { case CodeCreateCodeType::PREFIX_ALPHABET_UPPER: $T8hPr['code'] .= RandomUtil::upperChar($G0xOi); break; case CodeCreateCodeType::PREFIX_NUMBER: $T8hPr['code'] .= RandomUtil::number($G0xOi); break; case CodeCreateCodeType::PREFIX_NUMBER_ALPHABET_UPPER: $T8hPr['code'] .= RandomUtil::upperString($G0xOi); break; default: BizException::throws('防伪码生成方式错误'); } switch ($P1CdK['verifyCodeType']) { case CodeVerifyCodeType::NUMBER: $T8hPr['verifyCode'] = RandomUtil::number($P1CdK['verifyCodeLength']); break; } switch ($P1CdK['transportCodeType']) { case CodeTransportCodeType::NUMBER: $T8hPr['transportCode'] = RandomUtil::number($P1CdK['transportCodeLength']); break; case CodeTransportCodeType::NUMBER_ALPHABET: $T8hPr['transportCode'] = RandomUtil::upperString($P1CdK['transportCodeLength']); break; default: BizException::throws('物流码样式错误'); } try { ModelUtil::insert('tracking_code', array_merge($Wf4tk, $T8hPr)); $Tjf_l = 0; } catch (\Exception $d0tLO) { $IEIMr--; $Tjf_l++; } if ($Tjf_l > 5) { ModelUtil::transactionRollback(); return Response::generateError('失败次数太多，请重试'); } } ModelUtil::transactionCommit(); return Response::generate(0, '批量生成防伪码成功', null, CRUDUtil::adminRedirectOrTabClose(action('\\' . __CLASS__ . '@index'))); }); } goto R06Xf; AVSor: $HFZFF->text('codePrefix', '防伪码前缀')->defaultValue('')->help('如 CODE，建议2-4位,如果不要，可以不填写'); goto drNYB; urYiF: $HFZFF->select('productId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title')->selectSearch(true)->help('可在防伪码不变的情况下批量修改。')->required(); goto mp8dQ; V8jR0: $HFZFF->switch('enable', '是否启用防伪码')->optionsYesNo()->help('只有启用的防伪码才能查询到。')->defaultValue(true); goto BcRbn; neJ4a: $HFZFF->text('batch', '生成批次')->defaultValue(date('YmdHis'))->help('自动按时间生成,也可手工指定，方便溯源按批次调用等。')->required(); goto df0lN; Msdjq: } public function modify(AdminPage $pI9Cu) { goto mLkys; KIm_3: $HFZFF->display('_', '修改为')->addable(true); goto VQ_Fj; WV_Z6: $HFZFF->switch('enableTimeChange', '修改启用时间')->when(true, function (Form $HFZFF) { $HFZFF->datetime('enableTime', '启用时间')->help(''); }); goto C_v6A; Uz1VN: return $pI9Cu->pageTitle('批量修改防伪码')->row(new Box($HFZFF, '批量修改防伪码')); goto ZImwE; kN9sC: $HFZFF->radio('modifyType', '防伪码范围')->optionType(CodeBatchIdentityType::class)->defaultValue(CodeBatchIdentityType::TRANSPORT_CODE)->when(CodeBatchIdentityType::TRANSPORT_CODE, function (Form $HFZFF) { $HFZFF->textarea('fromTransportCodeTransportCodes', '录入物流码')->placeholder('一行一个，回车换行 , 支持扫描枪')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::ID_RANGE, function (Form $HFZFF) { $HFZFF->number('fromIdRangeStart', 'ID范围最小值')->placeholder('')->help('包含该值'); $HFZFF->number('fromIdRangeEnd', 'ID范围最大值')->placeholder('')->help('包含该值'); })->when(CodeBatchIdentityType::BATCH, function (Form $HFZFF) { $HFZFF->text('fromBatchBatch', '批次')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::PRODUCT, function (Form $HFZFF) { $HFZFF->select('fromProductProductId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title'); })->when(CodeBatchIdentityType::CREATE_TIME, function (Form $HFZFF) { $HFZFF->datetime('fromCreateTimeStart', '创建开始时间')->help('包含该时间'); $HFZFF->datetime('fromCreateTimeEnd', '创建结束时间')->help('包含该时间'); }); goto KIm_3; b7s1d: $HFZFF->switch('enableChange', '修改状态')->when(true, function (Form $HFZFF) { $HFZFF->switch('enable', '是否启用')->help(''); }); goto WV_Z6; uaxEt: $HFZFF->switch('agentIdChange', '修改所属经销商')->when(true, function (Form $HFZFF) { $HFZFF->select('agentId', '产品所属经销商')->optionModel('tracking_agent', 'id', 'name')->help('可在防伪码不变的情况下批量修改。'); }); goto b7s1d; VQ_Fj: $HFZFF->switch('productIdChange', '修改所属产品')->when(true, function (Form $HFZFF) { $HFZFF->select('productId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title')->selectSearch(true)->help('可在防伪码不变的情况下批量修改。'); }); goto uaxEt; C_v6A: if (Request::isPost()) { return $HFZFF->formRequest(function (Form $HFZFF) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $iUhMB = array(); if (isset($P1CdK['productIdChange']) && $P1CdK['productIdChange']) { $iUhMB['productId'] = $P1CdK['productId']; } if (isset($P1CdK['agentIdChange']) && $P1CdK['agentIdChange']) { $iUhMB['agentId'] = $P1CdK['agentId']; } if (isset($P1CdK['enableChange']) && $P1CdK['enableChange']) { $iUhMB['enable'] = $P1CdK['enable']; } if (isset($P1CdK['enableTimeChange']) && $P1CdK['enableTimeChange']) { $iUhMB['enableTime'] = $P1CdK['enableTime']; } if (empty($iUhMB)) { return Response::generateError('请至少选择一项修改'); } $VQzEU = ModelUtil::model('tracking_code'); switch ($P1CdK['modifyType']) { case CodeBatchIdentityType::TRANSPORT_CODE: goto W4Nl6; T5U7W: $VQzEU = $VQzEU->whereIn('transportCode', $P1CdK['fromTransportCodeTransportCodes']); goto JHxiA; W4Nl6: BizException::throwsIfEmpty('物流码为空', $P1CdK['fromTransportCodeTransportCodes']); goto T5U7W; JHxiA: break; goto L7nY1; L7nY1: case CodeBatchIdentityType::ID_RANGE: goto NJl5F; NJl5F: BizException::throwsIfEmpty('ID范围最小值为空', $P1CdK['fromIdRangeStart']); goto pnjbR; XQAsE: break; goto uMF1Y; r4509: $VQzEU = $VQzEU->where('id', '>=', $P1CdK['fromIdRangeStart'])->where('id', '<=', $P1CdK['fromIdRangeEnd']); goto XQAsE; pnjbR: BizException::throwsIfEmpty('ID范围最大值为空', $P1CdK['fromIdRangeEnd']); goto r4509; uMF1Y: case CodeBatchIdentityType::BATCH: goto U6qbq; U6qbq: BizException::throwsIfEmpty('批次为空', $P1CdK['fromBatchBatch']); goto pJNf2; Yy5Ir: break; goto g2F1g; pJNf2: $VQzEU = $VQzEU->where('batch', $P1CdK['fromBatchBatch']); goto Yy5Ir; g2F1g: case CodeBatchIdentityType::PRODUCT: goto wqL7X; wqL7X: BizException::throwsIfEmpty('批次为空', $P1CdK['fromProductProductId']); goto YVBPy; YVBPy: $VQzEU = $VQzEU->where('productId', $P1CdK['fromProductProductId']); goto OKbNJ; OKbNJ: break; goto LBHCY; LBHCY: case CodeBatchIdentityType::CREATE_TIME: goto NgRPv; fyNl0: break; goto Y3dH6; JsL3S: $VQzEU = $VQzEU->where('created_at', '>=', $P1CdK['fromCreateTimeStart'])->where('created_at', '<=', $P1CdK['fromCreateTimeEnd']); goto fyNl0; NgRPv: BizException::throwsIfEmpty('创建开始时间为空', $P1CdK['fromCreateTimeStart']); goto odCik; odCik: BizException::throwsIfEmpty('创建结束时间为空', $P1CdK['fromCreateTimeEnd']); goto JsL3S; Y3dH6: default: BizException::throws('防伪码范围为空'); } $HRaLB = intval($VQzEU->update($iUhMB)); return Response::generateSuccess('成功更新 ' . $HRaLB . ' 条记录'); }); } goto Uz1VN; mLkys: $HFZFF = Form::make('')->formClass('wide'); goto kN9sC; ZImwE: } public function export(AdminPage $pI9Cu) { goto od9XO; od9XO: $HFZFF = Form::make('')->formClass('wide'); goto ooA9q; ooA9q: $HFZFF->radio('modifyType', '防伪码范围')->optionType(CodeBatchIdentityType::class)->defaultValue(CodeBatchIdentityType::TRANSPORT_CODE)->when(CodeBatchIdentityType::TRANSPORT_CODE, function (Form $HFZFF) { $HFZFF->textarea('fromTransportCodeTransportCodes', '录入物流码')->placeholder('一行一个，回车换行 , 支持扫描枪')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::ID_RANGE, function (Form $HFZFF) { $HFZFF->number('fromIdRangeStart', 'ID范围最小值')->placeholder('')->help('包含该值'); $HFZFF->number('fromIdRangeEnd', 'ID范围最大值')->placeholder('')->help('包含该值'); })->when(CodeBatchIdentityType::BATCH, function (Form $HFZFF) { $HFZFF->text('fromBatchBatch', '批次')->help('录入物流码，支持扫描枪'); })->when(CodeBatchIdentityType::PRODUCT, function (Form $HFZFF) { $HFZFF->select('fromProductProductId', '防伪码所属产品')->optionModel('tracking_product', 'id', 'title'); })->when(CodeBatchIdentityType::CREATE_TIME, function (Form $HFZFF) { $HFZFF->datetime('fromCreateTimeStart', '创建开始时间')->help('包含该时间'); $HFZFF->datetime('fromCreateTimeEnd', '创建结束时间')->help('包含该时间'); }); goto Xp01r; b6pge: $HFZFF->ajax(false); goto H6_Dn; Xp01r: if (Request::isPost()) { goto xjSBu; TXVDd: return Excel::create('防伪码_' . date('Ymd_His'), function ($uE5gc) use($B5N9l) { $uE5gc->sheet('Data', function ($NhH2_) use($B5N9l) { $f2t5U = array(); for ($IEIMr = 0; $IEIMr < count($B5N9l[0]); $IEIMr++) { $f2t5U[\PHPExcel_Cell::stringFromColumnIndex($IEIMr)] = '@'; } $NhH2_->setColumnFormat($f2t5U); $NhH2_->setAutoSize(true); $NhH2_->rows($B5N9l, true); }); })->export('xlsx'); goto Xv6Df; bGjqv: foreach ($Y1ykT as $F80_3) { $B5N9l[] = array($F80_3['id'], Request::domainUrl() . modstart_web_url('tracking/show/code_' . $F80_3['code']), $F80_3['code'], $F80_3['batch'], $F80_3['verifyCode'], $F80_3['transportCode'], $F80_3['created_at'], $F80_3['_product'] ? $F80_3['_product']['title'] : $F80_3['productId'], $F80_3['_agent'] ? $F80_3['_agent']['name'] : $F80_3['agentId'], $F80_3['enable'] ? '是' : '否'); } goto TXVDd; xjSBu: $XJnSC = $HFZFF->formRequest(function (Form $HFZFF) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $VQzEU = ModelUtil::model('tracking_code'); switch ($P1CdK['modifyType']) { case CodeBatchIdentityType::TRANSPORT_CODE: goto rFVPH; WSGqk: $Dha5w = CodeUtil::transportCodeTextToCodes($P1CdK['fromTransportCodeTransportCodes']); goto BD8ob; BD8ob: BizException::throwsIfEmpty('物流码为空', $Dha5w); goto hdR53; hdR53: $VQzEU = $VQzEU->whereIn('transportCode', $Dha5w); goto uTY2K; rFVPH: BizException::throwsIfEmpty('物流码为空', $P1CdK['fromTransportCodeTransportCodes']); goto WSGqk; uTY2K: break; goto XFkTt; XFkTt: case CodeBatchIdentityType::ID_RANGE: goto UBC5s; JgK2F: $VQzEU = $VQzEU->where('id', '>=', $P1CdK['fromIdRangeStart'])->where('id', '<=', $P1CdK['fromIdRangeEnd']); goto dG5Bx; eG6bV: BizException::throwsIfEmpty('ID范围最大值为空', $P1CdK['fromIdRangeEnd']); goto JgK2F; UBC5s: BizException::throwsIfEmpty('ID范围最小值为空', $P1CdK['fromIdRangeStart']); goto eG6bV; dG5Bx: break; goto XLrg0; XLrg0: case CodeBatchIdentityType::BATCH: goto rjGd6; rjGd6: BizException::throwsIfEmpty('批次为空', $P1CdK['fromBatchBatch']); goto gauCI; BBun8: break; goto jo7Je; gauCI: $VQzEU = $VQzEU->where('batch', $P1CdK['fromBatchBatch']); goto BBun8; jo7Je: case CodeBatchIdentityType::PRODUCT: goto dOEfh; dOEfh: BizException::throwsIfEmpty('批次为空', $P1CdK['fromProductProductId']); goto gbsSN; gbsSN: $VQzEU = $VQzEU->where('productId', $P1CdK['fromProductProductId']); goto teieo; teieo: break; goto hFILG; hFILG: case CodeBatchIdentityType::CREATE_TIME: goto Qln65; c2R4R: $VQzEU = $VQzEU->where('created_at', '>=', $P1CdK['fromCreateTimeStart'])->where('created_at', '<=', $P1CdK['fromCreateTimeEnd']); goto t9T13; t9T13: break; goto YvLW5; F4TVG: BizException::throwsIfEmpty('创建结束时间为空', $P1CdK['fromCreateTimeEnd']); goto c2R4R; Qln65: BizException::throwsIfEmpty('创建开始时间为空', $P1CdK['fromCreateTimeStart']); goto F4TVG; YvLW5: default: BizException::throws('防伪码范围为空'); } return Response::generateSuccessData(array('records' => $VQzEU->get(array('*'))->toArray())); }); goto g3DCc; D6baD: ModelUtil::join($Y1ykT, 'productId', '_product', 'tracking_product'); goto DB8mt; u9tXz: $Y1ykT = $XJnSC['data']['records']; goto D6baD; MrJr4: $B5N9l = array(array('ID', '二维码', '防伪码', '批次', '校验码', '物流码', '创建时间', '产品', '经销商', '启用')); goto bGjqv; YJjfD: $XJnSC = $XJnSC->getData(true); goto u9tXz; g3DCc: if (Response::isError($XJnSC)) { return Response::sendFromGenerate($XJnSC); } goto YJjfD; DB8mt: ModelUtil::join($Y1ykT, 'agentId', '_agent', 'tracking_agent'); goto MrJr4; Xv6Df: } goto b6pge; H6_Dn: return $pI9Cu->pageTitle('批量导出防伪码')->row(new Box($HFZFF, '批量导出防伪码')); goto NRpcj; NRpcj: } }