<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberPasswordStrength; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($fJoR1) { return ModelUtil::get('member_user', array('id' => $fJoR1)); } public static function getCached($fJoR1) { return Cache::remember('MemberUser:' . $fJoR1, 60, function () use($fJoR1) { return self::get($fJoR1); }); } public static function processDefault(&$EZRTY) { goto JN7CR; G4j07: if (empty($EZRTY['avatarBig'])) { $EZRTY['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto iitzs; E2Gpz: if (empty($EZRTY['nickname'])) { } goto UsLwp; UsLwp: if (empty($EZRTY['avatar'])) { $EZRTY['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto MRGeg; JN7CR: if (empty($EZRTY)) { return; } goto E2Gpz; MRGeg: if (empty($EZRTY['avatarMedium'])) { $EZRTY['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto G4j07; iitzs: } private static function processBasicFields($uSFo7) { goto FyL0d; Fc5Gb: return $uSFo7; goto CLEBa; FyL0d: $JOao6 = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto L13Rt; L13Rt: if (null === $uSFo7) { $uSFo7 = $JOao6; } else { goto V1fs0; V1fs0: $A011B = array(); goto Pr_Nm; Pr_Nm: foreach ($uSFo7 as $IoVG6) { if ('<basic>' == $IoVG6) { $A011B = array_merge($A011B, $JOao6); } else { $A011B[] = $IoVG6; } } goto DSY3O; DSY3O: $uSFo7 = $A011B; goto oqxOw; oqxOw: } goto Fc5Gb; CLEBa: } public static function fixAvatar($YSWtX) { return AssetsUtil::fixFullOrDefault($YSWtX, 'asset/image/avatar.svg'); } public static function getBasic($fJoR1, $uSFo7 = null) { goto vgTiU; ga2aq: if (empty($BB065['nickname'])) { $BB065['nickname'] = $BB065['username']; } goto LOWOL; LOWOL: $BB065['avatar'] = self::fixAvatar($BB065['avatar']); goto GLE3F; vgTiU: $uSFo7 = self::processBasicFields($uSFo7); goto bjWnn; mlMCx: return $UdT_r; goto WCXGU; Ddp_i: foreach ($uSFo7 as $THIAq) { if (isset($BB065[$THIAq])) { $UdT_r[$THIAq] = $BB065[$THIAq]; } else { $UdT_r[$THIAq] = null; } } goto mlMCx; tVSMe: if (empty($BB065)) { return null; } goto ga2aq; bjWnn: $BB065 = self::get($fJoR1); goto tVSMe; GLE3F: $UdT_r = array(); goto Ddp_i; WCXGU: } public static function listViewName($g3N_W) { goto g12A_; F6x4h: return $iWNff; goto JEsJm; x9wnB: $toF0T = ModelUtil::allIn('member_user', 'id', $g3N_W); goto zxS0G; g12A_: $iWNff = array(); goto x9wnB; zxS0G: foreach ($toF0T as $EZRTY) { $iWNff[] = self::viewName($EZRTY); } goto F6x4h; JEsJm: } public static function listUsers($g3N_W) { return ModelUtil::allIn('member_user', 'id', $g3N_W); } public static function convertOneToBasic($EZRTY) { return array('id' => $EZRTY['id'], 'username' => $EZRTY['username'], 'nickname' => empty($EZRTY['nickname']) ? $EZRTY['username'] : $EZRTY['nickname'], 'created_at' => $EZRTY['created_at'], 'signature' => isset($EZRTY['signature']) ? $EZRTY['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($EZRTY['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($toF0T) { return array_map(function ($BB065) { return array('id' => $BB065['id'], 'username' => $BB065['username'], 'nickname' => empty($BB065['nickname']) ? $BB065['username'] : $BB065['nickname'], 'created_at' => $BB065['created_at'], 'signature' => isset($BB065['signature']) ? $BB065['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($BB065['avatar'], 'asset/image/avatar.svg')); }, $toF0T); } public static function listUsersBasic($g3N_W) { return self::convertToBasic(self::listUsers($g3N_W)); } public static function getViewName($fJoR1) { return self::viewName(self::get($fJoR1)); } public static function viewNameById($fJoR1) { return self::viewName(self::get($fJoR1)); } public static function viewName($EZRTY) { goto lwbqK; VElYu: if (empty($EZRTY)) { return '-'; } goto y_mKG; ifrea: return "ID-{$EZRTY['id']}"; goto SQ_bi; y_mKG: if (!empty($EZRTY['nickname'])) { return $EZRTY['nickname']; } goto Xb_ZG; lwbqK: if ($EZRTY && is_numeric($EZRTY)) { return self::viewNameById($EZRTY); } goto VElYu; Xb_ZG: if (!empty($EZRTY['username'])) { return $EZRTY['username']; } goto ifrea; SQ_bi: } public static function update($fJoR1, $P1CdK) { return ModelUtil::update('member_user', array('id' => $fJoR1), $P1CdK); } public static function updateBasicWithUniqueCheck($fJoR1, $P1CdK) { goto Cutfd; GwTYx: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $ccNNj => $jHfVM) { if (isset($P1CdK[$ccNNj])) { goto HJcs2; bcfpb: if (count($ejNxC) == 1) { if ($ejNxC[0]['id'] != $fJoR1) { return Response::generate(-1, $jHfVM . '重复'); } } goto hGav2; HJcs2: if (empty($P1CdK[$ccNNj])) { $P1CdK[$ccNNj] = null; continue; } goto e2Cf4; Y_0jH: if (count($ejNxC) > 1) { return Response::generate(-1, $jHfVM . '重复'); } goto bcfpb; e2Cf4: $ejNxC = ModelUtil::all('member_user', array($ccNNj => $P1CdK[$ccNNj])); goto Y_0jH; hGav2: } } goto N9GV3; Cutfd: if (empty($P1CdK)) { return Response::generate(0, 'ok'); } goto GwTYx; N9GV3: self::update($fJoR1, $P1CdK); goto HGpgZ; HGpgZ: return Response::generate(0, 'ok'); goto VKfFs; VKfFs: } public static function login($mKcTY = '', $LAVo8 = '', $p0fDQ = '', $n4bwG = '') { goto FSMQA; UGW2T: MemberUserLoginAttemptEvent::fire($EZRTY['id'], Request::ip(), AgentUtil::getUserAgent()); goto zLYhG; Smlc9: $mKcTY = trim($mKcTY); goto frFR5; cgkrb: if ($p0fDQ) { if (!FormatUtil::isEmail($p0fDQ)) { return Response::generate(-3, '邮箱格式不正确'); } $IcTkS = array('email' => $p0fDQ); } else { if ($LAVo8) { if (!preg_match('/(^1[0-9]{10}$)/', $LAVo8)) { return Response::generate(-4, '手机格式不正确'); } $IcTkS = array('phone' => $LAVo8); } else { if ($mKcTY) { if (strpos($mKcTY, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $IcTkS = array('username' => $mKcTY); } } } goto UvDBv; xReRY: if (!$n4bwG) { return Response::generate(-2, '密码为空'); } goto cgkrb; UvDBv: $EZRTY = ModelUtil::get('member_user', $IcTkS); goto HSo1u; FSMQA: $p0fDQ = trim($p0fDQ); goto XsgOc; F5I0T: return Response::generateSuccessData($EZRTY); goto V5640; cWAln: switch ($EZRTY['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto F5I0T; frFR5: if (!($p0fDQ || $LAVo8 || $mKcTY)) { return Response::generate(-1, '所有登录字段均为空'); } goto xReRY; HSo1u: if (empty($EZRTY)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto UGW2T; zLYhG: if ($EZRTY['password'] != EncodeUtil::md5WithSalt($n4bwG, $EZRTY['passwordSalt'])) { MemberUserLoginFailedEvent::fire($EZRTY['id'], $EZRTY['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto cWAln; XsgOc: $LAVo8 = trim($LAVo8); goto Smlc9; V5640: } public static function autoSetUsernameNickname($OUoxR, $y4jkz) { goto RPHeS; eEkbp: if (preg_match('/\\{.*\\}/', $y4jkz)) { goto ohRof; VgUxs: $kvpkQ = array('{Phone}' => $EZRTY['phone'], '{Phone4}' => substr($EZRTY['phone'], 7), '{Uid}' => $EZRTY['id']); goto HoAWw; ohRof: $EZRTY = self::get($OUoxR); goto VgUxs; HoAWw: $y4jkz = str_replace(array_keys($kvpkQ), array_values($kvpkQ), $y4jkz); goto Duon9; Duon9: $oS6KR = 0; goto MgxzO; MgxzO: } goto TqIUB; RPHeS: $oS6KR = 6; goto eEkbp; TqIUB: self::suggestUsernameNickname($OUoxR, $y4jkz, $oS6KR); goto hF61f; hF61f: } public static function getSuggestUsernameNickname($OPG_W) { goto X_o2W; QUkvH: return $y4jkz . Str::random(10); goto N9FWK; X_o2W: $y4jkz = $OPG_W . Str::random(1); goto vbVSa; vbVSa: for ($IEIMr = 0; $IEIMr < 20; $IEIMr++) { $QEpY9 = ModelUtil::model('member_user')->where(array('username' => $y4jkz))->orWhere(array('nickname' => $y4jkz))->first(); if (empty($QEpY9)) { return $y4jkz; } $y4jkz = $y4jkz . Str::random(1); } goto QUkvH; N9FWK: } private static function suggestUsernameNickname($OUoxR, $ip1iL = '用户', $oS6KR = 6) { goto NPDD4; cS_Ko: for ($IEIMr = 0; $IEIMr < 20; $IEIMr++) { $QEpY9 = ModelUtil::model('member_user')->where(array('username' => $y4jkz))->orWhere(array('nickname' => $y4jkz))->first(); if (empty($QEpY9)) { break; } $y4jkz = $y4jkz . Str::random(1); } goto r9m2R; r9m2R: ModelUtil::update('member_user', $OUoxR, array('username' => $y4jkz, 'nickname' => $y4jkz)); goto Jt2Sg; NPDD4: if ($oS6KR > 0) { $y4jkz = $ip1iL . RandomUtil::string($oS6KR); } else { $y4jkz = $ip1iL; } goto cS_Ko; Jt2Sg: } public static function registerId($fJoR1, $P1CdK = array()) { $EZRTY = ModelUtil::insert('member_user', array_merge(array('id' => $fJoR1, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $P1CdK)); return Response::generate(0, 'ok', $EZRTY); } public static function registerUsername($mKcTY) { return self::register($mKcTY, '', '', '', true); } public static function registerUsernameQuick($mKcTY) { goto qIHWt; Kf1tO: return Response::generateError('注册失败'); goto CKbmM; cUAm9: for ($IEIMr = 0; $IEIMr < 10; $IEIMr++) { $XJnSC = self::register($WszpM, '', '', '', true); if ($XJnSC['code']) { $WszpM = $WszpM . Str::random(1); } else { return $XJnSC; } } goto Kf1tO; qIHWt: $WszpM = $mKcTY; goto cUAm9; CKbmM: } public static function register($mKcTY = '', $LAVo8 = '', $p0fDQ = '', $n4bwG = '', $Ftv3f = false, $FlBDj = array()) { goto TabQQ; zmWmJ: if ($mKcTY) { goto LxL_U; LxL_U: $XJnSC = self::uniqueCheck('username', $mKcTY); goto gMZFz; Y7h2i: if (strlen($mKcTY) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto fUUSg; oOhRR: if (preg_match('/^[0-9]{11}$/', $mKcTY)) { return Response::generate(-1, '用户名不能为纯数字'); } goto LWsqy; gMZFz: if ($XJnSC['code']) { return $XJnSC; } goto Y7h2i; fUUSg: if (Str::contains($mKcTY, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto oOhRR; LWsqy: } else { $mKcTY = null; } goto LGg74; TabQQ: $FlBDj = array_merge(array('nickname' => $mKcTY), $FlBDj); goto vK7P5; LNm4A: $Gelze = Str::random(16); goto LmLPr; vK7P5: if (empty($FlBDj['nickname'])) { $FlBDj['nickname'] = null; } goto Kabip; LmLPr: $EZRTY = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $mKcTY, 'email' => $p0fDQ, 'phone' => $LAVo8, 'nickname' => $FlBDj['nickname'], 'password' => $Ftv3f ? null : EncodeUtil::md5WithSalt($n4bwG, $Gelze), 'passwordSalt' => $Ftv3f ? null : $Gelze, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto MDwfO; EK1Yz: $mKcTY = trim($mKcTY); goto v8Q8A; v8Q8A: if (!($p0fDQ || $LAVo8 || $mKcTY || $FlBDj['nickname'])) { return Response::generate(-1, '所有注册字段均为空'); } goto XM_Px; k27RY: $LAVo8 = trim($LAVo8); goto EK1Yz; LGg74: if (!$Ftv3f) { goto I4zqN; cnEUB: $XJnSC = self::passwordStrengthCheck($n4bwG); goto gTr4G; gTr4G: if (Response::isError($XJnSC)) { return Response::generate(-1, $XJnSC['msg']); } goto mL_uE; I4zqN: if (empty($n4bwG)) { return Response::generate(-3, '密码不合法'); } goto cnEUB; mL_uE: } goto LNm4A; Kabip: $p0fDQ = trim($p0fDQ); goto k27RY; i0pS8: if ($LAVo8) { $XJnSC = self::uniqueCheck('phone', $LAVo8); if ($XJnSC['code']) { return $XJnSC; } } else { $LAVo8 = null; } goto zmWmJ; XM_Px: if ($p0fDQ) { $XJnSC = self::uniqueCheck('email', $p0fDQ); if ($XJnSC['code']) { return $XJnSC; } } else { $p0fDQ = null; } goto i0pS8; MDwfO: return Response::generate(0, 'ok', $EZRTY); goto fHjEB; fHjEB: } public static function uniqueCheck($UY7c0, $BEhJZ, $iiIp2 = 0) { goto t7nqL; yJlFU: return Response::generate(-2, $u87nl[$UY7c0] . '已经被占用'); goto mus5c; wGOVq: $EZRTY = ModelUtil::get('member_user', array($UY7c0 => $BEhJZ)); goto UwNV7; aePTD: if ($iiIp2 == $EZRTY['id']) { return Response::generate(0, 'ok'); } goto yJlFU; t7nqL: $BEhJZ = trim($BEhJZ); goto WvVTe; WvVTe: switch ($UY7c0) { case 'email': if (!FormatUtil::isEmail($BEhJZ)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $BEhJZ)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($BEhJZ, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $UY7c0); } goto wGOVq; urm95: $u87nl = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto aePTD; UwNV7: if (empty($EZRTY)) { return Response::generate(0, 'ok'); } goto urm95; mus5c: } public static function getByUsername($mKcTY) { return ModelUtil::get('member_user', array('username' => $mKcTY)); } public static function getByEmail($p0fDQ) { return ModelUtil::get('member_user', array('email' => $p0fDQ)); } public static function getByPhone($LAVo8) { return ModelUtil::get('member_user', array('phone' => $LAVo8)); } public static function changeNickname($OUoxR, $xqqzT) { goto aPhom; v1Rr5: ModelUtil::update('member_user', $OUoxR, array('nickname' => $xqqzT)); goto twtU5; twtU5: return Response::generate(0, 'ok'); goto Yo2Zu; vmtwt: if (Response::isError($XJnSC)) { return $XJnSC; } goto v1Rr5; aPhom: $XJnSC = self::uniqueCheck('nickname', $xqqzT, $OUoxR); goto vmtwt; Yo2Zu: } public static function changePassword($OUoxR, $aMv2I, $Qa5ML = null, $b8T6w = false) { goto Nv_Hx; yjo1H: if (empty($aMv2I)) { return Response::generate(-1, '新密码为空'); } goto kltGL; Nv_Hx: if (!$b8T6w && empty($Qa5ML)) { return Response::generate(-1, '旧密码不能为空'); } goto myi7t; KvBr1: if (Response::isError($XJnSC)) { return Response::generate(-1, $XJnSC['msg']); } goto Z3cj4; kltGL: $XJnSC = self::passwordStrengthCheck($aMv2I); goto KvBr1; x6_J2: $Gelze = Str::random(16); goto EN4c2; NCD93: return Response::generate(0, 'ok'); goto Ilw3k; myi7t: $EZRTY = ModelUtil::get('member_user', array('id' => $OUoxR)); goto Ed33k; Z3cj4: if (!$b8T6w && EncodeUtil::md5WithSalt($Qa5ML, $EZRTY['passwordSalt']) != $EZRTY['password']) { return Response::generate(-1, '旧密码不正确'); } goto x6_J2; EN4c2: ModelUtil::update('member_user', array('id' => $EZRTY['id']), array('passwordSalt' => $Gelze, 'password' => EncodeUtil::md5WithSalt($aMv2I, $Gelze))); goto NCD93; Ed33k: if (empty($EZRTY)) { return Response::generate(-1, '用户不存在'); } goto yjo1H; Ilw3k: } public static function setAvatar($UOBbe, $c0z3N, $mMX01 = 'jpg') { goto Gt1ra; zeOnE: $EZRTY = self::get($UOBbe); goto ZDRHB; VJrcD: return Response::generateSuccess(); goto wy3Yc; LAEMv: $XJnSC = DataManager::upload('image', 'U_' . $UOBbe . '_Avatar.' . $mMX01, $CJITH, null, $cwE9f); goto uXKNu; zVFTj: if ($s8gM9['code']) { DataManager::deleteById($tHYny['data']['id']); if ($tHYny['code']) { return Response::generate(-1, '头像存储失败（' . $s8gM9['msg'] . '）'); } } goto LAEMv; pdKAm: if ($tHYny['code']) { return Response::generate(-1, '头像存储失败（' . $tHYny['msg'] . '）'); } goto OVoeI; OVoeI: $s8gM9 = DataManager::upload('image', 'U' . $UOBbe . '_AvatarMiddle.' . $mMX01, $Cw6K3, null, $cwE9f); goto zVFTj; j0EIr: $tHYny = DataManager::upload('image', 'U' . $UOBbe . '_AvatarBig.' . $mMX01, $s4X1P, null, $cwE9f); goto pdKAm; KVuYV: self::update($EZRTY['id'], array('avatarBig' => $tHYny['data']['fullPath'], 'avatarMedium' => $s8gM9['data']['fullPath'], 'avatar' => $XJnSC['data']['fullPath'])); goto VJrcD; sYNtm: $cwE9f = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto j0EIr; yY14_: $Cw6K3 = (string) Image::make($c0z3N)->resize(200, 200)->encode($mMX01, 75); goto eZru0; R29Uj: $s4X1P = (string) Image::make($c0z3N)->resize(400, 400)->encode($mMX01, 75); goto yY14_; uXKNu: if ($XJnSC['code']) { goto wUBct; Aryra: DataManager::deleteById($s8gM9['data']['id']); goto BsjX_; BsjX_: if ($tHYny['code']) { return Response::generate(-1, '头像存储失败（' . $XJnSC['msg'] . '）'); } goto ZSZ96; wUBct: DataManager::deleteById($tHYny['data']['id']); goto Aryra; ZSZ96: } goto KVuYV; eZru0: $CJITH = (string) Image::make($c0z3N)->resize(50, 50)->encode($mMX01, 75); goto sYNtm; ZDRHB: if (empty($EZRTY)) { return Response::generate(-1, '用户不存在'); } goto N0Jqy; N0Jqy: if (empty($c0z3N)) { return Response::generate(-1, '图片数据为空'); } goto R29Uj; Gt1ra: if (!in_array($mMX01, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto zeOnE; wy3Yc: } public static function findUsers($QrNOL) { goto FIjzb; xbCp0: $wkM8c = array(); goto Q5rNq; FIjzb: if (empty($QrNOL)) { return array(); } goto xbCp0; srbdG: foreach ($toF0T as &$Yia42) { $wkM8c[$Yia42->id] = $Yia42->toArray(); } goto zdV0m; zdV0m: return $wkM8c; goto m_Za2; Q5rNq: $toF0T = ModelUtil::model('member_user')->whereIn('id', $QrNOL)->get(); goto srbdG; m_Za2: } public static function filterUserIds($QrNOL) { goto ILHUf; mCIQF: $kvpkQ = array(); goto dMy5x; dMy5x: $toF0T = ModelUtil::model('member_user')->whereIn('id', $QrNOL)->get(array('id')); goto qRj7n; qRj7n: foreach ($toF0T as &$Yia42) { $kvpkQ[$Yia42->id] = true; } goto rLM37; rLM37: return array_keys($kvpkQ); goto TAI4V; ILHUf: if (empty($QrNOL)) { return array(); } goto mCIQF; TAI4V: } public static function mergeMemberUsers(&$Y1ykT, $cILnL = 'memberUserId', $g48cp = '_memberUser') { ModelUtil::join($Y1ykT, $cILnL, $g48cp, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$Y1ykT, $cILnL = 'memberUserId', $g48cp = '_memberUser', $uSFo7 = null) { $uSFo7 = self::processBasicFields($uSFo7); if (is_array($Y1ykT)) { ModelUtil::join($Y1ykT, $cILnL, $g48cp, 'member_user', 'id'); foreach ($Y1ykT as $IoVG6 => $cdzcv) { goto wXmZJ; WeqI_: $Y1ykT[$IoVG6][$g48cp] = $EZRTY; goto L3QhE; IRPTJ: if (empty($EZRTY['avatar'])) { $EZRTY['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $EZRTY['avatar'] = AssetsUtil::fixFull($EZRTY['avatar']); } goto WeqI_; wXmZJ: if (empty($cdzcv[$g48cp])) { continue; } goto zSoNA; HSeia: if (empty($EZRTY['nickname'])) { $EZRTY['nickname'] = $EZRTY['username']; } goto IRPTJ; zSoNA: $EZRTY = ArrayUtil::keepKeys($cdzcv[$g48cp], $uSFo7); goto HSeia; L3QhE: } } else { ModelUtil::joinItems($Y1ykT, $cILnL, $g48cp, 'member_user', 'id'); foreach ($Y1ykT as $BB065) { goto lQH1R; GZvJn: if (empty($EZRTY['nickname'])) { $EZRTY['nickname'] = $EZRTY['username']; } goto UjPxc; WqNSH: $BB065->{$g48cp} = $EZRTY; goto UKzEF; lQH1R: if (empty($BB065->{$g48cp})) { continue; } goto SQ1YH; SQ1YH: $EZRTY = ArrayUtil::keepKeys($BB065->{$g48cp}, $uSFo7); goto GZvJn; UjPxc: if (empty($EZRTY['avatar'])) { $EZRTY['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $EZRTY['avatar'] = AssetsUtil::fixFull($EZRTY['avatar']); } goto WqNSH; UKzEF: } } } public static function insert($P1CdK) { return ModelUtil::insert('member_user', $P1CdK); } public static function getIdByOauth($kITg0, $vuFID) { goto behBV; BIOCv: if (empty($yUwG3)) { return 0; } goto oFMkz; oFMkz: return intval($yUwG3['memberUserId']); goto NElVV; behBV: $yUwG3 = ModelUtil::get('member_oauth', array('type' => $kITg0, 'openId' => $vuFID)); goto BIOCv; NElVV: } public static function getIdByOauthAndCheck($kITg0, $vuFID) { goto zRhlm; TdxQO: MemberUtil::forgetOauth($kITg0, $vuFID); goto ukU1f; M1dns: if (self::get($OUoxR)) { return $OUoxR; } goto TdxQO; ukU1f: return 0; goto ETmOb; zRhlm: $OUoxR = self::getIdByOauth($kITg0, $vuFID); goto M1dns; ETmOb: } public static function getOauthOpenId($OUoxR, $kITg0) { goto mHqKV; I1UAc: return $yUwG3['openId']; goto KqVcq; mHqKV: $IcTkS = array('memberUserId' => $OUoxR, 'type' => $kITg0); goto qppPn; SVf7i: if (empty($yUwG3)) { return null; } goto I1UAc; qppPn: $yUwG3 = ModelUtil::get('member_oauth', $IcTkS); goto SVf7i; KqVcq: } public static function getOauth($OUoxR, $kITg0) { $IcTkS = array('memberUserId' => $OUoxR, 'type' => $kITg0); return ModelUtil::get('member_oauth', $IcTkS); } public static function listOauths($OUoxR) { return ModelUtil::all('member_oauth', array('memberUserId' => $OUoxR), array('*'), array('type', 'asc')); } public static function putOauth($OUoxR, $kITg0, $vuFID, $wDR0m = array()) { goto z1Y2o; Et27J: if (empty($yUwG3)) { ModelUtil::delete('member_oauth', array('type' => $kITg0, 'openId' => $vuFID)); ModelUtil::insert('member_oauth', array_merge($IcTkS, $iUhMB)); } else { if ($yUwG3['openId'] != $vuFID) { ModelUtil::update('member_oauth', $yUwG3['id'], $iUhMB); } } goto XPfeu; o5T09: $iUhMB = array_merge(array('openId' => $vuFID), $wDR0m); goto Et27J; JpeyL: $yUwG3 = ModelUtil::get('member_oauth', $IcTkS); goto o5T09; z1Y2o: $IcTkS = array('memberUserId' => $OUoxR, 'type' => $kITg0); goto p2kzC; p2kzC: $U1Z02 = "MemberOauth:{$OUoxR}"; goto vpkuk; XPfeu: LockUtil::release($U1Z02); goto cBOh1; vpkuk: if (!LockUtil::acquire($U1Z02)) { BizException::throws('正在处理中，请稍后再试'); } goto JpeyL; cBOh1: } public static function forgetOauth($kITg0, $vuFID) { ModelUtil::delete('member_oauth', array('type' => $kITg0, 'openId' => $vuFID)); } public static function updateNewMessageStatus($OUoxR) { ModelUtil::update('member_user', array('id' => $OUoxR), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $OUoxR, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($OUoxR) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $OUoxR), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $OUoxR)))); } } public static function paginate($pI9Cu, $qzgph, $b7bLh = array()) { return ModelUtil::paginate('member_user', $pI9Cu, $qzgph, $b7bLh); } public static function updateStatus($ewJLw, $KLHoy) { goto b4xWb; EO7o9: ModelUtil::model('member_user')->whereIn('id', $ewJLw)->update(array('status' => $KLHoy)); goto A3_Tc; dt4Ul: if (empty($ewJLw)) { return; } goto EO7o9; b4xWb: if (!is_array($ewJLw)) { $ewJLw = array($ewJLw); } goto dt4Ul; A3_Tc: } public static function delete($OUoxR) { goto ONLv8; pDXsm: ModelUtil::transactionCommit(); goto zTN7e; tBYDu: ModelUtil::update('member_user', $OUoxR, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto pDXsm; Hqhgh: $hsI71 = ModelUtil::all('member_oauth', array('memberUserId' => $EZRTY['id'])); goto R0vNm; ZTIe6: ModelUtil::insert('member_deleted', array('id' => $EZRTY['id'], 'username' => $EZRTY['username'], 'phone' => $EZRTY['phone'], 'email' => $EZRTY['email'], 'content' => SerializeUtil::jsonEncode($o8ZCj))); goto tBYDu; ONLv8: $EZRTY = self::get($OUoxR); goto RZSum; R0vNm: $o8ZCj['oauth'] = ArrayUtil::keepItemsKeys($hsI71, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto ZTIe6; zO9LZ: ModelUtil::transactionBegin(); goto v58mQ; v58mQ: $o8ZCj = array(); goto Hqhgh; RZSum: BizException::throwsIfEmpty('用户不存在', $EZRTY); goto zO9LZ; zTN7e: } public static function fireLogin($OUoxR) { goto siL2B; QJMY6: ModelUtil::insert('member_login_log', array('memberUserId' => $OUoxR, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($E9mpE, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto x4fYz; siL2B: $E9mpE = Request::ip(); goto VJ60E; VJ60E: ModelUtil::update('member_user', $OUoxR, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($E9mpE, 20))); goto QJMY6; x4fYz: } public static function passwordStrengthCheck($n4bwG) { goto t_UcO; us4Rz: switch ($P0PlB) { case MemberPasswordStrength::NO_LIMIT: break; case MemberPasswordStrength::STRENGTH_2: if (StrUtil::passwordStrength($n4bwG) < 2) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 2种以上'); } break; case MemberPasswordStrength::STRENGTH_3: if (StrUtil::passwordStrength($n4bwG) < 3) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 3种以上'); } break; } goto OaNKx; EYri2: $P0PlB = modstart_config('Member_PasswordStrength', MemberPasswordStrength::NO_LIMIT); goto us4Rz; OR7W4: if ($Ddg44 > 0) { if (strlen($n4bwG) < $Ddg44) { return Response::generateError('密码长度不能小于' . $Ddg44 . '位'); } } goto EYri2; t_UcO: $Ddg44 = modstart_config('Member_PasswordLengthMin', 0); goto OR7W4; OaNKx: return Response::generateSuccess(); goto XlvGo; XlvGo: } }