<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\Box; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Events\MemberUserVipChangeEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $p5Kcp) { $p5Kcp->init('member_user')->field(function ($p5Kcp) { $p5Kcp->id('id', 'ID'); MemberAdminList::callGridField($p5Kcp); $p5Kcp->display('avatar', '头像')->hookRendering(function (AbstractField $ccNNj, $BB065, $uM5KM) { $sJtOY = AssetsUtil::fixOrDefault($BB065->avatar, 'asset/image/avatar.svg'); $M6JWG = AssetsUtil::fixOrDefault($BB065->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$M6JWG}' class='tw-inline-block' data-image-preview>\n                        <img src='{$sJtOY}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $p5Kcp->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $ccNNj, $BB065, $uM5KM) { switch ($ccNNj->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($BB065->username), modstart_admin_url('member/show', array('_id' => $BB065->id)))->width('90%')->height('90%')->render()); break; } }); $p5Kcp->text('email', '邮箱'); $p5Kcp->text('phone', '手机'); $p5Kcp->text('nickname', '昵称')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $ccNNj, $BB065, $uM5KM) { switch ($ccNNj->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($BB065->username), modstart_admin_url('member/show', array('_id' => $BB065->id)))->width('90%')->height('90%')->render()); break; } }); if (MemberOauth::hasEnableItems()) { $p5Kcp->display('_oauth', '授权')->hookRendering(function (AbstractField $ccNNj, $BB065, $uM5KM) { $cu2Bn = array(); $jmR75 = MemberUtil::listOauths($BB065->id); foreach ($jmR75 as $Djrl6) { goto c1niC; gGyuY: $N_d2A = MemberOauth::getByOauthKey($Djrl6['type']); goto R082w; d61n9: $jRs5c = $Djrl6['type']; goto gGyuY; c1niC: $LUGmR = null; goto x0luL; R082w: if ($N_d2A) { goto kfIj4; kfIj4: $LUGmR = $N_d2A->color(); goto nZgHp; wxRiJ: if (method_exists($N_d2A, 'icon')) { $HiQup = $N_d2A->icon(); } goto ml39_; nZgHp: $jRs5c = $N_d2A->title(); goto wxRiJ; ml39_: } goto DE1QD; x0luL: $HiQup = 'iconfont icon-dot'; goto d61n9; CFKzA: $cu2Bn[] = join('', array("<a style='color:{$LUGmR};'", 'href=\'javascript:;\'', "data-tip-popover='{$jRs5c}'", 'data-dialog-request=\'' . modstart_admin_url('member/oauth', array('_id' => $BB065->id)) . '\'', "><i class='{$HiQup}'></i></a>")); goto dz22L; DE1QD: if (empty($LUGmR)) { $LUGmR = ColorUtil::pick($Djrl6['type']); } goto CFKzA; dz22L: } return join('', $cu2Bn); }); } $p5Kcp->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $YBWul = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($YBWul) { $p5Kcp->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $SILae = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($SILae) { $p5Kcp->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $p5Kcp->date('vipExpire', 'VIP过期'); } $p5Kcp->display('registerIp', '注册IP'); $p5Kcp->display('created_at', '注册时间'); $p5Kcp->canBatchSelect(true); $p5Kcp->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $hxiq7) { $hxiq7->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $hxiq7) { $hxiq7->eq('id', L('ID')); $hxiq7->like('username', '用户名'); $hxiq7->like('email', '邮箱')->autoHide(true); $hxiq7->like('phone', '手机')->autoHide(true); $hxiq7->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $hxiq7->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $hxiq7->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $ke_V3) { $BB065 = $ke_V3->item(); $ke_V3->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $BB065->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function oauth(AdminDialogPage $pI9Cu) { goto B3pcN; alCdn: $GXi4l = Detail::make(''); goto Kq3IF; M0Ss2: BizException::throwsIfEmpty('用户不存在', $EZRTY); goto alCdn; X4gua: foreach ($jmR75 as $Djrl6) { goto Ucw1r; xr_AL: if (empty($LUGmR)) { $LUGmR = ColorUtil::pick($Djrl6['type']); } goto OOSGx; S5Qah: $N_d2A = MemberOauth::getByOauthKey($Djrl6['type']); goto r9J_d; klCUN: $HiQup = 'iconfont icon-dot'; goto CN5Cw; r9J_d: if ($N_d2A) { goto hz1Pc; l9lSN: $jRs5c = $N_d2A->title(); goto O2nkD; O2nkD: if (method_exists($N_d2A, 'icon')) { $HiQup = $N_d2A->icon(); } goto vzxEw; hz1Pc: $LUGmR = $N_d2A->color(); goto l9lSN; vzxEw: } goto xr_AL; CN5Cw: $jRs5c = $Djrl6['type']; goto S5Qah; OOSGx: $GXi4l->html('_', $jRs5c)->html($Djrl6['openId']); goto dSOtk; Ucw1r: $LUGmR = null; goto klCUN; dSOtk: } goto vIP3H; B3pcN: $EZRTY = MemberUtil::get(CRUDUtil::id()); goto M0Ss2; vIP3H: return $pI9Cu->pageTitle('授权登录信息')->body(Box::make($GXi4l, '授权登录信息')); goto TQi9a; Kq3IF: $jmR75 = MemberUtil::listOauths($EZRTY['id']); goto X4gua; TQi9a: } public function add(AdminDialogPage $pI9Cu) { goto puu_H; TLTrm: $HFZFF->showSubmit(false)->showReset(false); goto aR8vv; CPzBC: $HFZFF->layoutPanel('高级', function (Form $HFZFF) { $HFZFF->text('nickname', '昵称'); $HFZFF->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $HFZFF->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $HFZFF->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $HFZFF->date('vipExpire', 'VIP过期'); } }); goto TLTrm; puu_H: $HFZFF = Form::make(''); goto kGGNB; kGGNB: $HFZFF->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $HFZFF) { $HFZFF->text('username', '用户名'); $HFZFF->text('phone', '手机'); $HFZFF->text('email', '邮箱'); $HFZFF->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto CPzBC; aR8vv: return $pI9Cu->pageTitle('创建用户')->body($HFZFF)->handleForm($HFZFF, function (Form $HFZFF) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $mKcTY = !empty($P1CdK['username']) ? $P1CdK['username'] : null; $LAVo8 = !empty($P1CdK['phone']) ? $P1CdK['phone'] : null; $p0fDQ = !empty($P1CdK['email']) ? $P1CdK['email'] : null; $pG1JC = ArrayUtil::keepKeys($P1CdK, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $XJnSC = MemberUtil::register($mKcTY, $LAVo8, $p0fDQ, $P1CdK['password']); BizException::throwsIfResponseError($XJnSC); if (!empty($pG1JC)) { if (isset($pG1JC['vipExpire']) && TimeUtil::isDateEmpty($pG1JC['vipExpire'])) { $pG1JC['vipExpire'] = null; } MemberUtil::update($XJnSC['data']['id'], $pG1JC); } EventUtil::fire(new MemberUserRegisteredEvent($XJnSC['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto NOP6a; NOP6a: } public function edit(AdminDialogPage $pI9Cu) { goto ZkyEH; V9z5o: if (Request::isPost()) { goto FB2Ca; c1g7s: $jY4at = InputPackage::buildFromInput(); goto c8G6X; FB2Ca: AdminPermission::demoCheck(); goto c1g7s; c8G6X: switch ($jY4at->getTrimString('_action')) { case 'itemCellEdit': goto C632g; McCAO: if (!empty($iUhMB)) { MemberUtil::update($EZRTY['id'], $iUhMB); } goto mN4fR; mN4fR: return Response::generateSuccess(); goto wcacf; IwQo7: switch ($jY4at->getTrimString('column')) { case 'status': $iUhMB['status'] = $jY4at->getInteger('value'); break; } goto McCAO; C632g: $iUhMB = array(); goto IwQo7; wcacf: } goto ovoa8; ovoa8: } goto PFKpK; Cjt6a: $HFZFF->item($EZRTY)->fillFields(); goto Tfr3_; As_bE: BizException::throwsIfEmpty('用户不存在', $EZRTY); goto V9z5o; ZkyEH: $EZRTY = ModelUtil::get('member_user', CRUDUtil::id()); goto As_bE; P4O2_: return $pI9Cu->pageTitle('修改信息')->body($HFZFF)->handleForm($HFZFF, function (Form $HFZFF) use($EZRTY) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $NYFU5 = ArrayUtil::keepKeys($P1CdK, array('username', 'phone', 'email')); $pG1JC = ArrayUtil::keepKeys($P1CdK, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $XJnSC = MemberUtil::updateBasicWithUniqueCheck($EZRTY['id'], $NYFU5); BizException::throwsIfResponseError($XJnSC); if (isset($pG1JC['vipExpire']) && TimeUtil::isDateEmpty($pG1JC['vipExpire'])) { $pG1JC['vipExpire'] = null; } if ($EZRTY['vipId'] != $pG1JC['vipId']) { MemberUserVipChangeEvent::fire($EZRTY['id'], $EZRTY['vipId'], $pG1JC['vipId']); } MemberUtil::update($EZRTY['id'], $pG1JC); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto A7d3c; Sh7_Q: $HFZFF->layoutPanel('基础', function (Form $HFZFF) { $HFZFF->display('id', '用户ID')->addable(true); $HFZFF->text('username', '用户名'); $HFZFF->text('phone', '手机'); $HFZFF->text('email', '邮箱'); }); goto NYkKj; Tfr3_: $HFZFF->showSubmit(false)->showReset(false); goto P4O2_; NYkKj: $HFZFF->layoutPanel('高级', function (Form $HFZFF) { $HFZFF->text('nickname', '昵称'); $HFZFF->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $HFZFF->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $HFZFF->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $HFZFF->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto Cjt6a; PFKpK: $HFZFF = Form::make(''); goto Sh7_Q; A7d3c: } public function select(AdminDialogPage $pI9Cu) { goto iF3vh; n1I2N: $ED2yH->disableCUD(); goto zmrdV; iF3vh: $ED2yH = $this->grid(); goto n1I2N; rtjPV: return $pI9Cu->pageTitle('选择用户')->body($ED2yH); goto HPHhm; xZzJr: CRUDUtil::registerGridResource($ED2yH, '\\' . __CLASS__); goto w14xl; zmrdV: $ED2yH->canSingleSelectItem(true); goto xZzJr; w14xl: if (Request::isPost()) { return $ED2yH->request(); } goto rtjPV; HPHhm: } public function search() { goto tF97D; tF97D: $jY4at = InputPackage::buildFromInput(); goto P5eDU; JYbE_: $Y1ykT = array_map(function ($BB065) { return array('value' => intval($BB065['id']), 'name' => htmlspecialchars(MemberUtil::viewName($BB065)), 'avatar' => AssetsUtil::fixOrDefault($BB065['avatar'], 'asset/image/avatar.svg')); }, $XMWCa['records']); goto Wm2mK; Wm2mK: return Response::jsonSuccessData($Y1ykT); goto c2w0i; P5eDU: $eFw2c = $jY4at->getTrimString('keywords'); goto HLmK8; z1X5x: $XMWCa = MemberUtil::paginate(1, 10, $b7bLh); goto JYbE_; HLmK8: $b7bLh = array(); goto m_4D8; m_4D8: $b7bLh['whereOperate'] = array('username', 'like', "%{$eFw2c}%"); goto z1X5x; c2w0i: } public function resetPassword(AdminConfigBuilder $p5Kcp) { goto jT5OJ; bjE03: $p5Kcp->useDialog(); goto JEOWU; rl1Uk: if (Request::isPost()) { return $p5Kcp->formRequest(function (Form $HFZFF) use($EZRTY) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $XJnSC = MemberUtil::changePassword($EZRTY['id'], $P1CdK['passwordNew'], null, true); BizException::throwsIfResponseError($XJnSC); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto gO8VW; J2hTN: $p5Kcp->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto rl1Uk; JEOWU: $p5Kcp->pageTitle('重置密码'); goto J2hTN; lk3Dz: BizException::throwsIfEmpty('用户不存在', $EZRTY); goto bjE03; jT5OJ: $fJoR1 = CRUDUtil::id(); goto ox7P4; gO8VW: return $p5Kcp; goto ZTuZO; ox7P4: $EZRTY = MemberUtil::get($fJoR1); goto lk3Dz; ZTuZO: } public function sendMessage(AdminConfigBuilder $p5Kcp) { goto f7Rxz; nVpQT: $p5Kcp->pageTitle('发送消息'); goto GOz6D; f7Rxz: $fJoR1 = CRUDUtil::id(); goto igcfP; o7kMM: BizException::throwsIfEmpty('用户不存在', $EZRTY); goto C9NxV; GOz6D: $p5Kcp->richHtml('content', '消息内容')->required(); goto C9l59; C9l59: if (Request::isPost()) { return $p5Kcp->formRequest(function (Form $HFZFF) use($EZRTY) { AdminPermission::demoCheck(); $P1CdK = $HFZFF->dataForming(); $XJnSC = MemberMessageUtil::send($EZRTY['id'], $P1CdK['content']); BizException::throwsIfResponseError($XJnSC); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto sHgZd; sHgZd: return $p5Kcp; goto A1OCl; C9NxV: $p5Kcp->useDialog(); goto nVpQT; igcfP: $EZRTY = MemberUtil::get($fJoR1); goto o7kMM; A1OCl: } public function show() { goto nxujW; nxujW: $F80_3 = MemberUtil::get(CRUDUtil::id()); goto tCNse; tCNse: $APT6q = MemberAdminShowPanelProvider::listAll(); goto PVl71; PVl71: return view('module::Member.View.admin.memberUser.show', array('record' => $F80_3, 'showPanelProviders' => $APT6q)); goto SwCZg; SwCZg: } public function delete() { goto RtEMW; RtEMW: AdminPermission::demoCheck(); goto xLhxF; xZrUw: return Response::redirect(CRUDUtil::jsGridRefresh()); goto y5jYI; xLhxF: MemberUtil::delete(CRUDUtil::id()); goto xZrUw; y5jYI: } public function statusForbidden() { goto UGCas; FQjee: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto F7O0t; UGCas: AdminPermission::demoCheck(); goto FQjee; F7O0t: return Response::redirect(CRUDUtil::jsGridRefresh()); goto Dg6Rh; Dg6Rh: } public function export(ExportHandle $VbLwA) { $r_w92 = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $VbLwA->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($r_w92)->handleFetch(function ($pI9Cu, $qzgph, $g55KQ, $FlBDj) { $KMes1 = ModelUtil::model('member_user'); $KMes1 = $KMes1->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($g55KQ as $iWWb2) { if (!empty($iWWb2['id']['eq'])) { $KMes1 = $KMes1->where('id', $iWWb2['id']['eq']); } elseif (!empty($iWWb2['status']['eq'])) { $KMes1 = $KMes1->where('status', $iWWb2['status']['eq']); } elseif (!empty($iWWb2['groupId']['eq'])) { $KMes1 = $KMes1->where('groupId', $iWWb2['groupId']['eq']); } elseif (!empty($iWWb2['vipId']['eq'])) { $KMes1 = $KMes1->where('vipId', $iWWb2['vipId']['eq']); } elseif (!empty($iWWb2['username']['like'])) { $KMes1 = $KMes1->where('username', 'like', '%' . $iWWb2['username']['like'] . '%'); } elseif (!empty($iWWb2['email']['like'])) { $KMes1 = $KMes1->where('email', 'like', '%' . $iWWb2['email']['like'] . '%'); } elseif (!empty($iWWb2['phone']['like'])) { $KMes1 = $KMes1->where('phone', 'like', '%' . $iWWb2['phone']['like'] . '%'); } } $UdT_r = $KMes1->paginate($qzgph, array('*'), 'page', $pI9Cu)->toArray(); $Z0XmT = array(); foreach ($UdT_r['data'] as $BB065) { goto iKcAv; sjAcm: $tLyGD[] = $BB065['created_at']; goto tUqpt; K0YGV: $tLyGD[] = $BB065['username']; goto Ji6J1; FyRBr: $tLyGD[] = $BB065['phone']; goto sjAcm; Ji6J1: $tLyGD[] = $BB065['email']; goto FyRBr; iKcAv: $tLyGD = array(); goto sMlR3; tUqpt: $tLyGD[] = TypeUtil::name(Gender::class, $BB065['gender']); goto VZkeI; sMlR3: $tLyGD[] = $BB065['id']; goto K0YGV; VZkeI: $tLyGD[] = $BB065['realname']; goto lQgTn; lQgTn: $tLyGD[] = $BB065['signature']; goto A7nS3; A7nS3: $Z0XmT[] = $tLyGD; goto gtw80; gtw80: } return array('list' => $Z0XmT, 'total' => $UdT_r['total']); })->performCommon(); } }