<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\PayCenter\Util; use Carbon\Carbon; use EasyWeChat\Factory; use EasyWeChat\Kernel\Exceptions\InvalidArgumentException; use EasyWeChat\Kernel\Exceptions\InvalidConfigException; use GuzzleHttp\Exception\GuzzleException; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use Module\Member\Util\MemberMoneyUtil; use Module\PayCenter\Events\OrderPayedEvent; use Module\PayCenter\Provider\PayCenterProvider; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; use Module\Vendor\Log\Logger; use Payment\Client\Charge; use Payment\Config; class PayOrderUtil { private static function getOrGeneratePaySessionKey() { goto pOJfV; hW6Mx: if (empty($AwzHV)) { $AwzHV = RandomUtil::string(32); Session::put('paySessionKey', $AwzHV); } goto gEUNW; gEUNW: return $AwzHV; goto piaiJ; pOJfV: $AwzHV = Session::get('paySessionKey', null); goto hW6Mx; piaiJ: } public static function updateFee($tcabM, $uvwf2, $njiTd) { goto wWVSq; wWVSq: $z58x5 = self::getByBizAndBizId($tcabM, $uvwf2); goto xlchm; ckczL: if ($z58x5['status'] == PayOrderStatus::NEW_ORDER || $z58x5['status'] == PayOrderStatus::CREATED) { self::update($z58x5['id'], array('feeTotal' => $njiTd)); } goto TbHJH; xlchm: BizException::throwsIfEmpty('订单不存在', $z58x5); goto ckczL; TbHJH: } public static function autoPay($tcabM, $uvwf2, $njiTd = null) { goto oQsVj; oQsVj: $ohquK = PayOrderUtil::prepareOrder($tcabM, $uvwf2, $njiTd); goto YwcXx; YwcXx: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => PayType::NONE, 'timePayCreated' => Carbon::now(), 'payOrderId' => null)); goto SLORm; SLORm: return PayOrderUtil::handleOrderPay(PayType::NONE, config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id']); goto mt9dZ; mt9dZ: } public static function prepareOrder($tcabM, $uvwf2, $njiTd = null, $feQw3 = null, $I4IgL = null, $hpjZO = array()) { goto zEg1D; zEg1D: $HGZDE = ModelUtil::get('pay_order', array('biz' => $tcabM, 'bizId' => $uvwf2)); goto wRt54; RX9HM: if (empty($HGZDE)) { goto wmiD7; Zesse: $z58x5['biz'] = $tcabM; goto qDxj0; Vb7cQ: $z58x5['redirect'] = $I4IgL; goto cOcg8; xMhEV: $z58x5['id'] = $g30EA; goto Zesse; wmiD7: $g30EA = IdUtil::generateSN(); goto xMhEV; NyrHX: $z58x5['status'] = PayOrderStatus::NEW_ORDER; goto yeOX2; dBEGr: $z58x5['body'] = $feQw3; goto Vb7cQ; M6Kts: $z58x5['timeRefundSuccess'] = null; goto Nd1XT; HWaAV: $z58x5['timeRefundCreated'] = null; goto M6Kts; JPfqj: $z58x5['feeTotal'] = $njiTd; goto qoGOW; cOcg8: $z58x5 = ModelUtil::insert('pay_order', $z58x5); goto dErHe; qoGOW: $z58x5['timePayCreated'] = null; goto O3XlF; Nd1XT: $z58x5['timeClosed'] = null; goto q8JgO; hcMv1: $z58x5['feeRefund'] = null; goto HWaAV; yeOX2: $z58x5['payOrderId'] = null; goto JPfqj; O3XlF: $z58x5['timePay'] = null; goto hcMv1; XFzSY: $z58x5['param'] = $hpjZO; goto lTsqh; q8JgO: $z58x5['param'] = json_encode($hpjZO, JSON_UNESCAPED_UNICODE); goto dBEGr; dErHe: $z58x5['id'] = $g30EA; goto XFzSY; qDxj0: $z58x5['bizId'] = $uvwf2; goto misJE; misJE: $z58x5['payType'] = null; goto NyrHX; lTsqh: } else { goto F8AMe; AUSaO: if (null !== $njiTd) { $RVZb8['feeTotal'] = $njiTd; } goto zti2q; zti2q: if (null !== $feQw3) { $RVZb8['body'] = $feQw3; } goto Gh_Kl; hrWae: $RVZb8 = array(); goto AUSaO; Brgiu: if (!empty($hpjZO)) { $RVZb8['param'] = json_encode($hpjZO, JSON_UNESCAPED_UNICODE); } goto GMKCQ; Gh_Kl: if (null !== $I4IgL) { $RVZb8['redirect'] = $I4IgL; } goto klMzJ; GMKCQ: if (!empty($RVZb8)) { ModelUtil::update('pay_order', $HGZDE['id'], $RVZb8); foreach ($RVZb8 as $yHNo7 => $I7oOV) { $z58x5[$yHNo7] = $I7oOV; } } goto VarRy; F8AMe: $z58x5 = $HGZDE; goto hrWae; klMzJ: switch ($z58x5['status']) { case PayOrderStatus::NEW_ORDER: break; case PayOrderStatus::CREATED: goto BZhex; BZhex: $RVZb8['status'] = PayOrderStatus::NEW_ORDER; goto rZItZ; mU0cw: break; goto DOxrc; rZItZ: $RVZb8['timeClosed'] = null; goto mU0cw; DOxrc: case PayOrderStatus::CLOSED: goto nSFoy; nSFoy: $RVZb8['status'] = PayOrderStatus::NEW_ORDER; goto xrvVH; nLb4i: break; goto qZk5M; xrvVH: $RVZb8['timeClosed'] = null; goto nLb4i; qZk5M: case PayOrderStatus::CLOSED_EXPIRED: goto LqOiV; LqOiV: $RVZb8['status'] = PayOrderStatus::NEW_ORDER; goto OXoC7; mRIau: break; goto cyTIp; OXoC7: $RVZb8['timeClosed'] = null; goto mRIau; cyTIp: default: BizException::throws('订单状态异常'); } goto Brgiu; VarRy: } goto PCrJs; PCrJs: return $z58x5; goto XMfsX; wRt54: $z58x5 = array(); goto RX9HM; XMfsX: } public static function getOrderSecretId($Xk8gG) { return EncodeUtil::expiredDataForever($Xk8gG, self::getOrGeneratePaySessionKey()); } public static function getOrder($z58x5) { goto LCpwS; qQW26: return $POM2f; goto aK_KH; LCpwS: $g30EA = EncodeUtil::expiredDataDecode($z58x5, self::getOrGeneratePaySessionKey()); goto QSvIt; XYL1W: $POM2f['id'] = '' . $POM2f['id']; goto qQW26; QSvIt: if (!$g30EA) { return null; } goto gpR6r; gpR6r: $POM2f = ModelUtil::get('pay_order', $g30EA); goto rU5xI; rU5xI: ModelUtil::decodeRecordJson($POM2f, array('param')); goto XYL1W; aK_KH: } public static function createPay($Xk8gG, $zDuI5, $QJqee = array()) { goto r1IAm; M8r3t: BizException::throwsIfEmpty('订单不存在', $ohquK); goto iOEN1; r1IAm: $ohquK = self::get($Xk8gG); goto M8r3t; iOEN1: if ($ohquK['status'] == PayOrderStatus::PAYED) { return Response::generateError('订单已支付'); } else { if ($ohquK['status'] == PayOrderStatus::CLOSED) { return Response::generateError('订单已关闭，请刷新该页面'); } } goto cNVN1; cNVN1: switch ($zDuI5) { case PayType::ALIPAY: return self::createAlipay($ohquK, $zDuI5, $QJqee); case PayType::ALIPAY_WEB: return self::createAlipayWeb($ohquK, $zDuI5, $QJqee); case PayType::ALIPAY_MOBILE: return self::createAlipayMobile($ohquK, $zDuI5, $QJqee); case PayType::WECHAT: return self::createWechat($ohquK, $zDuI5, $QJqee); case PayType::WECHAT_MOBILE: return self::createWechatMobile($ohquK, $zDuI5, $QJqee); case PayType::WECHAT_APP: return self::createWechatApp($ohquK, $zDuI5, $QJqee); case PayType::WECHAT_MINI_PROGRAM: return self::createWechatMiniProgram($ohquK, $zDuI5, $QJqee); case PayType::WECHAT_H5: return self::createWechatH5($ohquK, $zDuI5, $QJqee); case PayType::MEMBER_MONEY: return self::createMemberMoney($ohquK, $zDuI5, $QJqee); default: goto MoEv9; x59rO: return Response::generate(-1, '支付方式不存在'); goto EllZH; ZpDGy: if ($Aj2DI) { return $Aj2DI->onSubmit($ohquK, $zDuI5, $QJqee); } goto x59rO; MoEv9: $Aj2DI = PayCenterProvider::get($zDuI5); goto ZpDGy; EllZH: } goto vZHx0; vZHx0: } public static function update($g30EA, $rZTKT) { return ModelUtil::update('pay_order', array('id' => $g30EA), $rZTKT); } public static function total() { $T8usd = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->sum('feeTotal'); return sprintf('%.2f', $T8usd); } public static function totalByTimeRange($oPEYU, $jqk7a) { $T8usd = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->where('created_at', '>=', $oPEYU)->where('created_at', '<=', $jqk7a)->sum('feeTotal'); return sprintf('%.2f', $T8usd); } public static function get($g30EA) { goto ib_8a; MfzeO: return $XYknV; goto FuMZw; tK3Ov: ModelUtil::decodeRecordJson($XYknV, 'param'); goto MfzeO; ib_8a: $XYknV = ModelUtil::get('pay_order', $g30EA); goto tK3Ov; FuMZw: } public static function getByBizAndBizId($tcabM, $uvwf2) { goto XDBof; QZXwe: return $XYknV; goto lAqs0; Fo6cf: ModelUtil::decodeRecordJson($XYknV, 'param'); goto QZXwe; XDBof: $XYknV = ModelUtil::get('pay_order', array('biz' => $tcabM, 'bizId' => $uvwf2)); goto Fo6cf; lAqs0: } public static function refund($tcabM, $uvwf2, $iKjL8 = null, $hpjZO = array()) { goto QJQW5; C9WCw: return Response::generate(0, 'ok'); goto mS1Fm; QJQW5: $RVZb8 = array('status' => PayOrderStatus::REFUND_SUCCESS, 'feeRefund' => $iKjL8, 'timeRefundCreated' => date('Y-m-d H:i:s'), 'timeRefundSuccess' => date('Y-m-d H:i:s')); goto y9_V1; y9_V1: try { goto PPag0; ymjkX: BizException::throwsIf('订单状态异常', $z58x5['status'] != PayOrderStatus::PAYED); goto nSvur; qPpxz: BizException::throwsIfEmpty('订单不存在', $z58x5); goto ymjkX; PPag0: ModelUtil::transactionBegin(); goto wYwEv; AynLo: ModelUtil::update('pay_order', $z58x5['id'], $RVZb8); goto WIsN8; nSvur: if (null === $RVZb8['feeRefund']) { $RVZb8['feeRefund'] = $z58x5['feeTotal']; } goto AynLo; WIsN8: ModelUtil::transactionCommit(); goto SvtIB; wYwEv: $z58x5 = ModelUtil::getWithLock('pay_order', array('biz' => $tcabM, 'bizId' => $uvwf2)); goto qPpxz; SvtIB: } catch (BizException $ggRjH) { ModelUtil::transactionRollback(); return Response::generateError($ggRjH->getMessage()); } goto C9WCw; mS1Fm: } public static function getWechatPayment() { goto A12bN; A12bN: $dNpi2 = modstart_config(); goto TqbyR; TqbyR: $dNpi2 = array('app_id' => $dNpi2->getWithEnv('payWechatAppId'), 'mch_id' => $dNpi2->getWithEnv('payWechatMerchantId'), 'key' => $dNpi2->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'debug', 'channels' => array('debug' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'debug')))); goto AahjT; AahjT: return Factory::payment($dNpi2); goto eti8a; eti8a: } private static function createWechat($ohquK, $zDuI5, $QJqee) { goto MSgtj; AS0wN: try { $O2HCC = $mszIY->order->unify($zPqVE); } catch (\Exception $ggRjH) { goto ECF0I; sFxrz: throw $ggRjH; goto lF38Z; EDc3T: if (Str::contains($v97XK, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto sFxrz; ECF0I: $v97XK = $ggRjH->getMessage(); goto EDc3T; lF38Z: } goto zde7C; tlmJO: return Response::generate(0, null, $rZTKT); goto zpudN; Uk7MT: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now(), 'payOrderId' => $O2HCC['prepay_id'])); goto azbUn; hDVwT: if (isset($QJqee['limitPay'])) { switch ($QJqee['limitPay']) { case 'no_credit': $zPqVE['limit_pay'] = $QJqee['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto AS0wN; HHpm5: if (!isset($O2HCC['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto maVxs; MSgtj: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, '微信支付未开启'); } goto oMceA; oMceA: $mszIY = self::getWechatPayment(); goto Gh83B; zde7C: if (!isset($O2HCC['return_code']) || $O2HCC['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($O2HCC['return_msg']) ? $O2HCC['return_msg'] : 'NULL')); } goto HHpm5; azbUn: $rZTKT = array('payCodeUrl' => $O2HCC['code_url'], 'successRedirect' => $ohquK['redirect']); goto tlmJO; maVxs: if ($O2HCC['result_code'] != 'SUCCESS') { $SwFk3 = $O2HCC['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $SwFk3 . ')'); } goto Uk7MT; Gh83B: $zPqVE = array('trade_type' => 'NATIVE', 'body' => StrUtil::mbLimitChars($ohquK['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($ohquK['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT))); goto hDVwT; zpudN: } private static function createWechatApp($ohquK, $zDuI5, $QJqee) { goto e3BIm; d_ASB: $rZTKT = array('payJsSdkConfig' => $BBYmb, 'successRedirect' => $ohquK['redirect']); goto Xwrpo; Q_K73: try { $O2HCC = $mszIY->order->unify($zPqVE); } catch (\Exception $ggRjH) { goto FCo_7; pbr1G: if (Str::contains($v97XK, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto x_BuD; FCo_7: $v97XK = $ggRjH->getMessage(); goto pbr1G; x_BuD: throw $ggRjH; goto pCxvz; pCxvz: } goto sqrt_; b2rOW: $BBYmb = $mszIY->jssdk->bridgeConfig($O2HCC['prepay_id'], false); goto d_ASB; HKvph: $zPqVE = array('trade_type' => 'APP', 'body' => StrUtil::mbLimitChars($ohquK['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($ohquK['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto aqQbb; aqQbb: if (isset($QJqee['limitPay'])) { switch ($QJqee['limitPay']) { case 'no_credit': $zPqVE['limit_pay'] = $QJqee['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto Q_K73; sNtXt: if (!isset($O2HCC['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto iBCmx; iBCmx: if ($O2HCC['result_code'] != 'SUCCESS') { $SwFk3 = $O2HCC['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $SwFk3 . ')'); } goto sxAaa; sqrt_: if (!isset($O2HCC['return_code']) || $O2HCC['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($O2HCC['return_msg']) ? $O2HCC['return_msg'] : 'NULL')); } goto sNtXt; sxAaa: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now(), 'payOrderId' => $O2HCC['prepay_id'])); goto b2rOW; Xwrpo: return Response::generate(0, null, $rZTKT); goto aS5Ix; e3BIm: $mszIY = self::getWechatPayment(); goto HKvph; aS5Ix: } private static function createWechatMobile($ohquK, $zDuI5, $QJqee) { goto XDAJo; aqXo8: $mszIY = self::getWechatPayment(); goto Lc008; hu2Pn: if ($O2HCC['result_code'] != 'SUCCESS') { $SwFk3 = $O2HCC['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $SwFk3 . ')'); } goto cKZNy; Lc008: $zPqVE = array('openid' => $QJqee['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($ohquK['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($ohquK['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto phlXz; XDAJo: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto YGrAQ; jNIrc: return Response::generate(0, null, $rZTKT); goto Xo8W0; ncHzp: $rZTKT = array('payJsSdkConfig' => $BBYmb, 'successRedirect' => $ohquK['redirect']); goto jNIrc; sKTPO: $BBYmb = $mszIY->jssdk->bridgeConfig($O2HCC['prepay_id'], false); goto ncHzp; cKZNy: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now(), 'payOrderId' => $O2HCC['prepay_id'])); goto sKTPO; Nycj1: if (!isset($O2HCC['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto hu2Pn; YGrAQ: if (empty($QJqee['openId'])) { return Response::generate(-1, 'wechat mobile openId empty'); } goto aqXo8; pk2Fd: if (!isset($O2HCC['return_code']) || $O2HCC['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($O2HCC['return_msg']) ? $O2HCC['return_msg'] : 'NULL')); } goto Nycj1; IT9pT: try { $O2HCC = $mszIY->order->unify($zPqVE); } catch (\Exception $ggRjH) { goto SdNn9; WEsJY: throw $ggRjH; goto caH7U; SdNn9: $v97XK = $ggRjH->getMessage(); goto YWgyc; YWgyc: if (Str::contains($v97XK, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto WEsJY; caH7U: } goto pk2Fd; phlXz: if (isset($QJqee['limitPay'])) { switch ($QJqee['limitPay']) { case 'no_credit': $zPqVE['limit_pay'] = $QJqee['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto IT9pT; Xo8W0: } private static function createWechatH5($ohquK, $zDuI5, $QJqee) { goto N36y7; MozyP: $rZTKT = array('payLink' => $O2HCC['mweb_url'], 'successRedirect' => $ohquK['redirect']); goto PabkA; z8AFl: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now(), 'payOrderId' => $O2HCC['prepay_id'])); goto MozyP; PabkA: return Response::generate(0, null, $rZTKT); goto PUMEY; LiNjG: if (isset($QJqee['limitPay'])) { switch ($QJqee['limitPay']) { case 'no_credit': $zPqVE['limit_pay'] = $QJqee['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto BVTFy; SST0W: $mszIY = self::getWechatPayment(); goto faezv; faezv: $zPqVE = array('trade_type' => 'MWEB', 'body' => StrUtil::mbLimitChars($ohquK['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($ohquK['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_H5))); goto LiNjG; BVTFy: try { $O2HCC = $mszIY->order->unify($zPqVE); } catch (\Exception $ggRjH) { goto pE5b_; wenDn: throw $ggRjH; goto XBi2G; xNWjk: if (Str::contains($v97XK, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto wenDn; pE5b_: $v97XK = $ggRjH->getMessage(); goto xNWjk; XBi2G: } goto ViMwD; PlGKf: if (!isset($O2HCC['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto pVRHB; pVRHB: if ($O2HCC['result_code'] != 'SUCCESS') { $SwFk3 = $O2HCC['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $SwFk3 . ')'); } goto z8AFl; ViMwD: if (!isset($O2HCC['return_code']) || $O2HCC['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($O2HCC['return_msg']) ? $O2HCC['return_msg'] : 'NULL')); } goto PlGKf; N36y7: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto SST0W; PUMEY: } public static function getWechatMiniProgramPayment() { goto TdDHF; TjfUc: return Factory::payment($dNpi2); goto tCqh0; TdDHF: $dNpi2 = modstart_config(); goto F2FHo; F2FHo: $dNpi2 = array('app_id' => $dNpi2->getWithEnv('oauthWechatMiniProgramAppId'), 'mch_id' => $dNpi2->getWithEnv('payWechatMerchantId'), 'key' => $dNpi2->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'info', 'channels' => array('info' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'info')))); goto TjfUc; tCqh0: } private static function createWechatMiniProgram($ohquK, $zDuI5, $QJqee) { goto YWUsQ; xEpcS: $rZTKT = array('payJsSdkConfig' => $BBYmb, 'successRedirect' => $ohquK['redirect']); goto bKajf; e6GsG: try { $O2HCC = $mszIY->order->unify($zPqVE); } catch (\Exception $ggRjH) { goto PCtuZ; P1vD1: if (Str::contains($v97XK, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto y31pO; y31pO: throw $ggRjH; goto J_m9c; PCtuZ: $v97XK = $ggRjH->getMessage(); goto P1vD1; J_m9c: } goto mAe5m; rCfFI: if (!isset($O2HCC['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto fpg1j; Hor4e: if (empty($QJqee['openId'])) { return Response::generate(-1, 'wechat mini program openId empty'); } goto yp0Xz; v28WY: $BBYmb = $mszIY->jssdk->bridgeConfig($O2HCC['prepay_id'], false); goto xEpcS; uZyRC: if (isset($QJqee['limitPay'])) { switch ($QJqee['limitPay']) { case 'no_credit': $zPqVE['limit_pay'] = $QJqee['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto e6GsG; jOAaD: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now(), 'payOrderId' => $O2HCC['prepay_id'])); goto v28WY; bKajf: return Response::generate(0, null, $rZTKT); goto HeY9Z; YWUsQ: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mini program pay not enable'); } goto Hor4e; Jstij: $zPqVE = array('openid' => $QJqee['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($ohquK['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($ohquK['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MINI_PROGRAM))); goto uZyRC; yp0Xz: $mszIY = self::getWechatMiniProgramPayment(); goto Jstij; fpg1j: if ($O2HCC['result_code'] != 'SUCCESS') { $SwFk3 = $O2HCC['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $SwFk3 . ')'); } goto jOAaD; mAe5m: if (!isset($O2HCC['return_code']) || $O2HCC['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($O2HCC['return_msg']) ? $O2HCC['return_msg'] : 'NULL')); } goto rCfFI; HeY9Z: } public static function initAlipay() { config(array('latrell-alipay.partner_id' => config('pay.alipay.partnerId'), 'latrell-alipay.seller_id' => config('pay.alipay.sellerId'), 'latrell-alipay-web.key' => config('pay.alipay.key'), 'latrell-alipay-web.return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => PayType::ALIPAY)), 'latrell-alipay-web.notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::ALIPAY)))); } public static function alipayWebConfig($zDuI5) { return array('use_sandbox' => false, 'app_id' => modstart_config()->getWithEnv('payAlipayWebAppId'), 'sign_type' => 'RSA2', 'ali_public_key' => modstart_config()->getWithEnv('payAlipayWebAliPublicKey'), 'rsa_private_key' => modstart_config()->getWithEnv('payAlipayWebRSAPrivateKey'), 'limit_pay' => array(), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => $zDuI5)), 'return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => $zDuI5)), 'return_raw' => true); } private static function createAlipayWeb($ohquK, $zDuI5, $QJqee) { goto s1RfK; EKjqY: try { $WIWoQ = Charge::run(Config::ALI_CHANNEL_WEB, $dNpi2, $xToSr); } catch (\Exception $ggRjH) { return Response::generate(-1, '创建支付错误(' . $ggRjH->getMessage() . ')'); } goto j5udy; gOAMF: $rZTKT['payLink'] = $WIWoQ; goto MmVt4; EfPZi: return Response::generate(0, 'ok', $rZTKT); goto BD1a9; Rswhr: $rZTKT = array(); goto gOAMF; MmVt4: $rZTKT['successRedirect'] = $ohquK['redirect']; goto EfPZi; s1RfK: $dNpi2 = self::alipayWebConfig($zDuI5); goto U7b52; j5udy: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now())); goto Rswhr; U7b52: $xToSr = array('body' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($ohquK['body']), 200), 'subject' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($ohquK['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $ohquK['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto EKjqY; BD1a9: } private static function createAlipayMobile($ohquK, $zDuI5, $QJqee) { goto Wxova; rJm6W: return Response::generate(0, 'ok', $rZTKT); goto kQo8k; PP45U: $xToSr = array('body' => Str::limit(AlipayUtil::filterSpecialChars($ohquK['body']), 200), 'subject' => Str::limit(AlipayUtil::filterSpecialChars($ohquK['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $ohquK['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto pDZi4; A1s8e: $rZTKT = array(); goto hJvoN; Wxova: $dNpi2 = self::alipayWebConfig($zDuI5); goto PP45U; VTxWp: $rZTKT['successRedirect'] = $ohquK['redirect']; goto rJm6W; gTrfp: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now())); goto A1s8e; hJvoN: $rZTKT['payLink'] = $WIWoQ; goto VTxWp; pDZi4: try { $WIWoQ = Charge::run(Config::ALI_CHANNEL_WAP, $dNpi2, $xToSr); } catch (\Exception $ggRjH) { return Response::generate(-1, '创建支付错误(' . $ggRjH->getMessage() . ')'); } goto gTrfp; kQo8k: } private static function createMemberMoney($ohquK, $zDuI5, $QJqee) { goto aU1Ky; Ol8uS: if ($HF5p1 < $ohquK['feeTotal']) { return Response::generateError('余额不足'); } goto Ss_Pb; Oea92: ModelUtil::transactionBegin(); goto TETis; TETis: try { MemberMoneyUtil::change($id94O, -$ohquK['feeTotal'], $ohquK['body']); ModelUtil::transactionCommit(); } catch (\Exception $ggRjH) { ModelUtil::transactionRollback(); return Response::generateError('支付失败，请重试'); } goto WGEo4; WGEo4: $O2HCC = PayOrderUtil::handleOrderPay(PayType::MEMBER_MONEY, config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id']); goto lqn7W; Ss_Pb: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now())); goto Oea92; ot5dL: $HF5p1 = MemberMoneyUtil::getTotal($id94O); goto Ol8uS; aU1Ky: $id94O = $QJqee['memberUserId']; goto ot5dL; JQ_eD: return Response::generate(0, '支付成功', array('redirect' => $ohquK['redirect'])); goto ii3de; lqn7W: if (Response::isError($O2HCC)) { return $O2HCC; } goto JQ_eD; ii3de: } private static function createAlipay($ohquK, $zDuI5, $QJqee) { goto g1Oce; DuGw6: $zH5Gf->setSubject(Str::limit($ohquK['body'], 200)); goto p7JLk; p7JLk: $zH5Gf->setBody(Str::limit($ohquK['body'], 100)); goto R0bY8; g1Oce: self::initAlipay(); goto PcmQ7; p1wQY: $rZTKT['successRedirect'] = $ohquK['redirect']; goto L4XqL; HH422: $rZTKT['payLink'] = $zH5Gf->getPayLink(); goto p1wQY; XbSmr: $rZTKT = array(); goto HH422; og2h_: $zH5Gf->setTotalFee($ohquK['feeTotal']); goto DuGw6; R0bY8: self::update($ohquK['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $zDuI5, 'timePayCreated' => Carbon::now())); goto XbSmr; L4XqL: return Response::generate(0, 'ok', $rZTKT); goto gqeBt; oIc7o: if (!empty($QJqee['alipay_wap'])) { $zH5Gf = app('alipay.wap'); } else { $zH5Gf = app('alipay.web'); } goto j1AOw; j1AOw: $zH5Gf->setOutTradeNo(config('pay.payOrderOutTradeNoPrefix') . '_' . $ohquK['id']); goto og2h_; PcmQ7: if (!config('latrell-alipay.partner_id') || !config('latrell-alipay.seller_id') || !config('latrell-alipay-web.key')) { return Response::generate(-1, '支付宝配置错误'); } goto oIc7o; gqeBt: } public static function getOrderByOutTradeNo($iZxJq) { goto Wdumz; hUNLQ: $SVtY2 = $WclhF[0]; goto NIFK9; NIFK9: $Xk8gG = $WclhF[1]; goto ESgIO; oJrhX: return Response::generateSuccessData(array('order' => $z58x5)); goto Vnm72; ESgIO: if ($SVtY2 != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto qEKR9; Wdumz: $WclhF = explode('_', $iZxJq); goto vOmpn; qEKR9: $z58x5 = ModelUtil::get('pay_order', array('id' => $Xk8gG)); goto voO7U; vOmpn: if (count($WclhF) != 2) { return Response::generate(-1, 'outTradeNo error'); } goto hUNLQ; voO7U: BizException::throwsIf('order not found', empty($z58x5)); goto oJrhX; Vnm72: } public static function handleOrderPay($PHNQB, $iZxJq, $wpjkf = array()) { goto M2Plg; bSYvQ: $SVtY2 = $WclhF[0]; goto Qhdeo; Eq8bV: try { goto MzUbd; biorT: $z58x5 = ModelUtil::getWithLock('pay_order', array('id' => $Xk8gG)); goto OmKvB; OmKvB: if (empty($z58x5)) { ModelUtil::transactionCommit(); return Response::generate(-1, 'order not found'); } goto DnR4Y; DnR4Y: if ($z58x5['status'] == PayOrderStatus::CREATED) { goto jFE1a; FkeDS: ModelUtil::update('pay_order', array('id' => $z58x5['id']), array_merge(array('status' => PayOrderStatus::PAYED, 'timePay' => Carbon::now()), $wpjkf)); goto udG3m; jFE1a: Log::info('PayCenter.HandleOrderPay.UpdateOrderToPayed - ' . $iZxJq); goto FkeDS; udG3m: $dzswm = true; goto lVsav; lVsav: } else { Log::info('PayCenter.HandleOrderPay.Status - ' . $z58x5['status']); if (!empty($wpjkf)) { ModelUtil::update('pay_order', array('id' => $z58x5['id']), $wpjkf); } } goto qjeSM; MzUbd: ModelUtil::transactionBegin(); goto biorT; qjeSM: ModelUtil::transactionCommit(); goto X8lSK; X8lSK: } catch (\Exception $ggRjH) { Log::error('PayCenter.HandleOrderPay.Error - ' . $ggRjH->getMessage()); ModelUtil::transactionRollback(); } goto iHSXX; Ch28j: ModelUtil::update('pay_order', $z58x5['id'], array('eventNotified' => true)); goto dW3Qh; M2Plg: $dzswm = false; goto goAXr; dW3Qh: ModelUtil::decodeRecordJson($z58x5, 'param'); goto BDdps; PHJC9: $wpjkf = array_merge(array('payType' => $PHNQB), $wpjkf); goto Eq8bV; goAXr: $z58x5 = null; goto WlFoX; WlFoX: Log::info('PayCenter.PayOrderNotify - ' . $PHNQB . ' - ' . $iZxJq); goto vo1ak; s7eCJ: if ($SVtY2 != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto PHJC9; BDdps: return Response::generate(0, null, array('order' => $z58x5)); goto Bq6d_; Qhdeo: $Xk8gG = $WclhF[1]; goto s7eCJ; HZBLF: if (count($WclhF) != 2 && count($WclhF) != 3) { return Response::generate(-1, 'outTradeNo error'); } goto bSYvQ; iHSXX: if ($dzswm) { goto NZ2xO; MYadw: $N5Oui->biz = $z58x5['biz']; goto w2by7; w2by7: $N5Oui->bizId = $z58x5['bizId']; goto DrygZ; ZDcsY: Log::info('PayCenter.HandleOrderPay.OrderPayedEvent - ' . json_encode($N5Oui, JSON_UNESCAPED_UNICODE)); goto eX4BU; NZ2xO: $N5Oui = new OrderPayedEvent(); goto MYadw; DrygZ: $N5Oui->order = $z58x5; goto n8mMT; n8mMT: EventUtil::fire($N5Oui); goto ZDcsY; eX4BU: } goto Ch28j; vo1ak: $WclhF = explode('_', $iZxJq); goto HZBLF; Bq6d_: } }