<?php
namespace Payment\Query\Wx; use Payment\Common\PayException; use Payment\Common\Weixin\Data\Query\RedQueryData; use Payment\Common\Weixin\WxBaseStrategy; use Payment\Config; use Payment\Utils\DataParser; class WxRedQuery extends WxBaseStrategy { protected $reqUrl = 'https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo'; public function getBuildDataClass() { return RedQueryData::class; } protected function retData(array $data) { if ($this->config->returnRaw) { $data['channel'] = Config::WX_RED; return $data; } if ($data['return_code'] != 'SUCCESS') { return $retData = [ 'is_success' => 'F', 'error' => $data['return_msg'], 'channel' => Config::WX_RED, ]; } if ($data['result_code'] != 'SUCCESS') { return $retData = [ 'is_success' => 'F', 'error' => $data['err_code_des'], 'channel' => Config::WX_RED, ]; } return $this->createBackData($data); } protected function createBackData(array $data) { $amount = bcdiv($data['payment_amount'], 100, 2); $retData = [ 'is_success' => 'T', 'response' => [ 'trans_no' => $data['partner_trade_no'], 'transaction_id' => $data['detail_id'], 'status' => strtolower($data['status']), 'reason' => $data['reason'], 'openid' => $data['openid'], 'payee_name' => $data['transfer_name'], 'amount' => $amount, 'pay_date' => $data['transfer_time'], 'desc' => $data['desc'], 'channel' => Config::WX_RED, ], ]; return $retData; } public function handle(array $data) { $buildClass = $this->getBuildDataClass(); try { $this->reqData = new $buildClass($this->config, $data); } catch (PayException $e) { throw $e; } $this->reqData->setSign(); $xml = DataParser::toXml($this->reqData->getData()); try { $ret = $this->sendReq($xml); } catch (PayException $e) { throw $e; } return $this->retData($ret); } } 