<?php
namespace Payment; use Payment\Charge\Ali\AliAppCharge; use Payment\Charge\Ali\AliBarCharge; use Payment\Charge\Ali\AliWapCharge; use Payment\Charge\Ali\AliWebCharge; use Payment\Charge\Ali\AliQrCharge; use Payment\Charge\Cmb\CmbCharge; use Payment\Charge\Wx\WxAppCharge; use Payment\Charge\Wx\WxBarCharge; use Payment\Charge\Wx\WxPubCharge; use Payment\Charge\Wx\WxQrCharge; use Payment\Charge\Wx\WxWapCharge; use Payment\Common\BaseStrategy; use Payment\Common\PayException; class ChargeContext { protected $channel; public function initCharge($channel, array $config) { try { switch ($channel) { case Config::ALI_CHANNEL_WAP: $this->channel = new AliWapCharge($config); break; case Config::ALI_CHANNEL_APP: $this->channel = new AliAppCharge($config); break; case Config::ALI_CHANNEL_WEB: $this->channel = new AliWebCharge($config); break; case Config::ALI_CHANNEL_QR: $this->channel = new AliQrCharge($config); break; case Config::ALI_CHANNEL_BAR: $this->channel = new AliBarCharge($config); break; case Config::WX_CHANNEL_APP: $this->channel = new WxAppCharge($config); break; case Config::WX_CHANNEL_LITE: case Config::WX_CHANNEL_PUB: $this->channel = new WxPubCharge($config); break; case Config::WX_CHANNEL_WAP: $this->channel = new WxWapCharge($config); break; case Config::WX_CHANNEL_QR: $this->channel = new WxQrCharge($config); break; case Config::WX_CHANNEL_BAR: $this->channel = new WxBarCharge($config); break; case Config::CMB_CHANNEL_WAP: case Config::CMB_CHANNEL_APP: $this->channel = new CmbCharge($config); break; case Config::CCB_CHANNEL_WEB: $this->channel = new CcbWebCharge($config); break; default: throw new PayException('当前仅支持：支付宝  微信 招商一网通 建设银行'); } } catch (PayException $e) { throw $e; } } public function charge(array $data) { if (! $this->channel instanceof BaseStrategy) { throw new PayException('请检查初始化是否正确'); } try { return $this->channel->handle($data); } catch (PayException $e) { throw $e; } } } 